<?php

/**
 * This is the model class for table "pd_sub_job_list".
 *
 * The followings are the available columns in table 'pd_sub_job_list':
 * @property integer $id
 * @property integer $PDSubJobId
 * @property integer $subJobId
 * @property string $note
 * @property integer $statusId
 * @property integer $sortOrderval
 * @property string $duedate
 * @property integer $createdBy
 */
class PDSubJobList extends CActiveRecord
{
    public $job_search;
    public $subjob_search;
    public $pdsubjob_search;
    /**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PDSubJobList the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'pd_sub_job_list';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('PDSubJobId, subJobId, statusId, sortOrderval, createdBy', 'numerical', 'integerOnly'=>true),
			array('note, duedate, statusDate, createdDate, job_search, subjob_search, pdsubjob_search', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, PDSubJobId, subJobId, note, statusId, sortOrderval, duedate, createdBy, job_search, subjob_search, pdsubjob_search', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'RelPDSubJob' => array(self::BELONGS_TO, 'PDSubJob', 'PDSubJobId'),
                    'subjob' => array(self::BELONGS_TO, 'SubArtworkJob', 'subJobId'),
                    'RelStatus' => array(self::BELONGS_TO, 'Status', 'statusId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'PDSubJobId' => 'Pdsub Job',
			'subJobId' => 'Sub Job',
			'note' => 'Note',
			'statusId' => 'Status',
			'sortOrderval' => 'Order',
			'duedate' => 'Duedate',
			'createdBy' => 'Created By',
                        'statusDate'=>'Status Date',
                        'createdDate'=>'createdDate',
                        'job_search'=>'Job',
                        'subjob_search'=>'Sub Job',
                        'pdsubjob_search'=>'Sub Job Group'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
                $criteria->with = array( 'RelPDSubJob.job','subjob');
		$criteria->compare('id',$this->id);
		$criteria->compare('PDSubJobId',$this->PDSubJobId);
		$criteria->compare('subJobId',$this->subJobId);
		$criteria->compare('note',$this->note,true);
		$criteria->compare('statusId',$this->statusId);
		$criteria->compare('sortOrderval',$this->sortOrderval);
		$criteria->compare('duedate',$this->duedate,true);
		$criteria->compare('createdBy',$this->createdBy);
                $criteria->compare('job.jobNum', $this->job_search, true);
                $criteria->compare('subjob.name', $this->subjob_search, true);
                $criteria->compare('PDSubJobNum', $this->pdsubjob_search, true);
                
                $criteria->order = 'sortOrderval asc';

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function reportSearch()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
                $criteria->with = array( 'RelPDSubJob.job','subjob');
		$criteria->compare('id',$this->id);
		$criteria->compare('PDSubJobId',$this->PDSubJobId);
		$criteria->compare('subJobId',$this->subJobId);
		$criteria->compare('note',$this->note,true);
		$criteria->compare('statusId',$this->statusId);
		$criteria->compare('sortOrderval',$this->sortOrderval);
		$criteria->compare('duedate',$this->duedate,true);
		$criteria->compare('createdBy',$this->createdBy);
                $criteria->compare('job.jobNum', $this->job_search, true);
                $criteria->compare('subjob.name', $this->subjob_search, true);
                $criteria->compare('PDSubJobNum', $this->pdsubjob_search, true);
                
                $criteria->order = 'RelPDSubJob.createdDate desc';

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}