<?php

/**
 * This is the model class for table "payment_terms".
 *
 * The followings are the available columns in table 'payment_terms':
 * @property integer $id
 * @property string $type
 * @property string $description
 * @property string $display_text
 * @property integer $days
 */
class PaymentTerm extends CActiveRecord {

    const COD = 'COD';
    const DAYS_AFTER_BILL_DATE = 'DAYS_AFTER_BILL_DATE';
    const OF_FOLLOWING_MONTH = 'OF_FOLLOWING_MONTH';

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return PaymentTerm the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'payment_terms';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type', 'required'),
            array('days', 'numerical', 'integerOnly' => true),
            array('type, description, display_text', 'length', 'max' => 255),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, type, description, display_text, days', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'type' => 'Type',
            'description' => 'Description',
            'display_text' => 'Display Text',
            'days' => 'Days',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('type', $this->type, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('display_text', $this->display_text, true);
        $criteria->compare('days', $this->days);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}
