<?php

/**
 * This is the model class for table "product".
 *
 * The followings are the available columns in table 'product':
 * @property integer $prdsno
 * @property string $prdprd
 * @property string $prdshodes
 * @property string $prddes
 * @property string $prdsize
 * @property string $prdmaterial
 * @property integer $prdprinted
 * @property string $prddecorationtype
 * @property string $prdprintablearea
 * @property string $prdimage1
 * @property string $prdimage2
 * @property string $prdimage3
 * @property string $prdnumber_of_items_per_unit_price
 * @property string $prdnumber_of_units_per_carton
 * @property string $prdwidth
 * @property string $prdlength
 * @property string $prddepth
 * @property string $prdcartonweight
 * @property integer $prdis_registration_required
 * @property integer $prdflag
 * @property string $prdsorting
 * @property string $prducdnew
 * @property string $prdentddt
 * @property string $prdenttime
 * @property string $prducdame
 * @property string $prdameddt
 * @property string $prdametime
 */
class Product extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Product the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'product';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('prdprd,prdshodes,prddes', 'required'),
            array('prdprd,prdshodes,prddes', 'default', 'value' => ''),
            array('prdprinted, prdis_registration_required, prdflag, prdcusno', 'numerical', 'integerOnly' => true),
            array('prdprd', 'length', 'max' => 100),
            array('prdshodes, prdsize, prdmaterial, prddecorationtype, prdprintablearea, prdimage1, prdimage2, prdimage3, 
                            prdnumber_of_items_per_unit_price, prdnumber_of_units_per_carton, prdwidth, prdlength, prddepth, prdcartonweight',
                'length', 'max' => 255),
            array('prdsorting', 'length', 'max' => 5),
            array('prducdnew, prducdame', 'length', 'max' => 50),
            array('prddes', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('prdsno, prdprd, prdshodes, prddes, prdsize, prdmaterial, prdprinted, 
                            prddecorationtype, prdprintablearea, prdimage1, prdimage2, prdimage3, 
                            prdnumber_of_items_per_unit_price, prdnumber_of_units_per_carton, 
                            prdwidth, prdlength, prddepth, prdcartonweight, prdis_registration_required, 
                            prdflag, prdsorting, prducdnew, prdentddt, prdenttime, prducdame, prdameddt, 
                            prdametime, prdcusno', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'customer' => array(self::BELONGS_TO, 'Customer', 'prdcusno'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'prdsno' => 'Prdsno',
            'prdprd' => 'Prdprd',
            'prdshodes' => 'Prdshodes',
            'prddes' => 'Prddes',
            'prdsize' => 'Prdsize',
            'prdmaterial' => 'Prdmaterial',
            'prdprinted' => 'Prdprinted',
            'prddecorationtype' => 'Prddecorationtype',
            'prdprintablearea' => 'Prdprintablearea',
            'prdimage1' => 'Prdimage1',
            'prdimage2' => 'Prdimage2',
            'prdimage3' => 'Prdimage3',
            'prdnumber_of_items_per_unit_price' => 'Prdnumber Of Items Per Unit Price',
            'prdnumber_of_units_per_carton' => 'Prdnumber Of Units Per Carton',
            'prdwidth' => 'Prdwidth',
            'prdlength' => 'Prdlength',
            'prddepth' => 'Prddepth',
            'prdcartonweight' => 'Prdcartonweight',
            'prdis_registration_required' => 'Prdis Registration Required',
            'prdflag' => 'Prdflag',
            'prdsorting' => 'Prdsorting',
            'prducdnew' => 'Prducdnew',
            'prdentddt' => 'Prdentddt',
            'prdenttime' => 'Prdenttime',
            'prducdame' => 'Prducdame',
            'prdameddt' => 'Prdameddt',
            'prdametime' => 'Prdametime',
            'prdcusno' => 'Customer Specific',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('prdsno', $this->prdsno);
        $criteria->compare('prdprd', $this->prdprd, true);
        $criteria->compare('prdshodes', $this->prdshodes, true);
        $criteria->compare('prddes', $this->prddes, true);
        $criteria->compare('prdsize', $this->prdsize, true);
        $criteria->compare('prdmaterial', $this->prdmaterial, true);
        $criteria->compare('prdprinted', $this->prdprinted);
        $criteria->compare('prddecorationtype', $this->prddecorationtype, true);
        $criteria->compare('prdprintablearea', $this->prdprintablearea, true);
        $criteria->compare('prdimage1', $this->prdimage1, true);
        $criteria->compare('prdimage2', $this->prdimage2, true);
        $criteria->compare('prdimage3', $this->prdimage3, true);
        $criteria->compare('prdnumber_of_items_per_unit_price', $this->prdnumber_of_items_per_unit_price, true);
        $criteria->compare('prdnumber_of_units_per_carton', $this->prdnumber_of_units_per_carton, true);
        $criteria->compare('prdwidth', $this->prdwidth, true);
        $criteria->compare('prdlength', $this->prdlength, true);
        $criteria->compare('prddepth', $this->prddepth, true);
        $criteria->compare('prdcartonweight', $this->prdcartonweight, true);
        $criteria->compare('prdis_registration_required', $this->prdis_registration_required);
        $criteria->compare('prdflag', $this->prdflag);
        $criteria->compare('prdsorting', $this->prdsorting, true);
        $criteria->compare('prducdnew', $this->prducdnew, true);
        $criteria->compare('prdentddt', $this->prdentddt, true);
        $criteria->compare('prdenttime', $this->prdenttime, true);
        $criteria->compare('prducdame', $this->prducdame, true);
        $criteria->compare('prdameddt', $this->prdameddt, true);
        $criteria->compare('prdametime', $this->prdametime, true);
        $criteria->compare('prdcusno', $this->prdcusno);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

}