<?php

/**
 * This is the model class for table "product_by_sizes".
 *
 * The followings are the available columns in table 'product_by_sizes':
 * @property integer $id
 * @property integer $pdlsno
 * @property integer $product_size_id
 */
class ProductBySize extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return ProductBySize the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'product_by_sizes';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('pdlsno, product_size_id', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, pdlsno, product_size_id, order_number', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'productSizeRel' => array(self::BELONGS_TO, 'ProductSize', 'product_size_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'pdlsno' => 'Pdlsno',
            'product_size_id' => 'Product Size',
            'order_number' => 'Order Number'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('pdlsno', $this->pdlsno);
        $criteria->compare('product_size_id', $this->product_size_id);
        $criteria->compare('order_number', $this->order_number);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'order_number asc',
            )
        ));
    }

}
