<?php

/**
 * This is the model class for table "product_category".
 *
 * The followings are the available columns in table 'product_category':
 * @property integer $id
 * @property string $name
 * @property string $description
 * @property string $createdDate
 * @property integer $createdBy
 */
class ProductCategory extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'product_category';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
                        array('name', 'required'),
			array('createdBy', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>45),
			array('description,category_img', 'length', 'max'=>255),
			array('createdDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, description, createdDate, createdBy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'userRel' => array(self::BELONGS_TO, 'User', 'createdBy'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'description' => 'Description',
			'createdDate' => 'Created Date',
			'createdBy' => 'Created By',  
                        'category_img'=>'Category Image'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('createdDate',$this->createdDate,true);
		$criteria->compare('createdBy',$this->createdBy);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function searchWebStoreOrder($webstoreId)
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
                $criteria->join = "left join webstore_product_category_sort wpcs on t.id = wpcs.productCategoryId and wpcs.webstoreId = $webstoreId";

		//$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('createdDate',$this->createdDate,true);
		$criteria->compare('createdBy',$this->createdBy);
                
                
                
                $criteria->order = '-wpcs.sortOrder desc';

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        
        public function getWebstoreSortOrder($webstoreId) {
            $sortCategory = WebstoreProductCategorySort::model()->find(array('condition'=>"productCategoryId = $this->id and webstoreId = $webstoreId"));
            if($sortCategory){
                return $sortCategory->sortOrder;
            }else{
                return null;
            }
        }
}