<?php

/**
 * This is the model class for table "product_excel_lookup".
 *
 * The followings are the available columns in table 'product_excel_lookup':
 * @property integer $id
 * @property string $file_name
 * @property string $created_date
 * @property integer $to_be_read
 */
class ProductExcelLookup extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductExcelLookup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'product_excel_lookup';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('to_be_read', 'numerical', 'integerOnly'=>true),
			array('file_name', 'length', 'max'=>255),
			array('created_date, log_message', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, file_name, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'file_name' => 'File Name',
			'created_date' => 'Created Date',
			'to_be_read' => 'To Be Read',
			'log_message' => 'Log Message'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('file_name',$this->file_name,true);
		$criteria->compare('created_date',$this->created_date,true);
		$criteria->compare('to_be_read',$this->to_be_read);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}