<?php

/**
 * This is the model class for table "product_excel_lookup_details".
 *
 * The followings are the available columns in table 'product_excel_lookup_details':
 * @property integer $id
 * @property integer $product_excel_lookup_id
 * @property integer $pdlsno
 */
class ProductExcelLookupDetails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductExcelLookupDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'product_excel_lookup_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_excel_lookup_id, pdlsno', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, product_excel_lookup_id, pdlsno', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'productRel' => array(self::BELONGS_TO, 'ProductLine', 'pdlsno'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'product_excel_lookup_id' => 'Product Excel Lookup',
			'pdlsno' => 'Pdlsno',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
		$criteria->with = array('productRel');

		$criteria->compare('id',$this->id);
		$criteria->compare('product_excel_lookup_id',$this->product_excel_lookup_id);
		$criteria->compare('pdlsno',$this->pdlsno);
		$criteria->compare('productRel.pdldes',$this->pdlsno);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination' => array('pageSize' => 100),
			
		));
	}
}