<?php

/**
 * This is the model class for table "product_group".
 *
 * The followings are the available columns in table 'product_group':
 * @property integer $id
 * @property string $short_desc
 * @property string $long_desc
 * @property string $image
 * @property string $created_date
 * @property integer $created_by
 * @property string $code
 */
class ProductGroup extends CActiveRecord {

    public $importFile;
    public $uploadimg;
    public $category_name_search;
    public $sub_category_name_search;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return ProductGroup the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'product_group';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
             array('code, short_desc', 'required'),
            array('created_by, categoryId, subCategoryId', 'numerical', 'integerOnly' => true),
            array('short_desc, image,  in_production, in_transit', 'length', 'max' => 255),
            array('code', 'length', 'max' => 50),
            array('code, short_desc', 'unique'),
            array('long_desc, created_date, image_url, uploadimg, productDetailUrl, '
                . 'downloadStyleSheetUrl, quizAndAnswerUrl,category_name_search,sub_category_name_search,importFile', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, short_desc, long_desc, image, created_date, created_by', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'short_desc' => 'Short Description',
            'long_desc' => 'Long Description',
            'image' => 'Image',
            'created_date' => 'Created Date',
            'created_by' => 'Created By',
            'image_url' => 'Image URL',
            'categoryId' => 'Category',
            'subCategoryId' => 'Sub Category',
            'productDetailUrl' => 'Product Detail URL',
            'in_production' => "In Production",
            'in_transit' => "In Transit",
            'downloadStyleSheetUrl' => "Download Style Sheet URL",
            'quizAndAnswerUrl' => "Question & Answer URL",
            'category_name_search' => 'Category',
            'sub_category_name_search' => 'Sub Category',
            'code' => 'Group Code'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->join = 'left join product_category on t.categoryId = product_category.id'
                . '             left join  product_sub_category on t.subCategoryId = product_sub_category.id';

        $criteria->compare('id', $this->id);
        $criteria->compare('code', $this->code, true);
        $criteria->compare('short_desc', $this->short_desc, true);
        $criteria->compare('long_desc', $this->long_desc, true);
        $criteria->compare('image', $this->image, true);
        $criteria->compare('created_date', $this->created_date, true);
        $criteria->compare('created_by', $this->created_by);

        $criteria->compare('in_production', $this->in_production, true);
        $criteria->compare('in_transit', $this->in_transit, true);

        $criteria->compare('product_category.name', $this->category_name_search, true);
        $criteria->compare('product_sub_category.name', $this->sub_category_name_search, true);


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        //here define the filter fields by exactly value
        $paramarr = array();

        //here define the filter fields by like values
        $paramarrLike = array(
            'product_category.name LIKE :' => $this->category_name_search,
            'product_sub_category.name LIKE :' => $this->sub_category_name_search,
            'short_desc LIKE :' => $this->short_desc, 'long_desc :' => $this->long_desc,
            'in_production LIKE :' => $this->in_production, 'in_transit LIKE :' => $this->in_transit
        );

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        if (isset(Yii::app()->session['prd_grp_expt_qry'])) {
            unset(Yii::app()->session['prd_grp_expt_qry']);
        }


        Yii::app()->session['prd_grp_expt_qry'] = $originalQuery;
        
        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'created_date desc',
            )
        ));
    }

    public function searchForWebstore() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->join = "left join webstore_product_groups wpg on t.id = wpg.product_group_id";

        $criteria->compare('id', $this->id);
        $criteria->compare('short_desc', $this->short_desc, true);
        $criteria->compare('long_desc', $this->long_desc, true);
        $criteria->compare('image', $this->image, true);
        $criteria->compare('created_date', $this->created_date, true);
        $criteria->compare('created_by', $this->created_by);

        $criteria->addCondition("wpg.product_group_id is null");

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getImg() {
        $imagefile = '';

        if (!empty($this->image_url)) {
            $imagefile = $this->image_url;
        } else {
            $imagefile = $this->image;
        }

        if (strpos($imagefile, 'http:') !== false) {
            if ($this->is_url_exist($imagefile)) {
                return $imagefile;
            } else {
                return null;
            }
        } else if (strpos($imagefile, 'https:') !== false) {
            if ($this->is_url_exist($imagefile)) {
                return $imagefile;
            } else {
                return null;
            }
        } else {
            if (file_exists('images/product_img/' . $imagefile)) {
                return $return_img = 'images/product_img/' . $imagefile;
            } else {
                return $return_img = null;
            }
        }
    }

    function is_url_exist($url) {
        $file = $url; // 'http://www.domain.com/somefile.jpg';
        $file_headers = @get_headers($file);
        if (!$file_headers || $file_headers[0] == 'HTTP/1.1 404 Not Found') {
            $exists = false;
        } else if (!$file_headers || $file_headers[0] == 'HTTPS/1.1 404 Not Found') {
            $exists = false;
        } else {
            $exists = true;
        }
        return $exists;
    }

}
