<?php

/**
 * This is the model class for table "product_line_backup".
 *
 * The followings are the available columns in table 'product_line_backup':
 * @property integer $pdlsno
 * @property integer $pdlprdsno
 * @property string $pdlprdline
 * @property integer $pdlprinted
 * @property string $pdlpdl
 * @property string $pdlcustomyn
 * @property string $pdldes
 * @property string $pdlcolour
 * @property integer $pdlflag
 * @property string $pdlimage1
 * @property string $pdlimage2
 * @property string $pdlimage3
 * @property integer $pdlsupsno
 * @property double $pdluntprice
 * @property double $pdlsupmargin
 * @property integer $pdlleadtime
 * @property string $pdlduration
 * @property string $pdlmob
 * @property string $pdldecorationtype
 * @property string $pdlucdnew
 * @property string $pdlentddt
 * @property string $pdlenttime
 * @property string $pdlucdame
 * @property string $pdlameddt
 * @property string $pdlametime
 * @property integer $pdlcusno
 * @property string $json_response
 * @property string $myob_uuid
 * @property string $myob_row_version
 * @property integer $myobExpsAccntId
 * @property integer $myobIncmAccntId
 * @property integer $myobBuyingDtlTaxCodeId
 * @property integer $myobSellingDtlTaxCodeId
 * @property double $sellingPrice
 * @property integer $categoryId
 * @property integer $subCategoryId
 * @property integer $pdlaccrefcode
 * @property integer $orderTypeId
 * @property double $usdUnitFreightCost
 * @property double $usdUnitFreightMarkupRate
 * @property string $myob_guid_uuid
 * @property integer $myobAssetAccId
 * @property integer $qty_on_hand
 * @property integer $qty_available
 * @property double $current_value
 * @property integer $in_production
 * @property integer $in_transit
 * @property string $prodImgUri
 */
class ProductLineBackup extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductLineBackup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'product_line_backup';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('pdlsno, pdlprdsno, pdlprinted, pdlflag, pdlsupsno, pdlleadtime, pdlcusno, myobExpsAccntId, myobIncmAccntId, myobBuyingDtlTaxCodeId, myobSellingDtlTaxCodeId, categoryId, subCategoryId, pdlaccrefcode, orderTypeId, myobAssetAccId, qty_on_hand, qty_available, in_production, in_transit', 'numerical', 'integerOnly'=>true),
			array('pdluntprice, pdlsupmargin, sellingPrice, usdUnitFreightCost, usdUnitFreightMarkupRate, current_value', 'numerical'),
			array('pdlprdline', 'length', 'max'=>150),
			array('pdlpdl, pdlcolour, pdlimage1, pdlimage2, pdlimage3, pdldecorationtype, myob_row_version', 'length', 'max'=>255),
			array('pdlcustomyn', 'length', 'max'=>1),
			array('pdlduration', 'length', 'max'=>10),
			array('pdlmob', 'length', 'max'=>2),
			array('pdlucdnew, pdlucdame', 'length', 'max'=>50),
			array('myob_uuid, myob_guid_uuid', 'length', 'max'=>36),
			array('pdldes, pdlentddt, pdlenttime, pdlameddt, pdlametime, json_response, prodImgUri', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('pdlsno, pdlprdsno, pdlprdline, pdlprinted, pdlpdl, pdlcustomyn, pdldes, pdlcolour, pdlflag, pdlimage1, pdlimage2, pdlimage3, pdlsupsno, pdluntprice, pdlsupmargin, pdlleadtime, pdlduration, pdlmob, pdldecorationtype, pdlucdnew, pdlentddt, pdlenttime, pdlucdame, pdlameddt, pdlametime, pdlcusno, json_response, myob_uuid, myob_row_version, myobExpsAccntId, myobIncmAccntId, myobBuyingDtlTaxCodeId, myobSellingDtlTaxCodeId, sellingPrice, categoryId, subCategoryId, pdlaccrefcode, orderTypeId, usdUnitFreightCost, usdUnitFreightMarkupRate, myob_guid_uuid, myobAssetAccId, qty_on_hand, qty_available, current_value, in_production, in_transit, prodImgUri', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'pdlsno' => 'Pdlsno',
			'pdlprdsno' => 'Pdlprdsno',
			'pdlprdline' => 'Pdlprdline',
			'pdlprinted' => 'Pdlprinted',
			'pdlpdl' => 'Pdlpdl',
			'pdlcustomyn' => 'Pdlcustomyn',
			'pdldes' => 'Pdldes',
			'pdlcolour' => 'Pdlcolour',
			'pdlflag' => 'Pdlflag',
			'pdlimage1' => 'Pdlimage1',
			'pdlimage2' => 'Pdlimage2',
			'pdlimage3' => 'Pdlimage3',
			'pdlsupsno' => 'Pdlsupsno',
			'pdluntprice' => 'Pdluntprice',
			'pdlsupmargin' => 'Pdlsupmargin',
			'pdlleadtime' => 'Pdlleadtime',
			'pdlduration' => 'Pdlduration',
			'pdlmob' => 'Pdlmob',
			'pdldecorationtype' => 'Pdldecorationtype',
			'pdlucdnew' => 'Pdlucdnew',
			'pdlentddt' => 'Pdlentddt',
			'pdlenttime' => 'Pdlenttime',
			'pdlucdame' => 'Pdlucdame',
			'pdlameddt' => 'Pdlameddt',
			'pdlametime' => 'Pdlametime',
			'pdlcusno' => 'Pdlcusno',
			'json_response' => 'Json Response',
			'myob_uuid' => 'Myob Uuid',
			'myob_row_version' => 'Myob Row Version',
			'myobExpsAccntId' => 'Myob Exps Accnt',
			'myobIncmAccntId' => 'Myob Incm Accnt',
			'myobBuyingDtlTaxCodeId' => 'Myob Buying Dtl Tax Code',
			'myobSellingDtlTaxCodeId' => 'Myob Selling Dtl Tax Code',
			'sellingPrice' => 'Selling Price',
			'categoryId' => 'Category',
			'subCategoryId' => 'Sub Category',
			'pdlaccrefcode' => 'Pdlaccrefcode',
			'orderTypeId' => 'Order Type',
			'usdUnitFreightCost' => 'Usd Unit Freight Cost',
			'usdUnitFreightMarkupRate' => 'Usd Unit Freight Markup Rate',
			'myob_guid_uuid' => 'Myob Guid Uuid',
			'myobAssetAccId' => 'Myob Asset Acc',
			'qty_on_hand' => 'Qty On Hand',
			'qty_available' => 'Qty Available',
			'current_value' => 'Current Value',
			'in_production' => 'In Production',
			'in_transit' => 'In Transit',
			'prodImgUri' => 'Prod Img Uri',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('pdlsno',$this->pdlsno);
		$criteria->compare('pdlprdsno',$this->pdlprdsno);
		$criteria->compare('pdlprdline',$this->pdlprdline,true);
		$criteria->compare('pdlprinted',$this->pdlprinted);
		$criteria->compare('pdlpdl',$this->pdlpdl,true);
		$criteria->compare('pdlcustomyn',$this->pdlcustomyn,true);
		$criteria->compare('pdldes',$this->pdldes,true);
		$criteria->compare('pdlcolour',$this->pdlcolour,true);
		$criteria->compare('pdlflag',$this->pdlflag);
		$criteria->compare('pdlimage1',$this->pdlimage1,true);
		$criteria->compare('pdlimage2',$this->pdlimage2,true);
		$criteria->compare('pdlimage3',$this->pdlimage3,true);
		$criteria->compare('pdlsupsno',$this->pdlsupsno);
		$criteria->compare('pdluntprice',$this->pdluntprice);
		$criteria->compare('pdlsupmargin',$this->pdlsupmargin);
		$criteria->compare('pdlleadtime',$this->pdlleadtime);
		$criteria->compare('pdlduration',$this->pdlduration,true);
		$criteria->compare('pdlmob',$this->pdlmob,true);
		$criteria->compare('pdldecorationtype',$this->pdldecorationtype,true);
		$criteria->compare('pdlucdnew',$this->pdlucdnew,true);
		$criteria->compare('pdlentddt',$this->pdlentddt,true);
		$criteria->compare('pdlenttime',$this->pdlenttime,true);
		$criteria->compare('pdlucdame',$this->pdlucdame,true);
		$criteria->compare('pdlameddt',$this->pdlameddt,true);
		$criteria->compare('pdlametime',$this->pdlametime,true);
		$criteria->compare('pdlcusno',$this->pdlcusno);
		$criteria->compare('json_response',$this->json_response,true);
		$criteria->compare('myob_uuid',$this->myob_uuid,true);
		$criteria->compare('myob_row_version',$this->myob_row_version,true);
		$criteria->compare('myobExpsAccntId',$this->myobExpsAccntId);
		$criteria->compare('myobIncmAccntId',$this->myobIncmAccntId);
		$criteria->compare('myobBuyingDtlTaxCodeId',$this->myobBuyingDtlTaxCodeId);
		$criteria->compare('myobSellingDtlTaxCodeId',$this->myobSellingDtlTaxCodeId);
		$criteria->compare('sellingPrice',$this->sellingPrice);
		$criteria->compare('categoryId',$this->categoryId);
		$criteria->compare('subCategoryId',$this->subCategoryId);
		$criteria->compare('pdlaccrefcode',$this->pdlaccrefcode);
		$criteria->compare('orderTypeId',$this->orderTypeId);
		$criteria->compare('usdUnitFreightCost',$this->usdUnitFreightCost);
		$criteria->compare('usdUnitFreightMarkupRate',$this->usdUnitFreightMarkupRate);
		$criteria->compare('myob_guid_uuid',$this->myob_guid_uuid,true);
		$criteria->compare('myobAssetAccId',$this->myobAssetAccId);
		$criteria->compare('qty_on_hand',$this->qty_on_hand);
		$criteria->compare('qty_available',$this->qty_available);
		$criteria->compare('current_value',$this->current_value);
		$criteria->compare('in_production',$this->in_production);
		$criteria->compare('in_transit',$this->in_transit);
		$criteria->compare('prodImgUri',$this->prodImgUri,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}