<?php

/**
 * This is the model class for table "product_line".
 *
 * The followings are the available columns in table 'product_line':
 * @property integer $pdlsno
 * @property integer $pdlprdsno
 * @property string $pdlprdline
 * @property integer $pdlprinted
 * @property string $pdlpdl
 * @property string $pdlcustomyn
 * @property string $pdldes
 * @property string $pdlcolour
 * @property integer $pdlflag
 * @property string $pdlimage1
 * @property string $pdlimage2
 * @property string $pdlimage3
 * @property integer $pdlsupsno
 * @property double $pdluntprice
 * @property integer $pdlleadtime
 * @property string $pdlduration
 * @property string $pdlmob
 * @property string $pdldecorationtype
 * @property string $pdlucdnew
 * @property string $pdlentddt
 * @property string $pdlenttime
 * @property string $pdlucdame
 * @property string $pdlameddt
 * @property string $pdlametime
 * @property string $prodImgUri
 * @property string $product_source
 * @property string $sup_product_code
 * @property string $webstore_name
 * @property string $webstore_uuid
 */
class ProductLine extends CActiveRecord implements MYOBSynchronizable {

    const PRODUCT_SOURCE_LOCAL_DB = 'LOCAL_DB';
    const PRODUCT_SOURCE_GWS_API = 'GWS_API';

    public $uploadimg;
    public $importFile;
    public $category_name_search;
    public $sub_category_name_search;
    public $supplier_search;
    public $supsno;
    public $searchText;
    
    //delete product from
    public $productGroupId;

    /**
     * Provide the logic to be synchronized this record in an API 
     * @var MYOBSynchronizer concrete implementation of Synchronizer
     */
    public $synchronizer;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return ProductLine the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'product_line';
    }

    public function behaviors() {
        return array(
            'ERememberFiltersBehavior' => array(
                'class' => 'ext.yii-remember-filters-gridview-master.components.ERememberFiltersBehavior',
                'defaults' => array(), /* optional line */
                'defaultStickOnClear' => false /* optional line */
            ),
        );
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('pdlpdl, pdldes, pdlprdline, pdlsupsno, pdluntprice', 'required'),
            array('sup_product_code, webstore_name', 'length', 'max' => 100),
            array('webstore_uuid, searchText', 'length', 'max' => 255),
            array('pdlsno,pdlcusno, pdlaccrefcode, categoryId, subCategoryId, orderTypeId, '
                . 'myobExpsAccntId,myobIncmAccntId, myobBuyingDtlTaxCodeId, myobSellingDtlTaxCodeId, productGroupId', 'numerical', 'integerOnly' => true),
            //array('importFile', 'file', 'types'=>'xls, xlsx'),
            array('importFile, prodImgUri, supplier_search, product_source', 'safe'),
            array('pdluntprice,pdlprdsno, pdlprinted, pdlflag, pdlsupsno,pdlentddt,pdlenttime,pdlameddt,pdlametime,pdlleadtime', 'default', 'value' => 0),
            array('pdlucdnew, pdlucdame,pdlmob,pdlduration,pdlcustomyn,pdlpdl, pdlcolour,pdldes, 
                            pdlimage1, pdlimage2, pdlimage3, pdldecorationtype,pdlprdline,uploadimg', 'default', 'value' => ''),
            array('sellingPrice,usdUnitFreightCost,usdUnitFreightMarkupRate, qty_on_hand, qty_available, supsno', 'numerical'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('pdlsno, pdlprdsno, pdlprdline, pdlprinted, pdlpdl, pdlcustomyn, 
                pdldes, pdlcolour, pdlflag, pdlimage1, pdlimage2, pdlimage3, pdlsupsno, pdluntprice, pdlsupmargin,
                pdlleadtime, pdlduration, pdlmob, pdldecorationtype, pdlucdnew, pdlentddt, pdlenttime, pdlucdame, 
                pdlameddt, pdlametime, pdlcusno, pdlaccrefcode, categoryId, subCategoryId, orderTypeId, 
                category_name_search, sub_category_name_search, supplier_search, importFile', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'customer' => array(self::BELONGS_TO, 'Customer', 'pdlcusno'),
            'supplier' => array(self::BELONGS_TO, 'Supplier', 'pdlsupsno'),
            'categoryRel' => array(self::BELONGS_TO, 'ProductCategory', 'categoryId'),
            'subcategoryRel' => array(self::BELONGS_TO, 'ProductSubCategory', 'subCategoryId'),
            'inventoryRel' => array(self::BELONGS_TO, 'Inventory', '', 'foreignKey' => array('pdlsno' => 'product_id')),
            'orderTypeRel' => array(self::BELONGS_TO, 'OrderType', 'orderTypeId'),
            'prices' => array(self::HAS_MANY, 'ProductPrice', 'pdppdlsno', 'order' => 'pdpquantity_break_level'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'pdlsno' => 'ID',
            'pdlprdsno' => 'Pdlprdsno',
            'pdlprdline' => 'Product Short Description',
            'pdlprinted' => 'Pdlprinted',
            'pdlpdl' => 'Product Code',
            'pdlcustomyn' => 'Is Custom Product',
            'pdldes' => 'Product Long Description',
            'pdlcolour' => 'Pdlcolour',
            'pdlflag' => 'Pdlflag',
            'pdlimage1' => 'Image URL',
            'pdlimage2' => 'Image URL 2',
            'pdlimage3' => 'Image URL 3',
            'pdlsupsno' => 'Supplier',
            'pdluntprice' => 'Default Unit Price Cost',
            'pdlleadtime' => 'Lead Time',
            'pdlduration' => 'Pdlduration',
            'pdlmob' => 'MOB',
            'pdldecorationtype' => 'Pdldecorationtype',
            'pdlucdnew' => 'Created By',
            'pdlentddt' => 'Created Date',
            'pdlenttime' => 'Created Time',
            'pdlucdame' => 'Pdlucdame',
            'pdlameddt' => 'Pdlameddt',
            'pdlametime' => 'Pdlametime',
            'pdlsupmargin' => 'Supplier Margin',
            'uploadimg' => 'Upload Image',
            'pdlcusno' => 'Customer Specific',
            'pdlaccrefcode' => 'Xero Account Reference Code',
            'categoryId' => 'Category',
            'subCategoryId' => 'Sub Category',
            'orderTypeId' => 'Order Type',
            'sellingPrice' => 'Default Selling Price',
            'category_name_search' => 'Category Name',
            'sub_category_name_search' => 'Sub Category Name',
            'supplier_search' => 'Supplier',
            'myobExpsAccntId' => 'MYOB Expenses Account',
            'myobIncmAccntId' => 'MYOB Income Account',
            'myobBuyingDtlTaxCodeId' => 'MYOB Buying Details Tax Code',
            'myobSellingDtlTaxCodeId' => 'MYOB Selling Details Tax Code',
            'usdUnitFreightCost' => 'USD Unit Freight',
            'usdUnitFreightMarkupRate' => 'USD Unit Frieght Mark-Up Rate (%)',
            'qty_on_hand' => 'Stock On hand',
            'qty_available' => 'Stock Available',
            'product_source' => 'Product Source',
            'sup_product_code' => 'Supplier Product Code',
            'webstore_name' => 'Web Store Name',
            'webstore_uuid' => 'Web Store Uuid(s) (Use @ sign to define multiple uuids)',
            'productGroupId' => 'Product Group',
            'searchText' => 'Key Words'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        //$criteria->with = array('supplier','categoryRel','subcategoryRel');
        $criteria->join = 'left join supplier on t.pdlsupsno = supplier.supsno '
                . '         left join product_category on t.categoryId = product_category.id'
                . '             left join  product_sub_category on t.subCategoryId = product_sub_category.id';

        $criteria->compare('pdlsno', $this->pdlsno);
        //$criteria->compare('pdlprdsno', $this->pdlprdsno);
        $criteria->compare('pdlprdline', $this->pdlprdline, true);
        //$criteria->compare('pdlprinted', $this->pdlprinted);
        $criteria->compare('pdlpdl', $this->pdlpdl, true);
        //$criteria->compare('pdlcustomyn', $this->pdlcustomyn, true);
        $criteria->compare('pdldes', $this->pdldes, true);
        //$criteria->compare('pdlcolour', $this->pdlcolour, true);
        //$criteria->compare('pdlflag', $this->pdlflag);
        //$criteria->compare('pdlimage1', $this->pdlimage1, true);
        //$criteria->compare('pdlimage2', $this->pdlimage2, true);
        //$criteria->compare('pdlimage3', $this->pdlimage3, true);
        $criteria->compare('supplier.supnam', $this->supplier_search, true);
        $criteria->compare('pdluntprice', $this->pdluntprice, true);
        //$criteria->compare('pdlleadtime', $this->pdlleadtime);
        //$criteria->compare('pdlduration', $this->pdlduration, true);
        //$criteria->compare('pdlmob', $this->pdlmob, true);
        //$criteria->compare('pdldecorationtype', $this->pdldecorationtype, true);
        //$criteria->compare('pdlucdnew', $this->pdlucdnew, true);
        //$criteria->compare('pdlentddt', $this->pdlentddt, true);
        //$criteria->compare('pdlenttime', $this->pdlenttime, true);
        //$criteria->compare('pdlucdame', $this->pdlucdame, true);
        //$criteria->compare('pdlameddt', $this->pdlameddt, true);
        //$criteria->compare('pdlametime', $this->pdlametime, true);
        //$criteria->compare('pdlsupmargin', $this->pdlsupmargin, true);
        //$criteria->compare('pdlcusno', $this->pdlcusno);
        $criteria->compare('product_category.name', $this->category_name_search, true);
        $criteria->compare('product_sub_category.name', $this->sub_category_name_search, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);
        //$criteria->compare('sellingPrice', $this->sellingPrice, true);
        //$criteria->order = 'pdlsno desc';

        $criteria->compare('sup_product_code', $this->sup_product_code, true);
        $criteria->compare('webstore_name', $this->webstore_name, true);

        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        //here define the filter fields by exactly value
        $paramarr = array();

        //here define the filter fields by like values
        $paramarrLike = array(
            'product_category.name LIKE :' => $this->category_name_search,
            'product_sub_category.name LIKE :' => $this->sub_category_name_search,
            'pdlpdl LIKE :' => $this->pdlpdl, 'pdlprdline :' => $this->pdlprdline,
            'pdldes LIKE :' => $this->pdldes, 'supplier.supnam LIKE :' => $this->supplier_search,
            'pdluntprice LIKE :' => $this->pdluntprice, 'sup_product_code LIKE :' => $this->sup_product_code, 
            'webstore_name LIKE :' => $this->webstore_name
        );

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        if (isset(Yii::app()->session['prd_expt_qry'])) {
            unset(Yii::app()->session['prd_expt_qry']);
        }


        Yii::app()->session['prd_expt_qry'] = $originalQuery;


        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'pdlsno desc',
            )
        ));
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchForSelectPopup() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        //$criteria->with = array('supplier','categoryRel','subcategoryRel');
        //$criteria->join = 'left join supplier on t.pdlsupsno = supplier.supsno '
        //  . '         left join product_category on t.categoryId = product_category.id'
        // . '             left join  product_sub_category on t.subCategoryId = product_sub_category.id';

        $criteria->with = array('supplier');

        $hasFiltering = false;
        if (trim($this->pdlpdl)) {
            $hasFiltering = true;
            $criteria->compare('pdlpdl', trim($this->pdlpdl), true);
        }
        //$criteria->compare('pdlprinted', $this->pdlprinted);
        if (trim($this->searchText)) {
            $hasFiltering = true;
            $criteria->compare('pdlprdline', trim($this->searchText), true, "OR");
        }

        if (trim($this->searchText)) {
            $hasFiltering = true;
            $criteria->compare('pdldes', trim($this->searchText), true, "OR");
        }

        if (trim($this->pdlsupsno)) {

            $hasFiltering = true;
            $criteria->compare('pdlsupsno', trim($this->pdlsupsno));
        }

        if (!$hasFiltering) {
            $criteria->addCondition("t.pdlsno < 0");
        }



        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.pdlsno DESC',
            )
        ));
    }

    public function allocateSearch() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('pdlsno', $this->pdlsno);
        $criteria->compare('pdlprdsno', $this->pdlprdsno);
        $criteria->compare('pdlprdline', $this->pdlprdline, true);
        $criteria->compare('pdlprinted', $this->pdlprinted);
        $criteria->compare('pdlpdl', $this->pdlpdl, true);
        $criteria->compare('pdlcustomyn', $this->pdlcustomyn, true);
        $criteria->compare('pdldes', $this->pdldes, true);
        $criteria->compare('pdlcolour', $this->pdlcolour, true);
        $criteria->compare('pdlflag', $this->pdlflag);
        $criteria->compare('pdlimage1', $this->pdlimage1, true);
        $criteria->compare('pdlimage2', $this->pdlimage2, true);
        $criteria->compare('pdlimage3', $this->pdlimage3, true);
        $criteria->compare('pdlsupsno', $this->pdlsupsno);
        $criteria->compare('pdluntprice', $this->pdluntprice);
        $criteria->compare('pdlleadtime', $this->pdlleadtime);
        $criteria->compare('pdlduration', $this->pdlduration, true);
        $criteria->compare('pdlmob', $this->pdlmob, true);
        $criteria->compare('pdldecorationtype', $this->pdldecorationtype, true);
        $criteria->compare('pdlucdnew', $this->pdlucdnew, true);
        $criteria->compare('pdlentddt', $this->pdlentddt, true);
        $criteria->compare('pdlenttime', $this->pdlenttime, true);
        $criteria->compare('pdlucdame', $this->pdlucdame, true);
        $criteria->compare('pdlameddt', $this->pdlameddt, true);
        $criteria->compare('pdlametime', $this->pdlametime, true);
        $criteria->compare('pdlsupmargin', $this->pdlsupmargin, true);
        $criteria->compare('pdlcusno', $this->pdlcusno);
        
        $criteria->compare('sup_product_code', $this->sup_product_code, true);
        $criteria->compare('webstore_name', $this->webstore_name, true);

        $criteria->addCondition("pdlcusno IS NULL OR pdlcusno = ''");

        $criteria->order = 'pdlsno DESC';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getImg() {
        $imagefile = '';


        if (trim($this->pdlimage1)) {
            $imagefile = $this->pdlimage1;
        } else if (trim($this->pdlimage2)) {
            $imagefile = $this->pdlimage2;
        } else if (trim($this->pdlimage3)) {
            $imagefile = $this->pdlimage3;
        } else {
            return null;
        }



        if (strpos($imagefile, 'http:') !== false || strpos($imagefile, 'https:') !== false) {

            return $imagefile;
        } else {

            if (is_file('images/product_img/' . $imagefile)) {
                return 'images/product_img/' . $imagefile;
            } else {
                $gloablaResource = GlobalVars::get(GlobalVars::PRODUCT_IMAGE_SOURCE) . $this->supplier->supsup_fref . '/' . $imagefile;
                //if ($this->is_url_exist($gloablaResource)) {
                return $gloablaResource;
                //}
                // return $return_img = null;
            }
        }
    }

    function is_url_exist($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($code == 200) {
            $status = true;
        } else {
            $status = false;
        }
        curl_close($ch);
        return $status;
    }

    public function getImgField() {
        $imagefile = '';
        $img1 = trim($this->pdlimage1);
        $img2 = trim($this->pdlimage2);
        $img3 = trim($this->pdlimage3);

        if (!empty($img1)) {
            $imagefile = $img1;
        } else if (!empty($img2)) {
            $imagefile = $img2;
        } else if (!empty($img3)) {
            $imagefile = $img3;
        }
        return $imagefile;
    }

    public function getMYOBJson() {

        //required - ExpenseAccount,IncomeAccount
        //if IsBought = true then BuyingDetails.TaxCode required
        //if IsSold = true then SellingDetails.TaxCode required
        $myobsettings = MyobSetting::getSettings();
        $expensesaccnt = $this->myobExpsAccntId ? MyobAccount::model()->findByPk($this->myobExpsAccntId) : MyobAccount::model()->findByPk($myobsettings->prd_expns_accnt_id);
        $expensesaccntuuid = $expensesaccnt ? $expensesaccnt->uuid : null;

        $incomeaccnt = $this->myobIncmAccntId ? MyobAccount::model()->findByPk($this->myobIncmAccntId) : MyobAccount::model()->findByPk($myobsettings->prd_incm_accnt_id);
        $incomeaccntuuid = $incomeaccnt ? $incomeaccnt->uuid : null;

        $this->pdluntprice = is_null($this->pdluntprice) ? 0 : $this->pdluntprice;
        $this->sellingPrice = is_null($this->sellingPrice) ? 0 : $this->sellingPrice;

        $itemarr = array(
            "Number" => $this->pdlsno,
            "Name" => substr($this->pdlpdl, 0, 30),
            "IsActive" => "true",
            "Description" => substr($this->pdlprdline, 0, 255),
            "UseDescription" => "true",
            "AverageCost" => floatval($this->pdluntprice),
            "BaseSellingPrice" => floatval($this->sellingPrice),
            "IsBought" => true,
            "IsSold" => true,
            "ExpenseAccount" => array(
                "UID" => $expensesaccntuuid,
            ),
            "IncomeAccount" => array(
                "UID" => $incomeaccntuuid,
            ),
//           
        );



        $isbrought = ($this->myobBuyingDtlTaxCodeId > 0) ? true : (($myobsettings->prd_buying_taxcode_id > 0) ? true : false);


        if ($isbrought) {

            $buyingdtltaxcode = $this->myobBuyingDtlTaxCodeId ? MyobTaxCode::model()->findByPk($this->myobBuyingDtlTaxCodeId) : MyobTaxCode::model()->findByPk($myobsettings->prd_buying_taxcode_id);
            $buyingdtltaxcodeuuid = $buyingdtltaxcode ? $buyingdtltaxcode->uuid : null;
            if ($buyingdtltaxcodeuuid) {
                $itemarr["IsBought"] = true;
                $itemarr["BuyingDetails"] = array(
                    "TaxCode" => array(
                        "UID" => $buyingdtltaxcodeuuid,
                    ),
                );
            }
        }


        $issold = ($this->myobSellingDtlTaxCodeId > 0) ? true : (($myobsettings->prd_selling_taxcode_id > 0) ? true : false);


        if ($issold) {

            $sellingdtltaxcode = $this->myobSellingDtlTaxCodeId ? MyobTaxCode::model()->findByPk($this->myobSellingDtlTaxCodeId) : MyobTaxCode::model()->findByPk($myobsettings->prd_selling_taxcode_id);
            $sellingdtltaxcodeuuid = $sellingdtltaxcode ? $sellingdtltaxcode->uuid : null;
            if ($sellingdtltaxcodeuuid) {
                $itemarr["IsSold"] = true;
                $itemarr["SellingDetails"] = array(
                    "BaseSellingPrice" => $this->sellingPrice,
                    "TaxCode" => array(
                        "UID" => $sellingdtltaxcodeuuid,
                    ),
                );
            }
        }

        if (!empty($this->myob_uuid) && !empty($this->myob_row_version)) {
            $itemarr["UID"] = $this->myob_uuid;
            $itemarr["RowVersion"] = $this->myob_row_version;
        }


        return json_encode($itemarr);
    }

    public function getMYOBBulkJson() {

        //required - ExpenseAccount,IncomeAccount
        //if IsBought = true then BuyingDetails.TaxCode required
        //if IsSold = true then SellingDetails.TaxCode required
        $myobsettings = MyobSetting::getSettings();
        $expensesaccnt = $this->myobExpsAccntId ? MyobAccount::model()->findByPk($this->myobExpsAccntId) : MyobAccount::model()->findByPk($myobsettings->prd_expns_accnt_id);
        $expensesaccntuuid = $expensesaccnt ? $expensesaccnt->uuid : null;

        $incomeaccnt = $this->myobIncmAccntId ? MyobAccount::model()->findByPk($this->myobIncmAccntId) : MyobAccount::model()->findByPk($myobsettings->prd_incm_accnt_id);
        $incomeaccntuuid = $incomeaccnt ? $incomeaccnt->uuid : null;

        $dataProvider = $this->searchForGroup();

        $itemarr = array();
        foreach ($dataProvider->getData() as $record) {

            $isbrought = ($this->myobBuyingDtlTaxCodeId > 0) ? true : (($myobsettings->prd_buying_taxcode_id > 0) ? true : false);
            $broughArr = array();

            if ($isbrought) {

                $buyingdtltaxcode = $this->myobBuyingDtlTaxCodeId ? MyobTaxCode::model()->findByPk($this->myobBuyingDtlTaxCodeId) : MyobTaxCode::model()->findByPk($myobsettings->prd_buying_taxcode_id);
                $buyingdtltaxcodeuuid = $buyingdtltaxcode ? $buyingdtltaxcode->uuid : null;
                if ($buyingdtltaxcodeuuid) {
                    $broughArr["IsBought"] = true;
                    $broughArr["BuyingDetails"] = array(
                        "TaxCode" => array(
                            "UID" => $buyingdtltaxcodeuuid,
                        ),
                    );
                }
            }


            $issold = ($this->myobSellingDtlTaxCodeId > 0) ? true : (($myobsettings->prd_selling_taxcode_id > 0) ? true : false);
            $soldArr = array();

            if ($issold) {

                $sellingdtltaxcode = $this->myobSellingDtlTaxCodeId ? MyobTaxCode::model()->findByPk($this->myobSellingDtlTaxCodeId) : MyobTaxCode::model()->findByPk($myobsettings->prd_selling_taxcode_id);
                $sellingdtltaxcodeuuid = $sellingdtltaxcode ? $sellingdtltaxcode->uuid : null;
                if ($sellingdtltaxcodeuuid) {
                    $soldArr["IsSold"] = true;
                    $soldArr["SellingDetails"] = array(
                        "BaseSellingPrice" => $this->sellingPrice,
                        "TaxCode" => array(
                            "UID" => $sellingdtltaxcodeuuid,
                        ),
                    );
                }
            }

            $uidAndRowArr = array();
            if (!empty($this->myob_uuid) && !empty($this->myob_row_version)) {
                $uidAndRowArr["UID"] = $this->myob_uuid;
                $uidAndRowArr["RowVersion"] = $this->myob_row_version;
            }



            $itemarr[] = array(
                "Number" => $record->pdlsno,
                "Name" => substr($record->pdlpdl, 0, 30),
                "IsActive" => "true",
                "Description" => substr($record->pdlprdline, 0, 255),
                "UseDescription" => "true",
                "AverageCost" => $record->pdluntprice,
                "BaseSellingPrice" => $record->sellingPrice,
                //"IsBought" => true,
                //"IsSold" => true,
                "ExpenseAccount" => array(
                    "UID" => $expensesaccntuuid,
                ),
                "IncomeAccount" => array(
                    "UID" => $incomeaccntuuid,
                ),
                $broughArr,
                $soldArr,
                $uidAndRowArr
//           
            );
        }
        return json_encode($itemarr);
    }

    public function searchForGroup() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->join = 'left join supplier on t.pdlsupsno = supplier.supsno '
                . '         left join product_category on t.categoryId = product_category.id'
                . '             left join  product_sub_category on t.subCategoryId = product_sub_category.id'
                . '                 left join product_group_details pgd on t.pdlsno = pgd.pdlsno';

        $criteria->compare('pdlsno', $this->pdlsno);
        //$criteria->compare('pdlprdsno', $this->pdlprdsno);
        $criteria->compare('pdlprdline', $this->pdlprdline, true);
        //$criteria->compare('pdlprinted', $this->pdlprinted);
        $criteria->compare('pdlpdl', $this->pdlpdl, true);
        //$criteria->compare('pdlcustomyn', $this->pdlcustomyn, true);
        $criteria->compare('pdldes', $this->pdldes, true);
        //$criteria->compare('pdlcolour', $this->pdlcolour, true);
        //$criteria->compare('pdlflag', $this->pdlflag);
        //$criteria->compare('pdlimage1', $this->pdlimage1, true);
        //$criteria->compare('pdlimage2', $this->pdlimage2, true);
        //$criteria->compare('pdlimage3', $this->pdlimage3, true);
        $criteria->compare('supplier.supnam', $this->supplier_search, true);
        $criteria->compare('pdluntprice', $this->pdluntprice);
        //$criteria->compare('pdlleadtime', $this->pdlleadtime);
        //$criteria->compare('pdlduration', $this->pdlduration, true);
        //$criteria->compare('pdlmob', $this->pdlmob, true);
        //$criteria->compare('pdldecorationtype', $this->pdldecorationtype, true);
        //$criteria->compare('pdlucdnew', $this->pdlucdnew, true);
        //$criteria->compare('pdlentddt', $this->pdlentddt, true);
        //$criteria->compare('pdlenttime', $this->pdlenttime, true);
        //$criteria->compare('pdlucdame', $this->pdlucdame, true);
        //$criteria->compare('pdlameddt', $this->pdlameddt, true);
        //$criteria->compare('pdlametime', $this->pdlametime, true);
        //$criteria->compare('pdlsupmargin', $this->pdlsupmargin, true);
        $criteria->compare('product_category.name', $this->category_name_search, true);
        $criteria->compare('product_sub_category.name', $this->sub_category_name_search, true);
        $criteria->compare('pdlcusno', $this->pdlcusno);

        $criteria->addCondition("pgd.pdlsno is null");
        $criteria->addCondition("pdlpdl REGEXP  '[a-zA-Z0-9][.][0-9]'");

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'pdlsno desc',
            )
        ));
    }

    public function getCodeHtml() {
        $html = $this->pdlpdl;
        if ($this->myob_uuid && empty($this->json_response)) {
            $html .= '<br><span class="label label-success" title="Successfully uploaded">MYOB</span>';
        } else if (!empty($this->json_response)) {
            $html .= '<br><span class="label label-important" title="Unsuccessful  upload">MYOB</span>';
        }

        $html .= '<br/>' . $this->getSourceHtml();

        return $html;
    }

    /**
     * Get image content from the URL and save the file into images/product_img folder and the replace the imageField value by the fileName value
     * 
     * @param string $fileName i.e. test.jpeg if null or empty then basename of the URL will be the file name
     * @param string $imageField URL
     * @param string $location a place to save the file. This must be a exist folder path otherwise exception will be thrown
     * 
     * @return boolean if operation success then true otherwise false
     */
    public function saveImageContent($fileName = '', $imageField = 'pdlimage1', $location = 'images/product_img/') {



        if (strpos($this->$imageField, 'http:') !== false || strpos($this->$imageField, 'https:') !== false) {
            $fileName = $fileName ?: basename($this->$imageField);
            try {
                if ($content = $this->curl_get_file_contents($this->$imageField)) {

                    //if already exist remove the file before save                    
                    @unlink($location . $fileName);

                    if (@file_put_contents($location . $fileName, $content)) {

                        $this->prodImgUri = $this->$imageField;
                        $this->$imageField = $fileName;

                        return $this->save(false);
                    }
                }
            } catch (Exception $ex) {
                echo $ex->getMessage();
                exit();
            }
        }

        return false;
    }

    function curl_get_file_contents($URL) {
        $c = curl_init();
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_URL, $URL);
        $contents = curl_exec($c);
        curl_close($c);

        if ($contents) {
            return $contents;
        } else {
            return false;
        }
    }

    /**
     * @override
     * @return string Last modified date time in Y-m-d H:i:s format
     */
    public function myobLastModified() {
        return date('Y-m-d H:i:s', strtotime($this->pdlameddt . ' ' . $this->pdlametime));
    }

    /**
     * @override
     * Synchronize current record with MYOB
     * @param MYOBApiConnector $myobConnector api connection
     * @return boolean success true, otherwise false
     */
    public function myobSynchronize(\MYOBApiConnector $myobConnector) {
        return $this->synchronizer->syncronize(); /* Hide the syncronizing logics in syncronizer object */
    }

    public function toJsonString() {
        return $this->getMYOBJson();
    }

    public function updateByMYOB(\MYOBResponse $response) {

        try {
            $dataArr = self::myobProductDataCore($response);

            Yii::app()->db->createCommand()
                    ->update(
                            'product_line', $dataArr, "pdlsno=$this->pdlsno" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public function updateMYOBReferences(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('product_line', array(
                        'myob_uuid' => $response->UID,
                        'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
                        'myob_row_version' => $response->RowVersion,
                        'json_response' => null,
                            ), "pdlsno=$this->pdlsno" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public static function createByMYOB(\MYOBResponse $response) {
        try {
            $dataArr = self::myobProductDataCore($response);
            $dataArr['pdlpdl'] = $response->Number;
            $dataArr['pdlentddt'] = date('Y-m-d');
            $dataArr['pdlenttime'] = date('H:i:s');
            if (Yii::app()->db->createCommand()
                            ->insert(
                                    'product_line', $dataArr
                            ))
                ;
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true;
    }

    /**
     * Encapsulate product data creation from MYOB response
     * @return array key,value pairs represent this data table
     */
    static function myobProductDataCore(\MYOBResponse $response) {

        if ($supplierUID = $response->RestockingInformation["Supplier"]["UID"]) {
            $supplierRaw = Yii::app()->db->createCommand()->select('supsno')->from('supplier')->where('myob_uuid=:UID', array(':UID' => $supplierUID,))->queryRow();
        }

        if ($expensesAccUID = $response->ExpenseAccount["UID"]) {
            $expensesAccRaw = Yii::app()->db->createCommand()->select('id')->from('myob_accounts')->where('uuid=:UID', array(':UID' => $expensesAccUID,))->queryRow();
        }

        if ($costOfSalesAccUID = $response->CostOfSalesAccount["UID"]) {
            $costOfSalesAccRaw = Yii::app()->db->createCommand()->select('id')->from('myob_accounts')->where('uuid=:UID', array(':UID' => $costOfSalesAccUID,))->queryRow();
        }

        if ($incomeAccUID = $response->IncomeAccount["UID"]) {
            $incomeAccRaw = Yii::app()->db->createCommand()->select('id')->from('myob_accounts')->where('uuid=:UID', array(':UID' => $incomeAccUID,))->queryRow();
        }

        if ($assetAccUID = $response->IncomeAccount["UID"]) {
            $assetAccRaw = Yii::app()->db->createCommand()->select('id')->from('myob_accounts')->where('uuid=:UID', array(':UID' => $assetAccUID,))->queryRow();
        }

        $coreArr = array(
            'myob_uuid' => $response->UID,
            'pdlprdline' => $response->Name,
            'pdldes' => $response->Description,
            'qty_on_hand' => $response->QuantityOnHand,
            'qty_available' => $response->QuantityAvailable,
            'pdluntprice' => $response->AverageCost,
            'current_value' => $response->CurrentValue,
            'sellingPrice' => $response->BaseSellingPrice,
            'myobExpsAccntId' => isset($expensesAccRaw) ? $expensesAccRaw['id'] : null,
            'myobExpsAccntId' => isset($costOfSalesAccRaw) ? $costOfSalesAccRaw['id'] : null,
            'myobIncmAccntId' => isset($incomeAccRaw) ? $incomeAccRaw['id'] : null,
            'myobAssetAccId' => isset($assetAccRaw) ? $assetAccRaw['id'] : null,
            'myob_row_version' => $response->RowVersion,
            'myob_guid_uuid' => Yii::app()->session['myob_guid_uuid'],
            'json_response' => null,
            'pdlameddt' => date('Y-m-d'),
            'pdlametime' => date('H:i;s')
        );

        if (isset($supplierRaw) && $supplierRaw['supsno']) {
            $coreArr['pdlsupsno'] = $supplierRaw['supsno'];
        }

        return $coreArr;
    }

    public function setSynchronizer(\MYOBSynchronizer $synchronizer) {
        $this->synchronizer = $synchronizer;
    }

    public function reportMYOBError(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('product_line', array(
                        'json_response' => serialize($response),
                            ), "pdlsno=$this->pdlsno" /* where condition */
            );
            MYOBLog::writeLog(array(
                'table_name' => $this->tableName(),
                'table_reference_id' => $this->pdlsno,
                'log_type_id' => MYOBLog::LOG_TYPE_ERROR,
                'log_message' => serialize($response),
                'log_class' => $GLOBALS['MYOB_ERROR_CLASS'],
                'log_line' => $GLOBALS['MYOB_ERROR_LINE'],
            ));
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }

    public function getMYOBError() {
        $obj = @unserialize($this->json_response); //In case the passed string is not unserializeable, supress  E_NOTICE 
        return $obj ? MYOBResponse::formatError($obj) : '';
    }

    public function reportMYOBSuccess(\MYOBResponse $response) {
        
    }

    public function getImgForWebStore() {
        $imagefile = $this->pdlimage1;


        if (empty($imagefile)) {
            //check images for webstore items if image is not defined for each color item
            $code = $this->pdlpdl;
            $codeSplitted = explode(".", $code);
            if (count($codeSplitted) == 2) {
                $colorSizePart = $codeSplitted[1];
                $prdPart = $codeSplitted[0];
                $colorSizePart = $codeSplitted[1];

                $colorCode = substr($colorSizePart, 0, -2);
                $codewithcolor = $prdPart . '.' . $colorCode;
                $prodWhichHasImg = ProductLine::model()->find(array('condition' => "pdlpdl like '%$codewithcolor%' and pdlimage1 is not null and pdlimage1 <> ''"));
                if ($prodWhichHasImg) {
                    $imagefile = $prodWhichHasImg->pdlimage1;
                }
            }
        }



        if (strpos($imagefile, 'http:') !== false) {
            if ($this->is_url_exist($imagefile)) {
                return $imagefile;
            } else {
                return null;
            }
        } else if (strpos($imagefile, 'https:') !== false) {
            if ($this->is_url_exist($imagefile)) {
                return $imagefile;
            } else {
                return null;
            }
        }

        if (!empty($imagefile)) {

            return 'images/product_img/' . $imagefile;
        }
    }

    public function getHtmlWrapedDescription() {
        return "<div>$this->pdldes</div>";
    }

    public function getHtmlWrapedPriceLookUp() {

        $html = '';
        $html = "<table id='pricelookup_" . $this->pdlsno . "'>";
        $html .= "<caption style='text-align:center;'>" . CHtml::link("Price LookUp", array("#"), array("onclick" => "showPriceLookUp($this->pdlsno);return false;")) . "</caption>";
        $html .= "<tbody style='display:none;'>";

        if ($this->product_source == ProductLine::PRODUCT_SOURCE_GWS_API) {
            $postFields = GwsProductApi::getDefaultPostFields();
            $postFields['data'] = array(
                'supplier' => '',
                'product_code' => $this->pdlpdl,
                'product_Name' => '',
                'category' => ''
            );

            $apiProductData = GwsProductApi::productData($postFields);
            $html .= GwsProductApi::extractPriceBreaksIntoTableRows($apiProductData[0]);
        } else {

            $html .= "<tr><td>Qty From</td><td>Qty To</td><td>Cost</td></tr>";
            foreach ($this->prices as $priceBreak) {
                $html .= "<tr><td>{$priceBreak->pdpquantity}</td><td>{$priceBreak->pdpsquantity}</td><td>{$priceBreak->pdpprice}</td></tr>";
            }
        }

        $html .= "</tbody>";
        $html .= "</table>";

        return $html;
    }

    public function getHtmlPriceLookUpCalScreen() {
        $html = "<table style='border:1px solid #eee;text-align:center;'>";


        $html .= "<tr style='background-color:#eee;'><th style='text-align:center;'>Qty From</th><th style='text-align:center;'>Qty To</th><th style='text-align:center;'>Cost</th></tr>";
        foreach ($this->prices as $priceBreak) {
            $html .= "<tr><td>{$priceBreak->pdpquantity}</td><td>{$priceBreak->pdpsquantity}</td><td>{$priceBreak->pdpprice}</td></tr>";
        }


        $html .= "</table>";

        return $html;
    }

    public function getSourceHtml() {
        if ($this->product_source == ProductLine::PRODUCT_SOURCE_GWS_API) {
            return '<span class="label label-success">GWS API</span>';
        } else {
            return '<span class="label label-success">LOCAL DB</span>';
        }
    }
    
    public static function updateProductLine(array $attributes) {
        $productLine = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $attributes['pdlpdl'])));
        $supplier = Supplier::model()->find(array('condition' => 'supsup_fref=:supRef', 'params' => array(':supRef' => $attributes['supsup_fref'])));
        if (!$productLine) {
            $productLine = new ProductLine();
        }

        $productLine->pdlpdl = $attributes['pdlpdl'];
        $productLine->pdlprdline = $attributes['pdlprdline'];
        $productLine->pdldes = $attributes['pdldes'];
        $productLine->pdlimage1 = $attributes['pdlimage1'];



        $productLine->pdlsupsno = !empty($supplier) ? intval($supplier->supsno) : 0;
        $productLine->pdluntprice = $attributes['pdluntprice'];


        $productLine->usdUnitFreightCost = $attributes['usdUnitFreightCost'];


        $productLine->usdUnitFreightMarkupRate = $attributes['usdUnitFreightMarkupRate'];



        $productLine->pdlsupmargin = $attributes['pdlsupmargin'];
        $productLine->pdlucdnew = Yii::app()->user->username;
        $productLine->pdlameddt = date('Y-m-d');
        $productLine->pdlametime = date('H:i:s');

        return $productLine->save(false);
    }

}
