<?php

/**
 * This is the model class for table "product_price".
 *
 * The followings are the available columns in table 'product_price':
 * @property integer $pdpsno
 * @property integer $pdppdlsno
 * @property integer $pdpquantity_break_level
 * @property integer $pdpprinted
 * @property double $pdpsquantity
 * @property string $pdpquantity
 * @property string $pdpprice
 * @property string $pdpucdnew
 * @property string $pdpentddt
 * @property string $pdpenttime
 * @property string $pdpucdame
 * @property string $pdpameddt
 * @property string $pdpametime
 */
class ProductPrice extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return ProductPrice the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'product_price';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('pdpsquantity, pdpucdnew, pdpentddt, pdpenttime, pdpucdame, pdpameddt, pdpametime', 'required'),
            array('pdppdlsno, pdpquantity_break_level, pdpprinted', 'numerical', 'integerOnly' => true),
            array('pdpsquantity', 'numerical'),
            array('pdpquantity, pdpprice', 'length', 'max' => 10),
            array('pdpucdnew, pdpucdame', 'length', 'max' => 50),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('pdpsno, pdppdlsno, pdpquantity_break_level, pdpprinted, pdpsquantity, pdpquantity, pdpprice, pdpucdnew, pdpentddt, pdpenttime, pdpucdame, pdpameddt, pdpametime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'pdpsno' => 'Pdpsno',
            'pdppdlsno' => 'Pdppdlsno',
            'pdpquantity_break_level' => 'Pdpquantity Break Level',
            'pdpprinted' => 'Pdpprinted',
            'pdpsquantity' => 'Pdpsquantity',
            'pdpquantity' => 'Pdpquantity',
            'pdpprice' => 'Pdpprice',
            'pdpucdnew' => 'Pdpucdnew',
            'pdpentddt' => 'Pdpentddt',
            'pdpenttime' => 'Pdpenttime',
            'pdpucdame' => 'Pdpucdame',
            'pdpameddt' => 'Pdpameddt',
            'pdpametime' => 'Pdpametime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('pdpsno', $this->pdpsno);
        $criteria->compare('pdppdlsno', $this->pdppdlsno);
        $criteria->compare('pdpquantity_break_level', $this->pdpquantity_break_level);
        $criteria->compare('pdpprinted', $this->pdpprinted);
        $criteria->compare('pdpsquantity', $this->pdpsquantity);
        $criteria->compare('pdpquantity', $this->pdpquantity, true);
        $criteria->compare('pdpprice', $this->pdpprice, true);
        $criteria->compare('pdpucdnew', $this->pdpucdnew, true);
        $criteria->compare('pdpentddt', $this->pdpentddt, true);
        $criteria->compare('pdpenttime', $this->pdpenttime, true);
        $criteria->compare('pdpucdame', $this->pdpucdame, true);
        $criteria->compare('pdpameddt', $this->pdpameddt, true);
        $criteria->compare('pdpametime', $this->pdpametime, true);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public static function createPriceMetrix($param = array('pdlsno' => null, 'priceLevel' => 0, 'fromQty' => 0, 'toQty' => 0, 'pdpprice' => 0, 'pdpsellprice' => 0)) {
        
        $pdlsno = $param['pdlsno'];
        $priceLevel = $param['priceLevel'];
        $fromQty = $param['fromQty'];
        $toQty = $param['toQty'];
        $pdpprice = $param['pdpprice'];
        $pdpsellprice = $param['pdpsellprice'];
        
        
        $toQty = ($toQty > 0 ? ($toQty - 1) : 9999999999);
        

        $prdprice = ProductPrice::model()->find(array('condition' => "pdppdlsno = {$pdlsno} AND pdpquantity_break_level = {$priceLevel} AND pdpquantity = {$fromQty} AND pdpsquantity = {$toQty}"));

        if (!$prdprice) {
            $prdprice = new ProductPrice();
        }


        $prdprice->pdppdlsno = $pdlsno;
        $prdprice->pdpquantity_break_level = $priceLevel;
        $prdprice->pdpquantity = $fromQty;
        $prdprice->pdpsquantity = $toQty;
        $prdprice->pdpprice = $pdpprice;
        $prdprice->pdpsellprice = $pdpsellprice;
        $prdprice->pdpentddt = date('Y-m-d', strtotime('now'));
        return $prdprice->save(false);
    }

}
