<?php

/**
 * This is the model class for table "product_sizes".
 *
 * The followings are the available columns in table 'product_sizes':
 * @property integer $id
 * @property string $size_name
 * @property string $description
 * @property integer $ordernumber
 * @property integer $addedby
 * @property string $createddate
 */
class ProductSize extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ProductSize the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'product_sizes';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ordernumber, addedby', 'numerical', 'integerOnly'=>true),
			array('size_name', 'length', 'max'=>255),
			array('description, createddate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, size_name, description, ordernumber, addedby, createddate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'size_name' => 'Size Name',
			'description' => 'Description',
			'ordernumber' => 'Ordernumber',
			'addedby' => 'Addedby',
			'createddate' => 'Createddate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('size_name',$this->size_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('ordernumber',$this->ordernumber);
		$criteria->compare('addedby',$this->addedby);
		$criteria->compare('createddate',$this->createddate,true);
                
                $criteria->order = "ordernumber asc";

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}