<?php

/**
 * This is the model class for table "purchase_order_details".
 *
 * The followings are the available columns in table 'purchase_order_details':
 * @property integer $id
 * @property integer $po_id
 * @property integer $workorderDtl_id
 * @property integer $qty
 * @property string $image
 * @property string $notation
 */
class PurchaseOrderDetails extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return PurchaseOrderDetails the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'purchase_order_details';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('po_id, workorderDtl_id, qty, flowjob_id, xero_account_id', 'numerical', 'integerOnly' => true),
            array('image, notation, xeroLineItemID', 'length', 'max' => 255),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, po_id, workorderDtl_id, qty, image, notation, flowjob_id, xeroLineItemID', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'workorderDtl' => array(self::BELONGS_TO, 'Workorderdetails', 'workorderDtl_id'),
        );
    }

    public function rel_po() {
        return PurchaseOrders::model()->findByPk($this->po_id);
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'po_id' => 'Po',
            'workorderDtl_id' => 'Workorder Detail ID',
            'qty' => 'Qty',
            'image' => 'Image',
            'notation' => 'Notation',
            'xero_account_id' => 'Xero Account'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('workorderDtl_id', $this->workorderDtl_id);
        $criteria->compare('workorderDtl_id', $this->flowjob_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('image', $this->image, true);
        $criteria->compare('notation', $this->notation, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function searchForProductDecorations() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('workorderDtl_id', $this->workorderDtl_id);
        $criteria->compare('workorderDtl_id', $this->flowjob_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('image', $this->image, true);
        $criteria->compare('notation', $this->notation, true);

        $criteria->group = 't.workorderDtl_id';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getJobProductCostPrice() {
        $jobproduct = JobProducts::model()->findByPk($this->flowjob_id);

        if (!empty($jobproduct)) {
            return $jobproduct->prodCostPrice;
        } else {
            return null;
        }
    }

    public function getJobProductDecoration() {
        $job_product_decoration = JobProductDecorations::model()->findByPk($this->flowjob_id);

        if (!empty($job_product_decoration)) {
            return $job_product_decoration;
        } else {
            return null;
        }
    }

    private $productDecorations;

    public function getProductMultiDecorationHtml() {

        if (!$this->productDecorations) {
            $this->productDecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = {$this->po_id} and workorderDtl_id = {$this->workorderDtl_id}"));
        }


        $html = "";
        foreach ($this->productDecorations as $prdDeco) {

            //skip the line if the code is INCLUDE_PRODUCT
            if (!in_array($prdDeco->decprtnam, array(JobProductDecorations::PRODUCT_DECORATION_LINE_CODE))) {
                $deco = Decoration::model()->find(array('condition' => "decprtnam = '$prdDeco->decprtnam'"));

                $decorationdesc = '<a href="' . Yii::app()->createUrl("decoration/view", array("id" => $deco->decsno)) . '" target="_blank">CODE [ ' . $prdDeco->decprtnam . ' ]</a><br>';

                $decorationdesc .= nl2br($prdDeco->decdesc);


                $html .= $decorationdesc . nl2br($prdDeco->getCustomizationDetail());

                $html .= $prdDeco->getXeroAccountHtml();
            }
        }




        return $html;
    }

    public function getProductMultiDecorationHtmlWithoutLinks() {

        if (!$this->productDecorations) {
            $this->productDecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = {$this->po_id} and workorderDtl_id = {$this->workorderDtl_id}"));
        }


        $html = "";
        foreach ($this->productDecorations as $prdDeco) {
            $deco = Decoration::model()->find(array('condition' => "decprtnam = '$prdDeco->decprtnam'"));

            $decorationdesc = 'CODE [ ' . $prdDeco->decprtnam . ' ]<br>';

            $decorationdesc .= nl2br($prdDeco->decdesc);


            $html .= $decorationdesc . nl2br($prdDeco->getCustomizationDetail());
        }




        return $html;
    }

    public function getProductMultiDecorationCostPriceHtml($showProductCost = false) {

        if (!$this->productDecorations) {
            $this->productDecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = {$this->po_id} and workorderDtl_id = {$this->workorderDtl_id}"));
        }





        if ($showProductCost) {

            $itemQty = $this->workorderDtl->prodQty;
            $productCost = $this->workorderDtl->prodCostPrice;
            $productCostAmount = $productCost * $itemQty;

            $totalWithProductCost = $productCostAmount;

            $html = "<table class='costprice'>";
            $html .= "<tr >";
            $html .= "<td class='description'>Product Cost</td>";
            $html .= "<td class='price'>" . number_format($productCost, 2) . "</td>";
            $html .= "<td class='price'>" . number_format($productCostAmount, 2) . "</td>";
            $html .= "</tr >";

            $html .= "</table>";
        }


        $html .= "<table class='costprice'>";
        $html .= "<tr >
                    <th>Name</th>
                    <th>Cost</th>
                    <th>Setup</th>
                    <th>Amount</th>
                 </tr>";
        $decoCostTotal = 0;
        foreach ($this->productDecorations as $prdDeco) {

            //skip the line if the code is INCLUDE_PRODUCT
            if (!in_array($prdDeco->decprtnam, array(JobProductDecorations::PRODUCT_DECORATION_LINE_CODE))) {

                $workorderDetailDecoration = $prdDeco->rel_workorder_detail_decoration();
                $decocost = round($prdDeco->decoCostPrice * $prdDeco->decoQty, 2);
                //$logosetup = round($workorderDetailDecoration->logo_setup_unit_price * $prdDeco->decoQty, 2);
                $amount = ($decocost + $workorderDetailDecoration->logo_setup);
                $decoCostTotal += $amount;
                if ($showProductCost) {
                    $totalWithProductCost += $amount;
                }
                $html .= "<tr>
                        <td class='description'>{$prdDeco->decprtnam}</td>
                        <td class='price'>" . number_format($prdDeco->decoCostPrice, 2) . "</td>
                        <td class='price'>" . number_format($workorderDetailDecoration->logo_setup_unit_price, 2) . "</td>
                        <td class='price'>" . number_format($amount, 2) . "</td>
                    </tr>";
            }
        }
        $html .= "<tr>
                        <td class='description' colspan='3' style='border-top:1px solid #000;'>Decoration Cost Total</td>                       
                        <td class='price'  style='border-top:1px solid #000;'>" . number_format($decoCostTotal, 2) . "</td>
                    </tr>";


        if ($showProductCost) {
            $html .= "<tr>
                        <td class='description' colspan='3'  >Total Cost with Product</td>                       
                        <td class='price'  >" . number_format($totalWithProductCost, 2) . "</td>
                    </tr>";
        }


        $html .= "</table>";

        return $html;
    }

    public function getProductMultiDecorationLineAmount() {

        if (!$this->productDecorations) {
            $this->productDecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = {$this->po_id} and workorderDtl_id = {$this->workorderDtl_id}"));
        }


        $lineAmount = 0;
        foreach ($this->productDecorations as $prdDeco) {



            $lineAmount += ($prdDeco->decoQty * $prdDeco->decoCostPrice);
            $lineAmount += ($prdDeco->decoQty * $prdDeco->workorderDtlDeco->logo_setup_unit_price);
        }




        return $lineAmount;
    }

}
