<?php

/**
 * This is the model class for table "purchase_order_flag".
 *
 * The followings are the available columns in table 'purchase_order_flag':
 * @property integer $id
 * @property integer $po_id
 * @property integer $show_product_cost
 * @property integer $show_decoration
 * @property integer $show_decoration_cost
 * @property integer $show_customisation_details
 * @property integer $show_notes
 * @property integer $show_job_info
 * @property integer $show_website_ordering_info
 * @property integer $show_price_on_pdf
 * @property string $po_type
 * @property integer $show_logo_setup
 */
class PurchaseOrderFlag extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return PurchaseOrderFlag the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'purchase_order_flag';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('po_id', 'required'),
            array('po_id, show_product_cost, show_decoration, show_decoration_cost, show_customisation_details, show_notes, show_job_info, show_website_ordering_info, show_price_on_pdf, show_logo_setup', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, po_id, show_product_cost, show_decoration, show_decoration_cost, show_customisation_details, show_notes, show_job_info, show_website_ordering_info, show_price_on_pdf, po_type', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'po_id' => 'Po',
            'show_product_cost' => 'Show Product Cost',
            'show_decoration' => 'Show Decoration',
            'show_decoration_cost' => 'Show Decoration Cost',
            'show_customisation_details' => 'Show Customisation Details',
            'show_notes' => 'Show Notes',
            'show_job_info' => 'Show Job Info',
            'show_website_ordering_info' => 'Show Website Ordering Info',
            'show_price_on_pdf' => 'Show Price on PDF',
            'show_logo_setup' => 'Show Logo Setup'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('po_id', $this->po_type);
        $criteria->compare('show_product_cost', $this->show_product_cost);
        $criteria->compare('show_decoration', $this->show_decoration);
        $criteria->compare('show_decoration_cost', $this->show_decoration_cost);
        $criteria->compare('show_decoration_cost', $this->show_logo_setup);
        $criteria->compare('show_customisation_details', $this->show_customisation_details);
        $criteria->compare('show_notes', $this->show_notes);
        $criteria->compare('show_job_info', $this->show_job_info);
        $criteria->compare('show_website_ordering_info', $this->show_website_ordering_info);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}
