<?php

/**
 * This is the model class for table "purchase_order_notes".
 *
 * The followings are the available columns in table 'purchase_order_notes':
 * @property integer $id
 * @property integer $delivery_status_id
 * @property string $note
 * @property integer $createdBy
 * @property string $createdDtm
 */
class PurchaseOrderNotes extends CActiveRecord
{
    public $note;
    /**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PurchaseOrderNotes the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'purchase_order_notes';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('po_id, delivery_note_id, createdBy', 'numerical', 'integerOnly'=>true),
			//array('note', 'length', 'max'=>255),
			array('createdDtm', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, po_id, delivery_note_id, createdBy, createdDtm', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'purchaseOrder' => array(self::BELONGS_TO, 'PurchaseOrders', 'po_id'),
                    'deliveryStaus' => array(self::BELONGS_TO, 'DeliveryStatus', 'delivery_note_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
                        'po_id'=>'PO ID',
			'delivery_note_id' => 'Delivery Note',			
			'createdBy' => 'Created By',
			'createdDtm' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
                $criteria->compare('po_id',$this->po_id);
		$criteria->compare('delivery_note_id',$this->delivery_note_id);		
		$criteria->compare('createdBy',$this->createdBy);
		$criteria->compare('createdDtm',$this->createdDtm,true);
                
                $criteria->order = 'id desc';

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function beforeSave() {
        $this->createdBy = Yii::app()->user->id;
        $this->createdDtm = date("Y-m-d g:i");

        return parent::beforeSave();
    }
}