<?php

/**
 * This is the model class for table "purchase_orders".
 *
 * The followings are the available columns in table 'purchase_orders':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorder_id
 * @property integer $supplier_id
 * @property integer $quote_id
 * @property string $quoteNum
 * @property string $poNum
 * @property string $poType
 * @property string $notation
 * @property string $followupDate
 * @property string $dueDate
 * @property integer $user_id
 * @property integer $status_id
 * @property integer $xero_in_queue
 * @property integer $xero_to_be_sent
 */
class PurchaseOrders extends CActiveRecord implements MYOBSynchronizable {

    const PO_TYPE_PROUDCT = 'Purchase Product';
    const PO_TYPE_PROUDCT_DECORATION = 'Purchase Product-Decoration';
    const PO_TYPE_PROUDCT_OTHER_COST = 'Purchase Product-OtherCost';

    public $customer_search;
    public $filterPastDue = false;
    var $inventoryArtworkID;
    public $createddatefrom;
    public $createddateto;
    public $followupdatefrom;
    public $followupdateto;
    public $expecteddatefrom;
    public $expecteddateto;
    public $delivery_status_id;
    public $delivery_notes;
    public $supplier_search;
    public $job_search;

    /**
     * Provide the logic to be synchronized this record in an API 
     * @var MYOBSynchronizer concrete implementation of Synchronizer
     */
    public $synchronizer;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return PurchaseOrders the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'purchase_orders';
    }

    public function behaviors() {
        return array(
            'ERememberFiltersBehavior' => array(
                'class' => 'ext.yii-remember-filters-gridview-master.components.ERememberFiltersBehavior',
                'defaults' => array(), /* optional line */
                'defaultStickOnClear' => false /* optional line */
            ),
        );
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('job_id, workorder_id, supplier_id, quote_id, user_id, status_id, 
                inventoryArtworkID, delivery_status_id, artwork_job_id, xero_status, followup_status_id, xero_in_queue, xero_to_be_sent', 'numerical', 'integerOnly' => true),
            array('supplier_id,dueDate', 'required'),
            array('quoteNum, poNum', 'length', 'max' => 45),
            array('poType, image, xeroPurchaseOrderID', 'length', 'max' => 255),
            array('followupDate, dueDate, createdDtm, createddatefrom, createddateto
                , followupdatefrom, followupdateto, expecteddatefrom, expecteddateto, delivery_notes, supplier_search, filterPastDue, job_search, jobNumber, notation, customer_search', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, job_id, workorder_id, supplier_id, quote_id, quoteNum, poNum, poType, notation, 
                followupDate, dueDate, user_id, status_id, inventoryArtworkID, xeroPurchaseOrderID, xero_status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'workorder' => array(self::BELONGS_TO, 'Workorder', 'workorder_id'),
            'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
            'supplier_' => array(self::BELONGS_TO, 'Supplier', 'supplier_id'),
            'flag' => array(self::HAS_ONE, 'PurchaseOrderFlag', 'po_id'),
        );
    }

    public function rel_po_dtl() {
        return PurchaseOrderDetails::model()->findAll(array('condition' => "po_id = {$this->id}"));
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'job_id' => 'Job ID',
            'workorder_id' => 'Sales Order',
            'supplier_id' => 'Supplier',
            'quote_id' => 'Quote',
            'quoteNum' => 'Quote Num',
            'poNum' => 'PO Number',
            'poType' => 'Po Type',
            'notation' => 'Notes',
            'followupDate' => 'PO Follow Up Date',
            'dueDate' => 'PO Due Date',
            'user_id' => 'Created By',
            'status_id' => 'Status',
            'createdDtm' => 'Created Date',
            'image' => 'Image',
            'supplier_search' => 'Supplier',
            'artwork_job_id' => 'Artwork Job',
            'job_search' => 'Job',
            'customer_search' => 'Customer',
            'followup_status_id' => 'Follow-Up Status',
            'xero_to_be_sent' => 'To Be Sent'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('supplier_', 'job', 'job.customer');

        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.job_id', $this->job_id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('t.supplier_id', $this->supplier_id);
        $criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.poNum', $this->poNum, true);
        $criteria->compare('t.poType', $this->poType);
        $criteria->compare('t.notation', $this->notation, true);
        $criteria->compare('t.followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('t.user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('t.createdDtm', $this->createdDtm, true);

        $criteria->compare('supplier_.supnam', $this->supplier_search, true);

        $criteria->compare('job.jobNum', $this->job_search, true);

        $criteria->compare('customer.cusnam', $this->customer_search, true);

        if ($this->filterPastDue == true) {
            $nonSearchStatusIds = array(Status::SYS_STATUS_CANCELLED, Status::SYS_STATUS_ORDER_COMPLETED);
            $nonSearchStatusIdString = implode(',', $nonSearchStatusIds);
            $criteria->addCondition("t.status_id NOT IN ({$nonSearchStatusIdString}) AND t.dueDate < NOW()");
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }

        $criteria->order = 't.createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function searchDashboard()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('supplier_', 'job');

        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.job_id', $this->job_id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('t.supplier_id', $this->supplier_id);
        $criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.followup_status_id', $this->followup_status_id);

        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.poNum', $this->poNum, true);
        $criteria->compare('t.poType', $this->poType);
        $criteria->compare('t.notation', $this->notation, true);
        $criteria->compare('t.followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('t.user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('t.createdDtm', $this->createdDtm, true);

        $criteria->compare('supplier_.supnam', $this->supplier_search, true);

        $criteria->compare('job.jobNum', $this->job_search, true);        

        $criteria->order = 't.createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.createdDtm DESC',
                'attributes' => array(
                    'poNum',
                ),
            ),
        ));
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchXeroQueue() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('supplier_', 'job', 'job.customer');

        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.job_id', $this->job_id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('t.supplier_id', $this->supplier_id);
        $criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.poNum', $this->poNum, true);
        $criteria->compare('t.poType', $this->poType);
        $criteria->compare('t.notation', $this->notation, true);
        $criteria->compare('t.followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('t.user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('t.createdDtm', $this->createdDtm, true);

        $criteria->compare('supplier_.supnam', $this->supplier_search, true);

        $criteria->compare('job.jobNum', $this->job_search, true);

        $criteria->compare('customer.cusnam', $this->customer_search, true);

        $criteria->addCondition('t.xero_in_queue = 1');

        $criteria->order = 't.createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function search2() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('workorder_id', $this->workorder_id);
        $criteria->compare('supplier_id', $this->supplier_id);
        $criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('poNum', $this->poNum, true);
        $criteria->compare('poType', $this->poType, true);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('dueDate', $this->dueDate, true);
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('status_id', $this->status_id);
        $criteria->compare('createdDtm', $this->createdDtm, true);

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }

        $criteria->order = 'createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function searchoutstadingpos() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('job');

        //$criteria->compare('id', $this->id);
        //$criteria->compare('job_id', $this->job_id);
        //$criteria->compare('workorder_id', $this->workorder_id);
        $criteria->compare('t.supplier_id', $this->supplier_id);
        //$criteria->compare('quote_id', $this->quote_id);
        //$criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('poNum', $this->poNum, true);
        $criteria->compare('poType', $this->poType);
        //$criteria->compare('notation', $this->notation, true);
        //$criteria->compare('followupDate', $this->followupDate, true);
        //$criteria->compare('dueDate', $this->dueDate, true);
        //$criteria->compare('user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('job.jobNum', $this->jobNumber, true);
        //for createdDtm
        if (!empty($this->createddatefrom) && !empty($this->createddateto)) {
            $criteria->addCondition(" DATE_FORMAT(t.createdDtm, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->createddatefrom)) . "' and '" . date('Y-m-d', strtotime($this->createddateto)) . "' ");
        } else if (!empty($this->createddatefrom) && empty($this->createddateto)) {
            $criteria->addCondition(" DATE_FORMAT(t.createdDtm, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->createddatefrom)) . "'");
        } else if (empty($this->createddatefrom) && !empty($this->createddateto)) {
            $criteria->addCondition(" DATE_FORMAT(t.createdDtm, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->createddateto)) . "'");
        }

        //for follow-up date
        if (!empty($this->followupdatefrom) && !empty($this->followupdateto)) {
            $criteria->addCondition(" DATE_FORMAT(t.followupDate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->followupdatefrom)) . "' and '" . date('Y-m-d', strtotime($this->followupdateto)) . "' ");
        } else if (!empty($this->followupdatefrom) && empty($this->followupdateto)) {
            $criteria->addCondition(" DATE_FORMAT(t.followupDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->followupdatefrom)) . "'");
        } else if (empty($this->followupdatefrom) && !empty($this->followupdateto)) {
            $criteria->addCondition("DATE_FORMAT(t.followupDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->followupdateto)) . "'");
        }

        //for due date
        if (!empty($this->expecteddatefrom) && !empty($this->expecteddateto)) {
            $criteria->addCondition(" DATE_FORMAT(t.dueDate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->expecteddatefrom)) . "' and '" . date('Y-m-d', strtotime($this->expecteddateto)) . "' ");
        } else if (!empty($this->expecteddatefrom) && empty($this->expecteddateto)) {
            $criteria->addCondition(" DATE_FORMAT(t.dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->expecteddatefrom)) . "'");
        } else if (empty($this->expecteddatefrom) && !empty($this->expecteddateto)) {
            $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->expecteddateto)) . "'");
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }



        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        $paramarr = array('supplier_id=:' => $this->supplier_id, 'poNum=:' => $this->poNum, 'poType=:' => $this->poType,
            'status_id=:' => $this->status_id);

        foreach ($paramarr as $key => $value) {
            $position = strpos($originalQuery, $key);
            if (!empty($position)) {
                $param = str_replace('=:', '', $key);
                $param .= "='$value'";
                $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
            }
        }

        if (isset(Yii::app()->session['outstandingreport_query']))
            unset(Yii::app()->session['outstandingreport_query']);

        Yii::app()->session['outstandingreport_query'] = $originalQuery;

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        $sort = new CSort;
        $sort->attributes = array(
            'jobDueDate' => array(
                'asc' => 'job.dueDate',
                'desc' => 'job.dueDate desc',
            ),
            'jobNumber' => array(
                'asc' => 'job.jobNum',
                'desc' => 'job.jobNum desc',
            ),
            'poNum' => array(
                'asc' => 'poNum',
                'desc' => 'poNum desc',
            ),
            'followupDate' => array(
                'asc' => 't.followupDate',
                'desc' => 't.followupDate desc',
            ),
            'dueDate' => array(
                'asc' => 't.dueDate',
                'desc' => 't.dueDate desc',
            ),
            'supplier_id' => array(
                'asc' => 't.supplier_id',
                'desc' => 't.supplier_id desc',
            ),
            'poType' => array(
                'asc' => 't.poType',
                'desc' => 't.poType desc',
            ),
            'status_id' => array(
                'asc' => 't.status_id',
                'desc' => 't.status_id desc',
            ),
        );

        $sort->defaultOrder = 'job.dueDate desc';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => $sort
        ));
    }

    public $jobDueDate;
    public $jobNumber;

    public function searchDue($nextdays) {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('supplier_');

        $criteria->compare('id', $this->id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('workorder_id', $this->workorder_id);
        $criteria->compare('supplier_id', $this->supplier_id);
        $criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('poNum', $this->poNum, true);
        $criteria->compare('poType', $this->poType);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('dueDate', $this->dueDate, true);
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('status_id', $this->status_id);
        $criteria->compare('createdDtm', $this->createdDtm, true);

        $criteria->compare('supplier_.supnam', $this->supplier_search, true);

        $criteria->addCondition("dueDate between NOW() and DATE_ADD(NOW(), INTERVAL {$nextdays} DAY)");

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }

        $criteria->order = 'dueDate ASC';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getProductDetails() {
        $html = "<div><table>";
        $html .= "<tr>
                    <th style='text-align:center;font-weight:bold;font-size:0.8em;'>#</th>
                    <th style='text-align:center;font-weight:bold;font-size:0.8em;'>Product</th>
                  </tr>";

        $podtls = PurchaseOrderDetails::model()->findAll("po_id = '{$this->id}'");

        foreach ($podtls as $podtl) {
            $workorderdtl = Workorderdetails::model()->findByPk($podtl->workorderDtl_id);
            $html .= "<tr>
                        <td style='text-align:center'>{$workorderdtl->productsku}</td>
                        <td style='text-align:center'>{$workorderdtl->prdsrtdesc}</td>    
                     </tr>";
        }



        $html .= "</table></div>";
        return $html;
    }

    public function getProdQtyTotal() {
        $purchaseorderdtls = PurchaseOrderDetails::model()->findAll("po_id = '{$this->id}'");
        $totQty = 0;
        foreach ($purchaseorderdtls as $poDtl) {

            $totQty += $poDtl->qty;
        }

        return $totQty;
    }

    public function getProdCostTotal() {
        $purchaseorderdtls = PurchaseOrderDetails::model()->findAll("po_id = '{$this->id}'");
        $totPrice = 0;
        foreach ($purchaseorderdtls as $poDtl) {
            $wrkorderDtl = Workorderdetails::model()->findByPk($poDtl->workorderDtl_id);
            if ($this->poType == 'Purchase Product') {
                $totPrice += $wrkorderDtl->prodCostPrice;
            } else if ($this->poType == 'Purchase Product-Decoration') {
                $totPrice += $wrkorderDtl->decoCostPrice;
            }
        }

        return $totPrice;
    }

    public function getProdAmountTotal() {
        $purchaseorderdtls = PurchaseOrderDetails::model()->findAll("po_id = '{$this->id}'");
        $totAmnt = 0;
        foreach ($purchaseorderdtls as $poDtl) {
            $wrkorderDtl = Workorderdetails::model()->findByPk($poDtl->workorderDtl_id);
            if ($this->poType == 'Purchase Product') {
                $totAmnt += $wrkorderDtl->prodCostPrice * $poDtl->qty;
            } else if ($this->poType == 'Purchase Product-Decoration') {
                $totAmnt += $wrkorderDtl->decoCostPrice * $poDtl->qty;
            }
        }

        return $totAmnt;
    }

    var $no_column_width = 5;
    var $img_column_width = 20;
    var $prod_column_width = 20;
    var $deco_column_width = 30;
    var $qty_column_width = 5;
    var $cost_column_width = 10;
    var $amnt_column_width = 10;
    var $show_custmizedtl = true;
    var $show_notes = true;
    var $cutmz_column_width = 45;
    var $notes_column_width = 55;

    public function generatePDF($parms_arr) {
        $model = $this;

        $show_price = $parms_arr['show_price'];
        $show_decoration = $parms_arr['show_decoration'];
        $this->show_custmizedtl = $parms_arr['show_custmizedtl'];
        $this->show_notes = $parms_arr['show_notes'];
        $show_job_info = $parms_arr['show_job_info'];

        if ($model->poType == 'Purchase Product-Decoration') {
            $this->generatePDFProductDecoration($model, $show_price, $show_decoration, $show_job_info);
        }

        if ($show_price == false && $show_decoration == false) {
            $this->prod_column_width = 50;
            $this->deco_column_width = 0; //optional
            $this->qty_column_width = 25;
            $this->cost_column_width = 0; //optional
            $this->amnt_column_width = 0; //optional
        } else if ($show_price == true && $show_decoration == false) {

            $this->prod_column_width = 50;
            $this->deco_column_width = 0; //optional
        } else if ($show_price == false && $show_decoration == true) {
            $this->prod_column_width = 30;
            $this->deco_column_width = 35;
            $this->qty_column_width = 10;
        }


        if ($this->show_custmizedtl == true && $this->show_notes == true) {
            $this->cutmz_column_width = 45; //optional
            $this->notes_column_width = 55; //optional
        } else if ($this->show_custmizedtl == true && $this->show_notes == false) {
            $this->cutmz_column_width = 100;
        } else if ($this->show_custmizedtl == false && $this->show_notes == true) {
            $this->notes_column_width = 100;
        }

        $slog = SalesLog::model()->find("comments = 'Purchase Order PDF for ({$model->poNum}) is created'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quote_id, $model->workorder->id, $model->quoteNum, 'Job', "Purchase Order PDF for ({$model->poNum}) is created", 1, 1, 1);
            SalesLog::createSalesLog($model->quote_id, $model->workorder->id, $model->quoteNum, $model->poNum, "Purchase Order PDF for ({$model->poNum}) is created", 1, 1, 1);
        }


        $pdf = Yii::createComponent('application.extensions.tcpdf.ETcPdf', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle(Yii::app()->name . ' - Purchase Order');
        $pdf->SetSubject('Purchase Order');
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();

//Write the html
//Convert the Html to a pdf document

        $potype = "";
        if ($model->poType == 'Purchase Product')
            $potype = 'PRODUCT PO';
        else if ($model->poType == 'Purchase Product-Decoration') {
            $potype = 'PRODUCT DECORATION PO';
        } else if ($model->poType == 'Purchase Artwork') {
            $potype = 'ARTWORK PO';
        }

        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;text-align:center;font-size:2em;">PURCHASE ORDER</td></tr>
                    <tr><td style="width:100%;text-align:center;font-size:2em;">' . $model->poNum . '</td></tr>    
                  </table><br/><br/>';

        $productionCoordinator = '';
        if (!empty($model->workorder->prd_cordinator_id)) {
            $usercoord = User::model()->findByPk($model->workorder->prd_cordinator_id);
            if (!empty($usercoord)) {
                $productionCoordinator = $usercoord->username;
            }
        } else {
            $usercoord = User::model()->findByPk($model->job->prd_cordinator_id);
            if (!empty($usercoord)) {
                $productionCoordinator = $usercoord->username;
            }
        }

        $html .= '<table style="width:100%;">
                    <tr>
                        <td style="width:33%;text-align:left;font-size:1em;font-weight:bold;">Production Coordinator : ' . ucwords($productionCoordinator) . '</td>
                        <td style="width:33%;text-align:left;font-size:1.5em;font-weight:bold;">Due Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)) . '</td>    
                        <td style="width:33%;text-align:right;font-size:1em;">' . $potype . '</td>
                     </tr></table>';

        $html .= '<table style="width:100%;border-bottom:1px solid black;border-top:1px solid black;padding:5px;">';

        $html .= '<tr><td style="width:50%;font-size:1.2em;">Sales Person : ' . ucwords($model->job->ws_user) . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->createdDtm)) . '</td></tr>';

        $jobnumtd = '';
        $cusnamtd = '';
        if ($show_job_info == true) {
            $jobnumtd = 'Job : ' . $model->job->jobNum;
            $cusnamtd = 'Customer : ' . $model->job->customer->cusnam;
        }
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Supplier : ' . (!empty($model->supplier_) ? $model->supplier_->supnam : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">' . $jobnumtd . ' </td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Address : ' . (!empty($model->supplier_) ? $model->supplier_->getFullAddress() : '') . ',' . (!empty($model->supplier_) ? $model->supplier_->suppostcode : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">' . $cusnamtd . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">E-mail :  ' . (!empty($model->supplier_) ? $model->supplier_->supemail : '') . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Telephone :  ' . (!empty($model->supplier_) ? $model->supplier_->suptel : '') . ' </td></tr>';

        $html .= '</table><br/>';

        if ($model->poType == 'Purchase Artwork') {
            $artwork = JobArtwork::model()->findByPk($model->artwork_job_id);

            if (!empty($artwork)) {
                $html .= '<h3>ARTWORK DETIALS</h3>';
                //artwork details
                $html .= '<table style="width:100%;">';

                $artworkdetails = JobArtworkDetail::model()->findAll(array('condition' => "job_artowk_id = '{$artwork->id}'"));
                $items = '';
                foreach ($artworkdetails as $dtl) {
                    $items .= $dtl->workorderDtl->productsku . '(' . $dtl->workorderDtl->prdsrtdesc . ') - ';
                }

                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Item : ' . $items . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Embroidery Position : ' . $artwork->decorationType . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Print Size :  ' . $artwork->printSize . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Product Colour : ' . $artwork->productColor . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Print Colour :  ' . $artwork->printColor . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Design # : ' . $artwork->designNumber . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Repeat Design : ' . ($artwork->isRepeatDesign == true ? 'Yes' : 'No') . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Comment : ' . $artwork->comments . '</td></tr>';
                $html .= '<tr><td style="width:100%;font-size:1.2em;text-align:center;"><img src="images/artwork/job/' . $artwork->artworkjobNum . '/' . $artwork->archiveImageLogo . '" style="width:250px;"/></td></tr>';
                $html .= '</table><br/>';
            }
        }

        if ($model->poType == 'Purchase Embroidery Tape') {
            $inventoryartwrk = InventoryArtWork::model()->find("embrTapePo_id = '{$model->id}'");
            $html .= '<table style="width:100%;border-bottom:1px solid black;padding:5px;">';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Artwork Code : ' . $inventoryartwrk->artworkcode . ' </td></tr>';

            $html .= '<tr><td style="width:20%;font-size:1.2em;">Artwork Image </td><td style="width:80%;font-size:1.2em;text-align:left;"><img src="images/artwork/' . $inventoryartwrk->image . '" width="150px" height="150px"/></td></tr>';


            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Comments : ' . $model->notation . ' </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Quantity : 1 </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Unit Price : 100.00 </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Expected Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)) . ' </td></tr>';

            $html .= '</table><br/>';
        }

        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
            $html .= '<table style="width: 100%;height:100%;border:1px solid #000;padding:2px;">';
        }

        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
            $html .= '<tr style="width: 100%;background-color:#DDD;">
                    <td style="width: 100%;border:1px solid #000;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <th style="width: 5%;text-align: center;" >No</th>
                                <th style="width: 20%;text-align: center;">Image</th>
                                <th style="width: ' . $this->prod_column_width . '%;text-align: center;">Product</th>';

            if ($show_decoration == true)
                $html .= '<th style="width: ' . $this->deco_column_width . '%;text-align: center;">Decoration</th>';


            $html .= '<th style="width: ' . $this->qty_column_width . '%;text-align: center;">Qty</th>';

            if ($show_price == true) {
                $html .= '<th style="width: 10%;text-align: center;">Cost Price</th>
                                <th style="width: 10%;text-align: center;">Amount</th>';
            }

            $html .= '</tr>

                        </table>
                    </td>

                </tr>';
        }


        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {

            $purchaseorderdetailsList = PurchaseOrderDetails::model()->findAll("po_id = '{$model->id}'");

            $htmlbodyrows = '';

            foreach ($purchaseorderdetailsList as $record) {
                $this->count++;
                $this->rowtype = $this->count % 2;
                if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
                    $htmlbodyrows .= $this->getPurchaseProductHtml($model, $record, $show_price, $show_decoration);
                }
            }
        }

        $html .= $htmlbodyrows;





        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
            $html .= '<tr style="width: 100%;background-color:#CCC;">
                    <td style="width: 100%;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <td style="width: 5%;"></td>
                                <td style="width: 20%;"></td>';

            if ($show_decoration == true)
                $html .= '<td style="width: ' . $this->prod_column_width . '%;"></td>';
            else
                $html .= '<td style="width: ' . $this->prod_column_width . '%;text-align:center;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>';


            if ($show_decoration == true)
                $html .= '<td style="width: ' . $this->deco_column_width . '%;text-align:center;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>';

            $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;"><div style="font-size: 1.2em; font-weight: bold; text-align: center;" id="totprodqty">  ' . $this->totalQty . ' </div></td>';

            if ($show_price == true) {
                $html .= '<td style="width: 10%;text-align: right;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellexvat">  ' . number_format($this->totalCost, 2) . '</div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellincvat">  ' . number_format($this->totalAmount, 2) . '</div></td>';
            }
            $html .= '</tr>
                        </table>
                    </td>


                </tr>';
        }

        if (in_array($model->poType, array('Purchase Product'))) {
            $html .= '</table>';
        }


        $html .= '<br/><br/><br/><br/><table style="width:100%;">';

        $html .= '<tr>
                    <td style="width:100%;font-size:1.2em;border-bottom:1px solid #000;font-weight:bold;">Delivery Instructions</td>                    
                  </tr>';
        $signofflogs = SignOffLog::model()->findAll(array('condition' => "model = 'PurchaseOrder' and model_id = '{$model->id}'", 'order' => 'id desc'));
        foreach ($signofflogs as $signoff) {
            $signoffterm = SignOffTerms::model()->findByPk($signoff->sign_off_id);

            $signofftexttoprint = '';
            if (!empty($signoff->sign_off_terms)) {
                $signofftexttoprint = $signoff->sign_off_terms;
            } else if (!empty($signoffterm)) {
                $signofftexttoprint = $signoffterm->term;
            }
            $html .= '<tr nobr="true">
                        <td style="width:100%;font-size:1.2em;">' . nl2br($signofftexttoprint) . '</td>                    
                      </tr><tr><td>&nbsp;</td></tr>';
        }


        $html .= '</table><br/>';
// data loading
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();

        $filename = str_replace("/", "-", $model->poNum) . '.pdf';
        //Close and output PDF document
        $pdf->Output("files/{$filename}", 'F');
        //Yii::app()->end();

        $fileinventory = new FileInventory();
        $fileinventory->filename = $filename;
        $fileinventory->type = 'PO';
        $fileinventory->ref_id = $model->id;

        $fileinventory->createdBy = Yii::app()->user->id;
        $fileinventory->createdDtm = date("Y-m-d g:i");

        $fileinventory->save();

        return $fileinventory;
    }

    var $rowtype = 0;
    var $count = 0;
    var $totalQty = 0;
    var $totalCost = 0;
    var $totalAmount = 0;

    private function getPurchaseProductHtml($model, $podtl, $show_price, $show_deco) {

        $record = Workorderdetails::model()->findByPk($podtl->workorderDtl_id);

        $html = '';

        //$count = 0;
        //$productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));



        //$rowcolor = "background-color:#DDD;";

        $html .= '<tr style="width:100%;" nobr="true">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                <td style="width: 20%;">';

        if (!empty($record->image) && file_exists("images/product_img/" . $record->image)) {
            $html .= '<img src="images/product_img/' . $record->image . '" width="50" height="50"/>';
        } else {
            $html .= '&nbsp;';
        }
        $html .= '</td>
                                <td style="width: ' . $this->prod_column_width . '%;"><div class="prodecs">';



        if (!empty($record->productsku)) {

            $html .= trim($record->productsku . '<br>' . $record->prdsrtdesc);
        } else {

            $html .= trim($record->custmproduct);
        }
        $html .= '</div>';



        $html .= '</td>';

        if ($show_deco == true) {
            //decoration column start
            $html .= '<td style="width: ' . $this->deco_column_width . '%;">';

            if (!empty($record->decprtnam)) {

                $html .= $record->decdesc;
            } else {

                $html .= $record->customdecoration;
            }

            $html .= '</td>';
        }
        //decoration column end
        $this->totalQty += $record->prodQty;
        $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;">
                                    ' . $record->prodQty . '
                                </td>';

        $price = 0;

        if ($model->poType == 'Purchase Product') {
            $price = $record->prodCostPrice;
            $this->totalCost += $record->prodCostPrice;
        } else if ($model->poType == 'Purchase Product-Decoration') {
            $this->totalCost += $record->decoCostPrice;
            $price = $record->decoCostPrice;
        }
        $this->totalAmount += ($price * $record->prodQty);
        if ($show_price == true) {
            $html .= '<td style="width: 10%;text-align: right;">
                                   ' . number_format($price, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($price * $record->prodQty, 2) . '
                                </td>';
        }

        $html .= '</tr>
                            <tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">';


        $html .= '<tr style="width:100%;">
                                                <td style="width:100%;">';
        if ($this->show_custmizedtl != false || $this->show_notes != false) {
            $html .= '<table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">';
            if ($this->show_custmizedtl == true)
                $html .= '<th style="width:' . $this->cutmz_column_width . '%;text-align:center;" >Customisation Details</th>';

            if ($this->show_notes == true)
                $html .= '<th style="width:' . $this->notes_column_width . '%;text-align:center;" >Notes</th>';
            $html .= '<th></th>';

            $html .= '</tr>
                                                        <tr style="width:100%;">';
            if ($this->show_custmizedtl == true)
                $html .= '<td style="width:' . $this->cutmz_column_width . '%;text-align:center;" >' . $record->customizationDetails . '</td>';
            if ($this->show_notes == true)
                $html .= '<td style="width:' . $this->notes_column_width . '%;text-align:center;" >' . $record->notes . '</td>';

            $html .= '<td ></td>';
            $html .= '</tr>';
            $html .= '</table>';
        }
        $html .= '</td></tr>';

        $html .= '<tr style="width:100%">
                                                <td style="width:100%">
                                                    <div  style="width:100%;">
                                                        <table   style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:10%;text-align:center;">#</th>
                                                            <th style="width:30%;text-align:center;">Size</th>
                                                            <th style="width:30%;text-align:center;">Quantity</th>
                                                            <th style="width:30%;text-align:center;">Colour</th>
                                                            
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr style="width:100%;" >
                                                    <td style="width:10%;text-align:center;">' . $countrow . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['size'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['qty'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['color'] . '</td>
                                                    
                                                </tr>';
        }

        $html .= ' </table></div></td></tr></table></div></td> </tr> </table>                        
                        </td>
                    </tr>';

        return $html;
    }

    //start generate pdf of product-decoration
    public function generatePDFProductDecoration($model, $show_price, $show_decoration, $show_job_info) {
        if ($show_price == false && $show_decoration == false) {
            $this->prod_column_width = 50;
            $this->deco_column_width = 0; //optional
            $this->qty_column_width = 25;
            $this->cost_column_width = 0; //optional
            $this->amnt_column_width = 0; //optional
        } else if ($show_price == true && $show_decoration == false) {

            $this->prod_column_width = 50;
            $this->deco_column_width = 0; //optional
        } else if ($show_price == false && $show_decoration == true) {
            $this->prod_column_width = 30;
            $this->deco_column_width = 35;
            $this->qty_column_width = 10;
        }


        if ($this->show_custmizedtl == true && $this->show_notes == true) {
            $this->cutmz_column_width = 45; //optional
            $this->notes_column_width = 55; //optional
        } else if ($this->show_custmizedtl == true && $this->show_notes == false) {
            $this->cutmz_column_width = 100;
        } else if ($this->show_custmizedtl == false && $this->show_notes == true) {
            $this->notes_column_width = 100;
        }





        $slog = SalesLog::model()->find("comments = 'Purchase Order ({$model->poNum}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quote_id, $model->workorder->id, $model->quoteNum, 'Job', "Purchase Order ({$model->poNum}) is printed", 1, 1, 1);
            SalesLog::createSalesLog($model->quote_id, $model->workorder->id, $model->quoteNum, $model->poNum, "Purchase Order ({$model->poNum}) is printed", 1, 1, 1);
        }


        $pdf = Yii::createComponent('application.extensions.tcpdf.ETcPdf', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle(Yii::app()->name . ' - Purchase Order');
        $pdf->SetSubject('Purchase Order');
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();

//Write the html
//Convert the Html to a pdf document

        $potype = "";
        if ($model->poType == 'Purchase Product')
            $potype = 'PRODUCT PO';
        else if ($model->poType == 'Purchase Product-Decoration') {
            $potype = 'PRODUCT DECORATION PO';
        } else if ($model->poType == 'Purchase Artwork') {
            $potype = 'ARTWORK PO';
        }


        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;text-align:center;font-size:2em;">PURCHASE ORDER</td></tr>
                    <tr><td style="width:100%;text-align:center;font-size:2em;">' . $model->poNum . '</td></tr>    
                  </table><br/><br/>';

        $productionCoordinator = '';
        if (!empty($model->workorder->prd_cordinator_id)) {
            $usercoord = User::model()->findByPk($model->workorder->prd_cordinator_id);
            if (!empty($usercoord)) {
                $productionCoordinator = $usercoord->username;
            }
        } else {
            $usercoord = User::model()->findByPk($model->job->prd_cordinator_id);
            if (!empty($usercoord)) {
                $productionCoordinator = $usercoord->username;
            }
        }

        $html .= '<table style="width:100%;">
                    <tr>
                        <td style="width:33%;text-align:left;font-size:1em;font-weight:bold;">Production Coordinator : ' . ucwords($productionCoordinator) . '</td>
                        <td style="width:33%;text-align:left;font-size:1.5em;font-weight:bold;">Due Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)) . '</td>    
                        <td style="width:33%;text-align:right;font-size:1em;">' . $potype . '</td>
                     </tr></table>';

        $html .= '<table style="width:100%;border-bottom:1px solid black;border-top:1px solid black;padding:5px;">';

        $html .= '<tr><td style="width:50%;font-size:1.2em;">Sales Person : ' . ucwords($model->job->ws_user) . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->createdDtm)) . '</td></tr>';

        $jobnumtd = '';
        $cusnamtd = '';
        if ($show_job_info == true) {
            $jobnumtd = 'Job : ' . $model->job->jobNum;
            $cusnamtd = 'Customer : ' . $model->job->customer->cusnam;
        }
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Supplier : ' . (!empty($model->supplier_) ? $model->supplier_->supnam : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:left;">' . $jobnumtd . ' </td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Address : ' . (!empty($model->supplier_) ? $model->supplier_->getFullAddress() : '') . ',' . (!empty($model->supplier_) ? $model->supplier_->suppostcode : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:left;">' . $cusnamtd . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">E-mail :  ' . (!empty($model->supplier_) ? $model->supplier_->supemail : '') . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Telephone :  ' . (!empty($model->supplier_) ? $model->supplier_->suptel : '') . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Note :  ' . $model->notation . ' </td></tr>';
        $html .= '</table><br/>';

        if ($model->poType == 'Purchase Artwork') {
            $html .= '<table style="width:100%;border-bottom:1px solid black;padding:5px;">';

            $imagehtml = '';
            if (!empty($model->image) && file_exists("images/artwork/" . $model->image)) {
                $imagehtml = '<img src="images/artwork/' . $model->image . '" width="150px" height="150px"/>';
            } else {
                $imagehtml = 'No Image';
            }

            $html .= '<tr><td style="width:20%;font-size:1.2em;">Artwork Image </td><td style="width:80%;font-size:1.2em;text-align:left;"> ' . $imagehtml . ' </td></tr>';


            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Comments : ' . $model->notation . ' </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Quantity : 1 </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Unit Price : 100.00 </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Expected Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)) . ' </td></tr>';

            $html .= '</table><br/>';
        }

        if ($model->poType == 'Purchase Embroidery Tape') {
            $inventoryartwrk = InventoryArtWork::model()->find("embrTapePo_id = '{$model->id}'");
            $html .= '<table style="width:100%;border-bottom:1px solid black;padding:5px;">';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Artwork Code : ' . $inventoryartwrk->artworkcode . ' </td></tr>';

            $html .= '<tr><td style="width:20%;font-size:1.2em;">Artwork Image </td><td style="width:80%;font-size:1.2em;text-align:left;"><img src="images/artwork/' . $inventoryartwrk->image . '" width="150px" height="150px"/></td></tr>';


            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Comments : ' . $model->notation . ' </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Quantity : 1 </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Unit Price : 100.00 </td></tr>';
            $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Expected Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->dueDate)) . ' </td></tr>';

            $html .= '</table><br/>';
        }




        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
            $html .= '<table style="width:100%;"><tr>
                    <td style="width:100%;font-size:1.2em;border-bottom:1px solid #000;font-weight:bold;">PRODUCT TO BE DECORATED</td>                    
                  </tr></table>';
            $html .= '<table style="width: 100%;height:100%;border:1px solid #000;padding:2px;">';
        }

        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
            $html .= '<tr style="width: 100%;background-color:#DDD;">
                    <td style="width: 100%;border:1px solid #000;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <th style="width: 5%;text-align: center;" >No</th>
                                <th style="width: 20%;text-align: center;">Image</th>
                                <th style="width: ' . $this->prod_column_width . '%;text-align: center;">Product</th>';

            if ($show_decoration == true)
                $html .= '<th style="width: ' . $this->deco_column_width . '%;text-align: center;">Decoration</th>';


            $html .= '<th style="width: ' . $this->qty_column_width . '%;text-align: center;">Qty</th>';

            if ($show_price == true) {
                $html .= '<th style="width: 10%;text-align: center;">Cost Price</th>
                                <th style="width: 10%;text-align: center;">Amount</th>';
            }

            $html .= '</tr>

                        </table>
                    </td>

                </tr>';
        }


        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {

            $purchaseorderdetailsList = PurchaseOrderDetails::model()->findAll("po_id = '{$model->id}'");
            $iscommondeco = false;
            $commomdecodescription = '';
            $customizationdetails = '';
            $jobproddecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = '{$model->id}'"));


            $decorationarr = array();
            $customizationarr = array();

            foreach ($jobproddecorations as $proddeco) {
                if (!empty($proddeco->commondecoprtnam)) {
                    $iscommondeco = true;
                    $decoration = Decoration::model()->find(array('condition' => "decprtnam = '{$proddeco->commondecoprtnam}'"));
                    $commomdecodescription = $decoration->decnam;
                    $customizationdetails = $proddeco->customizationDetails;
                    break;
                } else if (!empty($proddeco->commondecocustom)) {
                    $iscommondeco = true;
                    $commomdecodescription = $proddeco->commondecocustom;
                    $customizationdetails = $proddeco->customizationDetails;
                    break;
                }

                $decorationarr[] = $proddeco->workorderDtl->decdesc;
                $customizationarr[] = $proddeco->workorderDtl->customizationDetails;
            }

            if ($iscommondeco == false) {
                if (count(array_unique($decorationarr)) === 1) {
                    $commomdecodescription = $decorationarr[0];
                }

                if (count(array_unique($customizationarr)) === 1) {
                    $customizationdetails = $customizationarr[0];
                }
            }

            $htmlbodyrows = '';

            foreach ($purchaseorderdetailsList as $record) {
                $this->count++;
                $this->rowtype = $this->count % 2;
                if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
                    $htmlbodyrows .= $this->getPurchaseProductDecorationHtml($model, $record, $show_price, $show_decoration, $iscommondeco, $commomdecodescription);
                }
            }
        }

        $html .= $htmlbodyrows;





        if (in_array($model->poType, array('Purchase Product', 'Purchase Product-Decoration'))) {
            $html .= '<tr style="width: 100%;background-color:#CCC;">
                    <td style="width: 100%;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <td style="width: 5%;"></td>
                                <td style="width: 20%;"></td>';

            if ($show_decoration == true)
                $html .= '<td style="width: ' . $this->prod_column_width . '%;"></td>';
            else
                $html .= '<td style="width: ' . $this->prod_column_width . '%;text-align:center;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>';


            if ($show_decoration == true)
                $html .= '<td style="width: ' . $this->deco_column_width . '%;text-align:center;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>';

            $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;"><div style="font-size: 1.2em; font-weight: bold; text-align: center;" id="totprodqty">  ' . $model->getProdQtyTotal() . ' </div></td>';

            if ($show_price == true) {
                $html .= '<td style="width: 10%;text-align: right;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellexvat">  ' . number_format($model->getProdCostTotal(), 2) . '</div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellincvat">  ' . number_format($model->getProdAmountTotal(), 2) . '</div></td>';
            }
            $html .= '</tr>
                        </table>
                    </td>


                </tr>';
        }

        if (in_array($model->poType, array('Purchase Product'))) {
            $html .= '</table>';
        }

        $html .= '<br/><br/><br/><br/>';

        $html .= '<table style="width:100%;"><tr>
                    <td style="width:100%;font-size:1.2em;border-bottom:1px solid #000;font-weight:bold;">DECORATION DETAILS</td>                    
                  </tr></table>';

        $html .= '<table style="width:100%;">';

        $html .= '<tr>
                    <td style="width:50%;font-size:1.1em;text-align:center;">Decoration</td><td style="width:50%;font-size:1.1em;text-align:center;">Customisation Details</td>                        
                </tr>';

        $html .= '<tr>
                    <td style="width:50%;font-size:1em;text-align:center;">' . $commomdecodescription . '</td><td style="width:50%;font-size:1em;text-align:center;">' . $customizationdetails . '</td>                        
                </tr>';
        $html .= '</table>';

        $html .= '<br/><br/><br/><br/><table style="width:100%;">';

        $html .= '<tr>
                    <td style="width:100%;font-size:1.2em;border-bottom:1px solid #000;font-weight:bold;">DELIVERY INSTRUCTIONS</td>                    
                  </tr>';
        $signofflogs = SignOffLog::model()->findAll(array('condition' => "model = 'PurchaseOrder' and model_id = '{$model->id}'", 'order' => 'id desc'));
        foreach ($signofflogs as $signoff) {
            $signoffterm = SignOffTerms::model()->findByPk($signoff->sign_off_id);

            $signofftexttoprint = '';
            if (!empty($signoff->sign_off_terms)) {
                $signofftexttoprint = $signoff->sign_off_terms;
            } else if (!empty($signoffterm)) {
                $signofftexttoprint = $signoffterm->term;
            }
            $html .= '<tr nobr="true">
                        <td style="width:100%;font-size:1.2em;">' . nl2br($signofftexttoprint) . '</td>                    
                      </tr><tr><td>&nbsp;</td></tr>';
        }



        $html .= '</table><br/>';
// data loading
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();
        $filename = str_replace("/", "-", $model->poNum) . '.pdf';
        //Close and output PDF document
        $pdf->Output("files/{$filename}", 'F');
        //Yii::app()->end();

        $fileinventory = new FileInventory();
        $fileinventory->filename = $filename;
        $fileinventory->type = 'PO';
        $fileinventory->ref_id = $model->id;

        $fileinventory->createdBy = Yii::app()->user->id;
        $fileinventory->createdDtm = date("Y-m-d g:i");

        $fileinventory->save();

        return $fileinventory;
    }

    private function getPurchaseProductDecorationHtml($model, $podtl, $show_price, $show_deco, $iscommondeco, $commomdecodescription) {

        $record = Workorderdetails::model()->findByPk($podtl->workorderDtl_id);

        $html = '';

        $count = 0;


        $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        $decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));



        $rowcolor = "background-color:#DDD;";

        $html .= '<tr style="width:100%;" nobr="true">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                <td style="width: 20%;">';

        if (!empty($record->image) && file_exists("images/product_img/" . $record->image)) {
            $html .= '<img src="images/product_img/' . $record->image . '" width="50" height="50"/>';
        } else {
            $html .= '&nbsp;';
        }
        $html .= '</td>
                                <td style="width: ' . $this->prod_column_width . '%;"><div class="prodecs">';



        if (!empty($record->productsku)) {

            $html .= trim($record->productsku . '<br>' . $record->prdsrtdesc);
        } else {

            $html .= trim($record->custmproduct);
        }
        $html .= '</div>';



        $html .= '</td>';

        if ($show_deco == true) {
            //decoration column start
            $html .= '<td style="width: ' . $this->deco_column_width . '%;">';

            if ($iscommondeco == true) {
                $html .= $commomdecodescription;
            } else {
                if (!empty($record->decprtnam)) {

                    $html .= $record->decdesc;
                } else {

                    $html .= $record->customdecoration;
                }
            }


            $html .= '</td>';
        }
        //decoration column end

        $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;">
                                    ' . $record->prodQty . '
                                </td>';

        $price = 0;

        if ($model->poType == 'Purchase Product') {
            $price = $record->prodCostPrice;
        } else if ($model->poType == 'Purchase Product-Decoration') {
            $price = $record->decoCostPrice;
        }

        if ($show_price == true) {
            $html .= '<td style="width: 10%;text-align: right;">
                                   ' . number_format($price, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($price * $record->prodQty, 2) . '
                                </td>';
        }

        $html .= '</tr>
                            <tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">';

        if ($iscommondeco == false) {
            $html .= '<tr style="width:100%;">
                                                <td style="width:100%;">';



            if ($this->show_custmizedtl != false || $this->show_notes != false) {
                $html .= '<table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">';
                if ($this->show_custmizedtl == true)
                    $html .= '<th style="width:' . $this->cutmz_column_width . '%;text-align:center;" >Customisation Details</th>';

                if ($this->show_notes == true)
                    $html .= '<th style="width:' . $this->notes_column_width . '%;text-align:center;" >Notes</th>';
                $html .= '<th></th>';

                $html .= '</tr>
                                                        <tr style="width:100%;">';
                if ($this->show_custmizedtl == true)
                    $html .= '<td style="width:' . $this->cutmz_column_width . '%;text-align:center;" >' . $record->customizationDetails . '</td>';
                if ($this->show_notes == true)
                    $html .= '<td style="width:' . $this->notes_column_width . '%;text-align:center;" >' . $record->notes . '</td>';


                $html .= '<td ></td>';
                $html .= '</tr>';
                $html .= '</table>';
            }

            $html .= '</td></tr>';
        }
        $html .= '<tr style="width:100%">
                                                <td style="width:100%">
                                                    <div  style="width:100%;">
                                                        <table   style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:10%;text-align:center;">#</th>
                                                            <th style="width:30%;text-align:center;">Size</th>
                                                            <th style="width:30%;text-align:center;">Quantity</th>
                                                            <th style="width:30%;text-align:center;">Colour</th>
                                                            
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr style="width:100%;" >
                                                    <td style="width:10%;text-align:center;">' . $countrow . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['size'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['qty'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['color'] . '</td>
                                                    
                                                </tr>';
        }

        $html .= ' </table></div></td></tr></table></div></td> </tr> </table>                        
                        </td>
                    </tr>';

        return $html;
    }

    //end generate pdf of product-decoration


    public function getTextAreaForPOView($fieldname, $modelvalue, $elmID) {
        $html = '';

        if ($elmID != null) {
            $html .= CHtml::textArea($fieldname, $modelvalue, array("style" => "width:300px;", "rows" => 5, "id" => $fieldname . "_" . $elmID));
            $html .= '<span id="save_' . $fieldname . '_' . $this->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>';
        } else {
            $html .= CHtml::textArea($fieldname, $modelvalue, array("style" => "width:300px;", "rows" => 5));
            $html .= '<span id="save_' . $fieldname . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>';
        }



        return $html;
    }

    public function getFlowStatus() {
        if ($this->status_id == 9)
            return 'complete';

        if (!empty($this->dueDate)) {
            if ($this->status_id != 9 && date('Y-m-d', strtotime('now')) > date('Y-m-d', strtotime($this->dueDate))) {
                return 'due';
            } else {
                return 'notcomplete';
            }
        } else {
            return 'notcomplete';
        }
    }

    public function getMasterPO() {
        $consolidateddtl = ConsolidatedPoDetail::model()->find(array('condition' => "child_po_id = {$this->id}"));

        return $consolidateddtl ? $consolidateddtl->rel_master_po() : null;
    }

    public function getPONumLink() {
        return CHtml::link($this->poNum, array("purchaseOrders/view", "id" => $this->id), array("target" => "_blank"));
    }

    public function getPONumberHtml() {
        $html = $this->getPONumLink();

        $masterpo = $this->getMasterPO();
        if ($masterpo) {
            $mpolink = CHtml::link($masterpo->po_number, array("consolidatedPurchaseOrder/view", "id" => $masterpo->id), array("target" => "_blank"));
            $html .= '<br><span class="label label-warning">' . $mpolink . '</span>';
        }
        
        if(SystemOptions::getOptions()->enableMyob) {            
            $html .= $this->getMYOBLabel() ? '<br />' . $this->getMYOBLabel() : '';
        }
        
        if(SystemOptions::getOptions()->enbleXero) {
             $html .= $this->getXeroLabel()  ? '<br />' . $this->getXeroLabel()  : '';
        }
        



        return $html;
    }

    public function getMYOBLabel() {
        $html = '';
        if ($this->myob_uuid && empty($this->json_response)) {
            $html .= '<span class="label label-success" title="Successfully uploaded">MYOB</span>';
        } else if (!empty($this->json_response)) {
            $html .= '<span class="label label-important" title="Unsuccessful  upload">MYOB</span>';
        }

        return $html;
    }
    
    public function getXeroLabel() {
        $html = '';
        if ($this->xeroPurchaseOrderID) {
            $html .= '<span class="label label-info" title="Successfully uploaded">Xero</span>';
        } 

        return $html;
    }

    public function getStatusHtml() {
        $html = '';
        if ($this->status_id == 9) {
            $html .= '<br><span class="label label-success">Goods Received</span>';
        } else if ($this->status_id == 17) {
            $html .= '<br><span class="label label-success">Job Completed</span>';
        }

        return $html;
    }

    public function myobLastModified() {
        return null;
    }

    /**
     * @override
     * Synchronize current record with MYOB
     * @param MYOBApiConnector $myobConnector api connection
     * @return boolean success true, otherwise false
     */
    public function myobSynchronize(\MYOBApiConnector $myobConnector) {
        return $this->synchronizer->syncronize(); /* Hide the syncronizing logics in syncronizer object */
    }

    public function setSynchronizer(\MYOBSynchronizer $synchronizer) {
        $this->synchronizer = $synchronizer;
    }

    public function toJsonString() {
        try {
            $myobsettings = MyobSetting::getSettings();


            $supplier = MyobSupplier::model()->findByPk($this->supplier_->myob_supplier_id);
            if (!$supplier) {
                throw new Exception("Cannot find the MYOB supplier relation with system supplier. [{$this->supplier_->supnam}]");
            }
            $shipToAddress = $supplier->supnam . ' ' . $supplier->supad1 . ' ' . $supplier->supad2 . ' ' . $supplier->supad3 . ' ' . $supplier->suptown . ' ' . $supplier->supstate . ' ' . $supplier->suppostcode;

            $taxCodeRawData = Yii::app()->db->createCommand()->select('uuid')->from('myob_tax_codes')->where('id=:ID', array(':ID' => ($this->myobTaxCodeId ?: $myobsettings->po_taxcode_id)))->queryRow();

            //$freightTaxCode = MyobTaxCode::model()->findByPk($myobsettings->po_freight_taxcode_id);
            //$freightTaxCodeUid = $freightTaxCode ? $freightTaxCode->uuid : null;
            if (in_array($this->poType, array('Purchase Product-Decoration'))) {
                $podtls = new PurchaseOrderDetails();
                $podtls->po_id = $this->id;
                //$purchaseorderdetailsList = $podtls->searchForProductDecorations()->getData();

                $jobproddecorations = JobProductDecorations::model()->findAll(array('condition' => "po_id = '{$this->id}'"));
            }


            $poArr = array(
                'Number' => $this->poNum,
                'Date' => date('Y-m-d H:i:s', strtotime($this->createdDtm)),
                //'SupplierInvoiceNumber' => '',
                'Supplier' => array(
                    'UID' => trim($supplier->myob_uuid),
                //"Name" => substr($model->customer->cusnam, 0, 50),
                //"DisplayID" => $model->customer->cuscus,
                ),
                'Status' => "Open",
                'IsTaxInclusive' => 'false',
                'ReferralSource' => $this->job->jobNum,
                'ShipToAddress' => trim($shipToAddress) ?: '',
            );

            /* this will force  MYOB to update the record */
            /* this section will only be added if company file of this record ( myob guid) is same as the current login one */
            if ($this->myob_uuid && $this->myob_row_version) {
                $poArr['UID'] = $this->myob_uuid;
                $poArr['RowVersion'] = $this->myob_row_version;
            }


            $subTotal = 0;

            foreach ($this->rel_po_dtl() as $dtl) {


                if ($dtl->workorderDtl->product) {

                    /*
                     * include product desc + deco desc + size info to description
                     * 
                     */
                    $description = '';
                    if ($dtl->workorderDtl->prdsrtdesc) {
                        $description .= $dtl->workorderDtl->prdsrtdesc;
                    }

                    if ($dtl->workorderDtl->decdesc) {
                        $description .= ' / ' . $dtl->workorderDtl->decdesc;
                    }

                    $sizeQtyColorRawData = Yii::app()->db->createCommand()->select('size, qty, color')->from('workorderdetailssizecolor')->where('workOrderDetailsId=:DETAILID', array(':DETAILID' => $dtl->workorderDtl->id))->queryAll();


                    if ($sizeQtyColorRawData) {
                        $description .= ' /Sizes:';
                        foreach ($sizeQtyColorRawData as $row) {
                            $description .= ' [ ' . $row['size'] . ' - ' . $row['qty'] . ' - ' . $row['color'] . ' ]';
                        }
                    }

                    if (in_array($this->poType, array('Purchase Product'))) {
                        $prodUnitPrice = $dtl->workorderDtl->prodCostPrice;
                        $prodLineAmount = $prodUnitPrice * $dtl->qty;
                        $subTotal += $prodLineAmount;
                    }


                    if (in_array($this->poType, array('Purchase Product-Decoration'))) {

                        $decoLineCost = 0;
                        foreach ($jobproddecorations as $jobprddata) {

                            $workorderDetailsDecoration = WorkorderDetailsDecoration::model()->find(
                                    array(
                                        'condition' => "id = {$jobprddata->work_order_detail_decoration_id} AND workorder_detail_id = {$dtl->workorderDtl->id}"
                            ));


                            if ($workorderDetailsDecoration->decprtnam) {

                                $description .= '/' . $workorderDetailsDecoration->decprtnam;

                                $prodUnitPrice += $workorderDetailsDecoration->cost_price;
                                $decoLineCost += ($workorderDetailsDecoration->cost_price * $dtl->qty);

                                $prodUnitPrice += $workorderDetailsDecoration->logo_setup;
                                $decoLineCost += $workorderDetailsDecoration->logo_setup;

                                $prodLineAmount += $decoLineCost;

                                $subTotal += $decoLineCost;
                            }
                        }
                    }

                    $poArr['Lines'][] = array(
                        //"Type" => "Transaction",                
                        'Description' => $description,
                        'BillQuantity' => $dtl->qty,
                        'ReceivedQuantity' => $dtl->qty,
                        'UnitPrice' => round($prodLineAmount / $dtl->qty, 2),
                        'Total' => $prodLineAmount,
                        'Item' => array(
                            'UID' => $dtl->workorderDtl->product->myob_uuid,
                            'Number' => $dtl->workorderDtl->product->pdlsno,
                            'Name' => $dtl->workorderDtl->product->pdlpdl,
                        ),
                        'TaxCode' => array(
                            'UID' => $taxCodeRawData['uuid'],
                        ),
                    );
                }
            }


            $poArr['Subtotal'] = $subTotal;

//			if ($freightTaxCode && $freightTaxCodeUid) {
//				/* need to provide both freight value and freight tax code otherwise MYOB responses 400 bad request! */
//				$invarr['Freight'] = round($this->postal_code_freight_charge, 2);
//
//				$invarr['FreightTaxCode'] = array(
//					"UID" => $freightTaxCodeUid,
//					'Code' => $freightTaxCode->code,
//				);
//			}
            //$invarr['TotalTax'] = round(($this->amountIncVat - $this->amountExVat), 2);
            $poArr['TotalAmount'] = $subTotal;
        } catch (Exception $x) {
            throw new Exception($x->getMessage(), $x->getCode());
        }
        return json_encode($poArr);
    }

    public function updateByMYOB(\MYOBResponse $response) {
        try {
            /* Here we only need to update the MYOB references for the invoice */
            Yii::app()->db->createCommand()
                    ->update('purchase_orders', array(
                        'myob_uuid' => $response->UID,
                        'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
                        'myob_row_version' => $response->RowVersion,
                        'json_response' => null,
                            ), "id=$this->id" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public function updateMYOBReferences(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('purchase_orders', array(
                        'myob_uuid' => $response->UID,
                        'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
                        'myob_row_version' => $response->RowVersion,
                        'json_response' => null,
                            ), "id=$this->id" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public static function createByMYOB(\MYOBResponse $response) {
        /* we don't pull the invoices from MYOB */
        return false;
    }

    public function reportMYOBError(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('purchase_orders', array(
                        'json_response' => serialize($response),
                            ), "id=$this->id" /* where condition */
            );
            MYOBLog::writeLog(array(
                'table_name' => $this->tableName(),
                'table_reference_id' => $this->id,
                'log_type_id' => MYOBLog::LOG_TYPE_ERROR,
                'log_message' => serialize($response),
                'log_class' => __CLASS__,
                'log_line' => __LINE__,
            ));
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }

    /**
     * Format the MYOB error reported early to database and return it with some changes if needed
     * @return string MYOB error return in any string format
     */
    public function getMYOBError() {
        $obj = @unserialize($this->json_response); //In case the passed string is not unserializeable, supress  E_NOTICE 
        return $obj ? MYOBResponse::formatError($obj) : '';
    }

    public function reportMYOBSuccess(\MYOBResponse $response) {
        
    }

    public function setDefaultFlag() {
        if (!$this->flag) {
            $systemOptions = SystemOptions::getOptions();
            $flag = new PurchaseOrderFlag();
            $flag->po_id = $this->id;
            $flag->po_type = $this->poType;

            $flag->show_price_on_pdf = $systemOptions->show_price_on_pdf;
            $flag->show_customisation_details = $systemOptions->show_customisation_details;
            $flag->show_decoration = $systemOptions->show_decoration;
            $flag->show_decoration_cost = $systemOptions->show_decoration_cost;
            $flag->show_logo_setup = $systemOptions->show_logo_setup;
            $flag->show_job_info = $systemOptions->show_job_info;
            $flag->show_notes = $systemOptions->show_notes;
            $flag->show_product_cost = $systemOptions->show_product_cost;
            $flag->show_website_ordering_info = $systemOptions->show_website_ordering_info;
            $flag->show_so_customisation = $systemOptions->show_so_customisation;
            if ($flag->save()) {
                $this->refresh();
            }
        }
    }

    //run this function to set system status with the follow-up status
    public function mapFollowupStatusForSystemStatus() {
        $systemOptions = SystemOptions::getOptions();

        switch ($this->followup_status_id) {
            case $systemOptions->poFollowupStatusForCancel: $this->status_id = Status::SYS_STATUS_CANCELLED;
                break;
            case $systemOptions->poFollowupStatusForCompleted: $this->status_id = Status::SYS_STATUS_ORDER_COMPLETED;
                break;
        }
    }

    public function getFollowupStatus() {
       
        return $this->followup_status_id ? FollowupStatus::model()->findByPk($this->followup_status_id)->status : null;
        
    }

    public function getFollowupStatusId() {
        $this->followup_status_id ? FollowupStatus::model()->findByPk($this->followup_status_id)->id : null;
    }

}
