<?php

/**
 * This is the model class for table "quatationdetails".
 *
 * The followings are the available columns in table 'quatationdetails':
 * @property integer $id
 * @property integer $quoteid
 * @property string $productsku
 * @property integer $qty
 * @property double $productexunitprice
 * @property string $productname
 * @property string $sup_fref
 * @property double $supmarg
 * @property string $productimg
 * @property integer $iscustomprodct
 * @property string $productdescription
 * @property double $prodctfrieght
 * @property double $productvat
 * @property string $supname
 * @property double $sellunitprice_ex_vat
 * @property double $sellunitprice_in_vat
 * @property double $selltot_ex_vat
 * @property double $selltot_in_vat
 * @property integer $lineOrder order of detail lines
 * @property integer $customer_accepted
 * @property string $product_source
 * @property integer $hide_on_pdf
 */
class QuatationDetails extends CActiveRecord {

    public $quote_number_search;
    public $product_shortname_search;
    public $customer_search;
    public $cusnam;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return QuatationDetails the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'quatationdetails';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('quoteid, qty, iscustomprodct, ws_id, lineOrder, customer_accepted, hide_on_pdf', 'numerical', 'integerOnly' => true),
            array('productexunitprice, supmarg, prodctfrieght, productvat,
                            sellunitprice_ex_vat, sellunitprice_in_vat, selltot_ex_vat, 
                            selltot_in_vat, system_freight, other_cost,other_cost_markup_rate, 
                            productFrieghtUnitCost, productFrieghtMarkUpRate, productFrieghtUnitCostWithMarkup, 
                            supmargPercentage, productFrieghtMarkUpPercentage, otherCostMarkupPercentage, systemFreightPercentage, lockSellPrice, systemTaxRateId', 'numerical'),
            array('productsku, productname, sup_fref, supname', 'length', 'max' => 255),
            array('productimg,productdescription,product_shortname_search, prodImgUri, quote_number_search, customer_search, cusnam, product_source', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, quoteid, productsku, qty, productexunitprice, productname, sup_fref, supmarg, productimg, iscustomprodct, productdescription, prodctfrieght, productvat, supname, sellunitprice_ex_vat, sellunitprice_in_vat, selltot_ex_vat, selltot_in_vat', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'quotationRel' => array(self::BELONGS_TO, 'Quatation', 'quoteid'),
            'decoration' => array(self::BELONGS_TO, 'QuoteProductDecoration', '', 'foreignKey' => array('id' => 'quataiondetailsid')),
            'RelDeco' => array(self::HAS_MANY, 'QuoteProductDecoration', 'quataiondetailsid'),
            'productRel' => array(self::BELONGS_TO, 'ProductLine', '', 'foreignKey' => array('productsku' => 'pdlpdl'))
        );
    }

    public function rel_size_qty_colors() {
        return QuotationDetailsSizeQtyColor::model()->findAll(array('condition' => "quote_detail_id = $this->id"));
    }

    public function rel_multi_deco() {
        return QuoteProductDecoration::model()->findAll(array('condition' => "quataiondetailsid = {$this->id}"));
    }

    public function rel_other_costs() {
        return QuoteOtherCost::model()->findAll(array('condition' => "quote_detail_id = {$this->id}"));
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'quoteid' => 'Quoteid',
            'productsku' => 'Product Code',
            'qty' => 'Quantity',
            'productexunitprice' => 'Product Unit Price',
            'productname' => 'Product Short Name',
            'sup_fref' => 'Sup Fref',
            'supmarg' => 'Supmarg',
            'productimg' => 'Image',
            'iscustomprodct' => 'Iscustomprodct',
            'productdescription' => 'Product Description',
            'prodctfrieght' => 'Prodctfrieght',
            'productvat' => 'Productvat',
            'supname' => 'Supname',
            'sellunitprice_ex_vat' => 'Selling Price Excluding GST',
            'sellunitprice_in_vat' => 'Selling Price Including GST',
            'selltot_ex_vat' => 'Total Ex GST',
            'selltot_in_vat' => 'Total Inc GST',
            'sub_decoration' => 'Decoration',
            'product_shortname_search' => 'Product Short Description',
            'other_cost' => 'Other Cost',
            'lineOrder' => 'Line Order',
            'systemTaxRateId' => 'Tax Rate',
            'customer_accepted' => 'Customer Accepted',
            'quote_number_search' => 'Quotation Number',
            'customer_search' => 'Customer',
            'hide_on_pdf' => 'Hide On PDF'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('quoteid', $this->quoteid);
        $criteria->compare('productsku', $this->productsku, true);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('productexunitprice', $this->productexunitprice);
        $criteria->compare('productname', $this->productname, true);
        $criteria->compare('sup_fref', $this->sup_fref, true);
        $criteria->compare('supmarg', $this->supmarg);
        $criteria->compare('productimg', $this->productimg, true);
        $criteria->compare('iscustomprodct', $this->iscustomprodct);
        $criteria->compare('productdescription', $this->productdescription, true);
        $criteria->compare('prodctfrieght', $this->prodctfrieght);
        $criteria->compare('productvat', $this->productvat);
        $criteria->compare('supname', $this->supname, true);
        $criteria->compare('sellunitprice_ex_vat', $this->sellunitprice_ex_vat);
        $criteria->compare('sellunitprice_in_vat', $this->sellunitprice_in_vat);
        $criteria->compare('selltot_ex_vat', $this->selltot_ex_vat);
        $criteria->compare('selltot_in_vat', $this->selltot_in_vat);



        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.lineOrder ASC',
            )
        ));
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchAllItems() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('quotationRel', 'RelDeco', 'productRel', 'quotationRel.customer');
        //$criteria->select = 't.quoteid, t.productsku, t.qty, t.productexunitprice, t.productname, t.productdescription, t.prodctfrieght, t.productvat, t.sellunitprice_ex_vat, t.sellunitprice_in_vat, t.selltot_ex_vat, t.selltot_in_vat';

        $criteria->compare('id', $this->id);
        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('quotationRel.quoteno', $this->quote_number_search, true);
        $criteria->compare('productsku', $this->productsku, true);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('productexunitprice', $this->productexunitprice);
        $criteria->compare('productname', $this->productname, true);
        $criteria->compare('sup_fref', $this->sup_fref, true);
        $criteria->compare('supmarg', $this->supmarg);
        $criteria->compare('productimg', $this->productimg, true);
        $criteria->compare('iscustomprodct', $this->iscustomprodct);
        $criteria->compare('productdescription', $this->productdescription, true);
        $criteria->compare('prodctfrieght', $this->prodctfrieght);
        $criteria->compare('productvat', $this->productvat);
        $criteria->compare('supname', $this->supname, true);
        $criteria->compare('sellunitprice_ex_vat', $this->sellunitprice_ex_vat);
        $criteria->compare('sellunitprice_in_vat', $this->sellunitprice_in_vat);
        $criteria->compare('selltot_ex_vat', $this->selltot_ex_vat);
        $criteria->compare('selltot_in_vat', $this->selltot_in_vat);



        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'quotationRel.quotecreated DESC',
            )
        ));
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchForSelectPopup() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('quotationRel', 'RelDeco', 'productRel', 'quotationRel.customer');
        //$criteria->select = 't.quoteid, t.productsku, t.qty, t.productexunitprice, t.productname, t.productdescription, t.prodctfrieght, t.productvat, t.sellunitprice_ex_vat, t.sellunitprice_in_vat, t.selltot_ex_vat, t.selltot_in_vat';


        $hasFiltering = false;

        if (trim($this->quote_number_search)) {
            $hasFiltering = true;
            $criteria->compare('quotationRel.quoteno', $this->quote_number_search, true);
        }

        if (trim($this->customer_search)) {
            $hasFiltering = true;
            $criteria->compare('customer.cusnam', $this->customer_search, true);
        }

        if (trim($this->productsku)) {
            $hasFiltering = true;
            $criteria->compare('t.productsku', $this->productsku, true);
        }

        if (trim($this->productname)) {
            $hasFiltering = true;
            $criteria->compare('t.productname', $this->productname, true);
        }


        if (!$hasFiltering) {
            $criteria->addCondition("t.id < 0");
        }


        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'quotationRel.quotecreated DESC',
            )
        ));
    }

    public function getImg() {
        $return_img = null;

        if (strpos($this->productimg, 'http:') !== false) {
            if ($this->is_url_exist($this->productimg)) {
                $return_img = $this->productimg;
            }
        } else if (strpos($this->productimg, 'https:') !== false) {
            if ($this->is_url_exist($this->productimg)) {
                $return_img = $this->productimg;
            }
        } else {
            $filename = trim($this->productimg);
            if (!empty($filename)) {
                if (file_exists('images/product_img/' . $this->productimg)) {
                    $return_img = 'images/product_img/' . $this->productimg;
                }
            } else {
                $return_img = null;
            }
        }

        if (empty($return_img)) {
            $productline = ProductLine::model()->find(array("condition" => "pdlpdl = '{$this->productsku}'"));
            if (!empty($productline)) {
                $return_img = $productline->getImg();
            }
        }

        return $return_img;
    }

    function is_url_exist($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($code == 200) {
            $status = true;
        } else {
            $status = false;
        }
        curl_close($ch);
        return $status;
    }

    public function getProdQtyTotal() {
        $sql = "select sum(qty) as totalQty from quatationdetails where quoteid = '$this->quoteid'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalQty'];
    }

    public function getSellingPriceExVatTot() {
        $sql = "select sum(sellunitprice_ex_vat) as sellExVat from quatationdetails where quoteid = '$this->quoteid'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellExVat'];
    }

    public function getSellingPriceIncVatTot() {
        $sql = "select sum(sellunitprice_in_vat) as sellIncVat from quatationdetails where quoteid = '$this->quoteid'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellIncVat'];
    }

    public function getTotalSellPriExVatTot() {
        $sql = "select sum(selltot_ex_vat) as sellTotExVat from quatationdetails where quoteid = '$this->quoteid'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellTotExVat'];
    }

    public function getTotalSellPriIncVatTot() {
        $sql = "select sum(selltot_in_vat) as sellTotIncVat from quatationdetails where quoteid = '$this->quoteid'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellTotIncVat'];
    }

    public function getMultiDecoHtml() {
        $html = "<ul>";
        $quoteProductDecoDetails = QuoteProductDecoration::model()->findAll(array('condition' => "quataiondetailsid = {$this->id}"));
        foreach ($quoteProductDecoDetails as $deco) {
            /*
              if($deco->decprtnam !== 'custom_decoration'){
              $decoRel = Decoration::model()->find(array('condition'=>"decprtnam = '{$deco->decprtnam}'"));
              $link = CHtml::link($deco->decprtnam, array("decoration/view", "id" => $decoRel->decsno), array("target" => "_blank", 'title' => "click here to see full decoration spec"));

              }else{
              $link = $deco->decorationdescription;
              }
             * 
             */
            $html .= "<li>{$deco->decorationdescription}</li>";
        }

        $html .= "</ul>";

        return $html;
    }

    public function getDecoCostTotal() {
        $sql = "select sum(decorationunitval) as totalDecoCost from quatationpdctdecorations where quataiondetailsid = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalDecoCost'];
    }

    public function getOtherCostTotal() {

        return $this->other_cost;
    }

    public function getDecoLogoSetUpUnitCostTotal() {

        $sql = "select sum(logoSetupUnitCost) as totalLogoSetUpUnitPrice from quatationpdctdecorations where quataiondetailsid = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalLogoSetUpUnitPrice'];
    }

    //cost per item
    public function getItemCost() {
        $productCost = $this->productexunitprice;
        $decoCost = $this->getDecoCostTotal();
        $otherCost = $this->getOtherCostTotal();
        $logoSetUpCost = $this->getDecoLogoSetUpUnitCostTotal();

        return ($productCost + $decoCost + $otherCost + $logoSetUpCost);
    }

    /**
     * @return array decoration codes otherwise null
     */
    public function getDecorationCodes() {
        if ($this->RelDeco && count($this->RelDeco) > 0) {
            return array_values(CHtml::listData($this->RelDeco, 'id', 'decprtnam'));
        }

        return null;
    }

    /**
     * Get image content from the URL and save the file into images/product_img folder and the replace the imageField value by the fileName value
     * 
     * @param string $fileName i.e. test.jpeg if null or empty then basename of the URL will be the file name
     * @param string $imageField URL
     * @param string $location a place to save the file. This must be a exist folder path otherwise exception will be thrown
     * 
     * @return boolean if operation success then true otherwise false
     */
    public function saveImageContent($fileName = '', $imageField = 'productimg', $location = 'images/product_img/') {



        if (strpos($this->$imageField, 'http:') !== false || strpos($this->$imageField, 'https:') !== false) {
            $fileName = $fileName ?: basename($this->$imageField);

            //echo $fileName, ',  ', $this->$imageField, ', ', $location;        exit();
            try {
                if ($content = $this->curl_get_file_contents($this->$imageField)) {

                    //if already exist remove the file before save

                    @unlink($location . $fileName);

                    if (@file_put_contents($location . $fileName, $content)) {

                        //echo 'the file ', $location . $fileName;  exit();

                        $this->prodImgUri = $this->$imageField;
                        $this->$imageField = $fileName;
                        return $this->save(false);
                    }
                }
            } catch (Exception $ex) {
                echo $ex->getMessage();
                exit();
            }
        }

        return false;
    }

    function curl_get_file_contents($URL) {
        $c = curl_init();
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_URL, $URL);
        $contents = curl_exec($c);
        curl_close($c);

        if ($contents) {
            return $contents;
        } else {
            return false;
        }
    }

    public function recalculateLinePrice() {


        $prodCostPrice = $this->productexunitprice;
        $prodMarkupRate = $this->supmarg;
        $prodDiscPercntg = $this->customerdicspcn;
        $usdFreight = $this->prodctfrieght;
        $usdFreightMarkUpRate = $this->productFrieghtMarkUpRate;
        $freightRate = $this->system_freight;
        $otherCostTotal = $this->other_cost;
        $otherCostMarkupRate = $this->other_cost_markup_rate;
        $itmQty = $this->qty;


        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;


        $decoCostPrice = 0;

        $quoteDecorations = $this->rel_multi_deco();
        foreach ($quoteDecorations as $deco) {


            $decoCalArr = $deco->getDecorationCalculations(
                    array(
                        'decorationunitval' => $deco->decorationunitval,
                        'supmarg' => $deco->supmarg,
                        'logosetupcharge' => $deco->logosetupcharge,
                        'decorationqty' => $itmQty,
                        'logoSetupMarkupRate' => $deco->logoSetupMarkupRate
            ));

            $decoCostPrice += ($deco->decorationunitval + $decoCalArr['logoSetupUnitCost']);
            $totalDecoSupMarginMarkupPrice += $decoCalArr['supmargMarkedUpPrice'];
            $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logoSetupUnitCostWithMarkup'];

            $deco->logoSetupUnitCost = $decoCalArr['logoSetupUnitCost'];
            $deco->logoSetupUnitCostWithMarkup = $decoCalArr['logoSetupUnitCostWithMarkup'];

            $deco->save(false); //save without validating the model
        }



        $prodMarkedUpPrice = $prodMarkupRate ? round(($prodCostPrice * $prodMarkupRate), 2) : $prodCostPrice;



        $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
        $prodDiscountedPrice = $prodDiscRate ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), 2) : $prodMarkedUpPrice;

        $usdFreightUnitCost = round(($usdFreight / $itmQty), 2);
        $usdFreightUnitCostWithMarkedUp = $usdFreightUnitCost * $usdFreightMarkUpRate;

        $prodUsdFreightedPrice = $prodDiscountedPrice + round(($usdFreightUnitCostWithMarkedUp), 2);




        $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), 2) : $otherCostTotal;



        $subTotal = $prodUsdFreightedPrice + $otherCostMarkedUpPrice + ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);
        $subTotalWithSetup = $subTotal;


        $total = $freightRate ? round(($subTotalWithSetup * $freightRate), 2) : $subTotalWithSetup;





        $this->productFrieghtUnitCost = $usdFreightUnitCost;
        $this->productFrieghtUnitCostWithMarkup = $usdFreightUnitCostWithMarkedUp;
        $this->sellunitprice_ex_vat = $total;
        $this->sellunitprice_in_vat = round(($this->sellunitprice_ex_vat * $this->productvat), 2);
        $this->selltot_ex_vat = $this->sellunitprice_ex_vat * $this->qty;
        $this->selltot_in_vat = round(($this->selltot_ex_vat * $this->productvat), 2);

        $this->save(false);
    }

    public function getHtmlRow() {
        $record = $this;
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $alldetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = '{$record->quoteid}'"));
        //$quotedecodetail = QuoteProductDecoration::model()->find(array('condition' => "quataiondetailsid = '{$record->id}'"));
        //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $quotedecodetail->decprtnam)));
        //$count = count($alldetails);
        //$rowtype = $count % 2;

        $html .= '<tr  id="quote_row_' . $record->id . '" >';

        $html .= '<td class="maincell">';
        $html .= '<table class="maintbl">';
        $html .= '<tr  id="mainrow_' . $record->id . '" >';
        $html .= ' <td class="counter"><div class="counter-no">'
                . '<input value="' . intval($record->lineOrder) . '" type="text" name="QuatationDetails[lineOrder]" id="detail-line-order-row-' . $record->id . '" style="width: 15px;" onchange="updateDetailField(\'' . $record->id . '\', \'lineOrder\', this.value);"/>'
                . '</div>'
                . '<input class="quote-line-select" detail-id="' . $record->id . '" type="checkbox" id="detail_select_row_' . $record->id . '"  />'
                . '</td>';
        $html .= '<td class="column2">';

        $imageHtml = CHtml::image($record->getImg(), '', array('id' => 'imgid-' . $record->id, 'class' => 'quote-dtl-img', 'width' => 75, 'height' => 75, 'style' => 'cursor: pointer;', 'title' => 'click to change the image'));
        $imageHtml .= '<form style="display: none;" name="photo" id="imageUploadForm" enctype="multipart/form-data"  method="post">
                        <input type="file" style="widows:0; height:0;" class="ImageBrowse" hidden="hidden" name="QuatationDetails[productimg]" />  
                        <input type="text"  hidden="hidden" name="QuatationDetails[id]" value="' . $record->id . '" />  
                    </form>';

        $html .= $imageHtml;
        $html .= ' </td>';
        $html .= ' <td class="column2">';




        if ($record->productsku && $record->productRel) {
            $html .= CHtml::link($record->productsku, array("productLine/view", "id" => $record->productRel->pdlsno), array("target" => "_blank", 'title' => "click here to see full product spec"));
        } else if ($record->productsku && !$record->productRel) {
            //product has been removed from the DB or may be a product from remote source like GWS API
            $html .= $record->productsku;
        } else {
            echo '<br>';
        }


        $html .= '<textarea style="width: 95%;" id="productname_' . $record->id . '" name="QuatationDetails[productname]" onchange="updateDetailField(' . $record->id . ', \'productname\', this.value);">';
        $html .= $record->productname;
        $html .= "</textarea>";





        $html .= ' </td>';
        $html .= '<td class="column3">';


        $html .= '<br><textarea style="width: 95%;" id="productdescription_' . $record->id . '" name="QuatationDetails[productdescription]" onchange="updateDetailField(' . $record->id . ', \'productdescription\', this.value);">';
        $html .= $record->productdescription;
        $html .= '</textarea>';


        $html .= '</td>';
        $html .= '<td class="column4">';



        $html .= '<div id="multideco_' . $record->id . '">';
        $html .= $record->getMultiDecoHtml();
        $html .= '</div>';
        $html .= '<a href="#" style="width: 95%;"   data-toggle="modal" onclick="showEditMultiDecoModal(' . $record->id . ');return false;">Edit Decorations</a>';





        $html .= '</td>';
        $html .= '<td style="width:10%;">';
        $html .= '<br><input style="width: 95%;text-align:center;" type="text" value="' . $record->qty . '" id="qty_' . $record->id . '" name="QuatationDetails[qty]"  onchange="calLinePrices(' . $record->id . ');"/>';
        $html .= '</td>';

        $html .= '<td style="width:12%;">';

        $html .= '<a href="#" style="width: 95%;" data-toggle="modal" onclick="showEditPriceModal(' . $record->id . ');return false;">Edit Price</a>';
        $html .= '<input style="width: 95%;text-align:right;" type="text" value="' . round($record->sellunitprice_ex_vat, $roundingPrecision) . '" id="sellunitpriceExVat_' . $record->id . '" readonly="readonly"/>';


        $html .= '</td>';
        $html .= '<td style="width:10%;">';
        $html .= '<br><input style="width: 95%;text-align:right;" type="text" value="' . (round($record->sellunitprice_ex_vat, $roundingPrecision) * $record->qty) . '" id="selltotExVat_' . $record->id . '"  readonly="readonly"/>';


        $html .= '</td>  ';

        $html .= '</tr>';

        $html .= '<tr>';
        $html .= '<td colspan="4"><table>';

        $html .= '<tr style="background-color: #EDEDED;"> <td>Custom Colour</td></tr>';

        $html .= '<tr> <td>';
        $html .= '<input 
                                    style="width: 95%;text-align: left;" 
                                    type="text" value="' . $record->customColor . '" 
                                    id="customColor_' . $record->id . '"
                                    onchange="updateDetailField(' . $record->id . ', \'customColor\', this.value);" />';


        $html .= '</td></tr>';

        $html .= '</table>';
        $html .= '</td>';
        $html .= '<td colspan="4">';
        $html .= '<table><tr style="background-color: #EDEDED;"> <td>Custom Note</td>';
        $html .= '</tr>';
        $html .= '<tr><td><input 
                                    style="width: 95%;text-align: left;" 
                                    type="text" value="' . $record->customNote . '" 
                                    id="customNote_' . $record->id . '"
                                    onchange="updateDetailField(' . $record->id . ', \'customNote\', this.value);" /></td>';
        $html .= '</tr>';
        $html .= '</table>';

        $html .= '</td>';
        $html .= '</tr>';
        $html .= '<tr id="lineOptionRow_' . $record->id . '">';
        $html .= '<td colspan="8" style="text-align: left;">';

        $html .= CHtml::button('Line Options:', array('class' => 'lineOptionRow', 'lineOptionRowId' => $record->id));


        $html .= '<div id="flagLabelTextDiv_' . $record->id . '" style="display: inline-block;">' . $record->getOnFlagsLabelsHtml() . '</div>';
        $html .= '</td>';
        $html .= '</tr>';


        $html .= '</table>';
        $html .= '<div id="savemessage_' . $record->id . '"  style="color: rgb(0, 255, 0);display: none;">Changes are saved</div>';
        $html .= '</td>';

        $html .= '</tr>';

        return $html;
    }

    public function getCustomerAcceptedString() {
        if ($this->customer_accepted) {
            return '<p style="color:green;font-weight:bold;">Customer Accepted</p>';
        }

        return '';
    }

    public function getProductString() {
        $text = '';

        $text .= $this->getCustomerAcceptedString();

        $text .= $this->productsku . '<br>' . $this->productname;

        return $text;
    }

    public static function createItemCopy($quoteId, $quotationDetailId) {
        $model = QuatationDetails::model()->findByPk($quotationDetailId);
        $cloneModel = new QuatationDetails();
        $cloneModel->attributes = $model->attributes;
        $cloneModel->id = null;
        $cloneModel->quoteid = $quoteId;
        if ($allsaved = $cloneModel->save(false)) {


            $quoteDecorations = $model->rel_multi_deco();
            if (count($quoteDecorations)) {
                foreach ($quoteDecorations as $deco) {
                    $copyLineQuoteDecoration = new QuoteProductDecoration();
                    $copyLineQuoteDecoration->attributes = $deco->attributes;
                    $copyLineQuoteDecoration->quataiondetailsid = $cloneModel->id;
                    unset($copyLineQuoteDecoration->id);
                    $allsaved = $copyLineQuoteDecoration->save();
                }
            }

            $quoteSizeQtyColours = $model->rel_size_qty_colors();
            if (count($quoteSizeQtyColours)) {
                foreach ($quoteSizeQtyColours as $sizeqtycol) {
                    $copyLineSizeQtyColour = new QuotationDetailsSizeQtyColor();
                    $copyLineSizeQtyColour->attributes = $sizeqtycol->attributes;
                    $copyLineSizeQtyColour->quote_detail_id = $cloneModel->id;
                    unset($copyLineSizeQtyColour->id);
                    $allsaved = $copyLineSizeQtyColour->save();
                }
            }

            $otherCosts = $model->rel_other_costs();
            if (count($otherCosts)) {
                foreach ($otherCosts as $cost) {
                    $copyLineOtherCost = new QuoteOtherCost();
                    $copyLineOtherCost->attributes = $cost->attributes;
                    $copyLineOtherCost->quote_detail_id = $cloneModel->id;
                    unset($copyLineOtherCost->id);
                    $allsaved = $copyLineOtherCost->save();
                }
            }
        }

        if ($allsaved) {
            return $cloneModel;
        } else {
            return false;
        }
    }

    public function getOnFlagsLabelsHtml() {


        $html = '';

        foreach (array('hide_on_pdf' => 'Hide on PDF') as $flag => $labelText) {
            //check flag on
            if ($this->$flag) {
                $html .= '<span class="label label-success" >' . $labelText . '</span>';
            }
        }

        return $html;
    }

    public function recalculateLineTotal() {
        if (round($this->sellunitprice_ex_vat * $this->qty, 2) != round($this->selltot_ex_vat, 2)) {
            $totalExPriceWas = $this->selltot_ex_vat;
            $this->selltot_ex_vat = round($this->sellunitprice_ex_vat * $this->qty, 2);
            $this->selltot_in_vat = $this->selltot_ex_vat * $this->productvat;
            if ($this->save(false) ) {
                $comment = "There was a price mismatch related to the detail [$this->productsku : $this->sellunitprice_ex_vat x $this->qty = $totalExPriceWas] and has been recalculated as [$this->sellunitprice_ex_vat x $this->qty = $this->selltot_ex_vat]";
                SalesLog::createSalesLog($this->quotationRel->id, null, $this->quotationRel->quoteno, 'Quotation', $comment , 1, 0, 1);
            }
        }
    }

}
