<?php

/**
 * This is the model class for table "quatation".
 *
 * The followings are the available columns in table 'quatation':
 * @property integer $id
 * @property integer $ws_id
 * @property string $quoteno
 * @property string $cus_fref
 * @property double $systemfreight
 * @property integer $quotecreatedby
 * @property string $quotecreated
 * @property string $quotecomments
 * @property int $salesperson_id
 * @property int $quote_online_acceptence_log_id
 * @property double $costPriceAmount
 * @property double $sellPriceAmountExGST
 * @property double $sellPriceAmountIncGST
 * @property string $ws_quoteno
 * @property integer $order_base_type
 */
class Quatation extends CActiveRecord {

    const STATUS_NEW = 1;
    const FILTER_THIS_WEEK = 1;

    public $dateFilterType = 0;
    var $customrtelephone;
    public $avg_sysfreight;
    public $cusnam;
    public $mastercus_search;
    public $customer_search;
    public $salesperson_search;
    public $followupStatus;
    public $onlineQuoteAcceptanceStatusSearch;
    public $datefrom;
    public $dateto;
    public $spersonDateFlag;
    public $allTotalExGST;
    public $allTotalCost;
    public $followupDate;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Quatation the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'quatation';
    }

    public function behaviors() {
        return array(
            'ERememberFiltersBehavior' => array(
                'class' => 'ext.yii-remember-filters-gridview-master.components.ERememberFiltersBehavior',
                'defaults' => array(), /* optional line */
                'defaultStickOnClear' => false /* optional line */
            ),
        );
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id,ws_id, quotecreatedby, ws_user_id, probability, status, originalQuoteId, is_viewed, first_viewed_by, salesperson_id, quote_online_acceptence_log_id, order_base_type', 'numerical', 'integerOnly' => true),
            array('systemfreight, salesEstimate, probability, costPriceAmount, sellPriceAmountExGST, sellPriceAmountIncGST', 'numerical'),
            array('quoteno, cus_fref, quotename, ws_user, ws_quoteno', 'length', 'max' => 255),
            array('quotecreated, quotecomments, cus_fref, cusnam, mastercus_search, customer_search,'
                . ' ws_date, dateFilterType, followupStatus, datefrom, dateto, dueDate, onlineQuoteAcceptanceStatusSearch, followupDate', 'safe'),
            array('systemfreight,avg_sysfreight', 'numerical', 'min' => 0.01),
            array('shipAddress1, shipAddress2, shipAddress3', 'length', 'max' => 150),
            array('shipSub, shipState, shipPostalCode', 'length', 'max' => 100),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, ws_id, quoteno, cus_fref, systemfreight, quotecreatedby, quotecreated, quotecomments, ws_date, 
                quotename, ws_user, salesEstimate, probability, ws_date, originalQuoteId, followupStatus, datefrom, dateto', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'createdby' => array(self::BELONGS_TO, 'User', 'quotecreatedby'),
            'customer' => array(self::BELONGS_TO, 'Customer', '', 'foreignKey' => array('cus_fref' => 'cuscus_fref')),
            'RelDtls' => array(self::HAS_MANY, 'QuatationDetails', 'quoteid'),
            'jobsRel' => array(self::HAS_MANY, 'Jobs', '', 'foreignKey' => array('quote_id' => 'id')),
            'workordersRel' => array(self::HAS_MANY, 'Workorder', '', 'foreignKey' => array('quotationId' => 'id')),
            'salesPersonRel' => array(self::BELONGS_TO, 'SalesPerson', 'ws_user_id'),
            'onlineAcceptenceLog' => array(self::BELONGS_TO, 'QuoteOnlineAcceptenceLog', 'quote_online_acceptence_log_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'ws_id' => 'Ws',
            'quoteno' => 'Quotation Number',
            'cus_fref' => 'Customer',
            'cusnam' => 'Customer',
            'systemfreight' => 'System Freight',
            'quotecreatedby' => 'Processed By',
            'quotecreated' => 'Date',
            'quotecomments' => 'Comments',
            'customrtelephone' => 'Customer Telephone',
            'ws_date' => 'Date',
            'quotename' => 'Quote Name',
            'ws_user' => 'Sales Person',
            'ws_user_id' => 'Sales Person',
            'salesEstimate' => 'Sales Estimate',
            'probability' => 'Probability',
            'mastercus_search' => 'Master Customer',
            'customer_search' => 'Customer',
            'status' => 'Status',
            'followupStatus' => 'Follow-up Status',
            'dueDate' => 'Due Date',
            'shipAddress1' => 'Shipping Address 1',
            'shipAddress2' => 'Shipping Address 2',
            'shipAddress3' => 'Shipping Address 3',
            'shipSub' => 'Shipping Suburb',
            'shipState' => 'Shipping State',
            'shipPostalCode' => 'Shipping Postal Code',
            'salesperson_id' => 'Salesperson',
            'onlineQuoteAcceptanceStatusSearch' => 'Online Acceptance Status',
            'followupDate' => 'Follow-up Date',
            'costPriceAmount' => 'Cost Amount',
            'sellPriceAmountExGST' => 'Price Ex GST',
            'sellPriceAmountIncGST' => 'Price Inc GST'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->with = array('customer.master', 'onlineAcceptenceLog');

        $criteria->compare('id', $this->id);
        $criteria->compare('ws_id', $this->ws_id);
        $criteria->compare('quoteno', $this->quoteno, true);
        $criteria->compare('cus_fref', $this->cus_fref, true);
        $criteria->compare('systemfreight', $this->systemfreight);
        $criteria->compare('quotecreatedby', $this->quotecreatedby);
        $criteria->compare('quotecreated', $this->quotecreated, true);
        $criteria->compare('quotecomments', $this->quotecomments, true);
        $criteria->compare('quotename', $this->quotename, true);
        $criteria->compare('ws_user', $this->ws_user, true);
        $criteria->compare('ws_user_id', $this->ws_user_id);
        $criteria->compare('master.mcusnam', $this->mastercus_search, true);
        $criteria->compare('customer.cusnam', $this->customer_search, true);

        $criteria->compare('dueDate', $this->dueDate, true);
        
        $criteria->compare('costPriceAmount', $this->costPriceAmount, true);
        $criteria->compare('sellPriceAmountExGST', $this->sellPriceAmountExGST, true);
        $criteria->compare('sellPriceAmountIncGST', $this->sellPriceAmountIncGST, true);

        $criteria->compare('onlineAcceptenceLog.status_id', $this->onlineQuoteAcceptanceStatusSearch);

        if ($this->dateFilterType == Quatation::FILTER_THIS_WEEK) {
            $this_week_ini = date("Y-m-d", strtotime("this week monday"));
            $this_week_end = date("Y-m-d", strtotime("this week sunday"));
            $criteria->addCondition("DATE_FORMAT(ws_date, '%Y-%m-%d') between '{$this_week_ini}' and '{$this_week_end}'");
        }

        //$criteria->addCondition("status <> 3");

        if (!empty($this->followupStatus)) {

            $followupQuotearr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Quotation' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupQuotearr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupQuotearr = array_filter($followupQuotearr);
            //add in condition
            $idStr = implode(',', $followupQuotearr);
            if (count($followupQuotearr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.quotecreatedby = ' . Yii::app()->user->id);
        }

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'attributes' => array(
                    'quoteno',
                    'quotecreated'
                ),
                'defaultOrder' => 't.quotecreated DESC',
            ),
        ));
    }

    public function searchSperson() {
        $loggeduserID = Yii::app()->user->id;
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->select = 't.id, t.quoteno, t.cus_fref, t.quotecreatedby, t.quotecomments, t.quotename, t.salesEstimate, quotecreated,t.dueDate, t.sellPriceAmountExGST, '
                . 'customer.cusnam, '
                . 'sales_persons.name, t.ws_user_id';

        $criteria->join = ' left join customer on t.cus_fref = customer.cuscus_fref '
                . '         left join sales_persons on t.ws_user_id = sales_persons.id';



        //$criteria->compare('t.id', $this->id);
        //$criteria->compare('t.workorder_id', $this->workorder_id);
        //$criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteno', $this->quoteno, true);
        $criteria->compare('t.quotename', $this->quotename, true);
        $criteria->compare('t.quotecomments', $this->quotecomments, true);
        //$criteria->compare('t.createdDtm', $this->createdDtm, true);
        //$criteria->compare('t.notation', $this->notation, true);
        //$criteria->compare('t.followupDate', $this->followupDate, true);
        //$criteria->compare('t.dueDate', $this->dueDate, true);
        //$criteria->compare('t.user_id', $this->user_id);
        //$criteria->compare('t.status_id', $this->status_id);
        //$criteria->compare('urgent_status', $this->urgent_status);
        //$criteria->compare('t.jobname', $this->jobname, true);
        //$criteria->compare('t.cus_fref', $this->cus_fref);
        //$criteria->compare('t.customerpono', $this->customerpono, true);
        //$criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare('customer.cuscontact', $this->customer_contact_search, true);
        //$criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        //$criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);
        //$criteria->compare('coordinator.username', $this->prdcoordinator_search, true);


        $criteria->compare('sales_persons.name', $this->salesperson_search, true);

        //$criteria->compare('t.ws_user', $this->ws_user, true);
        //$criteria->compare('t.ws_user_id', $this->ws_user_id, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);



        if ($this->spersonDateFlag == 1) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        } else if ($this->spersonDateFlag == 2) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        }











        //just pass the role name u need to check weather this user has or not,
        //if no user id pass then it will check for the current user

        if (AuthAssignment::checkRoleAccess('Production Staff')) {

            $criteria->addCondition("t.user_id = '$loggeduserID' or t.prd_cordinator_id = '$loggeduserID'");
        }

        if (!empty($this->followupStatus)) {
             $criteria->mergeWith(array(
                'join' => 'LEFT JOIN sales_log sl ON t.id = sl.tbl_id',
                'condition' => "sl.followupSts_id = {$this->followupStatus}",
                'order' => 'sl.id DESC'
            ));

            /*
            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Quotation' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
             * 
             */
        }





        if (isset(Yii::app()->session['sperson_selcted']) && Yii::app()->session['sperson_selcted']) {

            $spersonsStr = Yii::app()->session['sperson_selcted'];
            $criteria->addCondition("t.ws_user_id IN ($spersonsStr) ");
        }

        $criteria->addCondition("status <> 3");

        if (!User::isAdmin()) {
            $criteria->addCondition('t.quotecreatedby = ' . Yii::app()->user->id);
        }

        if (isset(Yii::app()->session['sperson_query'])) {
            unset(Yii::app()->session['sperson_query']);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();


        $paramarr = array('t.id=:' => $this->id);

        $paramarrLike = array('t.quoteno LIKE :' => $this->quoteno, 't.quotename LIKE :' => $this->quotename,
            'customer.cusnam LIKE :' => $this->customer_search, 't.quotecomments LIKE :' => $this->quotecomments,
            'sales_persons.name LIKE :' => $this->salesperson_search);



        foreach ($paramarr as $key => $value) {
            $position = strpos($originalQuery, $key);
            if (!empty($position)) {
                $param = str_replace('=:', '', $key);
                $param .= "='$value'";
                $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
            }
        }

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }





        Yii::app()->session['sperson_query'] = $originalQuery;

        $pageSize = 100; //100 is only for sales person report //(int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'attributes' => array(
                    'sales_persons.name',
                ),
                'defaultOrder' => 'sales_persons.name',
            ),
        ));
    }

    public function searchSpersonV2() {
        $loggeduserID = Yii::app()->user->id;
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->select = 't.id, t.quoteno, t.cus_fref, t.quotecreatedby, t.quotecomments, t.quotename, t.salesEstimate, quotecreated,t.dueDate, t.sellPriceAmountExGST, '
                . 'customer.cusnam, '
                . 'sales_persons.name, t.ws_user_id';

        $criteria->join = ' left join customer on t.cus_fref = customer.cuscus_fref '
                . '         left join sales_persons on t.ws_user_id = sales_persons.id';



        //$criteria->compare('t.id', $this->id);
        //$criteria->compare('t.workorder_id', $this->workorder_id);
        //$criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteno', $this->quoteno, true);
        $criteria->compare('t.quotename', $this->quotename, true);
        $criteria->compare('t.quotecomments', $this->quotecomments, true);
        //$criteria->compare('t.createdDtm', $this->createdDtm, true);
        //$criteria->compare('t.notation', $this->notation, true);
        //$criteria->compare('t.followupDate', $this->followupDate, true);
        //$criteria->compare('t.dueDate', $this->dueDate, true);
        //$criteria->compare('t.user_id', $this->user_id);
        //$criteria->compare('t.status_id', $this->status_id);
        //$criteria->compare('urgent_status', $this->urgent_status);
        //$criteria->compare('t.jobname', $this->jobname, true);
        //$criteria->compare('t.cus_fref', $this->cus_fref);
        //$criteria->compare('t.customerpono', $this->customerpono, true);
        //$criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare('customer.cuscontact', $this->customer_contact_search, true);
        //$criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        //$criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);
        //$criteria->compare('coordinator.username', $this->prdcoordinator_search, true);


        $criteria->compare('sales_persons.name', $this->salesperson_search, true);

        //$criteria->compare('t.ws_user', $this->ws_user, true);
        //$criteria->compare('t.ws_user_id', $this->ws_user_id, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);



        if ($this->spersonDateFlag == 1) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        } else if ($this->spersonDateFlag == 2) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        }











        //just pass the role name u need to check weather this user has or not,
        //if no user id pass then it will check for the current user

        if (AuthAssignment::checkRoleAccess('Production Staff')) {

            $criteria->addCondition("t.user_id = '$loggeduserID' or t.prd_cordinator_id = '$loggeduserID'");
        }

        if (isset(Yii::app()->session['sperson_sts_selcted'])) {
            $stsArr = explode(',', Yii::app()->session['sperson_sts_selcted']);

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Quotation' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && in_array($slog->followupSts_id, $stsArr)) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }





        if (isset(Yii::app()->session['sperson_selcted_v2']) && Yii::app()->session['sperson_selcted_v2']) {

            $spersonsStr = Yii::app()->session['sperson_selcted_v2'];
            $criteria->addCondition("t.ws_user_id IN ($spersonsStr) ");
        }

        $criteria->addCondition("status <> 3");

        if (!User::isAdmin()) {
            $criteria->addCondition('t.quotecreatedby = ' . Yii::app()->user->id);
        }

        //here we show only jobs which is not "ON_INVENTORY" types
        // $criteria->addCondition("t.orderTypeId not in (1,2)");
        //$criteria->order = 'createdDtm DESC';

        $dataProvider = new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => false,
        ));

        if (isset(Yii::app()->session['sperson_query_v2'])) {
            unset(Yii::app()->session['sperson_query_v2']);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();


        $paramarr = array('t.id=:' => $this->id);

        $paramarrLike = array('t.quoteno LIKE :' => $this->quoteno, 't.quotename LIKE :' => $this->quotename,
            'customer.cusnam LIKE :' => $this->customer_search, 't.quotecomments LIKE :' => $this->quotecomments,
            'sales_persons.name LIKE :' => $this->salesperson_search);



        foreach ($paramarr as $key => $value) {
            $position = strpos($originalQuery, $key);
            if (!empty($position)) {
                $param = str_replace('=:', '', $key);
                $param .= "='$value'";
                $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
            }
        }

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }





        Yii::app()->session['sperson_query_v2'] = $originalQuery;

        foreach ($dataProvider->getData() as $record) {
            $quote = Quatation::model()->findByPk($record->id);
            $this->allTotalExGST += $quote->getTotalWithoutGST();
        }


        $pageSize = 100; //100 is only for sales person report //(int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'attributes' => array(
                    'sales_persons.name',
                ),
                'defaultOrder' => 'sales_persons.name',
            ),
        ));
    }

    public function searchStatus() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        //$criteria->with = array('customer.master');
        $criteria->join = 'left join customer on cus_fref = customer.cuscus_fref '
                . '         left join master_customer on customer.cusmcussno = master_customer.mcussno';

        //$criteria->compare('id', $this->id);
        //$criteria->compare('ws_id', $this->ws_id);
        $criteria->compare('quoteno', $this->quoteno, true);
        //$criteria->compare('cus_fref', $this->cus_fref, true);
        //$criteria->compare('systemfreight', $this->systemfreight);
        //$criteria->compare('quotecreatedby', $this->quotecreatedby);
        //$criteria->compare('quotecreated', $this->quotecreated, true);
        $criteria->compare('quotecomments', $this->quotecomments, true);
        $criteria->compare('quotename', $this->quotename, true);
        $criteria->compare('ws_user', $this->ws_user, true);
        //$criteria->compare('ws_user_id', $this->ws_user_id);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);
        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);

        if ($this->dateFilterType == Quatation::FILTER_THIS_WEEK) {
            $this_week_ini = date("Y-m-d", strtotime("this week monday"));
            $this_week_end = date("Y-m-d", strtotime("this week sunday"));
            $criteria->addCondition("DATE_FORMAT(ws_date, '%Y-%m-%d') between '{$this_week_ini}' and '{$this_week_end}'");
        }

        $criteria->addCondition("status <> 3");

        //$criteria->addCondition("t.orderTypeId  <> 2");

        if (isset(Yii::app()->session['quote_sts_selcted']) && trim(Yii::app()->session['quote_sts_selcted'])) {
            $stsArr = explode(',', Yii::app()->session['quote_sts_selcted']);

            $followupQuotearr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Quotation' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && in_array($slog->followupSts_id, $stsArr)) {
                        $followupQuotearr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupQuotearr = array_filter($followupQuotearr);
            //add in condition
            $idStr = implode(',', $followupQuotearr);

            if ($idStr) {
                $criteria->addCondition("t.id in ($idStr)");
            }
        }


        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(ws_date, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(ws_date, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(ws_date, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        //$criteria->order = 'quotecreated desc';

        if (!User::isAdmin()) {
            $criteria->addCondition('t.quotecreatedby = ' . Yii::app()->user->id);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();


        //here define the filter fields by exactly value
        $paramarr = array();

        //here define the filter fields by like values
        $paramarrLike = array('quoteno LIKE :' => $this->quoteno, 'quotename LIKE :' => $this->quotename,
            'master_customer.mcusnam LIKE :' => $this->mastercus_search, 'customer.cusnam LIKE :' => $this->customer_search,
            'quotecomments LIKE :' => $this->quotecomments, 'ws_user LIKE :' => $this->ws_user);

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        if (isset(Yii::app()->session['quote_sts_qry']))
            unset(Yii::app()->session['quote_sts_qry']);

        Yii::app()->session['quote_sts_qry'] = $originalQuery;





        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.ws_date DESC',
            )
        ));
    }

    public function getTextField($fieldname, $modelvalue, $elmID) {
        $html = '';

        if ($elmID != null)
            $html .= CHtml::textField($fieldname, $modelvalue, array("style" => "width:300px;", "id" => $fieldname . "_" . $elmID));
        else
            $html .= CHtml::textField($fieldname, $modelvalue, array("style" => "width:300px;"));


        $html .= '<span id="' . $fieldname . '_' . $this->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>';
        return $html;
    }

    public function getTextFieldForQuoteView($fieldname, $modelvalue, $elmID) {
        $html = '';

        if ($elmID != null)
            $html .= CHtml::textField($fieldname, $modelvalue, array("style" => "width:300px;", "id" => $fieldname . "_" . $elmID));
        else
            $html .= CHtml::textField($fieldname, $modelvalue, array("style" => "width:300px;"));


        $html .= '<span id="savemsg_' . $fieldname . '_' . $this->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>';
        return $html;
    }

    public function getTextAreaForQuoteView($fieldname, $modelvalue, $elmID) {
        $html = '';

        if ($elmID != null)
            $html .= CHtml::textArea($fieldname, $modelvalue, array("style" => "width:300px;", "rows" => 5, "id" => $fieldname . "_" . $elmID));
        else
            $html .= CHtml::textArea($fieldname, $modelvalue, array("style" => "width:300px;", "rows" => 5));


        $html .= '<span id="savemsg_' . $fieldname . '_' . $this->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>';
        return $html;
    }

    public function getTextArea($fieldname, $modelvalue, $elmID) {
        $html = '';

        $html .= CHtml::textArea($fieldname, $modelvalue, array("style" => "width:300px;", "rows" => 5, "id" => "quote_" . $elmID));


        $html .= '<span id="' . $fieldname . '_' . $this->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>';
        return $html;
    }

    public function getDropDown($fieldname, $modelvalue, $elmID, $data, $key, $display, $empty) {
        $html = '';

        $html .= CHtml::dropDownList($fieldname, $modelvalue, CHtml::listData($data, $key, $display), array("id" => "{$fieldname}_{$elmID}", 'empty' => $empty));


        $html .= '<span id="savemsg_' . $fieldname . '_' . $this->id . '" style="color:green;margin-left:30px;display:none;"><b>Changes are saved</b></span>';
        return $html;
    }

    public function getMasterCustomerLink() {

        if (!empty($this->customer->master)) {
            return CHtml::link($this->customer->master->mcusnam, array("masterCustomer/view", "id" => $this->customer->master->mcuscus), array("target" => "_blank"));
        }

        return null;
    }

    public function getCustomerLink() {
        $html = null;
        $customerText = $this->customer->cusnam;
        $customerContactName = '<br><div style="border-top:1px solid #C9E0ED;" name="customer.cuscontact">' . $this->customer->cuscontact . '</div>';
        if (!empty($this->customer)) {

            $html .= CHtml::link($customerText, array("customer/view", "id" => $this->customer->cussno), array("target" => "_blank", "name" => "customer.cusnam")) . $customerContactName;


            if ($this->customer->status_id == 29) {
                $html .= "<br><span class='label label-important'>ACCOUNT ON HOLD</span>";
            }
        }

        return $html;
    }

    public function getProdQtyTotal() {
        $sql = "select sum(qty) as totalQty from quatationdetails where quoteid = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalQty'];
    }

    public function getSellingPriceExVatTot() {
        $sql = "select sum(sellunitprice_ex_vat) as sellExVat from quatationdetails where quoteid = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellExVat'];
    }

    public function getSellingPriceIncVatTot() {
        $sql = "select sum(sellunitprice_in_vat) as sellIncVat from quatationdetails where quoteid = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellIncVat'];
    }
    
    public function getTotalCost() {
        $sql = "select sum(productexunitprice * qty) as costPriceTotal from quatationdetails where quoteid = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['costPriceTotal'];
    }

    public function getTotalSellPriExVatTot() {
        $sql = "select sum(sellunitprice_ex_vat * qty) as sellTotExVat from quatationdetails where quoteid = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellTotExVat'];
    }

    public function getTotalSellPriIncVatTot() {
        $sql = "select sum(sellunitprice_in_vat * qty) as sellTotIncVat from quatationdetails where quoteid = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellTotIncVat'];
    }

    public function generatePDF() {

        $model = $this;



//        if (in_array($model->status_id, array(2, 6)) == true) {
//            $sotype = 'ORDER CONFIRMATION';
//        }



        if (empty($slog)) {
            SalesLog::createSalesLog($model->id, $model->id, $model->quoteno, 'Quotation', "Quotation ($model->quoteno) is printed", 1, 1, 1);
        }


        $pdf = Yii::createComponent('application.extensions.tcpdf.ETcPdf', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle(Yii::app()->name . " - Quotation");
        $pdf->SetSubject('Quotation');
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();

//Write the html
//Convert the Html to a pdf document




        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;text-align:center;font-size:2em;">QUOTATION</td></tr>
                    <tr><td style="width:100%;text-align:center;font-size:2em;">' . $model->quoteno . '</td></tr>    
                  </table><br/><br/>';

        $html .= '<table style="width:100%;">';

        $html .= '<tr><td style="width:50%;font-size:1.2em;">Quoatation Number : ' . $model->quoteno . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->quotecreated)) . '</td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Customer : ' . (!empty($model->customer) ? $model->customer->cusnam : '' ) . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Address : ' . (!empty($model->customer) ? $model->customer->getFullAddress() : '' ) . ' </td></tr>';
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">E-mail :  ' . (!empty($model->customer) ? $model->customer->cusemail : '') . ' </td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Telephone :  ' . (!empty($model->customer) ? $model->customer->custel : '' ) . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Sales Person : ' . $model->ws_user . '</td></tr>';

        $html .= '</table><br/>';


        $html .= '<table style="width: 100%;height:100%;border:1px solid #000;padding:2px;">';
        $html .= '<tr style="width: 100%;background-color:#DDD;">
                    <td style="width: 100%;border:1px solid #000;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <th style="width: 5%;text-align: center;" >No</th>
                                <th style="width: 15%;text-align: center;" >Image</th>
                                <th style="width: 15%;text-align: center;">Product</th>                               
                                <th style="width: 15%;text-align: center;">Decoration</th>
                                <th style="width: 10%;text-align: center;">Qty</th>

                                <th style="width: 10%;text-align: center;">Price Ex GST</th>
                                <th style="width: 10%;text-align: center;">Price Inc GST</th>
                                <th style="width: 10%;text-align: center;">Total Ex GST</th>
                                <th style="width: 10%;text-align: center;">Total Inc GST</th>                            
                                
                            </tr>

                        </table>
                    </td>

                </tr>';


        $quotationdetailsList = QuatationDetails::model()->findAll(array('condition' => 'quoteid=:quoteID', 'params' => array(':quoteID' => $model->id)));


        $htmlbodyrows = '';

        foreach ($quotationdetailsList as $record) {
            $this->count++;
            $this->rowtype = $this->count % 2;
            $htmlbodyrows .= $this->getHtml($record);
        }

        $html .= $htmlbodyrows;



        $quotedtl = new QuatationDetails();
        $quotedtl->quoteid = $model->id;
        $html .= '<tr style="width: 100%;background-color:#CCC;">
                    <td style="width: 100%;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <td style="width: 5%;"></td>
                                <td style="width: 15%;"></td>
                                <td style="width: 15%;"></td>
                                <td style="width: 15%;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>                                
                                <td style="width: 10%;text-align: center;"><div style="font-size: 1.2em; font-weight: bold; text-align: center;" id="totprodqty"> ' . $quotedtl->getProdQtyTotal() . '  </div></td>

                                <td style="width: 10%;text-align: right;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellexvat"> ' . number_format($quotedtl->getSellingPriceExVatTot(), 2) . '</div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellincvat"> ' . number_format($quotedtl->getSellingPriceIncVatTot(), 2) . ' </div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totexvattot">' . number_format($quotedtl->getTotalSellPriExVatTot(), 2) . '</div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totinvattot">' . number_format($quotedtl->getTotalSellPriIncVatTot(), 2) . ' </div></td>
                                
                            </tr>
                        </table>
                    </td>


                </tr>';

        $html .= '</table>';



// data loading
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();

        $filename = time() . 'UID' . Yii::app()->user->id . '.pdf';

//Close and output PDF document
        $pdf->Output("files/{$filename}", 'F');
        $fileinventory = new FileInventory();
        $fileinventory->filename = $filename;
        $fileinventory->type = 'Quote';
        $fileinventory->ref_id = $model->id;
        $fileinventory->createdBy = Yii::app()->user->id;
        $fileinventory->createdDtm = date("Y-m-d g:i");

        $fileinventory->save();

        return $fileinventory;
    }

    var $rowtype = 0;
    var $count = 0;

    private function getHtml($record) {

        $html = '';

        $count = 0;


        $quotedecodtl = QuoteProductDecoration::model()->find(array('condition' => "quoteid = '{$record->quoteid}' and quataiondetailsid = '{$record->id}'"));



        $html .= '<tr style="width:100%;">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                <td style="width: 15%;">';
        $image = $record->getImg();
        if (!empty($image))
            $html .= '<img src="' . $image . '" width="50" height="50"/> ';
        else
            $html .= '';
        $productname = $record->productsku . '<br>' . nl2br($record->productname);
        $html .= '</td><td style="width: 15%;">
                                    <div class="prodecs">' . trim($productname) . '</div></td>';


        $html .= '<td style="width: 15%;">
                         ' . $quotedecodtl->decprtnam . '<br>' . nl2br($quotedecodtl->decorationdescription) . '
                    </td>';

        $html .= '<td style="width: 10%;text-align: center;">
                                    ' . $record->qty . '
                                </td>
                                
                                <td style="width: 10%;text-align: right;">
                                   ' . number_format($record->sellunitprice_ex_vat, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($record->sellunitprice_in_vat, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($record->selltot_ex_vat, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($record->selltot_in_vat, 2) . '
                                </td>                                
                                
                            </tr>';

        $html .= '<tr  style="width:100%;">
                                <td colspan="9" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">
                                            <tr style="width:100%;">
                                                <td style="width:100%;">
                                                    <table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:100%;text-align:center;font-weight:bold;" >Product Details</th>                                                            
                                                            
                                                        </tr>
                                                        <tr style="width:100%;">
                                                            <td style="width:100%;text-align:left;" >' . nl2br($record->productdescription) . '</td>
                                                            
                                                        </tr>
                                                    </table>
                                                </td> 
                                            </tr>
                                        </table>
                                     </div>  
                                  </td>   
                            </tr> ';





        $html .= ' </table></td></tr>';

        return $html;
    }

    public static function getQuotesBetween($iniDate, $endDate) {
        $criteria = new CDbCriteria;
        if (!User::isAdmin()) {
            $criteria->addCondition('quotecreatedby = ' . Yii::app()->user->id);
        }

        $criteria->addCondition("DATE_FORMAT(ws_date, '%Y-%m-%d') between '{$iniDate}' and '{$endDate}'");
        $models = Quatation::model()->findAll($criteria);
        return $models;
    }

    public function getQuoteHtml() {
        $quotedetails = $this->RelDtls;
        $countdtl = count($quotedetails);
        $html = '';
        if (!empty($this->originalQuoteId)) {
            $html = '<div style="position: relative;width:100%;">' . $this->quoteno . '<div style="position: absolute;color:#fff;font-weight:bold;top:-2px;right:0px;font-size:0.8em;border:1px solid #f00;padding:1px;background-color:#f00;border-radius:3px;">Copy</div></div>';
        } else {
            $html = $this->quoteno;
        }

        $html .= '<div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #0f0;padding:1px;background-color:#0f0;border-radius:3px;">P-' . $countdtl . '</div>';
        if (!$this->is_viewed) {
            $html .= '<div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #09f;padding:1px;background-color:#09f;border-radius:3px;">new</div>';
        }



        if (!empty($this->workordersRel)) {
            //$html .= '<table style="width:100%;border:1px solid #eee;" border="0">';
            //$html .= '<tr style="width:100%;">Sales Orders</tr>';
            foreach ($this->workordersRel as $record) {
                $link = CHtml::link($record->salesorderNumber, array("workorderdetails/admin", "wid" => $record->id), array("target" => "_blank", "style" => 'font-size:7pt;'));
                $html .= '<br>' . $link;
            }
            //$html .= '<table>';
        }

        if (!empty($this->jobsRel)) {
            //$html .= '<table style="width:100%;border:1px solid #eee;" border="0">';
            //$html .= '<tr style="width:100%;">Sales Orders</tr>';
            foreach ($this->jobsRel as $record) {
                $link = CHtml::link($record->jobNum, array("jobs/view", "id" => $record->id), array("target" => "_blank", "style" => 'font-size:7pt;'));
                $html .= '<br>' . $link;
            }
            //$html .= '<table>';
        }



        return $html;
    }

    public function getDashboardQuoteHtml() {
        $quotedetails = $this->RelDtls;
        $countdtl = count($quotedetails);
        $html = '';
        if (!empty($this->originalQuoteId)) {
            $html = '<div style="position: relative;width:100%;">' . $this->quoteno . '<div style="position: absolute;color:#fff;font-weight:bold;top:-2px;right:0px;font-size:0.8em;border:1px solid #f00;padding:1px;background-color:#f00;border-radius:3px;">Copy</div></div>';
        } else {
            $html = $this->quoteno;
        }

        $html .= '<div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #0f0;padding:1px;background-color:#0f0;border-radius:3px;">P-' . $countdtl . '</div>';
        if (!$this->is_viewed) {
            $html .= '<div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #09f;padding:1px;background-color:#09f;border-radius:3px;">new</div>';
        }   

        return $html;
    }

    public function getFollowupStatus() {
        $slog = SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$this->id} and followupSts_id > 0", 'order' => "id desc"));
        if (!empty($slog)) {
            return FollowupStatus::model()->findByPk($slog->followupSts_id)->status;
        } else {
            return null;
        }
    }

    public function getFollowupStatusId() {
        $slog = SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$this->id} and followupSts_id > 0", 'order' => "id desc"));
        if (!empty($slog)) {
            return $slog->followupSts_id;
        } else {
            return 0;
        }
    }

    public function getTotalWithoutGST() {
        $sql = "select sum(sellunitprice_ex_vat * qty) as totalExGST from quatationdetails where quoteid = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalExGST'];
    }

    public function getNameWithTotalExGst() {
        $html = $this->getQuoteLink();
        $html .= "</br><div style='float:right;' class='label label-default'>" . number_format($this->sellPriceAmountExGST, 2) . "</div>";

        return $html;
    }

    public function getAllTotalExGST() {
        return $this->allTotalExGST;
    }

    public function footerTemplate() {
        $html = '<div class="label label-success" style="text-align:right;font-size:1.2em;"><span >' . number_format($this->getAllTotalExGST(), 2) . '</span></div>';

        return $html;
    }

    public function footerTemplateCost() {
        $html = '<div class="label label-success" style="text-align:right;font-size:1.2em;"><span >' . number_format($this->allTotalCost, 2) . '</span></div>';

        return $html;
    }

    public function getQuoteLink() {

        $html .= CHtml::link($this->quoteno, array("quatation/view", "id" => $this->id), array("target" => "_blank"));
        return $html;
    }

    public function searchUnconvertedQuotes() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->with = array('customer');

        //$criteria->compare('id', $this->id);
        //$criteria->compare('ws_id', $this->ws_id);
        $criteria->compare('t.quoteno', $this->quoteno, true);
        //$criteria->compare('cus_fref', $this->cus_fref, true);
        //$criteria->compare('systemfreight', $this->systemfreight);
        //$criteria->compare('quotecreatedby', $this->quotecreatedby);
        //$criteria->compare('quotecreated', $this->quotecreated, true);
        //$criteria->compare('quotecomments', $this->quotecomments, true);
        $criteria->compare('t.quotename', $this->quotename, true);
        //$criteria->compare('ws_user', $this->ws_user, true);
        //$criteria->compare('ws_user_id', $this->ws_user_id);
        //$criteria->compare('master.mcusnam', $this->mastercus_search, true);
        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);
        //$criteria->compare('dueDate', $this->dueDate, true);

        if ($this->dateFilterType == Quatation::FILTER_THIS_WEEK) {
            $this_week_ini = date("Y-m-d", strtotime("this week monday"));
            $this_week_end = date("Y-m-d", strtotime("this week sunday"));
            $criteria->addCondition("DATE_FORMAT(ws_date, '%Y-%m-%d') between '{$this_week_ini}' and '{$this_week_end}'");
        }

        $criteria->addCondition("status <> 3");

        //$criteria->addCondition("t.orderTypeId  <> 2");

        if (!empty($this->followupStatus)) {

            $followupQuotearr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Quotation' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupQuotearr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupQuotearr = array_filter($followupQuotearr);
            //add in condition
            $idStr = implode(',', $followupQuotearr);
            if (count($followupQuotearr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }


        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(t.quotecreated, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }


        $criteria->addCondition("NOT EXISTS (SELECT id FROM workorder WHERE t.id = workorder.quotationId)");

        if (!User::isAdmin()) {
            $criteria->addCondition('quotecreatedby = ' . Yii::app()->user->id);
        }

        //$criteria->order = 'quotecreated desc';


        $dataProvider = new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => false,
        ));

        if (isset(Yii::app()->session['unconquote_query'])) {
            unset(Yii::app()->session['unconquote_query']);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        $paramarr = array('t.id=:' => $this->id);

        $paramarrLike = array('t.quoteno LIKE :' => $this->quoteno, 't.quotename LIKE :' => $this->quotename,
            'customer.cusnam LIKE :' => $this->customer_search);


        foreach ($paramarr as $key => $value) {
            $position = strpos($originalQuery, $key);
            if (!empty($position)) {
                $param = str_replace('=:', '', $key);
                $param .= "='$value'";
                $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
            }
        }

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }


        foreach ($dataProvider->getData() as $record) {
            $quote = Quatation::model()->findByPk($record->id);
            $this->allTotalExGST += $quote->getTotalWithoutGST();
            $this->allTotalCost += ($quote->getItemCosts());
        }




        Yii::app()->session['unconquote_query'] = $originalQuery;

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'ws_date desc',
            )
        ));
    }

    public function getItemCosts() {
        $total = 0;
        foreach ($this->RelDtls as $dtl) {
            $total += ($dtl->getItemCost() * $dtl->qty);
        }

        return $total;
    }

    /**
     * @return string new quote number
     */
    public function generateQuoteNumber() {
        if ($quoteStartingNumber = GlobalVars::get(GlobalVars::QUOTATION_STARTING_NUMBER)) {
            if (!$quoteNumber = GlobalVars::get(GlobalVars::QUOTATION_NEXT_NUMBER)) {
                $quoteNumber = $quoteStartingNumber;
            }
            while (Quatation::model()->find("quoteno = '{$quoteNumber}'")) {
                $quoteNumber++;
            }


            $nextQuoteNumber = $quoteNumber + 1;
            $sql = "UPDATE global_vars SET value = $nextQuoteNumber WHERE globalVar = '" . GlobalVars::QUOTATION_NEXT_NUMBER . "'";
            Yii::app()->db->createCommand($sql)->execute();

            return $quoteNumber;
        } else {
            $newquotenum = sprintf("%06s", $this->id);
            $newquotenum = date('y') . '-' . $newquotenum;
            return $newquotenum;
        }
    }

    /**
     * Generate online acceptance link for the quote
     * @return string quote acceptance link
     */
    public function generateOnlineAcceptLink() {

        $linkSecret = AcceptanceLinkStringGenerator::randomString();
        $acceptURL = Yii::app()->createAbsoluteUrl('quoteAccept/index&id=' . $linkSecret, array(), 'http');

        $logId = QuoteOnlineAcceptenceLog::write(array(
                    'quote_id' => $this->id,
                    'link_secret' => $linkSecret,
                    'link_expire_in' => date('Y-m-d H:i:s', time() + (3600 * 24 * 7)), // expire in 7 days
                    'link_active' => QuoteOnlineAcceptenceLog::LINK_STATUS_ACTIVE,
                    'status_id' => QuoteOnlineAcceptenceLog::LOG_STATUS_LINK_GENERATED,
                    'accept_url' => $acceptURL
        ));

        $this->quote_online_acceptence_log_id = $logId;
        $this->save(false);

        return $acceptURL;
    }

    public function updateFollowUpStatusByOnlineAcceptance(int $status) {

        $systemOptions = SystemOptions::getOptions();
        switch ($status) {

            case QuoteOnlineAcceptenceLog::LOG_STATUS_SENT:
                $this->followupStatus = intval($systemOptions->quoteAcceptanceLinkSent);
                $this->status = Status::SYS_STATUS_PENDING_APPROVAL;
                break;
            case QuoteOnlineAcceptenceLog::LOG_STATUS_ACCEPT:
                $this->followupStatus = intval($systemOptions->quoteAcceptanceLinkAccept);
                $this->status = Status::SYS_STATUS_CONFIRMED;
                break;
            case QuoteOnlineAcceptenceLog::LOG_STATUS_DECLINE:
                $this->followupStatus = intval($systemOptions->quoteAcceptanceLinkDecline);
                $this->status = Status::SYS_STATUS_CANCELLED;
                break;
        }
    }

    public function getFollowupSalesLog() {
        return SalesLog::model()->find(array('condition' => "category = 'Quotation' and tbl_id = {$this->id} and followupSts_id > 0", 'order' => "id desc"));
    }

    private function getSalesOrderCountForQuote($quoteid) {
        $quotes = Workorder::model()->findAll("quotationId = '$quoteid'");
        $count = count($quotes);

        return $count;
    }

    public function createWorkOrder() {
        $allsaved = true;

        $workorder = new Workorder();
        $workorder->quotationId = $this->id;
        $workorder->salesorderNumber = "SO-" . $this->quoteno . "-" . (1 + $this->getSalesOrderCountForQuote($this->id));
        $workorder->quotationNumber = $this->quoteno;
        $workorder->cus_fref = $this->cus_fref;
        $workorder->mastercusno = $this->customer ? $this->customer->cusmcussno : null;

        $workorder->status_id = Status::model()->find(array('condition' => 'name=:status', 'params' => array(':status' => 'New')))->id;
        $workorder->createddate = date('Y-m-d H:i:s');
        $workorder->createdby = Yii::app()->user->id;
        $workorder->ws_user = $this->ws_user;
        $workorder->ws_user_id = $this->ws_user_id;
        $workorder->isBackOrder = $this->isBackOrder;


        if ($workorder->save(false)) {



            $quotationDetails = QuatationDetails::model()->findAll(
                    array(
                        'condition' => 'quoteid=:quoteID',
                        'params' => array(':quoteID' => $this->id))
            );

            foreach ($quotationDetails as $detail) {

                $workorderDetails = new Workorderdetails;
                $workorderDetails->workorderId = $workorder->id;
                $workorderDetails->linetypeId = 1;
                $workorderDetails->productsku = $detail->productsku;

                //$productLine = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $detail->productsku)));

                $workorderDetails->prdsrtdesc = $detail->productname;
                $workorderDetails->prdlngdesc = $detail->productdescription;

                $quotedecoration = QuoteProductDecoration::model()->find(array('condition' => 'quataiondetailsid=:qouteDetID', 'params' => array(':qouteDetID' => $detail->id)));

                if (!empty($detail->decoration) && $detail->decoration->decprtnam != 'custom_decoration') {
                    //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:decorationKey', 'params' => array(':decorationKey' => $detail->decoration->decprtnam)));

                    $workorderDetails->decprtnam = $detail->decoration->decprtnam;

                    $workorderDetails->decdesc = $quotedecoration->decorationdescription;
                } else {

                    if (!empty($quotedecoration)) {
                        $workorderDetails->decdesc = $quotedecoration->decorationdescription;
                        $workorderDetails->customdecoration = $quotedecoration->decorationdescription;
                    }
                }

                $workorderDetails->prodQty = $detail->qty;
                $workorderDetails->decoQty = !empty($detail->decoration) ? $detail->decoration->decorationqty : 0;
                $workorderDetails->prodCostPrice = floatval($detail->productexunitprice);
                $workorderDetails->decoCostPrice = !empty($detail->decoration) ? floatval($detail->decoration->decorationunitval) : 0;
                $workorderDetails->prodsupref = $detail->sup_fref;
                $workorderDetails->decosupref = !empty($detail->decoration) ? $detail->decoration->supref : '';
                $workorderDetails->sellPriceExVat = $detail->sellunitprice_ex_vat;
                $workorderDetails->sellPriceIncVat = $detail->sellunitprice_in_vat;
                $workorderDetails->totExVat = $detail->selltot_ex_vat;
                $workorderDetails->totIncVat = $detail->selltot_in_vat;


//                if (!empty($detail->productimg) && $detail->productimg != 'N/A') {
//                    $imgfilename = basename($detail->productimg);
//                    try {
//                        if(!empty($imgfilename)){
//                            copy($detail->productimg, (Yii::app()->basePath . '/../images/product_img/' . $imgfilename)); 
//                            $workorderDetails->image = $imgfilename;
//                        }
//                        
//                    } catch (Exception $ex) {
//                        
//                    }
//                }

                $workorderDetails->image = $detail->productimg;

                $workorderDetails->createdby = Yii::app()->user->id;
                $workorderDetails->createddate = date('Y-m-d H:i:s');
                if ($workorderDetails->save(false)) {
                    
                } else {
                    $allsaved = false;
                }
            }
        } else {
            $allsaved = false;
        }

        if ($allsaved == true) {

            return $workorder;
        } else {

            return null;
        }
    }

    /**
     * decide the created date based on web service or manual quote
     */
    public function getCreatedDate() {
        return $this->ws_date ?: $this->quotecreated;
    }
    
    public function recalculateLineTotals() {
        $quoteDetails = QuatationDetails::model()->findAll(array('condition' => "quoteid = {$this->id}"));
        
        foreach ($quoteDetails as $data) {
            $data->recalculateLineTotal();
        }
    }

}
