<?php

/**
 * This is the model class for table "quote_online_acceptence_log".
 *
 * The followings are the available columns in table 'quote_online_acceptence_log':
 * @property integer $id
 * @property integer $quote_id
 * @property string $link_secret
 * @property string $link_expire_in
 * @property integer $link_active
 * @property integer $status_id
 * @property string $cutomer_comment
 * @property string $accept_url
 * @property string $created_date
 * @property integer $created_by
 * @property string $user_data
 * @property bool $enable_pay_later
 */
class QuoteOnlineAcceptenceLog extends CActiveRecord
{

	const LINK_STATUS_ACTIVE = 1;
	const LINK_STATUS_INACTIVE = 0;
	const LOG_STATUS_LINK_GENERATED = 1;
	const LOG_STATUS_SENT = 2;
	const LOG_STATUS_ACCEPT = 3;
	const LOG_STATUS_DECLINE = 4;
	const LOG_STATUS_PAID = 5;
	const LOG_STATUS_PAY_LATER = 6;
	const LOG_STATUS_ARRAY = array(1 => 'LINK GENERATED', 2 => 'LINK SENT', 3 => 'ACCEPT', 4 => 'DECLINE', 5 => 'PAID', 6 => 'PAY LATER');

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return QuoteOnlineAcceptenceLog the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'quote_online_acceptence_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('quote_id, link_secret, link_expire_in, link_active, status_id, created_date', 'required'),
			array('quote_id, link_active, status_id, created_by, enable_pay_later', 'numerical', 'integerOnly' => true),
			array('link_secret, cutomer_comment', 'length', 'max' => 255),
			array('accept_url', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, quote_id, link_secret, link_expire_in, link_active, status_id, cutomer_comment, created_date, created_by', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'quote_id' => 'Quote',
			'link_secret' => 'Link Secret',
			'link_expire_in' => 'Link Expire In',
			'link_active' => 'Link Active',
			'status_id' => 'Status',
			'cutomer_comment' => 'Cutomer Comment',
			'created_date' => 'Created Date',
			'created_by' => 'Created By',
			'accept_url' => 'Accept URL',
			'enable_pay_later' => 'Enable Pay Later'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('quote_id', $this->quote_id);
		$criteria->compare('link_secret', $this->link_secret, true);
		$criteria->compare('link_expire_in', $this->link_expire_in, true);
		$criteria->compare('link_active', $this->link_active);
		$criteria->compare('status_id', $this->status_id);
		$criteria->compare('cutomer_comment', $this->cutomer_comment, true);
		$criteria->compare('created_date', $this->created_date, true);
		$criteria->compare('created_by', $this->created_by);

		$pageSize = (int) GlobalVars::get('RecordsViewPerPage');

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination' => array('pageSize' => $pageSize),
			'sort' => array(
				'defaultOrder' => 't.created_date DESC',
			)
		));
	}

	/**
	 * @param array $data key values pairs QuoteOnlineAcceptenceLog fields 
	 * @return int id of log
	 */
	public static function write(array $data)
	{
		$model = new QuoteOnlineAcceptenceLog();
		$model->quote_id = $data['quote_id'];
		$model->link_secret = $data['link_secret'];
		$model->link_expire_in = $data['link_expire_in'];
		$model->link_active = $data['link_active'];
		$model->status_id = $data['status_id'];
		$model->cutomer_comment = $data['cutomer_comment'];
		$model->accept_url = $data['accept_url'];

		$model->created_date = date('Y-m-d H:i:s');
		$model->user_data = $data['user_data'];

		$model->created_by = Yii::app()->user->id ?? -1;

		$model->save();

		return $model->id;
	}

	/**
	 * validate link secret against the database and return quote id if validated
	 * @param string $secret link secret
	 * @return int quote id
	 */
	public static function validateLinkSecret($secret)
	{
		//fisrt check if the secret available in the log record with conditions
		$criteria = new CDbCriteria(array(
			'condition' => 'BINARY link_secret=:secret AND link_active =:linkActive AND status_id =:linkStatus AND link_expire_in > :linkExpire',			
			'params' => array(
				':secret' => $secret,
				':linkActive' => QuoteOnlineAcceptenceLog::LINK_STATUS_ACTIVE,
				':linkStatus' =>QuoteOnlineAcceptenceLog::LOG_STATUS_SENT, //to be a valid link it has to be sent
				':linkExpire' => date('Y-m-d H:i:s')
			)
		));



		$log = QuoteOnlineAcceptenceLog::model()->find($criteria);

		return $log->quote_id ?? null;
	}

	public static function validateLinkSecretForCheckOut($secret)
	{
		//fisrt check if the secret available in the log record with conditions
		$criteria = new CDbCriteria(array(
			'condition' => 'BINARY link_secret=:secret AND link_active =:linkActive AND link_expire_in > :linkExpire',	
			'params' => array(
				':secret' => $secret,
				':linkActive' => QuoteOnlineAcceptenceLog::LINK_STATUS_ACTIVE,				
				':linkExpire' => date('Y-m-d H:i:s')
			)
		));

					
		$criteria->addInCondition('status_id', array(QuoteOnlineAcceptenceLog::LOG_STATUS_ACCEPT, QuoteOnlineAcceptenceLog::LOG_STATUS_PAY_LATER));



		$log = QuoteOnlineAcceptenceLog::model()->find($criteria);

		return $log->quote_id ?? null;
	}

	public static function getLogBySecret($secret) {		
		$criteria = new CDbCriteria(array(
			'condition' => 'BINARY link_secret=:secret',
			'order' => 'id DESC',
			'params' => array(
				':secret' => $secret			
			)
		));



		return QuoteOnlineAcceptenceLog::model()->find($criteria);
	}

	public static function dasableAllLinks($quoteId)
	{
		//if null deactivate all related links for given quote id

		QuoteOnlineAcceptenceLog::model()->updateAll(array('link_active' => 0, 'link_expire_in' => date('Y-m-d H:i:s')), 'quote_id ='. $quoteId);
	}

	public function toString()
	{
		switch ($this->status_id) {
			case QuoteOnlineAcceptenceLog::LOG_STATUS_LINK_GENERATED: return 'LINK GENERATED';
			case QuoteOnlineAcceptenceLog::LOG_STATUS_SENT: return 'LINK SENT';
			case QuoteOnlineAcceptenceLog::LOG_STATUS_ACCEPT: return 'ACCEPT';
			case QuoteOnlineAcceptenceLog::LOG_STATUS_DECLINE: return 'DECLINE';
			case QuoteOnlineAcceptenceLog::LOG_STATUS_PAID: return 'PAID';
			case QuoteOnlineAcceptenceLog::LOG_STATUS_PAY_LATER: return 'PAY LATER';
			default: return '';
		}
	}

}
