<?php

/**
 * This is the model class for table "quatationpdctdecorations".
 *
 * The followings are the available columns in table 'quatationpdctdecorations':
 * @property integer $id
 * @property string $productsku
 * @property integer $quataiondetailsid
 * @property string $decprtnam
 * @property integer $decorationqty
 * @property double $decorationunitval
 * @property string $maindecorationid
 * @property double $decorationfreightval
 * @property double $decorationvat
 */
class QuoteProductDecoration extends CActiveRecord
{

    public $decoration_shortname_search;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return QuoteProductDecoration the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'quatationpdctdecorations';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('quoteid, quataiondetailsid, decorationqty', 'numerical', 'integerOnly'=>true),
			array('decorationunitval, decorationfreightval, decorationvat, supmarg, supmargMarkedUpPrice, '
                            . 'logoSetupMarkupRate, logoSetupUnitCost, logoSetupUnitCostWithMarkup, supmargPercentage, logoSetupMarkupPercentage, logosetupcharge', 'numerical'),
			array('productsku, decprtnam, maindecorationid, supref', 'length', 'max' => 255),
			array('decorationdescription,decoration_shortname_search, customization_detail', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id,quoteid, productsku, quataiondetailsid, decprtnam, decorationdescription, decorationqty, decorationunitval, maindecorationid, decorationfreightval, decorationvat, supref', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'decoRel' => array(self::BELONGS_TO, 'Decoration', '', 'foreignKey' => array('decprtnam' => 'decprtnam')),
                    'supRel' => array(self::BELONGS_TO, 'Supplier', '', 'foreignKey' => array('supref' => 'supsup_fref')), 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
            'quoteid'=>'Quotation ID',
			'productsku' => 'Productsku',
			'quataiondetailsid' => 'Quataiondetailsid',
			'decprtnam' => 'Decoration Code',
			'decorationqty' => 'Decorationqty',
			'decorationunitval' => 'Decoration Unit Price',
			'maindecorationid' => 'Maindecorationid',
			'decorationfreightval' => 'Decorationfreightval',
			'decorationvat' => 'Decorationvat',
			'supref' => 'Supplier',
			'decorationdescription' => 'Decoration Description',
			'decoration_shortname_search' => 'Decoration Short Description',
			'customization_detail' => 'Customisation Details'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
                $criteria->compare('quoteid',$this->quoteid);
		$criteria->compare('productsku',$this->productsku,true);
		$criteria->compare('quataiondetailsid',$this->quataiondetailsid);
		$criteria->compare('decprtnam',$this->decprtnam,true);
		$criteria->compare('decorationqty',$this->decorationqty);
		$criteria->compare('decorationunitval',$this->decorationunitval);
		$criteria->compare('maindecorationid',$this->maindecorationid,true);
		$criteria->compare('decorationfreightval',$this->decorationfreightval);
		$criteria->compare('decorationvat',$this->decorationvat);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function getDecorationCalculations($mix = array()) {
            $decUnitPrice = $mix['decorationunitval'] ?:$this->decorationunitval;
            $decSupMarg = $mix['supmarg'] ?:$this->supmarg;
            $decMarkedupPrice = $decSupMarg ? number_format(($decUnitPrice * $decSupMarg),2) : $decUnitPrice;
            
            $logoSetup = $mix['logosetupcharge'] ?:$this->logosetupcharge;
            $qty = $mix['decorationqty'] ?:$this->decorationqty;
            $logoMarkupRate = $mix['logoSetupMarkupRate'] ?:$this->logoSetupMarkupRate;
            $logoUnitPrice = $qty ? number_format(($logoSetup / $qty),2) : $logoSetup;
            $logoSetupUnitCostWithMarkup = $logoMarkupRate ? number_format(($logoUnitPrice * $logoMarkupRate),2):$logoUnitPrice;
            
            
            return array(
                'decorationunitval' => $decUnitPrice, 
                'supmarg'=> $decSupMarg, 
                'supmargMarkedUpPrice'=>$decMarkedupPrice,
                'logosetupcharge'=>$logoSetup,
                'logoSetupMarkupRate'=>$logoMarkupRate,
                'logoSetupUnitCost'=>$logoUnitPrice,
                'logoSetupUnitCostWithMarkup'=>$logoSetupUnitCostWithMarkup,
                    );
        }
        
        
        public static function getAddNewDecorationCalculations($mix = array()) {
            $decUnitPrice = $mix['decorationunitval'];
            $decSupMarg = $mix['supmarg'];
            $decMarkedupPrice = floatval($decSupMarg) ? number_format(($decUnitPrice * $decSupMarg),2) : $decUnitPrice;
            
            $logoSetup = $mix['logosetupcharge'];
            $qty = $mix['decorationqty'];
            $logoMarkupRate = $mix['logoSetupMarkupRate'];
            $logoUnitPrice = $qty ? number_format(($logoSetup / $qty),2) : $logoSetup;
            $logoSetupUnitCostWithMarkup = $logoMarkupRate ? number_format(($logoUnitPrice * $logoMarkupRate),2):$logoUnitPrice;
            
            
            return array(
                'decorationunitval' => $decUnitPrice, 
			'supmarg' => $decSupMarg,
			'supmargMarkedUpPrice' => $decMarkedupPrice,
			'logosetupcharge' => $logoSetup,
			'logoSetupMarkupRate' => $logoMarkupRate,
			'logoSetupUnitCost' => $logoUnitPrice,
			'logoSetupUnitCostWithMarkup' => $logoSetupUnitCostWithMarkup,
                    );
        }

}