<?php

/**
 * This is the model class for table "sales_log".
 *
 * The followings are the available columns in table 'sales_log':
 * @property integer $id
 * @property integer $quoteId
 * @property string $quoteNum
 * @property string $category
 * @property integer $isIntrnl
 * @property integer $isExtrnl
 * @property string $createdDtm
 * @property string $followupDtm
 * @property integer $createdBy
 * @property integer $followupSts_id
 */
class SalesLog extends CActiveRecord {

    const CATEGORY_QUOTATION = 'Quotation';
    const CATEGORY_SALES_ORDER = 'SalesOrder';
    const CATEGORY_JOB = 'Job';
    const CATEGORY_INVOICE = 'Invoice';
    const CATEGORY_PURCHASE_ORDER = 'PurchaseOrder';
    const CATEGORY_ARTWORK_JOB = 'JobArtwork';
    Const CATEGORY_MASTER_PURCHASE_ORDER = 'MasterPO';
    const CATEGORY_WEBSTORE_ORDER = 'WebStoreOrder';
    const CATEGORY_OTHER = 'Other';
    const CATEGORY_PRODUCT = 'Product';
    const CATEGORY_QUOTATION_DETAIL = 'QuotationDetail';
    const CATEGORY_WORKORDER_DETAIL = 'WorkorderDetail';
    const CATEGORY_CUSTOMER = 'Customer';

    //db fields
    public $cusnam;

    public $customer_search;
    public $user_search;
    public $followup_sts_search;
    public $sonum_search;
    public $flwupsts_search;
    //report attributes
    public $datefrom;
    public $dateto;
    public $followupStatus;
    public $jobNum;
    public $cus_fref;
    public $user_id;
    public $ws_user_id;
    public $salesperson_id;
    public $prd_cordinator_id;
    public $job_id;

    //po report
    public $poNum;
    public $dueDate;
    public $pId;//PO id
    public $jId;//job id
    public $cId;// customer Id
    public $sPersonName; // salesperson name
    public $prodCoordinatorName;
    public $supsno;
    public $supnam;
    public $supplier_id;
    public $job_urgent_status;



    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return SalesLog the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'sales_log';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('category, comments', 'required'),
            array('id, pId, jId, cId,  quoteId, supsno, supplier_id, workorderId, isIntrnl, isExtrnl, isTechnical,createdBy, followupSts_id, job_urgent_status', 'numerical', 'integerOnly' => true),
            array('quoteNum, poNum, sPersonName, prodCoordinatorName, supnam', 'length', 'max' => 255),
            array('createdDtm, followupDtm,comments,workorderId, category,tbl_id, customer_search, followedUp, user_search, '
                . 'followup_sts_search, sonum_search, flwupsts_search, json_record, datefrom, dateto, followupStatus, '
                . 'jobNum, cus_fref, user_id, ws_user_id, salesperson_id, prd_cordinator_id, job_id, followup_sts_search, cusnam, followupSts_id, dueDate', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, quoteId,workorderId, quoteNum, category, isIntrnl, isExtrnl, 
                            createdDtm, followupDtm, createdBy,comments,followupSts_id, customer_search, followedUp, user_search,
                            followup_sts_search, sonum_search, flwupsts_search', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'user' => array(self::BELONGS_TO, 'User', 'createdBy'),
            'quote' => array(self::BELONGS_TO, 'Quatation', 'quoteId'),
            'salesorder' => array(self::BELONGS_TO, 'Workorder', 'workorderId'),
            'flwupstus' => array(self::BELONGS_TO, 'FollowupStatus', 'followupSts_id'),
            'cusRelOne' => array(self::BELONGS_TO, 'Customer', 'tbl_id'), //only works when category = "Customer"
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'quoteId' => 'Quote ID',
            'workorderId' => 'Sales Order',
            'quoteNum' => 'Quotataion Number',
            'category' => 'Category',
            'isIntrnl' => 'Internal Use',
            'isExtrnl' => 'Is Extrnl',
            'isTechnical' => 'Is Technical',
            'createdDtm' => 'Created Date',
            'followupDtm' => 'Follow up Date',
            'createdBy' => 'Added By',
            'comments' => 'Comments',
            'followupSts_id' => 'Follow-Up Status',
            'customer_search' => 'Customer',
            'user_search' => 'Added By',
            'followup_sts_search' => 'Follow-Up Status',
            'sonum_search' => 'Sales Order',
            'flwupsts_search' => 'Follow-Up Status',
            'datefrom' => 'Date From',
            'dateto' => 'Date To',
            'followupStatus' => 'Follow-Up Status',
            'prd_cordinator_id' => 'Production Coordinator',
            'poNum' => 'PO Number',
            'jobNum' => 'Job Number',
            'cusnam' => 'Customer',
            'sPersonName' => 'Salesperson',
            'prodCoordinatorName' => 'Production Coordinator',
            'supplier_id' => 'Supplier'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->join = 'left join quatation as q on quoteId = q.id '
                . '         left join customer as c on q.cus_fref = c.cuscus_fref'
                . '             left join workorder on t.workorderId = workorder.id'
                . '                 left join followup_status on t.followupSts_id = followup_status.id';

        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.quoteId', $this->quoteId);
        $criteria->compare('t.workorderId', $this->workorderId);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.tbl_id', $this->tbl_id);
        $criteria->compare('t.category', $this->category, true);
        $criteria->compare('t.comments', $this->comments, true);
        $criteria->compare('isExtrnl', $this->isExtrnl);
        $criteria->compare('isTechnical', $this->isTechnical);
        $criteria->compare('t.createdDtm', $this->createdDtm, true);
        $criteria->compare('followupDtm', $this->followupDtm, true);
        $criteria->compare('t.createdBy', $this->createdBy);
        $criteria->compare('followupSts_id', $this->followupSts_id);


        $criteria->compare('c.cusnam', $this->customer_search, true);
        $criteria->compare('workorder.salesorderNumber', $this->sonum_search, true);
        $criteria->compare('followup_status.status', $this->flwupsts_search, true);


        if (!User::isAdmin()) {
            $criteria->addCondition('t.createdBy = ' . Yii::app()->user->id);
        }

        // $criteria->order = 'createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.createdDtm desc',
            )
        ));
    }

    public function cusfollowup() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('cusRelOne', 'user', 'flwupstus');

        $criteria->compare('id', $this->id);
        $criteria->compare('quoteId', $this->quoteId);
        $criteria->compare('workorderId', $this->workorderId);
        $criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('tbl_id', $this->tbl_id);
        $criteria->compare('category', $this->category, true);
        $criteria->compare('comments', $this->comments, true);
        $criteria->compare('isExtrnl', $this->isExtrnl);
        $criteria->compare('isIntrnl', $this->isIntrnl);
        $criteria->compare('isTechnical', $this->isTechnical);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('followupDtm', $this->followupDtm, true);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('followupSts_id', $this->followupSts_id);
        $criteria->compare('cusRelOne.cusnam', $this->customer_search, true);
        $criteria->compare('followedUp', $this->followedUp);

        $criteria->compare('user.username', $this->user_search, true);
        $criteria->compare('flwupstus.status', $this->followup_sts_search, true);

        //$userID = Yii::app()->user->id;
        //$criteria->addCondition("category = 'Customer' and isIntrnl = 0 AND createdBy = '{$userID}'");

        if (!User::isAdmin()) {
            $criteria->addCondition('t.createdBy = ' . Yii::app()->user->id);
        }

        $criteria->order = 'createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }
    
    public function searchPO() {
        
        $criteria = new CDbCriteria;
        $criteria->select = 't.id, t.tbl_id, t.followupSts_id, t.followupDtm, t.comments, t.createdDtm, t.createdBy, t.isExtrnl, t.followedUp,'
                . 'p.id AS pId, p.poNum, p.dueDate, '
                . 'j.id AS jId, j.jobNum, j.urgent_status AS job_urgent_status, '
                . 'c.cussno AS cId, c.cusnam, '
                . 's.name AS sPersonName, '
                . 'pc.username AS prodCoordinatorName,'
                . 'sup.supnam';
        $criteria->join = 'LEFT JOIN purchase_orders p ON t.tbl_id = p.id'
                . ' LEFT JOIN jobs j ON p.job_id = j.id'
                . ' LEFT JOIN customer c ON j.cus_fref = c.cuscus_fref'
                . ' LEFT JOIN sales_persons s ON j.salesperson_id = s.id'
                . ' LEFT JOIN User pc ON j.prd_cordinator_id = pc.id'
                . ' LEFT JOIN supplier sup ON p.supplier_id = sup.supsno';
        
        
        
        $criteria->compare('p.poNum', $this->poNum, true);
        $criteria->compare('jobNum', $this->jobNum, true);
        $criteria->compare('c.cusnam', $this->cusnam, true);
        $criteria->compare('s.name', $this->sPersonName, true);
        $criteria->compare('pc.username', $this->prodCoordinatorName, true);
         $criteria->compare('p.supplier_id', $this->supplier_id);
        
        $criteria->compare('comments', $this->comments, true);
        
        $criteria->compare('t.followupSts_id', $this->followupSts_id);
        
        
         $criteria->addCondition('t.category = "PurchaseOrder" AND t.tbl_id IS NOT NULL AND t.followupSts_id IS NOT NULL AND t.followupDtm IS NOT NULL AND p.status_id NOT IN (3, 39, 40) AND t.followedUp IS NULL');
        
         $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.followupDtm ASC',
            )
        ));
    }

    protected function beforeSave() {        

        if (empty($this->followupDtm)) {
            $this->followupDtm = date("Y-m-d H:i:s", strtotime("+100 year"));
        }

        if(!$this->createdDtm) {
            $this->createdDtm = date("Y-m-d H:i:s");
        }
        


        try {
            //this can be failed when run in console ( command ) mode
            $this->createdBy = Yii::app()->user->id;
        } catch (Exception $ex) {
            
        }

        return parent::beforeSave();
    }

    public static function jsonLog($arr = array()) {
        if ($arr) {
            $saleslog = new SalesLog();
            $saleslog->quoteId = $arr['quoteId'];
            $saleslog->workorderId = $arr['workorderId'];
            $saleslog->quoteNum = $arr['quoteNum'];
            $saleslog->category = $arr['category'];
            $saleslog->comments = $arr['comments'];
            $saleslog->json_record = $arr['json_record'];
            $saleslog->isIntrnl = $arr['isIntrnl'];
            $saleslog->isExtrnl = $arr['isExtrnl'];
            $saleslog->isTechnical = $arr['isTechnical'];

            $saleslog->save();
        }
    }

    public static function createSalesLog($quoteid, $wrkorderid, $quotenum, $category, $comment, $isinternal = 0, $isexternal = 0, $istechnical = 0) {
        $saleslog = new SalesLog();
        $saleslog->quoteId = $quoteid;
        $saleslog->workorderId = $wrkorderid;
        $saleslog->quoteNum = $quotenum;
        $saleslog->category = $category;
        $saleslog->comments = $comment;
        $saleslog->isIntrnl = $isinternal;
        $saleslog->isExtrnl = $isexternal;
        $saleslog->isTechnical = $istechnical;

        $saleslog->save(false);
    }
    
    public static function createSalesLogByAtrributes($attributes = array()) {
        $saleslog = new SalesLog();
        
        foreach ($attributes as $attributes => $value) {
            $saleslog->$attributes = $value;
        }        

        $saleslog->save();
    }

    public static function createSalesLogTblId($quoteid, $wrkorderid, $quotenum, $tblId, $category, $comment, $isinternal = 0, $isexternal = 0, $istechnical = 0) {
        $saleslog = new SalesLog();
        $saleslog->quoteId = $quoteid;
        $saleslog->workorderId = $wrkorderid;
        $saleslog->quoteNum = $quotenum;
        $saleslog->tbl_id = $tblId;
        $saleslog->category = $category;
        $saleslog->comments = $comment;
        $saleslog->isIntrnl = $isinternal;
        $saleslog->isExtrnl = $isexternal;
        $saleslog->isTechnical = $istechnical;

        $saleslog->save();
    }

    public static function createCustomerLog($cusno, $category, $comment) {
        $saleslog = new SalesLog();

        $saleslog->tbl_id = $cusno;
        $saleslog->category = $category;
        $saleslog->comments = $comment;
        $saleslog->isIntrnl = 1;
        $saleslog->isExtrnl = 1;
        $saleslog->isTechnical = 1;

        $saleslog->save();
    }

    public static function createTblLog($tblID, $category, $comment) {
        $saleslog = new SalesLog();

        $saleslog->tbl_id = $tblID;
        $saleslog->category = $category;
        $saleslog->comments = $comment;
        $saleslog->isIntrnl = 1;
        $saleslog->isExtrnl = 1;
        $saleslog->isTechnical = 1;

        $saleslog->save();
    }

    public static function createSalesLogWithFollowup($quoteid, $wrkorderid, $quotenum, $category, $comment, $isinternal = 0, $isexternal = 0, $istechnical = 0, $followupDate = null) {
        $saleslog = new SalesLog();
        $saleslog->quoteId = $quoteid;
        $saleslog->workorderId = $wrkorderid;
        $saleslog->quoteNum = $quotenum;
        $saleslog->category = $category;
        $saleslog->comments = $comment;
        $saleslog->isIntrnl = $isinternal;
        $saleslog->isExtrnl = $isexternal;
        $saleslog->isTechnical = $istechnical;
        $saleslog->followupDtm = date('Y-m-d', strtotime($followupDate));

        return $saleslog->save();
    }

    public function getCustomerID() {
        $cusno = 0;

        if (!empty($this->quote) && !empty($this->quote->customer)) {
            $cusno = $this->quote->customer->cussno;
        } else if ($this->category == 'Customer') {
            $cusno = $this->tbl_id;
        }

        return $cusno;
    }

    public function getRefindeDateTime($datetime) {

        if (empty($datetime))
            return null;
        else {
            if ($datetime == '0000-00-00 00:00:00' || $datetime == '1970-01-01 00:00:00' || $datetime == '1969-12-31 00:00:00') {
                return null;
            } else {
                return date(GlobalVars::get("DateFormat"), strtotime($datetime));
            }
        }
    }

    public function getCustomerLink() {
        $customerText = null;
        if ($this->category == 'Customer' && !empty($this->tbl_id)) {

            $customer = Customer::model()->findByPk($this->tbl_id);
            if (!empty($customer)) {
                if (Yii::app()->user->checkAccess('Cutomer.View') == true) {
                    $customerText = CHtml::link($customer->cusnam, array("customer/view", "id" => $this->tbl_id), array("target" => "_blank"));
                } else {
                    $customerText = $customer->cusnam;
                }
            }
        } else {
            if (!empty($this->quote)) {
                if (Yii::app()->user->checkAccess('Cutomer.View') == true) {
                    $customerText = CHtml::link($this->quote->customer->cusnam, array("customer/view", "id" => $this->quote->customer->cussno), array("target" => "_blank"));
                } else {
                    $customerText = $this->quote->customer->cusnam;
                }
            }
        }

        return $customerText;
    }

    public function getLinkCategory() {

        if (in_array($this->category, array('Quotation', 'Job', 'SalesOrder', 'PurchaseOrder', 'JobArtwork', 'Invoice')) && !empty($this->tbl_id)) {

            $actionurl = '';
            $pram = 'id';
            $categoryHtml = $this->category;
            $referencenum = '';
            if ($categoryHtml == 'Quotation') {
                $actionurl = 'quatation/view';
                $referencenum = $this->quoteNum;
            } else if ($categoryHtml == 'Job') {
                $actionurl = 'jobs/view';
                $referencenum = Jobs::model()->findByPk($this->tbl_id)->jobNum;
            } else if ($categoryHtml == 'SalesOrder') {
                $actionurl = 'workorderdetails/admin';
                $pram = 'wid';
                $referencenum = Workorder::model()->findByPk($this->tbl_id)->salesorderNumber;
            } else if ($categoryHtml == 'PurchaseOrder') {
                $actionurl = 'purchaseOrders/view';
                $referencenum = PurchaseOrders::model()->findByPk($this->tbl_id)->poNum;
            } else if ($categoryHtml == 'JobArtwork') {
                $actionurl = 'jobArtwork/view';
                $referencenum = JobArtwork::model()->findByPk($this->tbl_id)->artworkjobNum;
            } else if ($categoryHtml == 'Invoice') {
                $actionurl = 'invoice/view';
                $referencenum = Invoice::model()->findByPk($this->tbl_id)->invoiceNum;
            }
            $categoryHtml .= '<br><font style="font-size:7pt;">[ ' . $referencenum . ' ]</font>';
            return CHtml::link($categoryHtml, array($actionurl, $pram => $this->tbl_id), array('target' => '_blank'));
        } else {
            return $this->category;
        }
    }

    public function isFollowUp() {
        if ($this->isIntrnl != true && !in_array($this->followupDtm, array('0000-00-00 00:00:00', '1970-01-01 00:00:00', null, '', ' '))) {
            return true;
        } else {
            return false;
        }
    }

    public static function addFollowUp(array $data) {
        if (!$data) {
            return null;
        }

        $salesLog = new SalesLog();


        $salesLog->category = $data['category'];
        $salesLog->tbl_id = $data['tbl_id'];
        $salesLog->followupSts_id = $data['followupSts_id'];

        return $salesLog->save(false);
    }

    public static function log(array $data) {
        $salesLog = new SalesLog();


        $salesLog->category = $data['category'];
        $salesLog->tbl_id = $data['tbl_id'];
        $salesLog->comments = $data['comments'];
        $salesLog->followupSts_id = $data['followupSts_id'];

        return $salesLog->save(false);
    }
    
    public function getFollowed() {
        
        
        $this->followedUp = !$this->followedUp;
        
        if ($this->save(false)) {
            if ($this->followedUp) {
                $txtcmnt = $this->comments;
                $flpmdl = FollowupStatus::model()->findByPk($this->followupSts_id);
                if (!empty($flpmdl)) {
                    $txtcmnt .= ' - ' . $flpmdl->status;
                }
                $linkId = CHtml::link($this->id, array('salesLog/view', 'id' => $this->id), array('target' => '_blank'));
                $comment = "[ID : " . $linkId . "]<br>[ " . $txtcmnt . " ] has completed";
                SalesLog::createSalesLogTblId($this->quoteId, $this->workorderId, $this->quoteNum, $this->tbl_id, $this->category, $comment, 1, 0, 1);
            }
            return true;
        } 
        
        return false;
        
    }

}
