<?php

/**
 * This is the model class for table "sales_persons".
 *
 * The followings are the available columns in table 'sales_persons':
 * @property integer $id
 * @property string $name
 * @property string $email
 * @property integer $is_active
 * @property string $signature_image
 */
class SalesPerson extends CActiveRecord
{
	public $uploadSignatureImage;

	public $reportDateFlag;
	public $datefrom;
	public $dateto;
	
	public $sumSellTotalExGST;
	public $sumSellTotalIncGST;
	public $sumSalesEstimate;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return SalesPerson the static model class
     */
	public static function model($className = __CLASS__)
	{
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
	public function tableName()
	{
        return 'sales_persons';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name', 'required'),
            array('is_active, reportDateFlag', 'numerical', 'integerOnly' => true),
			 array('sumSellTotalExGST, sumSellTotalIncGST, sumSalesEstimate', 'numerical'),
            array('name', 'length', 'max' => 255),
            array('email', 'length', 'max' => 150),
            array('log_id', 'length', 'max' => 100),
            array('phone_direct_line, phone_mobile', 'length', 'max' => 20),
			array('uploadSignatureImage', 'default', 'value' => ''),
            array('email', 'email'),
			array('uploadSignatureImage', 'file', 'allowEmpty' => true,'types' => 'jpg,gif,png', 'maxSize' => 1000 * 50 /* 50KB */, 'on' => 'insert', 'tooLarge' => 'The file was larger than 50KB. Please upload a smaller file.'),
			array('uploadSignatureImage', 'file', 'allowEmpty' => true, 'types' => 'jpg,gif,png', 'maxSize' => 1000 * 50 /* 50KB */, 'on' => 'update', 'tooLarge' => 'The file was larger than 50KB. Please upload a smaller file.'),
			//array('signature_image', 'file', 'allowEmpty' => true, 'types' => 'jpg,gif,png', 'wrongType' => 'Only jpg,gif,png allowed!', 'maxSize' => 512, 'tooLarge' => 'The file was larger than 512KB. Please upload a smaller file.'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, name, email, is_active, datefrom, dateto', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
	public function relations()
	{
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
             'salesperson' => array(self::BELONGS_TO, 'SalesPerson', 'user_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
	public function attributeLabels()
	{
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'email' => 'Email',
            'is_active' => 'Is Active',
			'sumSellTotalExGST' => 'Price Total ( Ex GST )',
			'sumSellTotalIncGST' => 'Price Total ( Inc GST )',
			'sumSalesEstimate' => 'Sales Estimate Total',
            'phone_direct_line' => 'Direct Line',
            'phone_mobile' => 'Mobile',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
	public function search()
	{
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('is_active', $this->is_active);
        $criteria->compare('phone_direct_line', $this->phone_direct_line, true);
        $criteria->compare('phone_mobile', $this->phone_mobile, true);

        $criteria->order = 'name asc';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

	
	public $grandSumExGST;
	public $grandSumIncGST;
	public $grandSalesEstimate;


	public function searchQuoteSum() {
        $loggeduserID = Yii::app()->user->id;
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->select = 't.name, SUM(q.salesEstimate) AS sumSalesEstimate, SUM(qd.selltot_ex_vat) AS sumSellTotalExGST, SUM(qd.selltot_in_vat) AS sumSellTotalIncGST';

        $criteria->join = 'LEFT JOIN quatation q on q.ws_user_id = t.id'
				. '			LEFT JOIN quatationdetails qd ON qd.quoteid = q.id';

		


        if ($this->reportDateFlag == 1) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(q.quotecreated, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(q.quotecreated, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(q.quotecreated, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
}
        } else if ($this->reportDateFlag == 2) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(q.dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(q.dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(q.dueDate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        }





        if (isset(Yii::app()->session['qs_sperson_selcted']) && Yii::app()->session['qs_sperson_selcted']) {
			
			$spersonsStr = Yii::app()->session['qs_sperson_selcted'];
            $criteria->addCondition("t.id IN ($spersonsStr) ");
        } 

        $criteria->addCondition("q.status <> 3");
		
		 $criteria->group = "t.id";

        //here we show only jobs which is not "ON_INVENTORY" types
        // $criteria->addCondition("t.orderTypeId not in (1,2)");
        //$criteria->order = 'createdDtm DESC';

        $dataProvider = new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => false,
        ));

        if (isset(Yii::app()->session['qs_sperson_query'])) {
            unset(Yii::app()->session['qs_sperson_query']);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

		
        




        Yii::app()->session['qs_sperson_query'] = $originalQuery;

        foreach ($dataProvider->getData() as $record) {
            
            $this->grandSumExGST += $record->sumSellTotalExGST;
			$this->grandSumIncGST += $record->sumSellTotalIncGST;
			$this->grandSalesEstimate += $record->sumSalesEstimate;
        }


        $pageSize = 100; //1000 is only for sales person report //(int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'attributes' => array(
                    't.name',
                ),
                'defaultOrder' => 't.name',
            ),
        ));
    }

    /**
     * update salesperson if exist else create new
     * @param array $param attribute names
     * @return Salesperson active record
     */
    public static function updateSalesperson(array $attributes) {


        if (!$salesperson = SalesPerson::model()->find(array('condition' => "email = '{$attributes['email']}'", 'order' => 'id DESC'))) {

            $salesperson = new SalesPerson();
}

        $salesperson->name = $attributes['name'];
        $salesperson->email = $attributes['email'];
        $salesperson->phone_direct_line = $attributes['phone_direct_line'];
        $salesperson->phone_mobile = $attributes['phone_mobile'];
        $salesperson->log_id = $attributes['log_id'];
        $salesperson->is_active = 1;

        if ($salesperson->save(false)) {
            return $salesperson;
        }

        return null;
    }
    
    public static function isLoggedUser() {
       if (SalesPerson::model()->find(array('condition' => "user_id = " . Yii::app()->user->id))) {
           return Yii::app()->user->id;
       } else {
           return null;
       }
    }

}