<?php

/**
 * This is the model class for table "shippingline".
 *
 * The followings are the available columns in table 'shippingline':
 * @property integer $id
 * @property string $name
 * @property string $address1
 * @property string $address2
 * @property string $email
 * @property string $telephone1
 * @property string $telephone2
 */
class ShippingLine extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ShippingLine the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'shippingline';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
                        array('name','required'),
                        array('countryId', 'numerical', 'integerOnly' => true),
			array('name, address1, address2, address3, town, state', 'length', 'max'=>255),
			array('email', 'length', 'max'=>150),
			array('telephone1, telephone2, postalCode', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, address1, address2, email, telephone1, telephone2, address3, town, state, postalCode, countryId', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                     'countryRel' => array(self::BELONGS_TO, 'Country', 'countryId'), 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'address1' => 'Address',
			'address2' => 'Address2',
                        'address3' => 'Address3',
                        'town'=>'Town',
                        'state'=>'State',
                        'postalCode'=>'Postal Code',
			'email' => 'Email',
			'telephone1' => 'Telephone1',
			'telephone2' => 'Telephone2',
                        'countryId'=>'Country'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
                $criteria->compare('address3',$this->address3,true);
                $criteria->compare('town',$this->town,true);
                $criteria->compare('state',$this->state,true);
                 $criteria->compare('postalCode',$this->postalCode,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('telephone1',$this->telephone1,true);
		$criteria->compare('telephone2',$this->telephone2,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function getMainAddresses(){
            $address = '';
            if(trim($this->address1) != ''){
                $address .= $this->address1;
            }
            if(trim($this->address2) != ''){
                $address .= ', ' . $this->address2;
            }
            if(trim($this->address3) != ''){
                $address .= ', ' . $this->address3;
            }
            
            return $address;
        }
}