<?php

/**
 * This is the model class for table "sign_off_logs".
 *
 * The followings are the available columns in table 'sign_off_logs':
 * @property integer $id
 * @property integer $sign_off_id
 * @property string $model
 * @property integer $createdby
 * @property string $createddate
 */
class SignOffLog extends CActiveRecord {

    const TYPE_MASTER_PURCHASE_ORDER = 'MasterPurchaseOrder';
    //public $sign_off_terms;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return SignOffLog the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'sign_off_logs';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('sign_off_id, model_id, createdby', 'numerical', 'integerOnly' => true),
            array('model', 'length', 'max' => 100),
            array('createddate,sign_off_terms', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, sign_off_id, model, createdby, createddate, model_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'signoffterm' => array(self::BELONGS_TO, 'SignOffTerms', 'sign_off_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'sign_off_id' => 'Sign Off Code',
            'model' => 'Model',
            'createdby' => 'Created By',
            'createddate' => 'Created Date',
            'sign_off_terms' => 'Sign Off Term'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('sign_off_id', $this->sign_off_id);
        $criteria->compare('model', $this->model);
        $criteria->compare('model_id', $this->model_id);
        $criteria->compare('createdby', $this->createdby);
        $criteria->compare('createddate', $this->createddate, true);

        $pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function beforeSave() {
        $this->createddate = date("Y-m-d g:i", strtotime('now'));
        $this->createdby = Yii::app()->user->id;

        return parent::beforeSave();
    }

}