<?php

/**
 * This is the model class for table "sign_off_terms".
 *
 * The followings are the available columns in table 'sign_off_terms':
 * @property integer $id
 * @property string $sign_off_id
 * @property string $term
 * @property string $model
 * @property string $createddate
 * @property integer $createdby
 */
class SignOffTerms extends CActiveRecord
{
	/**
	 * predefined terms for special purpose - value of the constant should be same as sign_off_id value of the sign_off_terms table
	 */
	const BUILT_IN_TERM_SHIPPING_ADDRESS = 'SHIPPING ADDRESS [BUILT-IN-TERM]';
	const BUILT_IN_TERM_OFFICE_ADDRESS = 'OFFICE ADDRESS [BUILT-IN-TERM]';
	
	const SIGN_OFF_CATEGORIES_ARRAY = array('Quotation'=>'Quotation','SalesOrder'=>'Sales Order','PurchaseOrder'=>'Purchase Order','DeliveryDocket'=>'Delivery Docket','JobArtwork'=>'Artwork Job');


		/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SignOffTerms the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'sign_off_terms';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
                        array('sign_off_id,term,model', 'required'),
			array('createdby', 'numerical', 'integerOnly'=>true),
			array('sign_off_id', 'length', 'max'=>255),
			array('model', 'length', 'max'=>100),
			array('term, createddate, model', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, sign_off_id, term, model, createddate, createdby', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'sign_off_id' => 'Sign Off Code',
			'term' => 'Sign Off Term',
			'model' => 'Type',
			'createddate' => 'Createddate',
			'createdby' => 'Createdby',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('sign_off_id',$this->sign_off_id,true);
		$criteria->compare('term',$this->term,true);
		$criteria->compare('model',$this->model,true);
		$criteria->compare('createddate',$this->createddate,true);
		$criteria->compare('createdby',$this->createdby);

		$pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
	}
        
        public function beforeSave() {
        $this->createddate = date("Y-m-d g:i",  strtotime('now'));
        $this->createdby = Yii::app()->user->id;

        return parent::beforeSave();
    }
}