<?php

/**
 * This is the model class for table "status_log".
 *
 * The followings are the available columns in table 'status_log':
 * @property integer $id
 * @property string $tableName
 * @property integer $tableId
 * @property integer $statusId
 * @property string $statusDate
 * @property integer $changedBy
 */
class StatusLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return StatusLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'status_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tableId, statusId, changedBy', 'numerical', 'integerOnly'=>true),
			array('tableName', 'length', 'max'=>255),
			array('statusDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, tableName, tableId, statusId, statusDate, changedBy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'tableName' => 'Table Name',
			'tableId' => 'Table',
			'statusId' => 'Status',
			'statusDate' => 'Status Date',
			'changedBy' => 'Changed By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('tableName',$this->tableName,true);
		$criteria->compare('tableId',$this->tableId);
		$criteria->compare('statusId',$this->statusId);
		$criteria->compare('statusDate',$this->statusDate,true);
		$criteria->compare('changedBy',$this->changedBy);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public static function actionSave($tableName,$tableID, $statusID){
            $model = new StatusLog();
            $model->tableName = $tableName;
            $model->tableId = $tableID;
            $model->statusId = $statusID;
            $model->statusDate = date("Y-m-d H:i:s");
            $model->changedBy = Yii::app()->user->id;
            return $model->save();
        }
}