<?php

/**
 * This is the model class for table "status".
 *
 * The followings are the available columns in table 'status':
 * @property integer $id
 * @property string $name
 */
class Status extends CActiveRecord {

    const SYS_STATUS_NEW = 1;
    const SYS_STATUS_CONFIRMED = 2;
    const SYS_STATUS_CANCELLED = 3;
    const SYS_STATUS_PENDING_APPROVAL = 4;
    const SYS_STATUS_ORDER_COMPLETED = 39;
    const SYS_STATUS_JOB_IN_PROGRESS = 18;
    const SYS_STATUS_JOB_COMPLETED = 17;
    const SYS_STATUS_SUBJOB_DONE = 11;
    
    const SYS_STATUS_GOODS_RECEIVED = 9;
    const SYS_STATUS_PARTIALLY_GOODS_RECEIVED = 41;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Status the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'status';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name', 'length', 'max' => 255),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, name', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Status',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function getStatusName($status_id) {
        $status = Status::model()->findByPk($status_id);
        if (!empty($status))
            return $status->name;
        else
            return 'Not Defined';
    }

}
