<?php

/**
 * This is the model class for table "supplier_product_log".
 *
 * The followings are the available columns in table 'supplier_product_log':
 * @property integer $id
 * @property string $supplier_id
 * @property string $uploaded_product_count
 * @property string $uploaded_product_id_json
 * @property string $created_at
 * @property string $created_by
 */
class SupplierProductLog extends CActiveRecord
{
	const STATUS_UPLOADED = 1;
	const STATUS_DELETED = 2;


	public $supplierCodeSearch;
	public $supplierNameSearch;
	
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SupplierProductLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'supplier_product_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('status_id, supplier_id, uploaded_product_count, created_by','numerical', 'integerOnly' => true),			
			array('uploaded_product_id_json, created_at, supplierCodeSearch, supplierNameSearch', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, supplier_id, uploaded_product_count, uploaded_product_id_json, created_at, created_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'supplier' => array(self::BELONGS_TO, 'Supplier', 'supplier_id'), 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'supplier_id' => 'Supplier',
			'uploaded_product_count' => 'Upload Products',
			'uploaded_product_id_json' => 'Uploaded Product Id Json',
			'created_at' => 'Upload Date',
			'created_by' => 'Created By',
			'supplierCodeSearch' => 'Supplier Code',
			'supplierNameSearch' =>  'Range Name',
			'status_id' => 'Status'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
		$criteria->with = array('supplier');
		
		$criteria->compare('supplier.supsup_fref',$this->supplierCodeSearch,true);
		$criteria->compare('supplier.supnam',$this->supplierNameSearch,true);

		//$criteria->compare('id',$this->id);
		//$criteria->compare('supplier_id',$this->supplier_id,true);
		$criteria->compare('uploaded_product_count',$this->uploaded_product_count,true);
		//$criteria->compare('uploaded_product_id_json',$this->uploaded_product_id_json,true);
		//$criteria->compare('created_at',$this->created_at,true);
		//$criteria->compare('created_by',$this->created_by,true);

		$pageSize = (int) GlobalVars::get('RecordsViewPerPage');

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination' => array('pageSize' => $pageSize),
			'sort' => array(
				'defaultOrder' => 't.created_at DESC',
			)
		));
	}
	
	public function extractLogArrToAttributes($log)
	{
		
		
		$this->supplier_id = $log['supplier_id'];
		$this->uploaded_product_count = $log['uploaded_product_count'];
		$this->uploaded_product_id_json = $log['items']; // should be in json format
		$this->created_at = $log['created_at'];
		$this->created_by = Yii::app()->user->id;
		$this->status_id = self::STATUS_UPLOADED;
	}
	
	/**
	 * @return string status name
	 */
	public function getStatus()
	{
		switch ($this->status_id) {
			case 1: return 'UPLOADED';
			case 2: return 'DELETED';
				
		}
	}
}