<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class SystemOptions extends CFormModel {

    public $quoteToJob;
    public $showPageID;
    public $jobDueUrgentAuto;
    public $enbleXero;
    public $enableMyob;
    public $defaultImagePath;
    public $salesPersonSignatureOnQuotePDF;
    public $quoteLockSellPrice;
    public $soLockSellPrice;
    //Match quote acceptance values with follow-up status
    public $quoteAcceptanceLinkSent;
    public $quoteAcceptanceLinkAccept;
    public $quoteAcceptanceLinkDecline;
    //Match SO acceptance values with follow-up status
    public $soAcceptanceLinkSent;
    public $soAcceptanceLinkAccept;
    public $soAcceptanceLinkDecline;
    //Match Web store order acceptance values with follow-up status
    public $webstoreOrderAcceptanceLinkSent;
    public $webstoreOrderAcceptanceLinkAccept;
    public $webstoreOrderAcceptanceLinkDecline;
    
    public $ftpProductRemoteServerDIR;
    public $ftpProductRemoteServerFtpIP;
    public $ftpProductRemoteServerFtpUser;
    public $ftpProductRemoteServerFtpPassword;
    public $ftpLocalDirToSaveExcelFiles;
    
    public $maxWebServiceQuoteExecutePerOneRefresh;
    //PO option default settings
    public $show_product_cost;
    public $show_decoration;
    public $show_decoration_cost;
    public $show_customisation_details;
    public $show_notes;
    public $show_job_info;
    public $show_website_ordering_info;
    public $show_price_on_pdf;
    public $show_logo_setup;
    public $show_so_customisation;
    
    //GWS API related
    public $gwsApiRequestUrl;
    public $gwsApiUsername;
    public $gwsApiPassword;
    
    //PO system status map to followup status
    public $poFollowupStatusForCancel;
    public $poFollowupStatusForCompleted;
    
    //payment type - invoice related - master customer can override the default value
    public $payment_type_days;
    public $payment_type_id;

    public $logoImageUploadInstance;
    public $logoImage;

    public $defaultPdfLogoUploadInstance;
    public $defaultPdfLogoImage;

    //paypal payment gateway settings
    public $enablePaypalPayment;
    public $paypalClientId;
    public $paypalCurrency;
    

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            array(
                'quoteToJob, showPageID, jobDueUrgentAuto, enbleXero, enableMyob, salesPersonSignatureOnQuotePDF, quoteLockSellPrice, '
                . 'soLockSellPrice, quoteAcceptanceLinkSent, quoteAcceptanceLinkAccept, quoteAcceptanceLinkDecline, '
                . 'soAcceptanceLinkSent, soAcceptanceLinkAccept, soAcceptanceLinkDecline, '
                . 'webstoreOrderAcceptanceLinkSent, webstoreOrderAcceptanceLinkAccept, webstoreOrderAcceptanceLinkDecline, maxWebServiceQuoteExecutePerOneRefresh,'
                . 'show_product_cost, show_decoration, show_decoration_cost, show_customisation_details, show_notes, show_job_info, show_website_ordering_info, '
                . 'show_price_on_pdf, show_logo_setup, show_so_customisation, poFollowupStatusForCancel, poFollowupStatusForCompleted, payment_type_days, payment_type_id, enablePaypalPayment', 'numerical', 'integerOnly' => true),
                array('logoImage, logoImageUploadInstance, defaultPdfLogoImage, defaultPdfLogoUploadInstance, paypalClientId, paypalCurrency', 'default', 'value' => ''),
                array('logoImageUploadInstance, defaultPdfLogoUploadInstance', 'file', 'types'=>'jpg, gif, png', 'maxSize'=> 550000, 'allowEmpty'=>true ), // Max file size is 500KB
                array('defaultImagePath, ftpProductRemoteServerDIR, ftpProductRemoteServerFtpIP, ftpProductRemoteServerFtpUser, '
                . 'ftpProductRemoteServerFtpPassword, ftpLocalDirToSaveExcelFiles, gwsApiUsername, gwsApiPassword, gwsApiRequestUrl, logoImage, logoImageUploadInstance', 'safe')
        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'quoteToJob' => 'Convert Quote Direct to Job',
            'showPageID' => 'Show Page ID',
            'jobDueUrgentAuto' => 'Change Job Status URGENT Automatically',
            'enbleXero' => 'Enable Xero',
            'enableMyob' => 'Enable MYOB',
            'defaultImagePath' => 'Default Image Path',
            'salesPersonSignatureOnQuotePDF' => 'Salesperson\'s signature on quote PDF',
            'quoteLockSellPrice' => 'Lock Sell Price (Quote Cal Screen)',
            'soLockSellPrice' => 'Lock Sell Price (Sales Order Cal Screen)',
            'quoteAcceptanceLinkSent' => 'Quote Acceptace Link Sent',
            'quoteAcceptanceLinkAccept' => 'Quote Acceptace Link Accept',
            'quoteAcceptanceLinkDecline' => 'Quote Acceptace Link Decline',
            'soAcceptanceLinkSent' => 'SO Acceptace Link Sent',
            'soAcceptanceLinkAccept' => 'SO Acceptace Link Accept',
            'soAcceptanceLinkDecline' => 'SO Acceptace Link Decline',
            'webstoreOrderAcceptanceLinkSent' => 'Web Store Order Acceptace Link Sent',
            'webstoreOrderAcceptanceLinkAccept' => 'Web Store Order Acceptace Link Accept',
            'webstoreOrderAcceptanceLinkDecline' => 'Web Store Order Acceptace Link Decline',
            
            'ftpProductRemoteServerDIR' => 'Remote Server File DIRECTORY',
            'ftpProductRemoteServerFtpIP' => 'Remote Server IP',
            'ftpProductRemoteServerFtpUser' => 'Remote Server Username',
            'ftpProductRemoteServerFtpPassword' => 'Remote Server Password',
            'ftpLocalDirToSaveExcelFiles' => 'Local File Saving DIRECTORY',
            
            'maxWebServiceQuoteExecutePerOneRefresh' => 'Web Service Quotes Execute per One Refresh',
            
            'show_product_cost' => 'Show Product Cost',
            'show_decoration' => 'Show Decoration',
            'show_decoration_cost' => 'Show Decoration Cost',
            'show_customisation_details' => 'Show Customisation Details',
            'show_notes' => 'Show Notes',
            'show_job_info' => 'Show Job Info',
            'show_website_ordering_info' => 'Show Website Ordering Info',
            'show_price_on_pdf' => 'Show Price on PDF',
            'show_logo_setup' => 'Show Logo Setup',
            'show_so_customisation' => 'Show SO Customisation',
            
            'gwsApiRequestUrl' => 'Request URL',
            'gwsApiUsername' => 'Username',
            'gwsApiPassword' => 'Password',
            
            'poFollowupStatusForCancel' => 'PO follow-Up status for cancel',
            'poFollowupStatusForCompleted' => 'PO follow-Up status for completed',
            
            'payment_type_id' => 'Payment Term Type',
            'payment_type_days' => 'Payment Days',
            'logoImageUploadInstance' => 'Logo Image [max-size:550KB] [max-width:250px | max-height:150px]',
            'logoImage' => 'logoImage',
            'defaultPdfLogoUploadInstance' => 'Default PDF Logo Image [max-size:550KB]',
            'defaultPdfLogoImage' => 'PDF Logo Image',
            'enablePaypalPayment' => 'Enable paypal Payment',
            'paypalClientId' => 'Paypal Client ID',
            'paypalCurrency' => 'Currency'
            
            
            
        );
    }

    public static function getOptions() {
        $model = new SystemOptions();
        $file = fopen(__DIR__ . "/../filemodels/systemoptions.csv", "r");
        $propertyArr = array();
        while (!feof($file)) {
            $line = fgets($file);
            $pairs = explode('=>', $line);
            $propertyArr[$pairs[0]] = $pairs[1];
        }
        fclose($file);

        $intCastFields = array(  
            'quoteToJob',          
            'quoteAcceptanceLinkSent',
            'quoteAcceptanceLinkAccept',
            'quoteAcceptanceLinkDecline',
            'soAcceptanceLinkSent',
            'soAcceptanceLinkAccept',
            'soAcceptanceLinkDecline',
            'webstoreOrderAcceptanceLinkSent',
            'webstoreOrderAcceptanceLinkAccept',
            'webstoreOrderAcceptanceLinkDecline',
            'maxWebServiceQuoteExecutePerOneRefresh',
            'poFollowupStatusForCancel',
            'poFollowupStatusForCompleted',
            'payment_type_id',
            'payment_type_days',
            'enablePaypalPayment'
            
            
        );
        foreach ($model->attributeLabels() as $attr => $lbl) {

            if (in_array($attr, $intCastFields)) {
                $model->$attr = intval($propertyArr[$attr]);
            } else {
                $model->$attr = trim($propertyArr[$attr]);
            }
        }


        return $model;
    }

}
