<?php

/**
 * This is the model class for table "template_text".
 *
 * The followings are the available columns in table 'template_text':
 * @property integer $id
 * @property integer $template_id
 * @property string $name
 * @property string $contents
 * @property string $created_at
 * @property integer $created_by
 */
class TemplateText extends CActiveRecord
{
    const TEMPLATE_QUOTE_EMAIL = 1;
    const TEMPLATE_SALES_ORDER_EMAIL = 2;
    const TEMPLATE_WEBSTORE_ORDER_EMAIL = 3;
    const TEMPLATE_FOLLOW_UP = 4;

    /**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TemplateText the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'template_text';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('template_id, contents, created_at, created_by, name', 'required'),
                        array('template_id, name','unique'),
                        array('name', 'length', 'max' => 50),
			array('template_id, created_by', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, template_id, contents, created_at, created_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'template_id' => 'Template',
			'contents' => 'Contents',
			'created_at' => 'Created At',
			'created_by' => 'Created By',
		);
	}
        
        public function templateToString() {
            switch ($this->template_id) {
                case self::TEMPLATE_QUOTE_EMAIL: return 'QUOTE_EMAIL';
                case self::TEMPLATE_SALES_ORDER_EMAIL: return 'SALES_ORDER_EMAIL';
                     case self::TEMPLATE_WEBSTORE_ORDER_EMAIL: return 'WEB_STORE_ORDER_EMAIL';
                         case self::TEMPLATE_FOLLOW_UP: return 'FOLLOW_UP';
            }
        }

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('template_id',$this->template_id);
		$criteria->compare('contents',$this->contents,true);
		$criteria->compare('created_at',$this->created_at,true);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        
        public static function getTempleteText(int $template_id) {
            $template = TemplateText::model()->find("template_id = $template_id");
            return $template ? $template->contents: '';
        }
        
        
        
        
        
}