<?php

/**
 * This is the model class for table "tracking".
 *
 * The followings are the available columns in table 'tracking':
 * @property integer $id
 * @property string $username
 * @property string $title
 * @property string $accesstime
 * @property string $accessip
 * @property string $action
 * @property string $server_json
 */
class Tracking extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Tracking the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'tracking';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, title, accesstime, accessip, action', 'required'),
            array('username', 'length', 'max' => 255),
            array('title', 'length', 'max' => 50),
            array('accessip', 'length', 'max' => 30),
            array('action', 'length', 'max' => 100),
            array('server_json'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, username, title, accesstime, accessip, action', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'username' => 'Username',
            'title' => 'Title',
            'accesstime' => 'Accesstime',
            'accessip' => 'Accessip',
            'action' => 'Action',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('username', $this->username, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('accesstime', $this->accesstime, true);
        $criteria->compare('accessip', $this->accessip, true);
        $criteria->compare('action', $this->action, true);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

}