<?php

/**
 * This is the model class for table "user".
 *
 * The followings are the available columns in table 'user':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $title
 * @property string $email
 */
class User extends CActiveRecord {

    // Old password for password change
    public $old_password = '';
    // New password for password change
    public $new_password = '';
    public $cur_password = '';
    // Confirm password for password change
    public $confirm_password = '';
    public $is_activated;

    /**
     * Returns the static model of the specified AR class.
     * @return User the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'User';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, password, branch_id', 'required', 'on' => 'create'),
            array('password', 'EPasswordStrength', 'min' => 7, 'allowEmpty' => true, 'on' => 'create, update'),
            array('username', 'required', 'on' => 'update'),
            array('branch_id, cussno', 'numerical', 'integerOnly' => true),
            array('username, password, title, email', 'length', 'max' => 50),
            array('email', 'email'),
            array('username', 'unique', 'message' => 'User {value} already exists!'),
            array('old_password', 'validatePasswords', 'on' => 'my_account'),
            array('new_password', 'EPasswordStrength', 'min' => 7, 'allowEmpty' => true, 'on' => 'my_account'),
            array('old_password, new_password, confirm_password, is_activated', 'safe'),
            array('is_activated', 'numerical', 'integerOnly' => true),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, username, password, title, email, dealerid, branch_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'username' => 'Username',
            'password' => 'Password',
            'branch_id' => 'Branch',
            'title' => 'Title',
            'email' => 'Email',
            'old_password' => 'Old Password',
            'new_password' => 'New Password',
            'confirm_password' => 'Confirm Password',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('username', $this->username, true);
        $criteria->compare('password', $this->password, true);
        $criteria->compare('branch_id', $this->branch_id, true);
        $criteria->compare('title', $this->title, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('dealerid', $this->dealerid, true);




        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function validatePasswords() {
        if ('' == $this->old_password && '' != $this->new_password) {
            $this->addError('old_password', 'Old Password is required');
        } elseif ('' != $this->old_password && md5($this->old_password) != $this->cur_password) {
            $this->addError('old_password', 'Old Password mismatch');
        } elseif ('' != $this->old_password && '' == $this->new_password) {
            $this->addError('new_password', 'New Password is required');
        } elseif ($this->new_password != $this->confirm_password) {
            $this->addError('confirm_password', 'Confirm Password mismatch');
        }
    }

    public function encryptPassword($password = '') {
        if ('' == $password)
            $password = $this->password;

        return md5($password);
    }

    public static function generateRandomPassword() {
        //Initialize the random password
        $password = '';

        //Initialize a random desired length
        $desired_length = rand(3, 3);

        for ($length = 0; $length < $desired_length; $length++) {
            //Append a random ASCII character (including symbols)
            $password .= chr(rand(65, 90));
            $password .= chr(rand(49, 57));
        }

        $checkpassword = md5($password);
        $model = User::model()->find(array('condition' => "password = '{$checkpassword}'"));

        if (!empty($model))
            self::generateRandomPassword();
        else
            return $password;
    }
    
    public  static function isAdmin() {
        
        if (in_array(strtolower(Yii::app()->user->title) , array('administrator', 'superadmin'))) {
            return true;
        }
        
        return false;
    }

}