<?php

/**
 * This is the model class for table "ws_data".
 *
 * The followings are the available columns in table 'ws_data':
 * @property integer $ws_id
 * @property string $ws_quoteno
 * @property string $ws_clientid
 * @property string $ws_data
 * @property string $ws_user
 * @property string $ws_type
 * @property string $ws_compyn
 * @property string $ws_updflg
 * @property string $ws_showflg
 * @property string $ws_updflgsup
 * @property string $ws_updflgprc
 * @property string $ws_updflgmdec
 * @property integer $ws_qthsno
 * @property string $ws_date
 * @property string $ws_time
 */
class WebService extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return WebService the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'ws_data';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
// NOTE: you should only define rules for those attributes that
// will receive user inputs.
        return array(
            array('ws_quoteno, ws_data, ws_type, ws_compyn, ws_updflg, ws_showflg, ws_updflgsup, ws_updflgprc, ws_updflgmdec, ws_qthsno, ws_date, ws_time', 'required'),
            array('ws_qthsno, is_read', 'numerical', 'integerOnly' => true),
            array('ws_quoteno, ws_clientid, ws_user', 'length', 'max' => 255),
            array('ws_type', 'length', 'max' => 10),
            array('ws_compyn, ws_updflg, ws_showflg, ws_updflgsup, ws_updflgprc, ws_updflgmdec', 'length', 'max' => 1),
            // The following rule is used by search().
// Please remove those attributes that should not be searched.
            array('ws_id, ws_quoteno, ws_clientid, ws_data, ws_user, ws_type, ws_compyn, ws_updflg, ws_showflg, ws_updflgsup, ws_updflgprc, ws_updflgmdec, ws_qthsno, ws_date, ws_time', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
// NOTE: you may need to adjust the relation name and the related
// class name for the relations automatically generated below.
        return array();
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'ws_id' => 'Ws',
            'ws_quoteno' => 'Web Service Quotation Number',
            'ws_clientid' => 'Ws Clientid',
            'ws_data' => 'Ws Data',
            'ws_user' => 'Ws User',
            'ws_type' => 'Ws Type',
            'ws_compyn' => 'Ws Compyn',
            'ws_updflg' => 'Ws Updflg',
            'ws_showflg' => 'Ws Showflg',
            'ws_updflgsup' => 'Ws Updflgsup',
            'ws_updflgprc' => 'Ws Updflgprc',
            'ws_updflgmdec' => 'Ws Updflgmdec',
            'ws_qthsno' => 'Ws Qthsno',
            'ws_date' => 'Ws Date',
            'ws_time' => 'Ws Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
// Warning: Please modify the following code to remove attributes that
// should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('ws_id', $this->ws_id);
        $criteria->compare('ws_quoteno', $this->ws_quoteno, true);
        $criteria->compare('ws_clientid', $this->ws_clientid, true);
        $criteria->compare('ws_data', $this->ws_data, true);
        $criteria->compare('ws_user', $this->ws_user, true);
        $criteria->compare('ws_type', $this->ws_type, true);
        $criteria->compare('ws_compyn', $this->ws_compyn, true);
        $criteria->compare('ws_updflg', $this->ws_updflg, true);
        $criteria->compare('ws_showflg', $this->ws_showflg, true);
        $criteria->compare('ws_updflgsup', $this->ws_updflgsup, true);
        $criteria->compare('ws_updflgprc', $this->ws_updflgprc, true);
        $criteria->compare('ws_updflgmdec', $this->ws_updflgmdec, true);
        $criteria->compare('ws_qthsno', $this->ws_qthsno);
        $criteria->compare('ws_date', $this->ws_date, true);
        $criteria->compare('ws_time', $this->ws_time, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    private $_quatation = null;
    private $_lastProduct = null;

    public function generateQuatationViaWSData($quatationno) {

        $quatationmodel = Quatation::model()->find(array("condition" => "quoteno = '{$quatationno}' "));

        if (!empty($quatationmodel)) {
            $this->_quatation = $quatationmodel;
        }

//get all records related to this quatation number
        $recordIds = Yii::app()->db->createCommand("select ws_id from ws_data where ws_quoteno = '{$quatationno}' order by ws_id asc")->queryAll();


        $lastproductid = null;
        foreach ($recordIds as $id) {

            $wsData = Yii::app()->db->createCommand("select ws_data,ws_clientid,ws_date,ws_time,ws_user from ws_data where ws_id = '{$id['ws_id']}'")->queryRow();

//create quatation only if not yet created
            if ($this->_quatation == null)
                $this->_saveQuatation($id['ws_id'], $wsData['ws_clientid'], $quatationno, $wsData['ws_date'], $wsData['ws_time'], $wsData['ws_user']);

            $dataArr = explode('#', $wsData['ws_data']);

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'P') {
                $lastproductid = $dataArr[0];
                $this->_saveQuatationWithProduct($id['ws_id'], $dataArr);
            }

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'D') {

                $this->_saveQuatationWithDecoration($id['ws_id'], $dataArr);
            }


            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'C') {

                $this->_updateQuatationWithComments($dataArr[3]);
            }

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'E') {
                $extras = array('quotename' => $dataArr[0], 'dueDate' => $dataArr[1]);
                $this->_updateQuatationWithExtras($extras);
            }
        }
    }

    private function _saveQuatation($wsdataid, $cusref, $quatationno, $wsdate, $wstime, $wsuser) {
        if ($this->_quatation == null) {
            $this->_quatation = new Quatation;

            $this->_quatation->ws_id = $wsdataid;
            $this->_quatation->quoteno = $quatationno;
            $this->_quatation->cus_fref = $cusref;

            $this->_quatation->quotecreatedby = Yii::app()->user->id;
            $this->_quatation->quotecreated = date("Y-m-d g:i"); // current date & time
            $this->_quatation->ws_date = date('Y-m-d H:i:s', strtotime("$wsdate $wstime"));
            $this->_quatation->ws_user = $wsuser;
            $this->_quatation->ws_user_id = $this->_getWSUserID($wsuser);
            $this->_quatation->status = 1; //New

            if ($this->_quatation->save(false)) {
                SalesLog::createSalesLog($this->_quatation->id, null, $this->_quatation->quoteno, 'Quotation', 'Processed quotation from the web service', 0, 0, 1);
            }
        }
    }

    private function _getWSUserID($wsuser) {
        if (!empty($wsuser)) {
            $salesperson = SalesPerson::model()->find(array('condition' => "name = '{$wsuser}'"));
            if (!empty($salesperson)) {
                return $salesperson->id;
            } else {
                $salesperson = new SalesPerson();
                $salesperson->name = $wsuser;
                $salesperson->is_active = 1;

                if ($salesperson->save(false)) {
                    return $salesperson->id;
                } else {
                    return 0;
                }
            }
        }

        return 0;
    }

    private function _saveQuatationWithProduct($ws_id, $productArr) {

        /*
         * Typical product string
         * 
         * P3200_BIZ#50#16.50#Mens Elite Polo#P#BIZ#N/A#0.00#1.50#EMBG,SCRG,DIGTRANS#SCRG-1C1P-CP,SCRG-2C1P-CP,SCRG-3C1P-CP
         * #1=10=16.50,2=25=16.50,3=50=16.50,4=100=16.50,5=250=16.00,6=500=15.35,7=1000=15.35,8=2500=15.35
         * #http://www.mypromosource.com.au/vcquotesystem/resources/product_images/BIZ/P3200_Worn.jpg#Yes
         * #Mens Elite Polo. Sizes: S - 3XL, 5XL | Fabric: BIZ COOL 100% Breathable Polyester Textured mini self-check patterned fabric 170 GSM UPF rating - Excellent | Features: Contrast self fabric trim on placket and sleeve hem Contrast tipping on knitted collar Side splits Loose pocket included. Colours: Navy/White 
         * #1=1.50=N/A,2=1.50=N/A,3=1.50=N/A,4=1.50=N/A,5=1.50=N/A,6=1.50=N/A,7=1.50=N/A,8=1.50=N/A#0#1.1#no#1#Biz Collection#34.73#38.20#1736.50#1910.00#10.00#0.00#0.00#0.00
         * 
         * zero based index array
         * 
         * 0  = product code
         * 1  = quantity
         * 2  = unit price
         * 3  = name
         * 4  = line type (in this case it is "P" which represents product line flag)
         * 5  = suppler code
         * 6  = 
         * 7 =
         * 8  = supplier margin
         * 9  = decoration main code
         * 10 = 
         * 11 =
         * 12 = product image (url)
         * 13 = 
         * 14 = description for product
         * 15 = 
         * 16 = product frieght (devided value by product qty)
         * 17 = product GST
         * 18 = custom product flag
         * 19 = 
         * 20 = supplier name
         * 21 = selling unit price excluding GST
         * 22 = selling unit price including GST
         * 23 = total selling price excluding GST
         * 24 = total selling price including GST
         * 
         * new lines added by Thranga from front-end on 2018-10-08
         * 
         * 25 = freight mark-up percentage
         * 26 = fright total cost
         * 27 = fright unit cost ( total cost devided by qty )
         * 28 = freight unit cost price including mark-up
         * 
         * 100467_TRDZ#250#0.67#Carpenters Pencil#P#TRENDZ#N/A#0.00#1.50#PRINTINC#pntin#1=250=0.67,2=500=0.59,3=1000=0.55,4=2500=0.51,5=5000=0.50,6=0=0.00,7=0=0.00,8=0=0.0
         */

        if ($this->_quatation != null && sizeof($productArr) >= 24) {


            $this->_quatation->systemfreight = floatval($productArr[19]); //System freight value

            $this->_lastProduct = new QuatationDetails;
            $this->_lastProduct->quoteid = $this->_quatation->id;
            $this->_lastProduct->ws_id = $ws_id;
            $this->_lastProduct->productsku = $productArr[0];
            $this->_lastProduct->qty = intval($productArr[1]);
            $this->_lastProduct->productexunitprice = floatval($productArr[2]);
            $this->_lastProduct->productname = $productArr[3];
            $this->_lastProduct->sup_fref = $productArr[5];
            $this->_lastProduct->supmarg = floatval($productArr[8]);
            $this->_lastProduct->customerdicspcn = floatval($productArr[7]);
            $this->_lastProduct->productimg = $productArr[12];
            $this->_lastProduct->iscustomprodct = (strtolower($productArr[18]) == 'yes' ? 1 : 0);
            $this->_lastProduct->productdescription = $productArr[14];
            $this->_lastProduct->prodctfrieght = isset($productArr[26]) ? floatval($productArr[26]) : 0; //floatval($productArr[16]);
            $this->_lastProduct->productvat = floatval($productArr[17]);
            $this->_lastProduct->supname = $productArr[20];
            $this->_lastProduct->sellunitprice_ex_vat = floatval($productArr[21]);
            $this->_lastProduct->sellunitprice_in_vat = floatval($productArr[22]);
            $this->_lastProduct->selltot_ex_vat = floatval($productArr[23]);
            $this->_lastProduct->selltot_in_vat = floatval($productArr[24]);

//convert precentage to rate
            $usdUnitMarkupRate = isset($productArr[25]) ? ((floatval($productArr[25]) + 100) / 100) : 0;
            $this->_lastProduct->productFrieghtMarkUpRate = $usdUnitMarkupRate;
            $usdUnitFreightCost = isset($productArr[27]) ? floatval($productArr[27]) : 0;
            $this->_lastProduct->productFrieghtUnitCost = $usdUnitFreightCost;
            $this->_lastProduct->productFrieghtUnitCostWithMarkup = isset($productArr[28]) ? floatval($productArr[28]) : 0;

            if ($this->_lastProduct->save(false)) {
                $this->_quatation->save(false);

                $this->_updateProduct($productArr[0], $productArr[14], $productArr[12]);
                $productLine = $this->_updateProductLine($productArr[0], $productArr[3], $productArr[14], $productArr[12], $productArr[5], floatval($productArr[2]), $productArr[18], floatval($productArr[8]), $usdUnitFreightCost, $usdUnitMarkupRate);

                //saving product iamge to local
                if ($productLine) {
                    $this->_lastProduct->productimg = $productLine->pdlimage1;
                    $this->_lastProduct->prodImgUri = $productLine->prodImgUri;
                    //update overall prices of the quote;
                    $this->_lastProduct->quotePriceUpdate();
                    $this->_lastProduct->save(false);
                }
            }
        }
    }

    private function _saveQuatationWithDecoration($ws_id, $decorationArr) {
        /*

         * Typical decoration string
         * SCRG-3C1P-CP#50#3.35#Screen Print to Garment: 3 Colour, 1 Position#D#N/A#225.00#0#1.50#SCRG#N/A
         * #1=25=5.00,2=50=3.35,3=100=2.50,4=250=1.72,5=500=1.29,6=1000=1.20,7=2500=0.98,8=5000=0.92#N/A#Yes
         * #N/A#1=1.50=N/A,2=1.50=N/A,3=1.50=N/A,4=1.50=N/A,5=1.50=N/A,6=1.50=N/A,7=1.50=N/A,8=1.50=N/A#N/A#1.1#no#1#N/A#N/A#N/A#N/A#N/A#10.00#225.00#4.50#4.95
         * 
         * zero based index array
         * 
         * 0  = decoration code
         * 1  = quantity
         * 2  = unit price
         * 3  = 
         * 4  =
         * 5  = supplier
         * 6  = logo setup charge
         * 7  = customer discount percentage
         * 8  = decoration mark-up
         * 9  = main decoration id
         * 10 = 
         * 11
         * 12
         * 13
         * 14
         * 15
         * 16 = freight value
         * 17 = GST value
         * 18 =
         * 19 = custom decoration flag
         * 
         * 
         * new lines added by Thranga from front-end on 2018-10-08
         * 
         * 25 = logo set-up mark-up percentage
         * 26 = logo set-up total cost
         * 27 = ogo set-up unit cost ( total cost devided by qty )
         * 28 = ogo set-up unit cost price including mark-up
         *          */
        if ($this->_quatation != null && $this->_lastProduct != null) {

            $decoration = new QuoteProductDecoration;

            $decoration->ws_id = $ws_id;
            $decoration->quoteid = $this->_quatation->id;
            $decoration->productsku = $this->_lastProduct->productsku;
            $decoration->quataiondetailsid = $this->_lastProduct->id;
            $decoration->decprtnam = $decorationArr[0];
            $decoration->decorationdescription = $decorationArr[3];
            $decoration->decorationqty = intval($decorationArr[1]);
            $decoration->decorationunitval = floatval($decorationArr[2]);
            $decoration->logosetupcharge = floatval($decorationArr[6]);
            $decoration->customerdicspcn = floatval($decorationArr[7]);
            $decoration->maindecorationid = $decorationArr[9];
            $decoration->decorationfreightval = floatval($decorationArr[16]);
            $decoration->decorationvat = floatval($decorationArr[17]);
            $decoration->supref = $decorationArr[5];

            $decoration->supmarg = $decorationArr[8];

            $logoSetupUnitMarkupRate = isset($decorationArr[25]) ? $this->percentageToRate($decorationArr[25]) : 0;
            $decoration->logoSetupMarkupRate = $logoSetupUnitMarkupRate;
            $decoration->logoSetupUnitCost = isset($decorationArr[27]) ? floatval($decorationArr[27]) : 0;
            $decoration->logoSetupUnitCostWithMarkup = isset($decorationArr[28]) ? floatval($decorationArr[28]) : 0;


            if ($decoration->save(false)) {
                $this->_updateDecoration($decorationArr[0], $decorationArr[19], $decorationArr[3], $decorationArr[6], $decorationArr[5], $decorationArr[2], $decorationArr[9], $logoSetupUnitMarkupRate);
            }
        }
    }

    /**
     * this function will return the appropriate rate for a given percentage
     * i.e. if you provide 10 (%) this will return 1.11, if you provide 9 (%) this will return 1.1
     * @param float $margin - percentage value to be converted into rate 
     * @return float percentage
     */
    protected function percentageToRate($margin) {


        if (!$margin || $margin === '0') {
            return 0;
        }

        $margin_value = intval($margin);
        $retail_lavel = 100;
        $buffer_value = $retail_lavel - $margin_value;
        $markup_percentage = (($retail_lavel / $buffer_value) - 1);
        $markup_value = round(((100 + $markup_percentage * 100) / 100), 2);


        if (!is_numeric($markup_value)) {
            return 0;
        }

        if (!is_finite($markup_value)) {
            return 0;
        }

        return $markup_value;
    }

    private function _updateQuatationWithComments($comment) {
        if ($this->_quatation != null && $this->_quatation->id > 0) {
            $this->_quatation->quotecomments = $comment;
            $this->_quatation->save(false);
        }
    }

    private function _updateQuatationWithExtras($extra) {
        if ($this->_quatation != null && $this->_quatation->id > 0) {
            $this->_quatation->quotename = $extra['quotename'];
            if (!$extra['dueDate']) {
                $dueInXDays = GlobalVars::get(GlobalVars::DUE_IN_X_DAYS);
                $this->_quatation->dueDate = date('Y-m-d', strtotime("+{$dueInXDays} days"));
            } else {
                $this->_quatation->dueDate = date('Y-m-d', strtotime($extra['dueDate']));
            }
            $this->_quatation->save(false);
        }
    }

    private function _updateProduct($prdprd, $prddes, $prdimage1) {
        $product = Product::model()->find(array('condition' => 'prdprd=:productKey', 'params' => array(':productKey' => $prdprd)));
        if (!empty($product)) {
            $product->prddes = $prddes;
            $product->prdimage1 = $prdimage1;
            $product->prdameddt = date('Y-m-d');
            $product->prdametime = date('H:i:s');
            $product->save(false);
        } else {
            $product = new Product();
            $product->prdprd = $prdprd;
            $product->prdshodes = $prdprd;
            $product->prddes = $prddes;
            $product->prdimage1 = $prdimage1;

            $product->prdflag = 1;
            $product->prducdnew = Yii::app()->user->username;
            $product->prdentddt = date('Y-m-d');
            $product->prdenttime = date('H:i:s');

            $product->prdameddt = date('Y-m-d');
            $product->prdametime = date('H:i:s');

            $product->save(false);
        }
    }

    private function _updateProductLine($pdlpdl, $pdlprdline, $pdldes, $pdlimage1, $supfref, $pdluntprice, $pdlcustomyn, $suppmrg, $usdUnitFreightCost, $usdMarkupRate) {


        $productLine = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $pdlpdl)));
        $supplier = Supplier::model()->find(array('condition' => 'supsup_fref=:supRef', 'params' => array(':supRef' => $supfref)));
        if ($productLine) {
            $productLine->pdlprdline = $pdlprdline;
            $productLine->pdldes = $pdldes;
            $productLine->pdlimage1 = $pdlimage1;



            $productLine->pdlsupsno = !empty($supplier) ? intval($supplier->supsno) : 0;
            $productLine->pdluntprice = floatval($pdluntprice);

            if ($usdUnitFreightCost) {
                $productLine->usdUnitFreightCost = $usdUnitFreightCost;
            }
            if ($usdMarkupRate > 1) {
                $productLine->usdUnitFreightMarkupRate = $usdMarkupRate;
            }


            $productLine->pdlsupmargin = floatval($suppmrg);
            $productLine->pdlucdnew = Yii::app()->user->username;
            $productLine->pdlameddt = date('Y-m-d');
            $productLine->pdlametime = date('H:i:s');

            if ($productLine->save(false)) {
                $productLine->saveImageContent();
                SalesLog::createSalesLog($this->_quatation->id, null, $this->_quatation->quoteno, 'Quotation', "Product details are updated for {$pdlprdline}({$pdlpdl})", 1, 0, 1);
                return $productLine;
            }
        } else {

//Fields that not define here are set in the model
            $productLine = new ProductLine();

            $productLine->pdlprdline = $pdlprdline;

            $productLine->pdlpdl = $pdlpdl;
            $productLine->pdlcustomyn = (strtolower($pdlcustomyn) == 'yes' ? 'Y' : 'N');
            $productLine->pdldes = $pdldes;
            $productLine->pdlimage1 = $pdlimage1;
            $productLine->pdlsupsno = !empty($supplier) ? intval($supplier->supsno) : 0;
            $productLine->pdluntprice = floatval($pdluntprice);

            if ($usdUnitFreightCost) {
                $productLine->usdUnitFreightCost = $usdUnitFreightCost;
            }
            if ($usdMarkupRate > 1) {
                $productLine->usdUnitFreightMarkupRate = $usdMarkupRate;
            }

            $productLine->pdlsupmargin = floatval($suppmrg);
            $productLine->pdlucdnew = Yii::app()->user->username;
            $productLine->pdlentddt = date('Y-m-d');
            $productLine->pdlenttime = date('H:i:s');
            $productLine->pdlucdame = Yii::app()->user->username;
            $productLine->pdlameddt = date('Y-m-d');
            $productLine->pdlametime = date('H:i:s');

            if ($productLine->save(false)) {
                $productLine->saveImageContent();
                SalesLog::createSalesLog($this->_quatation->id, null, $this->_quatation->quoteno, 'Quotation', "New product received as {$pdlprdline}({$pdlpdl})", 1, 0, 1);

                return $productLine;
            }
        }
    }

    private function _updateDecoration($decprtnam, $deccustomyn, $decnam, $logosetupchrg, $supref, $decuntprice, $mainDecID, $logoSetupUnitMarkupRate) {

        $supplier = Supplier::model()->find("supsup_fref = '$supref'");
        if (strtolower($deccustomyn) != 'yes' && $decprtnam != 'custom_decoration') {
            $decoration = Decoration::model()->find(array('condition' => 'decprtnam=:decorationKey', 'params' => array(':decorationKey' => $decprtnam)));

            if (!empty($decoration)) {
                $decoration->deccustomyn = (strtolower($deccustomyn) == 'yes' ? 'Y' : 'N');
                $decoration->decnam = $decnam;
                $decoration->declogo_setup_charges = doubleval($logosetupchrg);

                if ($logoSetupUnitMarkupRate > 1) {
                    $decoration->logoSetupUnitMarkupRate = $logoSetupUnitMarkupRate;
                }

                $decoration->decsupsno = ($supplier ? $supplier->supsno : null);
                $decoration->decuntprice = doubleval($decuntprice);
                $decoration->decucdnew = Yii::app()->user->username;
                $decoration->decameddt = date('Y-m-d');
                $decoration->decametime = date('H:i:s');

                if ($decoration->save(false)) {
                    SalesLog::createSalesLog($this->_quatation->id, null, $this->_quatation->quoteno, 'Quotation', "Decoration details are updated for {$decprtnam}({$decnam})", 1, 0, 1);
                }
            } else {

                $decoration = new Decoration();
                $decoration->decprtnam = $decprtnam;
                $decoration->deccustomyn = (strtolower($deccustomyn) == 'yes' ? 'Y' : 'N');
                $decoration->decnam = $decnam;
                $decoration->declogo_setup_charges = doubleval($logosetupchrg);

                if ($logoSetupUnitMarkupRate > 1) {
                    $decoration->logoSetupUnitMarkupRate = $logoSetupUnitMarkupRate;
                }


                $maindecoration = Decoration::model()->find(array('condition' => 'decprtnam=:decorationKey and  decis_main_type=:isMainType',
                    'params' => array(':decorationKey' => $mainDecID, ':isMainType' => 'Y')));

                if (empty($maindecoration)) {
                    $maindecoration = $this->_createMainDecoration($mainDecID, $deccustomyn);
                }

                if (!empty($maindecoration))
                    $decoration->decmaintypsno = intval($maindecoration->decsno);



                $decoration->decis_main_type = 'N';
                $decoration->decis_shown_to_clients = 1;
                $decoration->decflag = 1;
                $decoration->decsupsno = ($supplier ? $supplier->supsno : null);
                $decoration->decuntprice = doubleval($decuntprice);
                $decoration->decucdnew = Yii::app()->user->username;
                $decoration->decentddt = date('Y-m-d');
                $decoration->decenttime = date('H:i:s');
                $decoration->decucdame = Yii::app()->user->username;
                $decoration->decameddt = date('Y-m-d');
                $decoration->decametime = date('H:i:s');

                if ($decoration->save(false)) {
                    SalesLog::createSalesLog($this->_quatation->id, null, $this->_quatation->quoteno, 'Quotation', "New decoration is received as {$decprtnam}({$decnam})", 1, 0, 1);
                }
            }
        }
    }

    private function _createMainDecoration($mainDecID, $deccustomyn) {
        $maindecoration = new Decoration();
        $maindecoration->decprtnam = $mainDecID;
        $maindecoration->deccustomyn = strtolower($deccustomyn) == 'yes' ? 'Y' : 'N';
        $maindecoration->decnam = $mainDecID;
//$maindecoration->declogo_setup_charges = 0;
//$maindecoration->decmaintypsno = 0;
        $maindecoration->decis_main_type = 'Y';
//$maindecoration->decweight_4_sorting = 0;
//$maindecoration->decpriority = 0;
        $maindecoration->decis_shown_to_clients = 1;
        $maindecoration->decflag = 1;
        $maindecoration->decucdnew = Yii::app()->user->username;
        $maindecoration->decentddt = date('Y-m-d');
        $maindecoration->decenttime = date('H:i:s');
        $maindecoration->decameddt = date('Y-m-d');
        $maindecoration->decametime = date('H:i:s');

        if ($maindecoration->save(false)) {
            SalesLog::createSalesLog($this->_quatation->id, null, $this->_quatation->quoteno, 'Quotation', "New main decoration ({$maindecoration->decnam}) is created", 0, 0, 1);
        }

        return $maindecoration;
//$maindecoration->decsupsno = 0;
    }

    /**
     * @param WebServiceQuoteFinder $webServiceQuoteFinder WebServiceQuoteFinder or sub class 
     * @return array of  WebService
     */
    public static function findQuotes($webServiceQuoteFinder) {
        if (!$webServiceQuoteFinder instanceof WebServiceQuoteFinder) {
            throw new InvalidArgumentException('Expected WebServiceQuoteFinder type!');
}

        return $webServiceQuoteFinder->findAll();
    }

    /**
     * convert particular web service model data into a JSON string
     * @return string JSON
     */
    public function toArray() {

        //Get all records related to given timestamp group
        $recordIds = Yii::app()->db->createCommand("SELECT ws_id FROM ws_data WHERE ws_date = '{$this->ws_date}' AND ws_time = '{$this->ws_time}' ORDER BY ws_id")->queryAll();

        $webserviceQuoteArr = array();
        $productRowID = 0;
        foreach ($recordIds as $id) {

            $wsData = Yii::app()->db->createCommand("SELECT ws_id, ws_quoteno, ws_data, ws_clientid, ws_date, ws_time, ws_user FROM ws_data WHERE ws_id = '{$id['ws_id']}'")->queryRow();


            $dataArr = explode('#', $wsData['ws_data']);


            $webserviceQuoteArr['QuotationNumber'] = $wsData['ws_quoteno'];
            $webserviceQuoteArr['Date'] = date('Y-m-d H:i:s', strtotime("{$wsData['ws_date']} {$wsData['ws_time']}"));
            $webserviceQuoteArr['Customer'] = array(
                'Reference' => $wsData['ws_clientid'],
            );

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'E') {

                $webserviceQuoteArr['QuotationName'] = $dataArr[0];
                $webserviceQuoteArr['DueDate'] = $dataArr[1];

                $webserviceQuoteArr['Salesperson'] = array(
                    'LogId' => $dataArr[3],
                    'Name' => $dataArr[5],
                    'DirectLine' => $dataArr[6],
                    'Mobile' => $dataArr[7],
                    'Email' => $dataArr[8],
                );
            }

            if (sizeOf($dataArr) > 4 && $dataArr[4] == 'C') {

                $webserviceQuoteArr['Comment'] = $dataArr[3];
            }

            if (sizeOf($dataArr) > 4 && in_array($dataArr[4], array('P'))) {
                $productRowID = $wsData['ws_id'];
                $webserviceQuoteArr['Products'][$productRowID] = array(
                    'SystemFreight' => $dataArr[19],
                    'Code' => $dataArr[0],
                    'Quantity' => intval($dataArr[1]),
                    'UnitPrice' => floatval($dataArr[2]),
                    'Name' => $dataArr[3],
                    'Description' => $dataArr[14],
                    'CustomNote' => (isset($dataArr[30])?$dataArr[30]:''),
                    'Tax' => floatval($dataArr[17]),
                    'SellPriceExcludingTax' => floatval($dataArr[21]),
                    'SellPriceIncludingTax' => floatval($dataArr[22]),
                    'SellTotalExcludingTax' => floatval($dataArr[23]),
                    'SellTotalIncludingTax' => floatval($dataArr[24]),
                    'CusomerDiiscountPercentage' => floatval($dataArr[7]),
                    'Freight' => floatval($dataArr[26]),
                    'USDFreight' => $dataArr[27],
                    'FreightMarkUp' => $dataArr[25],
                    'FreightUnitMarkedUpCost' => $dataArr[28],                    
                    'PhtoURI' => $dataArr[12],
                    'Supplier' => array(
                        'Reference' => $dataArr[5],
                        'Name' => $dataArr[20],
                        'Margin' => floatval($dataArr[8])
                    ),
                );
            }
            
            /**
             * Create product from custom notes
             */
            if (sizeOf($dataArr) > 4 && in_array($dataArr[4], array('N'))) {
                $productRowID = $wsData['ws_id'];
                $webserviceQuoteArr['Products'][$productRowID] = array(
                    'SystemFreight' => 0,
                    'Code' => $dataArr[0],
                    'Quantity' => 1,
                    'UnitPrice' => 0,
                    'Name' => $dataArr[0],
                    'Description' => $dataArr[14],
                    'Tax' => 0,
                    'SellPriceExcludingTax' => $dataArr[21],
                    'SellPriceIncludingTax' => $dataArr[22],
                    'SellTotalExcludingTax' => $dataArr[23],
                    'SellTotalIncludingTax' => $dataArr[24],
                    'CusomerDiiscountPercentage' => 0,
                    'Freight' => 0,
                    'USDFreight' => 0,
                    'FreightMarkUp' => 0,
                    'FreightUnitMarkedUpCost' => 0,
                    'PhtoURI' => 0,
                    'Supplier' => array(
                        'Reference' => '',
                        'Name' => '',
                        'Margin' => 0
                    ),
                );
            }

            //save decoration data
            if (
                    sizeOf($dataArr) > 4 &&
                    $dataArr[4] == 'D' &&
                    !in_array($dataArr[0], array('N/A', 'n/a'))
            ) {

                $webserviceQuoteArr['Products'][$productRowID]['Decorations'][$wsData['ws_id']] = array(
                    'Code' =>  $dataArr[0],
                    'MasterCode' => $dataArr[9],
                    'Description' => $dataArr[3],
                    'Quantity' => intval($dataArr[1]),
                    'UnitPrice' => floatval($dataArr[2]),
                    'LogoSetupCharge' => floatval($dataArr[6]),
                    'CusomerDiiscountPercentage' => floatval($dataArr[7]),
                    'Freight' => floatval($dataArr[16]),
                    'Tax' => floatval($dataArr[17]),
                    'LogoSetupUnitMarkUpRate' => $this->getMarkupMultiplierOutOfMargin($dataArr[25]),
                    'LogoSetupUnitCost' => $dataArr[27],
                    'LogoSetupUnitMarkedUpPrice' => $dataArr[28],
                    'Supplier' => array(
                        'Reference' => $dataArr[5],
                        'Name' => '',
                        'Margin' => $dataArr[8],
                    ),
                );
            }
        }
        
        return $webserviceQuoteArr;
       
    }
    
    private function getMarkupMultiplierOutOfMargin($margin) {
        
        if (!$margin || $margin === '0') {
            return 0;
        }

        $margin_value = intval($margin);
        $retail_lavel = 100;
        $buffer_value = $retail_lavel - $margin_value;
        $markup_percentage = $buffer_value ? (($retail_lavel / $buffer_value) - 1) : 0;
        $markup_value = round(((100 + $markup_percentage * 100) / 100), 2);


        if (is_nan($markup_value)) {
            return 0;
        }

        if (!is_finite($markup_value)) {
            return 0;
        }

        return $markup_value;

    }

}
