<?php

/**
 * This is the model class for table "web_store".
 *
 * The followings are the available columns in table 'web_store':
 * @property integer $id
 * @property string $name
 * @property string $code
 * @property string $image
 * @property string $description
 * @property string $createdDate
 * @property integer $createdBy
 * @property integer $budget_enabled
 * @property integer $backorder_enabled
 * @property integer $show_stock_available_row_in_grid
 * @property integer $show_in_production_row_in_grid
 * @property integer $show_in_transit_row_in_grid
 * @property integer $no_login
 * @property integer $dummy_webstore_user_id
 * @property decimal $flat_frieght_val
 * 
 */
class WebStore extends CActiveRecord {

    public $wysiwygContent;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return WebStore the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'web_store';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name', 'required'),
            array('name', 'unique'),
            array('createdBy, autoCreateJob, autoCreateInvoice, pageItems, budget_enabled, backorder_enabled, '
                . 'show_stock_available_row_in_grid, show_in_production_row_in_grid, show_in_transit_row_in_grid, no_login, dummy_webstore_user_id', 'numerical', 'integerOnly' => true),
            array('name', 'length', 'max' => 100),
            array('flat_frieght_val', 'numerical'),
            array('description, createdDate, webstoreUrl,customerPriceLevel,webOrdersEmail, budget_enabled', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, name, code, imagelogo, description, createdDate, createdBy', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'code' => 'Code',
            'imagelogo' => 'Image',
            'description' => 'Description',
            'createdDate' => 'Created Date',
            'createdBy' => 'Created By',
            'wysiwygContent' => 'Edit Home Template',
            'webstoreUrl' => 'Web Store URL',
            'autoCreateJob' => 'Automatically Create Job',
            'autoCreateInvoice' => 'Automatically Create Invoice',
            'customerPriceLevel' => 'Customer Item Price Level',
            'webOrdersEmail' => 'Web Orders Email',
            'pageItems' => 'Items per Page',
            'budget_enabled' => 'Budget Enable',
            'backorder_enabled' => 'Enable Back-Order Function',
            'show_stock_available_row_in_grid' => 'Show Stock Available',
            'show_in_production_row_in_grid' => 'Show In Production',
            'show_in_transit_row_in_grid' => 'Show In Transit',
            'no_login' => 'No Login ( Bypass the login page )',
            'dummy_webstore_user_id' => 'Dummy Web Store User ( If no login )',
            'flat_frieght_val' => 'Flat Freight'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('code', $this->code, true);
        $criteria->compare('imagelogo', $this->imagelogo, true);
        $criteria->compare('description', $this->description, true);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('createdBy', $this->createdBy);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}
