<?php

/**
 * This is the model class for table "webstore_products".
 *
 * The followings are the available columns in table 'webstore_products':
 * @property integer $id
 * @property integer $webstoreId
 * @property integer $productId
 * @property string $createdDate
 * @property integer $createdBy
 */
class WebStoreProduct extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebStoreProduct the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'webstore_products';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('webstoreId, productId, createdBy', 'numerical', 'integerOnly'=>true),
			array('createdDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, webstoreId, productId, createdDate, createdBy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'webstoreRel' => array(self::BELONGS_TO, 'WebStore', 'webstoreId'),
                    'productLineRel' => array(self::BELONGS_TO, 'ProductLine', 'productId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'webstoreId' => 'Webstore',
			'productId' => 'Product',
			'createdDate' => 'Created Date',
			'createdBy' => 'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('webstoreId',$this->webstoreId);
		$criteria->compare('productId',$this->productId);
		$criteria->compare('createdDate',$this->createdDate,true);
		$criteria->compare('createdBy',$this->createdBy);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        
        
}