<?php

/**
 * This is the model class for table "webstore_cart".
 *
 * The followings are the available columns in table 'webstore_cart':
 * @property integer $id
 * @property integer $webstore_id
 * @property integer $webstore_user_id
 * @property integer $statusId
 * @property string $createdDate
 * @property integer $createdBy
 */
class WebstoreCart extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return WebstoreCart the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'webstore_cart';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('webstore_id, webstore_user_id, statusId, createdBy', 'numerical', 'integerOnly' => true),
            array('createdDate,alternateDeliveryAddress,specialInstructions,customerTelephone', 'safe'),
            array('customerEmail', 'length', 'max' => 150),
            array('customerEmail, purchaseOrderNumber, customerAccountNumber,contactName', 'length', 'max' => 100),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, webstore_id, webstore_user_id, statusId, createdDate, createdBy', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'webstore_id' => 'Webstore',
            'webstore_user_id' => 'Webstore User',
            'statusId' => 'Status',
            'createdDate' => 'Created Date',
            'createdBy' => 'Created By',
            'specialInstructions'=>'Special Instructions',
            'alternateDeliveryAddress' =>'Alternative Delivery Address',
            'customerEmail'=>'Customer Email',
            'purchaseOrderNumber'=>'Purchase Order',
            'customerAccountNumber'=>'Account',
            'contactName'=>'Contact Name'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('webstore_id', $this->webstore_id);
        $criteria->compare('webstore_user_id', $this->webstore_user_id);
        $criteria->compare('statusId', $this->statusId);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('specialInstructions', $this->specialInstructions, true);
        $criteria->compare('alternateDeliveryAddress', $this->alternateDeliveryAddress, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    

    public static function getItemPriceByLevel($uuid, $level) {
        $priceMetrix = MyobItemPriceMatrix::model()->find(array('condition' => "myob_item_uuid = '$uuid'"));
        if ($priceMetrix) {
            if ($level == 'BASE') {
                return $priceMetrix->level_a;
            } else if ($level == 'VIP') {
                return $priceMetrix->level_b;
            } else if ($level == 'Level C') {
                return $priceMetrix->level_c;
            } else if ($level == 'Level D') {
                return $priceMetrix->level_d;
            } else if ($level == 'Level E') {
                return $priceMetrix->level_e;
            } else if ($level == 'Level F') {
                return $priceMetrix->level_f;
            } else {
                return 0;
            }
        } else {
            return 0;
        }
    }

    public static function getItemCount($webcartId) {

        if (!$webcartId) {
            $webstoreID = Yii::app()->user->webstoreID;
            $webstoreUserID = Yii::app()->user->id;
            $status = Status::model()->find(array('condition' => "name = 'Cart Opened'"));
            $webcart = WebstoreCart::model()->find(array('condition' => "webstore_id = {$webstoreID} and webstore_user_id = {$webstoreUserID} and statusId = {$status->id}"));
            $webcartId = $webcart->id;
        }

        $sql = "select COUNT(DISTINCT colorGroupCode)  as itemcount from webstore_cart_details where webstoreCartId = '$webcartId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['itemcount'];
    }

    public static function getItemQty($pdlsno) {


        $webstoreID = Yii::app()->user->webstoreID;
        $webstoreUserID = Yii::app()->user->id;
        $status = Status::model()->find(array('condition' => "name = 'Cart Opened'"));
        $webcart = WebstoreCart::model()->find(array('condition' => "webstore_id = {$webstoreID} and webstore_user_id = {$webstoreUserID} and statusId = {$status->id}"));
        $webcartId = $webcart->id;


        if ($webcart) {
            $sql = "select sum(requestQty)  as itemQty from webstore_cart_details where webstoreCartId = '$webcartId' and productId = $pdlsno";
            $result = Yii::app()->db->createCommand($sql)->queryRow();

            return $result['itemQty'];
        } else
            return 0;
    }

    public function getGroupQty($colorGroupCode, $isBackOrder) {
        if($isBackOrder){
            $sql = "select sum(requestQty)  as groupQty from webstore_cart_details where webstoreCartId = '$this->id' and colorGroupCode = '$colorGroupCode' and isBackOrder = 1";
        }else{
            $sql = "select sum(requestQty)  as groupQty from webstore_cart_details where webstoreCartId = '$this->id' and colorGroupCode = '$colorGroupCode' and (isBackOrder <> 1 or isBackOrder is null)";
        }
        
        $result = Yii::app()->db->createCommand($sql)->queryRow();
        return $result['groupQty'];
    }
    
    public function getInStockQty($colorGroupCode) {
        
        $sql = "select sum(requestQty)  as groupQty from webstore_cart_details where webstoreCartId = '$this->id' and colorGroupCode = '$colorGroupCode' and (isBackOrder <> 1 or isBackOrder is null)";
        

        $result = Yii::app()->db->createCommand($sql)->queryRow();
        return $result['groupQty'];
    }

    public function getGroupAmount($colorGroupCode, $isBackOrder) {
        if($isBackOrder){
            $sql = "select sum(lineAmount)  as groupAmount from webstore_cart_details where webstoreCartId = '$this->id' and colorGroupCode = '$colorGroupCode' and isBackOrder = 1";
        }else{
            $sql = "select sum(lineAmount)  as groupAmount from webstore_cart_details where webstoreCartId = '$this->id' and colorGroupCode = '$colorGroupCode' and (isBackOrder <> 1 or isBackOrder is null)";
        }
        
        $result = Yii::app()->db->createCommand($sql)->queryRow();
        return $result['groupAmount'];
    }

    public function getColorSizeQtyHtml($colorGroupCode, $isBackOrder) {
        if($isBackOrder){
            $colorGroupDetails = WebstoreCartDetail::model()->findAll(array('condition' => "webstoreCartId = $this->id and colorGroupCode = '$colorGroupCode' and isBackOrder = 1"));
        }else{
            $colorGroupDetails = WebstoreCartDetail::model()->findAll(array('condition' => "webstoreCartId = $this->id and colorGroupCode = '$colorGroupCode' and (isBackOrder <> 1 or isBackOrder is null)"));
        }
        
        $colorGroupProductArr = array();

        foreach ($colorGroupDetails as $dtl) {
            $product = ProductLine::model()->findByPk($dtl->productId);
            $colorSize = substr($product->pdlprdline, strrpos($product->pdlprdline, ' '));

            $colorSizeSellingPrice = $dtl->sellingPrice;
            $qtyOrdered = $dtl->requestQty;

//            $qty_message = $dtl->qty_message;
//            if (empty($qty_message)) {
//                if ($product->qty_available == 0 || $product->qty_available < 0) {
//                    $qty_message = $dtl->requestQty . " units will be placed on back order";
//                } else if ($product->qty_available > 0 && $product->qty_available < $dtl->requestQty) {
//                    $balanceQty = $dtl->requestQty - $product->qty_available;
//                    $qty_message = $balanceQty . " units will be placed on back order";
//                }
//            }

            $colorGroupProductArr[$product->pdlsno] = array(
                'size' => $colorSize,
                'sellingPrice' => $colorSizeSellingPrice,
                'qtyOrdered' => $qtyOrdered,
                'prodCode' => $product->pdlpdl,                
                
            );
        }

        return $this->generateColorSizeTableHtml($colorGroupProductArr);
    }

    function generateColorSizeTableHtml($colorGroupProductArr) {
        $html = "";
        $html .= "<table style='padding:15px;width:100%;'>";
        $html .= "<thead>";
        $html .= "<tr>";
        $html .= "<td style='width:25%;border-right:2px solid #BAB9B9;border-left:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;border-top:2px solid #BAB9B9;background-color:#ddd;'>Sizes</td>";
        foreach ($colorGroupProductArr as $key => $value) {
            $html .= "<td style='border-right:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;text-align:center;border-top:2px solid #BAB9B9;'>" . $value['size'] . "</td>";
        }
        $html .= "</tr>";
        $html .= "</thead>";

        $html .= "</tbody>";
        $html .= "<tr>";

        $html .= "<td style='border-right:2px solid #BAB9B9;border-left:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;border-top:2px solid #BAB9B9;background-color:#ddd;'>Item Code</td>";
        foreach ($colorGroupProductArr as $key => $value) {
            $html .= "<td style='border-right:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;text-align:center;'>" . $value['prodCode'] . "</td>";
        }

        $html .= "</tr>";

        $html .= "<tr>";

        $html .= "<td style='border-right:2px solid #BAB9B9;border-left:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;border-top:2px solid #BAB9B9;background-color:#ddd;'>Quantity</td>";
        foreach ($colorGroupProductArr as $key => $value) {
            $html .= "<td style='border-right:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;text-align:center;'>" . $value['qtyOrdered'] . "</td>";
        }

        $html .= "</tr>";
        $html .= "<tr>";

        $html .= "<td style='border-right:2px solid #BAB9B9;border-left:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;background-color:#ddd;'>Selling Price</td>";
        foreach ($colorGroupProductArr as $key => $value) {
            $html .= "<td style='border-right:2px solid #BAB9B9;border-bottom:2px solid #BAB9B9;text-align:center;'>" . number_format($value['sellingPrice'], 2) . "</td>";
        }

        $html .= "</tr>";
        $html .= "</tbody>";

        $html .= "</table>";

        return $html;
    }

    public function getTotalQty() {

        $sql = "select sum(requestQty)  as totQty from webstore_cart_details where webstoreCartId = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();
        return $result['totQty'];
    }
    
     public function getTotalAmount() {

        $sql = "select sum(lineAmount)  as totAmount from webstore_cart_details where webstoreCartId = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();
        return $result['totAmount'];
    }
    
    public function getTotalItems() {

        $sql = "select count(id)  as totItms from webstore_cart_details where webstoreCartId = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();
        return $result['totItms'];
    }

}
