<?php

/**
 * This is the model class for table "webstore_cart_details".
 *
 * The followings are the available columns in table 'webstore_cart_details':
 * @property integer $id
 * @property integer $webstoreCartId
 * @property integer $colorGroupCode
 * @property integer $requestQty
 * @property string $createdDate
 * @property double $costPrice
 * @property double $sellingPrice
 * @property double $lineAmount
 * @property integer $productId
 */
class WebstoreCartDetail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebstoreCartDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'webstore_cart_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('webstoreCartId, requestQty, productId', 'numerical', 'integerOnly'=>true),
			array('costPrice, sellingPrice, lineAmount', 'numerical'),
			array('createdDate, colorGroupCode', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, webstoreCartId, colorGroupCode, requestQty, createdDate, costPrice, sellingPrice, lineAmount, productId', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'webstoreCartId' => 'Webstore Cart',
			'colorGroupCode' => 'Color Group Code',
			'requestQty' => 'Request Qty',
			'createdDate' => 'Created Date',
			'costPrice' => 'Cost Price',
			'sellingPrice' => 'Selling Price',
			'lineAmount' => 'Line Amount',
			'productId' => 'Product',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('webstoreCartId',$this->webstoreCartId);
		$criteria->compare('colorGroupCode',$this->colorGroupCode);
		$criteria->compare('requestQty',$this->requestQty);
		$criteria->compare('createdDate',$this->createdDate,true);
		$criteria->compare('costPrice',$this->costPrice);
		$criteria->compare('sellingPrice',$this->sellingPrice);
		$criteria->compare('lineAmount',$this->lineAmount);
		$criteria->compare('productId',$this->productId);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        
}