<?php

/**
 * This is the model class for table "webstore_cart_detail_sizeqtycolors".
 *
 * The followings are the available columns in table 'webstore_cart_detail_sizeqtycolors':
 * @property integer $id
 * @property integer $webstore_cart_id
 * @property integer $webstore_cart_detail_id
 * @property integer $product_size_id
 * @property integer $qty
 * @property string $color
 */
class WebstoreCartDetailSizeQtyColor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebstoreCartDetailSizeQtyColor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'webstore_cart_detail_sizeqtycolors';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('webstore_cart_id, webstore_cart_detail_id, product_size_id, qty', 'numerical', 'integerOnly'=>true),
			array('color', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, webstore_cart_id, webstore_cart_detail_id, product_size_id, qty, color', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'webstore_cart_id' => 'Webstore Cart',
			'webstore_cart_detail_id' => 'Webstore Cart Detail',
			'product_size_id' => 'Product Size',
			'qty' => 'Qty',
			'color' => 'Color',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('webstore_cart_id',$this->webstore_cart_id);
		$criteria->compare('webstore_cart_detail_id',$this->webstore_cart_detail_id);
		$criteria->compare('product_size_id',$this->product_size_id);
		$criteria->compare('qty',$this->qty);
		$criteria->compare('color',$this->color,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}