<?php

/**
 * This is the model class for table "webstore_orders".
 *
 * The followings are the available columns in table 'webstore_orders':
 * @property integer $id
 * @property integer $webstore_id
 * @property integer $webstoreCartId
 * @property string $orderNumber
 * @property integer $webstore_user_id
 * @property integer $statusId
 * @property string $adminComment
 * @property string $createdDate
 * @property string $estimatedDeliveryDate
 */
class WebstoreOrder extends CActiveRecord {
    
    public $invoice_html;
    public $job_html;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return WebstoreOrder the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'webstore_orders';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('webstore_id, webstoreCartId, webstore_user_id, statusId, statusChangedBy, jobId,backOrderJobId', 'numerical', 'integerOnly' => true),
            array('orderNumber', 'length', 'max' => 45),
            array('adminComment, createdDate, estimatedDeliveryDate, statusUpdatedAt,specialInstructions,'
                . 'officeAddress,specialInstructions,deliveryAddress,contactPerson,contactEmail,postalCode,state,customerTelephone,invoice_html,job_html,customerTelephone2,postalCode1,state1', 'safe'),
            array('customerEmail,suburb,suburb2', 'length', 'max' => 150),
            array('customerEmail, purchaseOrderNumber, customerAccountNumber,contactPerson1', 'length', 'max' => 100),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, webstore_id, webstoreCartId, orderNumber, webstore_user_id, statusId, adminComment, createdDate, estimatedDeliveryDate', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'webstore_id' => 'Webstore',
            'webstoreCartId' => 'Webstore Cart',
            'orderNumber' => 'Order Number',
            'webstore_user_id' => 'Webstore User',
            'statusId' => 'Status',
            'adminComment' => 'Admin Comment',
            'createdDate' => 'Created Date',
            'estimatedDeliveryDate' => 'Estimated Delivery Date',
            'statusUpdatedAt' => 'Status Updated At',
            'statusChangedBy' => 'Status Changed By',
            'jobId' => 'Job',
            'officeAddress' => 'Office Address',
            'isThirdpartyDelivery' => 'Third Party Delivery',
            'deliveryAddress' => 'Delivery Address',
            'contactPerson' => 'Contact Person',
            'contactEmail' => 'Contact Email',
            'postalCode' => 'Post Code',
            'state' => 'State',
            'contactEmail' => 'Contact Email',
            'postalCode' => 'Post Code',
            'state' => 'State',
            'customerEmail' => 'Customer Email',
            'purchaseOrderNumber' => 'Purchase Order',
            'customerAccountNumber' => 'Account',
            'contactPerson1' => 'Contact Name',
            'invoice_html'=>'Invoices',
            'job_html'=>'Jobs',
            'customerTelephone'=>'Customer Telephone',
            'customerTelephone2'=>'Telephone',
            'postalCode1' => 'Post Code',
            'state1' => 'State',
            'suburb'=>'Suburb',
            'suburb2'=>'Suburb'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('webstore_id', $this->webstore_id);
        $criteria->compare('webstoreCartId', $this->webstoreCartId);
        $criteria->compare('orderNumber', $this->orderNumber, true);
        $criteria->compare('webstore_user_id', $this->webstore_user_id);
        $criteria->compare('statusId', $this->statusId);
        $criteria->compare('adminComment', $this->adminComment, true);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('estimatedDeliveryDate', $this->estimatedDeliveryDate, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 'createdDate desc',
            )
        ));
    }

    public static function processOrder($cartId) {

        $statusOpen = Status::model()->find(array('condition' => "name = 'Cart Opened'"));
        $statusPendingAppr = Status::model()->find(array('condition' => "name = 'Pending Approval'"));
        $cart = WebstoreCart::model()->findByPk($cartId);
        $cartdetails = WebstoreCartDetail::model()->findAll(array('condition' => "webstoreCartId = $cartId"));
        if ($cart && $cart->statusId == $statusOpen->id) {
            $weborder = new WebstoreOrder();
            $weborder->webstore_id = $cart->webstore_id;
            $weborder->webstoreCartId = $cart->id;
            $weborder->webstore_user_id = $cart->webstore_user_id;
            $weborder->statusId = $statusPendingAppr->id;
            $weborder->createdDate = date('Y-m-d');

            if ($weborder->save(false)) {
                $weborder->orderNumber = $cart->webstore_id . '-' . date('Ymd') . '-' . $weborder->id;
                $weborder->save(false);

                foreach ($cartdetails as $dtl) {
                    $orderdtl = new WebstoreOrderDetail();
                    $orderdtl->webstoreOrderId = $weborder->id;
                    $orderdtl->webstoreCartId = $cartId;
                    $orderdtl->webstoreCartDetailId = $dtl->id;
                    $orderdtl->productId = $dtl->productId;
                    $orderdtl->requestQty = $dtl->requestQty;
                    $orderdtl->costPrice = $dtl->costPrice;
                    $orderdtl->sellingPrice = $dtl->sellingPrice;
                    $orderdtl->lineAmount = $dtl->lineAmount;
                    $orderdtl->save(false);
                }
            }

            return $weborder;
        }

        return null;
    }

    public function createQuote($orderdtls, $isBackOrder) {

        $quote = null;

        $webstoreuser = WebstoreUser::model()->findByPk($this->webstore_user_id);
        $customer = Customer::model()->findByPk($webstoreuser->customer_id);
        $quote = new Quatation();
        $quote->quotename = "Web Store Order";
        $quote->cus_fref = $customer->cuscus_fref;
        $quote->quotecreatedby = Yii::app()->user->id;
        $quote->quotecreated = date('Y-m-d H:i:s');
        $quote->dueDate = date('Y-m-d H:i:s', strtotime('+ ' . GlobalVars::get('DueInXDays') . ' days'));
        $quote->status = 1; //New        
        $quote->webstore_order_id = $this->id;
        $quote->isBackOrder = $isBackOrder;
        if ($quote->save(false)) {
            $newquotenum = sprintf("%06s", $quote->id);
            $newquotenum = date('y') . '-' . $newquotenum;
            $quote->quoteno = $newquotenum;
            if ($quote->save(false)) {
                //$orderdtls = WebstoreOrderDetail::model()->findAll(array('condition' => "webstoreOrderId = $this->id"));
                foreach ($orderdtls as $data) {

                    $quotedtl = new QuatationDetails();
                    $quotedtl->quoteid = $quote->id;
                    $quotedtl->productsku = $data->productRel->pdlpdl;
                    $quotedtl->qty = $data->requestQty;
                    $quotedtl->productexunitprice = $data->costPrice;
                    $quotedtl->productname = $data->productRel->pdlprdline;
                    $quotedtl->productdescription = $data->productRel->pdldes;
                    $quotedtl->sellunitprice_ex_vat = $data->sellingPrice;
                    $quotedtl->selltot_ex_vat = $data->lineAmount;

                    if ($quotedtl->save(false)) {
                        
                    }
                }
            }
        }


        return $quote;
    }

    public function getCustomer() {
        $webuser = WebstoreUser::model()->findByPk($this->webstore_user_id);
        return Customer::model()->findByPk($webuser->customer_id);
    }

    public function getMYOBCustomerID() {
        $customerMYOBID = "";
        if ($this->getCustomer() && $this->getCustomer()->master) {
            $customerMYOBID = $this->getCustomer()->master->displayIdMYOB;
        }

        return $customerMYOBID;
    }

    public function getInvoicesHtml() {
        $html = "";
        $invJob = Jobs::model()->findByPk($this->jobId);
        if ($invJob) {
            if ($invJob->getInvoice()) {
                $invInvoice = $invJob->getInvoice();
                $link = CHtml::link($invInvoice->invoiceNum, array("invoice/view", "id" => $invInvoice->id), array("target" => "_blank"));
                if ($invInvoice->myob_uuid && empty($invInvoice->json_response)) {
                    $link .= '&nbsp;<span class="label label-success" title="Successfully uploaded">MYOB</span>';
                } else if (!empty($invInvoice->json_response)) {
                     $link .= '&nbsp;<span class="label label-important" title="Unsuccessful  upload">MYOB</span>';
                }
                
                $html .= '<br>' . $link;
                
            }
        }

        $backorderJob = Jobs::model()->findByPk($this->backOrderJobId);
        if ($backorderJob) {
            if ($backorderJob->getInvoice()) {
                $backInvoice = $backorderJob->getInvoice();
                $link = CHtml::link($backInvoice->invoiceNum, array("invoice/view", "id" => $backInvoice->id), array("target" => "_blank"));
                if ($backInvoice->myob_uuid && empty($backInvoice->json_response)) {
                    $link .= '&nbsp;<span class="label label-success" title="Successfully uploaded">MYOB</span>';
                } else if (!empty($backInvoice->json_response)) {
                     $link .= '&nbsp;<span class="label label-important" title="Unsuccessful  upload">MYOB</span>';
                }
                
                $html .= '<br>' . $link;
                
            }
        }
        
        return $html;
    }
    
    public function getJobsHtml() {
        $html = "";
        $invJob = Jobs::model()->findByPk($this->jobId);
        if ($invJob) {
            
                $link = CHtml::link($invJob->jobNum, array("job/view", "id" => $invJob->id), array("target" => "_blank", 'title'=>'Inventory Job'));
                
                
                $html .= '<br>' . $link;
                
            
        }

        $backorderJob = Jobs::model()->findByPk($this->backOrderJobId);
        if ($backorderJob) {
            $link = CHtml::link($backorderJob->jobNum, array("job/view", "id" => $backorderJob->id), array("target" => "_blank", 'title'=>'Back Order Job'));
                
                
                $html .= '<br>' . $link;
        }
        
        return $html;
    }
    
    
    public function reCalculateFreight() {
        //$result_arr = array();
        //retrive web cart details again
        $cart = WebstoreCart::model()->findByPk($this->webstoreCartId);
        $cartdetails = WebstoreCartDetail::model()->findAll(array('condition' => "webstoreCartId =  $this->webstoreCartId", 'group' => "colorGroupCode,isBackOrder"));
        $totQty = 0;
        $inStockQty = 0;
        //$totAmount = 0;
        foreach ($cartdetails as $dtl) {
            //$groupAmount = $this->getGroupAmount($dtl->colorGroupCode, $dtl->isBackOrder);
             

            $totQty += $cart->getGroupQty($dtl->colorGroupCode, $dtl->isBackOrder);
            if (!$dtl->isBackOrder) {
                //$inStockQty += $this->getInStockQty($dtl->colorGroupCode);
            }
            //$totAmount += $groupAmount;
        }

        //$gst_rate = GlobalVars::get("GST") ? floatval(GlobalVars::get("GST")) : 0;

        //$this->total_amount = $totAmount;
        //$this->gst_rate = $gst_rate;


        $postcode = $this->isThirdpartyDelivery ? trim($this->postalCode) : trim($this->postalCode1);
        $suburb = $this->isThirdpartyDelivery ? trim($this->suburb2) : trim($this->suburb);

        //Freight charges are calculated only for in stock quantites not including backorder quantities
        $this->postal_code_freight_charge = FreightChargeOnLocation::findCharge(array('postcode'=>$postcode,'suburb'=>$suburb),$inStockQty);;
        

        return $this->save(false);
    }

}
