<?php

/**
 * This is the model class for table "webstore_order_details".
 *
 * The followings are the available columns in table 'webstore_order_details':
 * @property integer $id
 * @property integer $webstoreOrderId
 * @property integer $webstoreCartId
 * @property integer $webstoreCartDetailId
 * @property integer $productId
 * @property integer $requestQty
 * @property double $costPrice
 * @property double $sellingPrice
 * @property double $lineAmount
 */
class WebstoreOrderDetail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebstoreOrderDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'webstore_order_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('webstoreOrderId, webstoreCartId, webstoreCartDetailId, productId, requestQty, isBackOrder', 'numerical', 'integerOnly'=>true),
			array('costPrice, sellingPrice, lineAmount', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, webstoreOrderId, webstoreCartId, webstoreCartDetailId, productId, requestQty, costPrice, sellingPrice, lineAmount', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'productRel' => array(self::BELONGS_TO, 'ProductLine', 'productId'), 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'webstoreOrderId' => 'Webstore Order',
			'webstoreCartId' => 'Webstore Cart',
			'webstoreCartDetailId' => 'Webstore Cart Detail',
			'productId' => 'Product',
			'requestQty' => 'Request Qty',
			'costPrice' => 'Cost Price',
			'sellingPrice' => 'Selling Price',
			'lineAmount' => 'Line Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('webstoreOrderId',$this->webstoreOrderId);
		$criteria->compare('webstoreCartId',$this->webstoreCartId);
		$criteria->compare('webstoreCartDetailId',$this->webstoreCartDetailId);
		$criteria->compare('productId',$this->productId);
		$criteria->compare('requestQty',$this->requestQty);
		$criteria->compare('costPrice',$this->costPrice);
		$criteria->compare('sellingPrice',$this->sellingPrice);
		$criteria->compare('lineAmount',$this->lineAmount);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}