<?php

/**
 * This is the model class for table "webstore_price_list".
 *
 * The followings are the available columns in table 'webstore_price_list':
 * @property integer $id
 * @property integer $webstoreId
 * @property string $priceListName
 * @property string $headerTxt
 * @property string $comment
 * @property string $imageName
 * @property string $fileName
 * @property integer $isActive
 * @property string $createdDate
 * @property integer $createdBy
 */
class WebstorePriceList extends CActiveRecord {

    public $uploadFile;
    public $uploadImage;
    public $webstore_search;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return WebstorePriceList the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'webstore_price_list';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('webstoreId, isActive, createdBy', 'numerical', 'integerOnly' => true),
            array('priceListName, headerTxt, comment, imageName, fileName', 'length', 'max' => 255),
            array('uploadImage', 'file', 'allowEmpty' => true, 'types' => 'jpg,jpeg,gif,png'),
            array('createdDate,uploadFile,uploadImage,webstore_search', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, webstoreId, priceListName, headerTxt, comment, imageName, fileName, isActive, createdDate, createdBy', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'webstoreRel' => array(self::BELONGS_TO, 'WebStore', 'webstoreId'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'webstoreId' => 'Webstore',
            'priceListName' => 'Price List Name',
            'headerTxt' => 'Header Text',
            'comment' => 'Comment',
            'imageName' => 'File Image Icon',
            'fileName' => 'File Name',
            'isActive' => 'Is Active',
            'createdDate' => 'Created Date',
            'createdBy' => 'Created By',
            'webstore_search' => 'Web Store'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('webstoreRel');

        //$criteria->compare('id', $this->id);
        $criteria->compare('webstoreId', $this->webstoreId);
        $criteria->compare('priceListName', $this->priceListName, true);
        $criteria->compare('headerTxt', $this->headerTxt, true);
        $criteria->compare('comment', $this->comment, true);
        $criteria->compare('imageName', $this->imageName, true);
        $criteria->compare('fileName', $this->fileName, true);
        $criteria->compare('isActive', $this->isActive);
        $criteria->compare('t.createdDate', $this->createdDate, true);
        $criteria->compare('webstoreRel.name', $this->webstore_search, true);

        $criteria->compare('createdBy', $this->createdBy);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.createdDate desc',
            )
        ));
    }

    public function getImg() {
        $dirpath_img = 'images/pricelistimg/' . $this->webstoreId . '/' . $this->imageName;

        return $dirpath_img;
    }

    public function getFile() {
        $dirpath_pricelist = 'files/pricelist/' . $this->webstoreId . '/' . $this->fileName;
        return $dirpath_pricelist;
    }

    function format_size($size) {
        $sizes = array(" Bytes", " KB", " MB", " GB", " TB", " PB", " EB", " ZB", " YB");
        if ($size == 0) {
            return('n/a');
        } else {
            return (round($size / pow(1024, ($i = floor(log($size, 1024)))), 2) . $sizes[$i]);
        }
    }

}
