<?php

/**
 * This is the model class for table "webstore_users".
 *
 * The followings are the available columns in table 'webstore_users':
 * @property integer $id
 * @property string $username
 * @property string $password
 * @property string $email
 * @property integer $is_active
 */
class WebstoreUser extends CActiveRecord {
    
    public $importFile;
    public $webstore_user_store_id;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return WebstoreUser the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'webstore_users';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, email, password, customer_id', 'required'),
            array('is_active,webstore_user_store_id', 'numerical', 'integerOnly' => true),
            array('username, password, email,companyName', 'length', 'max' => 255),
            array('password', 'length', 'min' => 4),
            array('email', 'email'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, username, password, email, is_active, importFile,companyName', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }
    
    public function rel_customer() {
        return Customer::model()->findByPk($this->customer_id);
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'username' => 'Username',
            'password' => 'Password',
            'email' => 'Email',
            'is_active' => 'Is Active',
            'customer_id' => 'Customer Name',
            'companyName'=>'Company Name',
            'webstore_user_store_id'=>'Web Store'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('username', $this->username, true);
        $criteria->compare('password', $this->password, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('companyName', $this->companyName, true);
        $criteria->compare('is_active', $this->is_active);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}
