<?php

/**
 * This is the model class for table "workorder_details_decorations".
 *
 * The followings are the available columns in table 'workorder_details_decorations':
 * @property integer $id
 * @property integer $work_order_id
 * @property integer $workorder_detail_id
 * @property integer $decoration_id
 * @property string $decprtnam
 * @property string $decdesc
 * @property string $customdecoration
 * @property integer $quantity
 * @property double $cost_price
 * @property double $sup_margin
 * @property double $sup_markedup_price
 * @property double $logo_setup
 * @property double $logo_setup_unit_price
 * @property double $logo_setup_markup_rate
 * @property double $logo_setup_unit_markedup_price
 * @property double $decorationfreightval
 * @property double $decorationvat
 * @property string $supref
 * @property string $created_at
 * @property integer $created_by
 */
class WorkorderDetailsDecoration extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return WorkorderDetailsDecoration the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'workorder_details_decorations';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('work_order_id, workorder_detail_id, decoration_id, quantity, created_by', 'numerical', 'integerOnly' => true),
            array('cost_price, sup_margin, sup_markedup_price, logo_setup, logo_setup_unit_price, logo_setup_markup_rate, '
                . 'logo_setup_unit_markedup_price, decorationfreightval, decorationvat, supmargPercentage, logoSetupMarkupPercentage', 'numerical'),
            array('decprtnam, decdesc, customdecoration, supref', 'length', 'max' => 255),
            array('created_at, customization_detail', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, work_order_id, workorder_detail_id, decoration_id, decprtnam, decdesc, customdecoration, quantity, cost_price, sup_margin, sup_markedup_price, logo_setup, logo_setup_unit_price, logo_setup_markup_rate, logo_setup_unit_markedup_price, decorationfreightval, decorationvat, supref, created_at, created_by', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'decoRel' => array(self::BELONGS_TO, 'Decoration', 'decoration_id'),
            'supRel' => array(self::BELONGS_TO, 'Supplier', '', 'foreignKey' => array('supref' => 'supsup_fref')), 
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'work_order_id' => 'Work Order',
            'workorder_detail_id' => 'Workorder Detail',
            'decoration_id' => 'Decoration',
            'decprtnam' => 'Decprtnam',
            'decdesc' => 'Decdesc',
            'customdecoration' => 'Customdecoration',
            'quantity' => 'Quantity',
            'cost_price' => 'Cost Price',
            'sup_margin' => 'Sup Margin',
            'sup_markedup_price' => 'Sup Markedup Price',
            'logo_setup' => 'Logo Setup',
            'logo_setup_unit_price' => 'Logo Setup Unit Price',
            'logo_setup_markup_rate' => 'Logo Setup Markup Rate',
            'logo_setup_unit_markedup_price' => 'Logo Setup Unit Markedup Price',
            'decorationfreightval' => 'Decorationfreightval',
            'decorationvat' => 'Decorationvat',
            'supref' => 'Supref',
            'created_at' => 'Created At',
            'created_by' => 'Created By',
			'customization_detail' => 'Customisation Details'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('work_order_id', $this->work_order_id);
        $criteria->compare('workorder_detail_id', $this->workorder_detail_id);
        $criteria->compare('decoration_id', $this->decoration_id);
        $criteria->compare('decprtnam', $this->decprtnam, true);
        $criteria->compare('decdesc', $this->decdesc, true);
        $criteria->compare('customdecoration', $this->customdecoration, true);
        $criteria->compare('quantity', $this->quantity);
        $criteria->compare('cost_price', $this->cost_price);
        $criteria->compare('sup_margin', $this->sup_margin);
        $criteria->compare('sup_markedup_price', $this->sup_markedup_price);
        $criteria->compare('logo_setup', $this->logo_setup);
        $criteria->compare('logo_setup_unit_price', $this->logo_setup_unit_price);
        $criteria->compare('logo_setup_markup_rate', $this->logo_setup_markup_rate);
        $criteria->compare('logo_setup_unit_markedup_price', $this->logo_setup_unit_markedup_price);
        $criteria->compare('decorationfreightval', $this->decorationfreightval);
        $criteria->compare('decorationvat', $this->decorationvat);
        $criteria->compare('supref', $this->supref, true);
        $criteria->compare('created_at', $this->created_at, true);
        $criteria->compare('created_by', $this->created_by);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getDecorationCalculations($mix = array()) {
        $decUnitPrice = $mix['cost_price'] ?: $this->cost_price;
        $decSupMarg = $mix['sup_margin'] ?: 0;
        //if markup rate zero then set price must be zero
        $decMarkedupPrice = $decSupMarg ? number_format(($decUnitPrice * $decSupMarg), 2) : 0;

        $logoSetup = floatval($mix['logo_setup']);
        $qty = $mix['quantity'] ?: $this->quantity;
        $logoMarkupRate = $mix['logo_setup_markup_rate'] ?: 0;
        $logoUnitPrice = $qty ? number_format(($logoSetup / $qty), 2) : $logoSetup;
         //if markup rate zero then set price must be zero
        $logoSetupUnitCostWithMarkup = $logoMarkupRate ? number_format(($logoUnitPrice * $logoMarkupRate), 2) : 0;


        return array(
            'cost_price' => $decUnitPrice,
            'sup_margin' => $decSupMarg,
            'sup_markedup_price' => $decMarkedupPrice,
            'logo_setup' => $logoSetup,
            'logo_setup_markup_rate' => $logoMarkupRate,
            'logo_setup_unit_price' => $logoUnitPrice,
            'logo_setup_unit_markedup_price' => $logoSetupUnitCostWithMarkup,
        );
    }

    public static function getAddNewDecorationCalculations($mix = array()) {
        $decUnitPrice = $mix['cost_price'];
        $decSupMarg = $mix['sup_margin'];
         //if markup rate zero then set price must be zero
        $decMarkedupPrice = floatval($decSupMarg) ? number_format(($decUnitPrice * $decSupMarg), 2) : 0;

        $logoSetup = $mix['logo_setup'];
        $qty = $mix['quantity'];
        $logoMarkupRate = $mix['logo_setup_markup_rate'];
        $logoUnitPrice = $qty ? number_format(($logoSetup / $qty), 2) : $logoSetup;
         //if markup rate zero then set price must be zero
        $logoSetupUnitCostWithMarkup = $logoMarkupRate ? number_format(($logoUnitPrice * $logoMarkupRate), 2) : 0;


        return array(
            'cost_price' => $decUnitPrice,
            'sup_margin' => $decSupMarg,
            'sup_markedup_price' => $decMarkedupPrice,
            'logo_setup' => $logoSetup,
            'logo_setup_markup_rate' => $logoMarkupRate,
            'logo_setup_unit_price' => $logoUnitPrice,
            'logo_setup_unit_markedup_price' => $logoSetupUnitCostWithMarkup,
        );
    }

}
