<?php

/**
 * This is the model class for table "workorder_other_costs".
 *
 * The followings are the available columns in table 'workorder_other_costs':
 * @property integer $id
 * @property integer $workorder_id
 * @property integer $workorder_detail_id
 * @property integer $other_cost_id
 * @property double $cost
 * @property integer $created_by
 * @property string $created_date
 */
class WorkorderOtherCost extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkorderOtherCost the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workorder_other_costs';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('workorder_id, workorder_detail_id, other_cost_id, created_by', 'numerical', 'integerOnly'=>true),
			array('cost', 'numerical'),
			array('created_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, workorder_id, workorder_detail_id, other_cost_id, cost, created_by, created_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'workorder_id' => 'Workorder',
			'workorder_detail_id' => 'Workorder Detail',
			'other_cost_id' => 'Other Cost',
			'cost' => 'Cost',
			'created_by' => 'Created By',
			'created_date' => 'Created Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('workorder_id',$this->workorder_id);
		$criteria->compare('workorder_detail_id',$this->workorder_detail_id);
		$criteria->compare('other_cost_id',$this->other_cost_id);
		$criteria->compare('cost',$this->cost);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date',$this->created_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}