<?php

/**
 * This is the model class for table "workorder_paypal_payments".
 *
 * The followings are the available columns in table 'workorder_paypal_payments':
 * @property integer $id
 * @property integer $quote_id
 * @property integer $workorder_id
 * @property string $payment_id
 * @property string $payment_status
 * @property string $payer_id
 * @property string $payer_given_name
 * @property string $payer_surname
 * @property string $payer_email
 * @property string $purchase_units_reference_id
 * @property string $purchase_units_amount_currency_code
 * @property string $purchase_units_amount_value
 * @property string $paypal_response_json
 * @property string $created_at
 * @property integer $created_by
 */
class WorkorderPaypalPayment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkorderPaypalPayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workorder_paypal_payments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('quote_id, workorder_id, created_by', 'numerical', 'integerOnly'=>true),
			array('payment_id, purchase_units_reference_id', 'length', 'max'=>100),
			array('payment_status, payer_id, payer_given_name, payer_surname, purchase_units_amount_currency_code, purchase_units_amount_value', 'length', 'max'=>50),
			array('payer_email', 'length', 'max'=>150),
			array('paypal_response_json, created_at', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, quote_id, workorder_id, payment_id, payment_status, payer_id, payer_given_name, payer_surname, payer_email, purchase_units_reference_id, purchase_units_amount_currency_code, purchase_units_amount_value, paypal_response_json, created_at, created_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'quote_id' => 'Quote',
			'workorder_id' => 'Workorder',
			'payment_id' => 'Payment',
			'payment_status' => 'Payment Status',
			'payer_id' => 'Payer',
			'payer_given_name' => 'Payer Given Name',
			'payer_surname' => 'Payer Surname',
			'payer_email' => 'Payer Email',
			'purchase_units_reference_id' => 'Purchase Units Reference',
			'purchase_units_amount_currency_code' => 'Purchase Units Amount Currency Code',
			'purchase_units_amount_value' => 'Purchase Units Amount Value',
			'paypal_response_json' => 'Paypal Response Json',
			'created_at' => 'Created At',
			'created_by' => 'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('quote_id',$this->quote_id);
		$criteria->compare('workorder_id',$this->workorder_id);
		$criteria->compare('payment_id',$this->payment_id,true);
		$criteria->compare('payment_status',$this->payment_status,true);
		$criteria->compare('payer_id',$this->payer_id,true);
		$criteria->compare('payer_given_name',$this->payer_given_name,true);
		$criteria->compare('payer_surname',$this->payer_surname,true);
		$criteria->compare('payer_email',$this->payer_email,true);
		$criteria->compare('purchase_units_reference_id',$this->purchase_units_reference_id,true);
		$criteria->compare('purchase_units_amount_currency_code',$this->purchase_units_amount_currency_code,true);
		$criteria->compare('purchase_units_amount_value',$this->purchase_units_amount_value,true);
		$criteria->compare('paypal_response_json',$this->paypal_response_json,true);
		$criteria->compare('created_at',$this->created_at,true);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}