<?php

/**
 * This is the model class for table "workorder".
 *
 * The followings are the available columns in table 'workorder':
 * @property integer $id
 * @property integer $quotationId
 * @property string $quotationNumber
 * @property string $createddate
 * @property integer $createdby
 * @property integer $order_base_type
 */
class Workorder extends CActiveRecord {

    public $customer_search;
    public $mastercus_search;
    public $quoteComment_search;
     public $salesperson_search;
     
     public $coordinator_search;
	 public $onlineQuoteAcceptanceStatusSearch;


     public $cusRejectionTxt;
    
    public $SOInventoryType = 'SO';
    public $followupStatus;
    
    public $datefrom;
    public $dateto;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Workorder the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'workorder';
    }
    
    public function behaviors() {
        return array(
            'ERememberFiltersBehavior' => array(
                'class' => 'ext.yii-remember-filters-gridview-master.components.ERememberFiltersBehavior',
                'defaults' => array(), /* optional line */
                'defaultStickOnClear' => false /* optional line */
            ),
        );
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('quotationId,status_id, createdby,statusChangedBy,mastercusno, ws_user_id, prd_cordinator_id, surcharge_id, so_online_acceptence_log_id, order_base_type', 'numerical', 'integerOnly' => true),
            array('customerpono', 'length', 'max' => 100),
            array('quotationNumber,salesorderNumber', 'length', 'max' => 45),
            array('cus_fref,ws_user', 'length', 'max' => 255),
            array('createddate,statusChangedDtm, cusRejectionTxt, SOInventoryType, 
                quoteComment_search, ws_user, salesperson_search, dueDate,datefrom, dateto, 
                coordinator_search, followupStatus, onlineQuoteAcceptanceStatusSearch', 'safe'),
            array('shipAddress1, shipAddress2, shipAddress3, shipContactName, shipSendVia', 'length', 'max' => 150),
            array('shipSub, shipState, shipPostalCode, surcharge_rate', 'length', 'max' => 100),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, quotationId,status_id,statusChangedBy, cus_fref, quotationNumber,salesorderNumber, 
                createddate, createdby,mastercusno,mastercus_search,customer_search,ws_user, cusRejectionTxt, 
                quoteComment_search, salesperson_search, dueDate, coordinator_search, followupStatus', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'status' => array(self::BELONGS_TO, 'Status', 'status_id'),
            'createdBy' => array(self::BELONGS_TO, 'User', 'createdby'),
            'changedBy' => array(self::BELONGS_TO, 'User', 'statusChangedBy'),
            'quotation' => array(self::BELONGS_TO, 'Quatation', 'quotationId'),
            'customer' => array(self::BELONGS_TO, 'Customer', '', 'foreignKey' => array('cus_fref' => 'cuscus_fref')),
            'master' => array(self::BELONGS_TO, 'MasterCustomer', '', 'foreignKey' => array('mastercusno' => 'mcussno')),
            'coordinator'=>array(self::BELONGS_TO, 'User', 'prd_cordinator_id'),
              'RelDtls' => array(self::HAS_MANY, 'Workorderdetails', 'workorderId'),
            'salesperson' => array(self::BELONGS_TO, 'SalesPerson', 'ws_user_id'),
			'onlineAcceptenceLog' => array(self::BELONGS_TO, 'WorkorderOnlineAcceptenceLog', 'so_online_acceptence_log_id'), 
            
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'quotationId' => 'Quotation',
            'quotationNumber' => 'Quotation Number',
            'salesorderNumber' => 'Sales Order Number',
            'createddate' => 'Created Date',
            'createdby' => 'Createdby',
            'status_id' => 'Status',
            'statusChangedBy' => 'Changed By',
            'customer_search' => 'Customer',
            'mastercus_search' => 'Master Customer',
            'ws_user' => 'Sales Person',
            'ws_user_id' => 'Sales Person ID',
            'prd_cordinator_id' => 'Production Coordinator',
            'cusRejectionTxt'=>'Reason to reject',
            'customerpono'=>'Customer PO#',
            'quoteComment_search'=>'Quote Comments',
            'salesperson_search'=>'Sales Person',
            'dueDate'=>'Due Date',
            'coordinator_search'=>'Production Coordinator',
            'followupStatus' => 'Follow-up Status',
            
            
            'shipAddress1'=>'Shipping Address 1',
            'shipAddress2'=>'Shipping Address 2',
            'shipAddress3'=>'Shipping Address 3',
            'shipSub'=>'Shipping Suburb',
            'shipState'=>'Shipping State',
            'shipPostalCode'=>'Shipping Postal Code',
			'surcharge_id' => 'Surcharge',
			'surcharge_rate' => 'Surcharge Rate',
			'onlineQuoteAcceptanceStatusSearch' => 'Online Acceptance Status'
            
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
         $criteria->with = array('customer','quotation', 'salesperson', 'coordinator', 'onlineAcceptenceLog');
        //$criteria->with = array('master');
        //$criteria->join = 'left join customer on cus_fref = customer.cuscus_fref';
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';

        $criteria->compare('id', $this->id);
        $criteria->compare('cus_fref', $this->cus_fref);
        $criteria->compare('quotationId', $this->quotationId);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('quotationNumber', $this->quotationNumber, true);
        $criteria->compare('salesorderNumber', $this->salesorderNumber, true);
        
        $criteria->compare('t.createddate', $this->createddate, true);
        $criteria->compare('t.createdby', $this->createdby);
        $criteria->compare('t.statusChangedBy', $this->statusChangedBy);        
        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('master_customer.mcussno', $this->mastercus_search);
        $criteria->compare('quotation.quotecomments', $this->quoteComment_search, true);
        
        $criteria->compare('salesperson.name', $this->salesperson_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);
        
        $criteria->compare('customerpono', $this->customerpono, true);

        $criteria->compare('t.ws_user_id', $this->ws_user_id);
        $criteria->compare('prd_cordinator_id', $this->prd_cordinator_id);
        
        $criteria->compare('coordinator.username', $this->coordinator_search, true);
		
		 $criteria->compare('onlineAcceptenceLog.status_id', $this->onlineQuoteAcceptanceStatusSearch);
        
        if (!empty($this->followupStatus)) {

            $followupSOarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'SalesOrder' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'SalesOrder' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupSOarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupSOarr = array_filter($followupSOarr);
            //add in condition
            $idStr = implode(',', $followupSOarr);
            if(count($followupSOarr) > 0){
                $criteria->addCondition("t.id in ($idStr)");
            }else{
                $criteria->addCondition("t.id in (0)");
            }
            
        }
        
        if (!User::isAdmin()) {
            $criteria->addCondition('t.createdby = ' . Yii::app()->user->id);
        }

         //hide job based created SO
         //$criteria->addCondition('t.order_base_type IN ('.Status::ORDER_BASE_TYPE_QUOTE.')');

        $criteria->order = 't.quotationId desc';

        $pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
    }
    
    public function searchStatus() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer', 'quotation', 'salesperson');
        //$criteria->with = array('master');
        //$criteria->join = 'left join customer on cus_fref = customer.cuscus_fref';
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';

        $criteria->compare('id', $this->id);
        $criteria->compare('cus_fref', $this->cus_fref);
        $criteria->compare('quotationId', $this->quotationId);
        $criteria->compare('status_id', $this->status_id);
        $criteria->compare('quotationNumber', $this->quotationNumber, true);
        $criteria->compare('salesorderNumber', $this->salesorderNumber, true);
        $criteria->compare('createddate', $this->createddate, true);
        $criteria->compare('createdby', $this->createdby);
        $criteria->compare('statusChangedBy', $this->statusChangedBy);
        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('master_customer.mcussno', $this->mastercus_search,true);
        $criteria->compare('quotation.quotecomments', $this->quoteComment_search, true);

        $criteria->compare('salesperson.name', $this->salesperson_search, true);

        $criteria->compare('ws_user', $this->ws_user, true);

        $criteria->compare('customerpono', $this->customerpono, true);

        $criteria->compare('ws_user_id', $this->ws_user_id);
        $criteria->compare('prd_cordinator_id', $this->prd_cordinator_id);

        //$criteria->compare('orderTypeId', $this->orderTypeId);
        
        //$criteria->addCondition("t.orderTypeId is null or t.orderTypeId in (1)");

        //$criteria->order = 'quotationId desc';
        
        if (isset(Yii::app()->session['so_sts_selcted'])) {
            
            $stsArr = explode(',', Yii::app()->session['so_sts_selcted']);
            

            $followupSOarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'SalesOrder' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'SalesOrder' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && in_array($slog->followupSts_id, $stsArr)) {
                        $followupSOarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupSOarr = array_filter($followupSOarr);
            //add in condition
            $idStr = implode(',', $followupSOarr);
            if(count($followupSOarr) > 0){
                $criteria->addCondition("t.id in ($idStr)");
            }else{
                $criteria->addCondition("t.id in (0)");
            }
            
        }
        
        
        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(createddate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(createddate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(createddate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.createdby = ' . Yii::app()->user->id);
        }
        
        
        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();
        
        
         //here define the filter fields by exactly value
        $paramarr = array();

        //here define the filter fields by like values
        $paramarrLike = array('salesorderNumber LIKE :' => $this->salesorderNumber, 'quotationNumber LIKE :' => $this->quotationNumber, 
            'master_customer.mcussno LIKE :' => $this->mastercus_search, 'customer.cusnam LIKE :' => $this->customer_search,
            'quotation.quotecomments LIKE :' => $this->quoteComment_search, 'ws_user LIKE :' => $this->ws_user);

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }
        
        if (isset(Yii::app()->session['so_sts_qry']))
            unset(Yii::app()->session['so_sts_qry']);

        Yii::app()->session['so_sts_qry'] = $originalQuery;
        

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'quotationId desc',
            )
        ));
    }

    public function getCustomerLink() {

        $html = null;
        $customerText = $this->customer->cusnam;
        $customerContactName = '<br><div style="border-top:1px solid #C9E0ED;">' . $this->customer->cuscontact . '</div>';
        if (!empty($this->customer)) {
            if (Yii::app()->user->checkAccess('Customer.View') == true) {
                $html .= CHtml::link($customerText, array("customer/view", "id" => $this->customer->cussno), array("target" => "_blank")) . $customerContactName;
            } else {
                $html .= $customerText . $customerContactName;
            }

            if ($this->customer->status_id == 29) {
                $html .= "<br><span class='label label-important'>ACCOUNT ON HOLD</span>";
            }
        }

        return $html;
    }

    public function getMasterCustomerLink() {

        if (!empty($this->master)) {
            return CHtml::link($this->master->mcusnam, array("masterCustomer/view", "id" => $this->customer->master->mcuscus), array("target" => "_blank"));
        }

        return null;
    }

    protected function beforeSave() {

        $this->statusChangedBy = Yii::app()->user->id;
        $this->statusChangedDtm = date("Y-m-d g:i");


        return parent::beforeSave();
    }

    public $show_product_details = 0;
    public $show_custmz_details = 0;
    public $show_notes = 0;
    
    public function generatePDF($show_product_details, $show_custmz_details, $show_notes) {
        $model = $this;
        $this->show_product_details = $show_product_details;
        $this->show_custmz_details = $show_custmz_details;
        $this->show_notes = $show_notes;

        $sotype = 'ORDER CONFIRMATION';

//        if(in_array($model->status_id, array(2,6)) == true){
//            $sotype = 'ORDER CONFIRMATION';
//        }

        $slog = SalesLog::model()->find("comments = '$sotype PDF for ($model->salesorderNumber) is created'");

        if (empty($slog)) {

            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'Quotation', "$sotype PDF for ($model->salesorderNumber) is created", 1, 1, 1);
            SalesLog::createSalesLog($model->quotationId, $model->id, $model->quotationNumber, 'SalesOrder', "$sotype PDF for ($model->salesorderNumber) is created", 1, 1, 1);
        }


        $pdf = Yii::createComponent('application.extensions.tcpdf.How2PayPDF', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle(Yii::app()->name . " - {$sotype}");
        $pdf->SetSubject($sotype);
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();

//Write the html
//Convert the Html to a pdf document

        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;text-align:center;font-size:2em;">' . $sotype . '</td></tr>
                    <tr><td style="width:100%;text-align:center;font-size:2em;">' . $model->salesorderNumber . '</td></tr>    
                  </table><br/><br/>';

        $html .= '<table style="width:100%;">';
        $duedate = date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->dueDate));
        $showdueDate = '';
        if(!in_array($duedate, array('01-01-1970','31-12-1969','00-00-0000'))){
            $showdueDate = $duedate;
        }
        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:center;">Due Date : ' .$showdueDate . '</td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;">Quoatation Number : ' . $model->quotationNumber . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Date : ' . date(GlobalVars::get("DateFormat"), strtotime($model->createddate)) . '</td></tr>';

        $html .= '<tr><td colspan="2" style="width:100%;font-size:1.2em;text-align:left;">Customer : ' . (!empty($model->quotation->customer) ? $model->quotation->customer->cusnam : '' ) . ' </td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Address : ' . (!empty($model->quotation->customer) ? $model->quotation->customer->getFullAddress() : '' ) . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Customer PO# : ' . $model->customerpono . '</td></tr>';
        $productionCoordinator = '';
        if(!empty($model->prd_cordinator_id)){
            $usercoord = User::model()->findByPk($model->prd_cordinator_id);
            $productionCoordinator = $usercoord->username;
        }
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">E-mail :  ' . (!empty($model->quotation->customer) ? $model->quotation->customer->cusemail : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Production Coordinator : ' . ucwords($productionCoordinator) . '</td></tr>';
        
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Telephone :  ' . (!empty($model->quotation->customer) ? $model->quotation->customer->custel : '' ) . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Sales Person : ' . $model->ws_user . '</td></tr>';

        $html .= '</table><br/>';


        $html .= '<table style="width: 100%;height:100%;border:1px solid #000;padding:2px;">';
        $html .= '<tr style="width: 100%;background-color:#DDD;">
                    <td style="width: 100%;border:1px solid #000;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <th style="width: 5%;text-align: center;" >No</th>
                                <th style="width: 20%;text-align: center;">Product</th>
                                <th style="width: 30%;text-align: center;">Decoration</th>
                                <th style="width: 5%;text-align: center;">Qty</th>

                                <th style="width: 10%;text-align: center;">Price Ex GST</th>
                                <th style="width: 10%;text-align: center;">Price Inc GST</th>
                                <th style="width: 10%;text-align: center;">Total Ex GST</th>
                                <th style="width: 10%;text-align: center;">Total Inc GST</th>                             
                                
                            </tr>

                        </table>
                    </td>

                </tr>';


        $workorderdetailsList = Workorderdetails::model()->findAll(array('condition' => 'workorderId=:wrkOrdID', 'params' => array(':wrkOrdID' => $model->id)));


        $htmlbodyrows = '';

        foreach ($workorderdetailsList as $record) {
            $this->count++;
            $this->rowtype = $this->count % 2;
            $htmlbodyrows .= $this->getHtml($record);
        }

        $html .= $htmlbodyrows;



        $workoderDetails = new Workorderdetails();
        $workoderDetails->workorderId = $model->id;
        $html .= '<tr style="width: 100%;background-color:#CCC;">
                    <td style="width: 100%;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <td style="width: 5%;"></td>
                                <td style="width: 20%;"></td>
                                <td style="width: 30%;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>
                                <td style="width: 5%;text-align: center;"><div style="font-size: 1.2em; font-weight: bold; text-align: center;" id="totprodqty">  ' . $workoderDetails->getProdQtyTotal() . ' </div></td>

                                <td style="width: 10%;text-align: right;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellexvat">  ' . number_format($workoderDetails->getSellingPriceExVatTot(), 2) . '</div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totsellincvat">  ' . number_format($workoderDetails->getSellingPriceIncVatTot(), 2) . '</div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totexvattot">' . number_format($workoderDetails->getTotalSellPriExVatTot(), 2) . ' </div></td>
                                <td style="width: 10%;"><div style="font-size: 1.2em; font-weight: bold; text-align: right;" id="totinvattot"> ' . number_format($workoderDetails->getTotalSellPriIncVatTot(), 2) . '</div></td>
                                
                            </tr>
                        </table>
                    </td>


                </tr>';

        $html .= '</table>';


        $html .= '<br/><br/><br/><br/><table style="width:100%;" nobr="true">';

        $html .= '<tr>
                    <td style="width:100%;font-size:1.2em;border-bottom:1px solid #000;font-weight:bold;">SIGN OFF TERMS </td>                    
                  </tr>';
        $signofflogs = SignOffLog::model()->findAll(array('condition' => "model = 'SalesOrder' and model_id = '{$model->id}'", 'order' => 'id desc'));
        foreach ($signofflogs as $signoff) {
            $signoffterm = SignOffTerms::model()->findByPk($signoff->sign_off_id);
            
            $signofftexttoprint = '';
            if(!empty($signoff->sign_off_terms)){
                $signofftexttoprint = $signoff->sign_off_terms;
            }else if(!empty ($signoffterm)){
                $signofftexttoprint = $signoffterm->term;
            }
            $html .= '<tr >
                        <td style="width:100%;font-size:1.2em;">' . nl2br($signofftexttoprint) . '</td>                    
                      </tr><tr><td>&nbsp;</td></tr>';
        }



        $html .= '</table><br/>';
        $howtopayimgsrc =  Yii::app()->baseUrl . '/images/how_to_pay.jpg';
        $html .= '<table style="width:100%"><tr style="width:100%"><td style="width:100%"><img src="'.$howtopayimgsrc.'" /></td></tr></table>';

// data loading
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();

        $filename = time() . 'UID' . Yii::app()->user->id . '.pdf';
//Close and output PDF document
        $pdf->Output("files/{$filename}", 'F');

        $fileinventory = new FileInventory();
        $fileinventory->filename = $filename;
        $fileinventory->type = $this->SOInventoryType;
        $fileinventory->ref_id = $model->id;
        $fileinventory->createdBy = Yii::app()->user->id;
        $fileinventory->createdDtm = date("Y-m-d g:i");

        $fileinventory->save();

        return $fileinventory;
        //Yii::app()->end();
    }

    var $rowtype = 0;
    var $count = 0;

    private function getHtml($record) {

        $html = '';

        //$count = 0;


        //$productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));



        //$rowcolor = "background-color:#DDD;";

        $html .= '<tr style="width:100%;" nobr="true">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                <td style="width: 20%;"><div class="prodecs">';



        if (!empty($record->productsku)) {

            $html .= trim($record->productsku . '<br>' . $record->prdsrtdesc);
        } else {

            $html .= trim($record->custmproduct);
        }
        $html .= '</div>';



        $html .= '</td><td style="width: 30%;">';

        if (!empty($record->decdesc)) {

            $html .= $record->decdesc;
        } else {

            $html .= $record->customdecoration;
        }



        $html .= '</td>
                                <td style="width: 5%;text-align: center;">
                                    ' . $record->prodQty . '
                                </td>
                                
                                <td style="width: 10%;text-align: right;">
                                   ' . number_format($record->sellPriceExVat, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($record->sellPriceIncVat, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($record->totExVat, 2) . '
                                </td>
                                <td style="width: 10%;text-align: right;">
                                    ' . number_format($record->totIncVat, 2) . '
                                </td>                                
                                
                            </tr>';
        if ($this->show_product_details == 1) {
            $html .= '<tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">
                                            <tr style="width:100%;">
                                                <td style="width:100%;">
                                                    <table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:100%;text-align:center;font-weight:bold;" >Product Details</th>                                                            
                                                            
                                                        </tr>
                                                        <tr style="width:100%;">
                                                            <td style="width:20%;text-align:center;" ><img src="' . $record->getImg() . '" width="50" height="50"/></td>
                                                            <td style="width:80%;text-align:left;" ><p align="justify">' . $record->prdlngdesc . '</p></td>
                                                            
                                                        </tr>
                                                    </table>
                                                </td> 
                                            </tr>
                                        </table>
                                     </div>  
                                  </td>   
                            </tr> ';
        }

        
        if(count($workordersizeqtycolors) > 0 || (!empty($record->customizationDetails) || !empty($record->notes))){
        $html .= '<tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">
                                            <tr style="width:100%;">
                                                <td style="width:100%;">';
        
        if ((!empty($record->customizationDetails) || !empty($record->notes)) && ($this->show_custmz_details || $this->show_notes)) {
                //start of customization details section
                if ($this->show_custmz_details == true && $this->show_notes == true) {
                    $html .= '<table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:50%;text-align:center;" >Customization Details</th>
                                                            <th style="width:50%;text-align:center;" >Notes</th>                                                            
                                                            
                                                        </tr>
                                                        <tr style="width:100%;">
                                                            <td style="width:50%;text-align:center;" >' . $record->customizationDetails . '</td>
                                                            <td style="width:50%;text-align:center;" >' . $record->notes . '</td>                                                            
                                                        </tr>
                                                     </table>';
                } else {
                    $header = '';
                    $details = '';
                    if ($this->show_custmz_details == true) {
                        $header = 'Customization Details';
                        $details = $record->customizationDetails;
                    } else if ($this->show_notes == true) {
                        $header = 'Notes';
                        $details = $record->notes;
                    }
                    $html .= '<table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:100%;text-align:center;" >'.$header.'</th>                                                                                                                       
                                                            
                                                        </tr>
                                                        <tr style="width:100%;">
                                                            <td style="width:100%;text-align:center;" >' . $details . '</td>
                                                                                                                      
                                                        </tr>
                                                     </table>';
                }
                //end of customization details section
            }
          $html .=                               '</td> 
                                            </tr>
                                            <tr style="width:100%">
                                                <td style="width:100%">';
          if(count($workordersizeqtycolors) > 0){
        //start of size qty section
        
                                        $html .= '<div  style="width:100%;">
                                                        <table   style="width:100%;background-color:#ECFBD4;">
                                                            <tr style="width:100%;">
                                                                <th style="width:10%;text-align:center;">#</th>
                                                                <th style="width:30%;text-align:center;">Size</th>
                                                                <th style="width:30%;text-align:center;">Quantity</th>
                                                                <th style="width:30%;text-align:center;">Color</th>

                                                            </tr>';


                                        $countrow = 0;
                                        foreach ($workordersizeqtycolors as $row) {
                                            $countrow++;

                                                  $html .= '<tr style="width:100%;" >
                                                                <td style="width:10%;text-align:center;">' . $countrow . '</td>
                                                                <td style="width:30%;text-align:center;">' . $row['size'] . '</td>
                                                                <td style="width:30%;text-align:center;">' . $row['qty'] . '</td>
                                                                <td style="width:30%;text-align:center;">' . $row['color'] . '</td>
                                                    
                                                            </tr>';
                                         }

                                            $html .= ' </table>
                                                    </div>';
              //end of size qty section                   
          }
                                     $html .=    '</td></tr></table></div></td> </tr>';
        }
                                         
                              $html .=         '  </table>                        
                        </td>
                    </tr>';
                           
        return $html;
    }

    public function qtysizebreakdiffresult() {
        $isqtydiff = false;
        $sizediffIdArr = array();
        $workorderdtls = Workorderdetails::model()->findAll(array('condition' => "workorderId = '{$this->id}'"));

        foreach ($workorderdtls as $dtl) {
            $workorderdtlsizebrks = Workorderdetailssizecolor::model()->findAll(array('condition' => "workOrderDetailsId = '{$dtl->id}'"));
            $sizebrkqtytotal = 0;
            foreach ($workorderdtlsizebrks as $sizebrk) {
                $sizebrkqtytotal += $sizebrk->qty;
            }

            if ($sizebrkqtytotal <> $dtl->prodQty) {
                $isqtydiff = true;
                $sizediffIdArr[] = $dtl->id;
            }
        }

        $resultarr = array();
        $resultarr['isQtyDiff'] = $isqtydiff;
        $resultarr['WrkOrdDtlIds'] = $sizediffIdArr;

        return $resultarr;
    }

    public function allowtocomfirm() {
        $allow = false;
        if (!in_array($this->status_id, array(2, 3, 4, 5, 6))) {
            $allow = true;
        }

//        $diffresult = $this->qtysizebreakdiffresult();
//        if ($diffresult['isQtyDiff'] == true) {
//            $allow = false;
//        }

        return $allow;
    }
    
    public static function getSOBetween($iniDate, $endDate){
        $criteria = new CDbCriteria;
        if (!User::isAdmin()) {
            $criteria->addCondition('createdby = ' . Yii::app()->user->id);
        }
        
        $criteria->addCondition("DATE_FORMAT(createddate, '%Y-%m-%d') between '{$iniDate}' and '{$endDate}'");
        $workorder = Workorder::model()->findAll($criteria);
        return $workorder;
    }
    
    public function getSONumberWithJobLink(){
        $job = Jobs::model()->find(array('condition'=>"workorder_id = '{$this->id}'"));
        if(!empty($job)){
            $html = $this->salesorderNumber . '<br>';
            $html .= '<div style="width:100%;background-color:#0f0;">'.CHtml::link($job->jobNum,array("jobs/view","id"=>$job->id)).'</div>';
            return $html;
        }
        else return $this->salesorderNumber;
    }
    
	public function getCancelStatusText()
	{
		if($this->status_id != 3) {
			return '';
		}
		 return  '<br><span class="label label-important" title="Cancelled Sales Order">CANCELLED</span>';
	}
    
    public function createJob() {

        $allsaved = true;
        


        $job = new Jobs();
        $job->workorder_id = $this->id;
        $job->quote_id = $this->quotation->id;
        $job->quoteNum = $this->quotation->quoteno;
        $job->jobNum = 'JOB-' . $this->quotation->quoteno . '-' . $this->id;
        $job->jobname = $this->quotation->quotename;
        $job->cus_fref = $this->quotation->cus_fref;
        $job->mastercusno = $this->quotation->customer?$this->quotation->customer->cusmcussno:null;
        $job->createdDtm = date('Y-m-d H:i:s');
        $job->user_id = Yii::app()->user->id;
        $job->urgent_status = 20;
        $job->status_id = 1; //New
        $job->ws_user = $this->ws_user;
        $job->ws_user_id = $this->ws_user_id;
        $job->prd_cordinator_id = $this->prd_cordinator_id;
        $job->customerpono = $this->customerpono;
        $job->orderTypeId = $this->orderTypeId;

        if ($job->save()) {

            $wrkorderdtls = Workorderdetails::model()->findAll("workorderId = '$job->workorder_id'");

            foreach ($wrkorderdtls as $dtl) {
                if (!empty($dtl->productsku) || !empty($dtl->prdsrtdesc) || !empty($dtl->prdlngdesc)) {
                    $job_product = new JobProducts();
                    $job_product->job_id = $job->id;
                    $job_product->workorderDtl_id = $dtl->id;
                    $job_product->qty = $dtl->prodQty;
                    $job_product->prodCostPrice = $dtl->prodCostPrice;
                    $job_product->status_id = 1; //New
                    $job_product->user_id = Yii::app()->user->id;

                    if($job_product->save()){
                        //success
                    }else{
                        $allsaved = false;
                    }
                    
                }

                if (!empty($dtl->decprtnam) || !empty($dtl->decdesc)) {
                    $job_decoration = new JobDecorations();
                    $job_decoration->job_id = $job->id;
                    $job_decoration->workorderDtl_id = $dtl->id;
                    $job_decoration->decprtnam = $dtl->decprtnam;
                    $job_decoration->decdesc = $dtl->decdesc;
                    $job_decoration->customdecoration = $dtl->customdecoration;
                    $job_decoration->decoQty = $dtl->decoQty;
                    $job_decoration->decoCostPrice = $dtl->decoCostPrice;
                    $job_decoration->decosupref = $dtl->decosupref;
                    $job_decoration->customizationDetails = $dtl->customizationDetails;
                    $job_decoration->status_id = 1; //New
                    $job_decoration->user_id = Yii::app()->user->id;
                    $job_decoration->createdDtm = date('Y-m-d H:i:s a');
                    if($job_decoration->save()){
                        //success
                    }else{
                       $allsaved = false;
                    }
                    

                    $job_product_decoration = new JobProductDecorations();
                    $job_product_decoration->job_id = $job->id;
                    $job_product_decoration->workorderDtl_id = $dtl->id;
                    $job_product_decoration->decprtnam = $dtl->decprtnam;
                    $job_product_decoration->decdesc = $dtl->decdesc;
                    $job_product_decoration->customdecoration = $dtl->customdecoration;
                    $job_product_decoration->decoQty = $dtl->decoQty;
                    $job_product_decoration->decoCostPrice = $dtl->decoCostPrice;
                    $job_product_decoration->decosupref = $dtl->decosupref;
                    $job_product_decoration->customizationDetails = $dtl->customizationDetails;
                    $job_product_decoration->user_id = Yii::app()->user->id;
                    $job_product_decoration->status_id = 1; //New
                    
                    if($job_product_decoration->save()){
                        //success
                    }else{
                       $allsaved = false;
                    }
                    
                }
            }
        } else {
            $allsaved = false;
        }


        if ($allsaved == true) {
           
            return $job;
        } else {
            
            return null;
        }
    }
    
    public function getFollowupStatus() {
        $slog = SalesLog::model()->find(array('condition' => "category = 'SalesOrder' and tbl_id = {$this->id} and followupSts_id > 0", 'order' => "id desc"));
        if (!empty($slog)) {
            return FollowupStatus::model()->findByPk($slog->followupSts_id)->status;
        } else {
            return null;
        }
    }
    
    public function getFollowupStatusId() {
        $slog = SalesLog::model()->find(array('condition' => "category = 'SalesOrder' and tbl_id = {$this->id} and followupSts_id > 0", 'order' => "id desc"));
        if (!empty($slog)) {
            return $slog->followupSts_id;
        } else {
            return 0;
        }
    }
    
    public function getTotalWithoutGST() {
        $sql = "select sum(sellPriceExVat * prodQty) as totalExGST from workorderdetails where workorderId = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalExGST'];
    }
    
    
    public function getItemCosts() {
        $total = 0;
        foreach ($this->RelDtls as $dtl) {
            $total += ($dtl->getItemCost() * $dtl->prodQty);
        }
        
        return $total;
    }
    
    public function getGrossProfit() {
        return ($this->getTotalWithoutGST() - $this->getItemCosts());
    }
    
    public function getGrossProfitMarginPercentage() {
        $gpPercentage = ($this->getGrossProfit() * 100 / ($this->getTotalWithoutGST() ? $this->getTotalWithoutGST() : 1));
        return round($gpPercentage,2);
    }
	
	/**
	 * Generate online acceptance link for the quote
	 * @return string quote acceptance link
	 */
	public function generateOnlineAcceptLink()
	{	
		
		$linkSecret = AcceptanceLinkStringGenerator::randomString();
		$acceptURL = Yii::app()->createAbsoluteUrl('workOrderAccept/index&id=' . $linkSecret, array(), 'http');
		
		$logId = WorkorderOnlineAcceptenceLog::write(array(
			'workorder_id' => $this->id,
			'link_secret' => $linkSecret,
			'link_expire_in' => date('Y-m-d H:i:s', time() + (3600*24*7)), // expire in 7 days
			'link_active' => WorkorderOnlineAcceptenceLog::LINK_STATUS_ACTIVE,
			'status_id' => WorkorderOnlineAcceptenceLog::LOG_STATUS_LINK_GENERATED,
			'accept_url' => $acceptURL
		));
		
		$this->so_online_acceptence_log_id = $logId;
		$this->save();
		
		return $acceptURL;
	}
	
	public function updateFollowUpStatusByOnlineAcceptance(int $status)
	{

		$systemOptions = SystemOptions::getOptions();
		switch ($status) {

			case WorkorderOnlineAcceptenceLog::LOG_STATUS_SENT:
				$this->followupStatus = intval($systemOptions->soAcceptanceLinkSent);
				$this->status_id = Status::SYS_STATUS_PENDING_APPROVAL;
				break;
			case WorkorderOnlineAcceptenceLog::LOG_STATUS_ACCEPT:
				$this->followupStatus = intval($systemOptions->soAcceptanceLinkAccept);
				$this->status_id = Status::SYS_STATUS_CONFIRMED;
				break;
			case WorkorderOnlineAcceptenceLog::LOG_STATUS_DECLINE:
				$this->followupStatus = intval($systemOptions->soAcceptanceLinkDecline);
				$this->status_id = Status::SYS_STATUS_CANCELLED;
				break;
		}
	}
	
	public static function getSOCountOfQuote($quoteId)
	{	
		
		$sql = "SELECT COUNT(id)  totalSOCount from workorder where quotationId = {$quoteId}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalSOCount'];
		
	}
        
        public function recalculateLineTotals() {
        $soDetails = Workorderdetails::model()->findAll(array('condition' => "workorderId = {$this->id}"));
        
        foreach ($soDetails as $data) {
            $data->recalculateLineTotal();
        }
    }
        
}