<?php

/**
 * This is the model class for table "workorderdetails".
 *
 * The followings are the available columns in table 'workorderdetails':
 * @property integer $id
 * @property integer $workorderId
 * @property integer $linetypeId
 * @property string $productsku
 * @property string $decprtnam
 * @property string $customdecoration
 * @property integer $prodQty
 * @property integer $decoQty
 * @property string $customizationDetails
 * @property string $notes
 * @property string $extracomments
 * @property double $sellPriceExVat
 * @property double $sellPriceIncVat
 * @property double $totExVat
 * @property double $totIncVat
 * @property string $image
 * @property integer $createdby
 * @property string $createddate
 * @property integer $lineOrder order of detail lines
 * @property string $product_source
 * @property integer $hide_on_pdf
 * @property integer $gstRate
 * @property bool $customer_accepted
 */
class Workorderdetails extends CActiveRecord {

    const LINE_TYPE_PRODUCT = 1;
    const LINE_TYPE_NOTE = 2;

    public $pdlsno;
    public $decsno;
    public $myob_income_acc_id;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Workorderdetails the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'workorderdetails';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('workorderId, linetypeId, prodQty, decoQty, createdby, updateBy, pdlsno, decsno, lineOrder, lockSellPrice, myob_income_acc_id', 'numerical', 'integerOnly' => true),
            array('sellPriceExVat, sellPriceIncVat, totExVat, totIncVat, hide_on_pdf, gstRate, customer_accepted', 'numerical'),
            array('productsku,custmproduct, decprtnam, customdecoration', 'length', 'max' => 255),
            array('createddate,prdlngdesc,decdesc,updateDtm, image, customizationDetails, notes, extracomments, product_source', 'safe'),
            array('prodsupref,decosupref,prdsrtdesc', 'length', 'max' => 255),
            array('prodCostPrice,decoCostPrice,sellPriceExVat,sellPriceIncVat,totExVat,totIncVat, '
                . 'exGSTRoundLoss, incGSTRoundLoss, totExGSTRoundLoss, totIncGSTRoundLoss, prod_discount_pcntg, '
                . 'prod_supmarg, deco_supmarg, logo_setup_charge, prod_usd_freight, system_freight, other_cost, other_cost_markup_rate,'
                . 'productFrieghtUnitCost, productFrieghtMarkUpRate,productFrieghtUnitCostWithMarkup,logoSetupMarkupRate,logoSetupUnitCost,logoSetupUnitCostWithMarkup, '
                . 'supmargPercentage, productFrieghtMarkUpPercentage, otherCostMarkupPercentage, systemFreightPercentage', 'type', 'type' => 'float'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, workorderId, linetypeId, decprtnam, productsku, customdecoration, prodQty, decoQty, costprice, 
                customizationDetails, notes, extracomments, sellPriceExVat, sellPriceIncVat, totExVat, totIncVat, image, 
                createdby, createddate, prdlngdesc, decdesc', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'workorder' => array(self::BELONGS_TO, 'Workorder', 'workorderId'),
            'prodSupp' => array(self::BELONGS_TO, 'Supplier', '', 'foreignKey' => array('prodsupref' => 'supsup_fref')),
            'decoSupp' => array(self::BELONGS_TO, 'Supplier', '', 'foreignKey' => array('decosupref' => 'supsup_fref')),
            'product' => array(self::BELONGS_TO, 'ProductLine', '', 'foreignKey' => array('productsku' => 'pdlpdl')),
            'decoRel' => array(self::BELONGS_TO, 'Decoration', '', 'foreignKey' => array('decprtnam' => 'decprtnam')),
        );
    }

    public function rel_multi_deco() {
        return WorkorderDetailsDecoration::model()->findAll(array('condition' => "workorder_detail_id = {$this->id}"));
    }

    public function rel_other_costs() {
        return WorkorderOtherCost::model()->findAll(array('condition' => "workorder_detail_id = {$this->id}"));
    }

    public function rel_size_qty_colors() {
        return Workorderdetailssizecolor::model()->findAll(array('condition' => "workOrderDetailsId = {$this->id}"));
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'workorderId' => 'Workorder',
            'linetypeId' => 'Linetype',
            'productsku' => 'Product',
            'prdsrtdesc' => 'Product',
            'custmproduct' => 'Custom Product',
            'decprtnam' => 'Decoration',
            'decdesc' => 'Decoration Name',
            'customdecoration' => 'Custom Decoration',
            'prodQty' => 'Product Quantity',
            'prodCostPrice' => 'Product Cost Price',
            'decoQty' => 'Decoration Quantity',
            'decoCostPrice' => 'Decoration Cost Price',
            'customizationDetails' => 'Customization Details',
            'notes' => 'Notes',
            'extracomments' => 'Extracomments',
            'sellPriceExVat' => 'Selling Price Excluding GST',
            'sellPriceIncVat' => 'Selling Price Including GST',
            'totExVat' => 'Totatl Excluding GST',
            'totIncVat' => 'Totatl Including GST',
            'image' => 'Image',
            'createdby' => 'Createdby',
            'createddate' => 'Createddate',
            'prdsrtdesc' => 'Product Name',
            'prdlngdesc' => 'Product Description',
            'other_cost' => 'Other Cost',
            'lineOrder' => 'Line Order',
            'xero_account_id' => 'Xero Account',
            'systemTaxRateId' => 'Tax Rate',
            'product_source' => 'Product Source',
            'hide_on_pdf' => 'Hide on PDF'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('workorderId', $this->workorderId);
        $criteria->compare('linetypeId', $this->linetypeId);
        $criteria->compare('productsku', $this->productsku);

        $criteria->compare('customdecoration', $this->customdecoration, true);
        $criteria->compare('prodQty', $this->prodQty);
        $criteria->compare('decoQty', $this->decoQty);
        $criteria->compare('customizationDetails', $this->customizationDetails, true);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('extracomments', $this->extracomments, true);
        $criteria->compare('sellPriceExVat', $this->sellPriceExVat);
        $criteria->compare('sellPriceIncVat', $this->sellPriceIncVat);
        $criteria->compare('totExVat', $this->totExVat);
        $criteria->compare('totIncVat', $this->totIncVat);
        $criteria->compare('image', $this->image, true);
        $criteria->compare('createdby', $this->createdby);
        $criteria->compare('createddate', $this->createddate, true);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.lineOrder ASC',
            )
        ));
    }

    public function searchForInvoice() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('workorderId', $this->workorderId);
        $criteria->compare('linetypeId', $this->linetypeId);
        $criteria->compare('productsku', $this->productsku);

        $criteria->compare('customdecoration', $this->customdecoration, true);
        $criteria->compare('prodQty', $this->prodQty);
        $criteria->compare('decoQty', $this->decoQty);
        $criteria->compare('customizationDetails', $this->customizationDetails, true);
        $criteria->compare('notes', $this->notes, true);
        $criteria->compare('extracomments', $this->extracomments, true);
        $criteria->compare('sellPriceExVat', $this->sellPriceExVat);
        $criteria->compare('sellPriceIncVat', $this->sellPriceIncVat);
        $criteria->compare('totExVat', $this->totExVat);
        $criteria->compare('totIncVat', $this->totIncVat);
        $criteria->compare('image', $this->image, true);
        $criteria->compare('createdby', $this->createdby);
        $criteria->compare('createddate', $this->createddate, true);

        $invoiceDetails = InvoiceDetail::model()->findAll("workorder_id = $this->workorderId");

        $exsitingIds = array();
        foreach ($invoiceDetails as $invdtl) {
            $exsitingIds[] = $invdtl->wrkorderDtl_id;
        }

        $criteria->addNotInCondition("id", $exsitingIds);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.lineOrder ASC',
            )
        ));
    }

    public function getProdQtyTotal() {
        $sql = "select sum(prodQty) as totalQty from workorderdetails where workorderId = '$this->workorderId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalQty'];
    }

    public function getDecorationQtyTotal() {
        $sql = "select sum(decoQty) as totalQty from workorderdetails where workorderId = '$this->workorderId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalQty'];
    }

    public function getSellingPriceExVatTot() {
        $sql = "select sum(sellPriceExVat) as sellExVat from workorderdetails where workorderId = '$this->workorderId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellExVat'];
    }

    public function getSellingPriceIncVatTot() {
        $sql = "select sum(sellPriceIncVat) as sellIncVat from workorderdetails where workorderId = '$this->workorderId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellIncVat'];
    }

    public function getTotalSellPriExVatTot() {
        $sql = "select sum(totExVat) as sellTotExVat from workorderdetails where workorderId = '$this->workorderId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellTotExVat'];
    }

    public function getTotalSellPriIncVatTot() {
        $sql = "select sum(totIncVat) as sellTotIncVat from workorderdetails where workorderId = '$this->workorderId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellTotIncVat'];
    }

    public function getRoundingLossTotal($fieldname) {
        $sql = "select sum($fieldname) as roundingLossTotal from workorderdetails where workorderId = '$this->workorderId'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return number_format($result['roundingLossTotal'], 4);
    }

    public function getDecoCostTotal() {

        $sql = "select sum(cost_price) as totalDecoCost from workorder_details_decorations where workorder_detail_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalDecoCost'];
    }

    public function getDecoMarkedPriceTotal() {

        $sql = "select (CASE WHEN SUM(sup_markedup_price) IS NULL OR SUM(sup_markedup_price) = 0 THEN (SUM(cost_price) * AVG(sup_margin)) ELSE SUM(sup_markedup_price) END) AS totalMarkedUpPrice from workorder_details_decorations where workorder_detail_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalMarkedUpPrice'];
    }

    public function getDecoLogoSetUpUnitCostTotal() {

        $sql = "select sum(logo_setup_unit_price) as totalLogoSetUpUnitPrice from workorder_details_decorations where workorder_detail_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalLogoSetUpUnitPrice'];
    }

    public function getDecoLogoSetUpUnitMarkedUpTotal() {

        $sql = "select sum(logo_setup_unit_markedup_price) as totalSetUpMarkedUpPrice from workorder_details_decorations where workorder_detail_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['totalSetUpMarkedUpPrice'];
    }

    public function getOtherCostTotal() {

        return $this->other_cost;
    }

    //cost per item
    public function getItemCost() {
        $productCost = $this->prodCostPrice;
        $decoCost = $this->getDecoCostTotal();
        $otherCost = $this->getOtherCostTotal();
        $logoSetUpCost = $this->getDecoLogoSetUpUnitCostTotal();

        return ($productCost + $decoCost + $otherCost + $logoSetUpCost);
    }

    protected function beforeSave() {

        try {
            //this can be failed when run in console ( command ) mode
            $this->updateBy = Yii::app()->user->id;
        } catch (Exception $ex) {
            
        }
        $this->updateDtm = date("Y-m-d g:i");


        return parent::beforeSave();
    }

    public function getSizeQtyColorTable() {
        $sizeqtycolors = Workorderdetailssizecolor::model()
                ->findAll(array('condition' => 'workOrderDetailsId=:wrkOrdDtlID', 'params' => array(':wrkOrdDtlID' => $this->id)));
        $html = "<div><table>";
        $html .= "<tr><th>Size</th><th>Qty</th><th>Color</th></tr>";

        foreach ($sizeqtycolors as $row) {
            $html .= "<tr><td style='text-align:center'>{$row['size']}</td><td style='text-align:center'>{$row['qty']}</td><td style='text-align:center'>{$row['color']}</td></tr>";
        }


        $html .= "</table></div>";
        return $html;
    }

    public function getCustomizationDetail() {
        $html = "<div><table>";
        $html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Customization Details</th></tr>";

        if (!empty($this->customizationDetails)) {
            $html .= "<tr><td style='text-align:center'>{$this->customizationDetails}</td></tr>";
        } else {
            $html .= "<tr><td style='text-align:center'>--empty--</td></tr>";
        }


        $html .= "</table></div>";
        return $html;
    }

    public function getCustomerAcceptedString() {
        if ($this->customer_accepted) {
            return '<p style="color:green;font-weight:bold;">Customer Accepted</p>';
        }

        return '';
    }

    public function getProductColumnHtml() {
        $html = '';
        if (!empty($this->productsku) && !empty($this->product)) {
            $html .= CHtml::link($this->productsku, array("productLine/view", "id" => $this->product->pdlsno), array("target" => "_blank", 'title' => "click here to see full product spec"));
        }
        // if(!empty($this->productsku)){
        $html .= " <br> " . $this->prdsrtdesc . $this->getProdSupplierLink();
        //}else{
        //$html = $this->custmproduct . $this->getProdSupplierLink();
        //}
        return $html;
    }

    public function getProductNameAndDescriptionHtml() {
        $html = '';

        $html .= CHtml::link($this->productsku, array("productLine/view", "id" => $this->product->pdlsno), array("target" => "_blank", 'title' => "click here to see full product spec"));


        $html .= " <br> " . $this->prdsrtdesc;
        $html .= " <br> " . $this->prdlngdesc . $this->getSizeQtyColorTable();

        return $html;
    }

    public function getProdSupplierLink() {

        $html = "<div><table>";
        $html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Supplier</th></tr>";
        $html .= "<tr><td style='text-align:center'>" . CHtml::link($this->product->supplier->supnam, array('supplier/view', 'id' => $this->product->supplier->supsno)) . "</td></tr>";
        $html .= "</table></div>";

        return $html;
    }

    public function getDecorationColumnHtml() {
        $html = '';
        if (!empty($this->decprtnam) && !empty($this->decoRel)) {

            $html .= CHtml::link(strtoupper($this->decprtnam), array("decoration/view", "id" => $this->decoRel->decsno), array("target" => "_blank", 'title' => "click here to see full decoration spec"));
        }



        return $html;
    }

    public function getDecoSupplierLink() {
        $html = "<div><table>";
        $html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Supplier</th></tr>";
        $html .= "<tr><td style='text-align:center'>" . CHtml::link($this->decoSupp->supnam, array('supplier/view', 'id' => $this->decoSupp->supsno)) . "</td></tr>";
        $html .= "</table></div>";

        return $html;
    }

    public function getJobActivityFlow($type) {
        $flowstr = '';
        $lastactivity = '';
        $artworkdtl = null;
        $artworkPO = null;

        $job = Jobs::model()->find("workorder_id = '{$this->workorderId}'");

        $flows = JobActivityFlow::model()->findAll(
                array('condition' => 'wrkorderDtl_id=:wrkOrderDtlID and type=:type',
                    'params' => array(':wrkOrderDtlID' => $this->id, ':type' => $type)));

        $flowstr .= '<ul style="font-size:0.9em;">';

        foreach ($flows as $flow) {

            if ($type == 'Product') {


                $jobproduct = JobProducts::model()->find("job_id = '{$flow->job_id}' and workorderDtl_id = '{$flow->wrkorderDtl_id}'");
                $po = PurchaseOrders::model()->findByPk($jobproduct->po_id);
                if ($flow->activity == 'PO Created') {
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $po->id)) . '">' . $po->poNum . '</a>)</li>';
                } else if ($flow->activity == 'Goods Received') {
                    $grn = GoodsReceived::model()->find("grnType = 'Product' and po_id = '{$po->id}'");
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
                } else {
                    $flowstr .= '<li >' . $flow->activity . '</li>';
                }
            } else if ($type == 'Decoration') {
                if ($flow->activity == 'Artwork Processing') {
                    $artworkdtl = InternalJobsDetails::model()->find("wrkorder_id = '{$flow->wrkorder_id}' and wrkordrDtl_id = '{$flow->wrkorderDtl_id}'");
                    $interjob = InternalJobs::model()->findByPk($artworkdtl->internalJob_id);
                    $flowstr .= '<li >' . $flow->activity . '<br> <a href="' . Yii::app()->createUrl("internalJobs/view", array("id" => $artworkdtl->internalJob_id)) . '">(' . $interjob->interjobnum . ')</a></li>';
                } else if ($flow->activity == 'Artwork Done') {
                    $artworkdtl = InternalJobsDetails::model()->find("wrkorder_id = '{$flow->wrkorder_id}' and wrkordrDtl_id = '{$flow->wrkorderDtl_id}'");
                    $artworkinventory = InventoryArtWork::model()->find("internaljob_id = '{$artworkdtl->internalJob_id}'");
                    $flowstr .= '<li ><a href="' . Yii::app()->createUrl("inventoryArtWork/view", array("id" => $artworkinventory->id)) . '">' . $flow->activity . '(' . $artworkinventory->artworkcode . ')</a></li>';
                } else if ($flow->activity == 'PO Emb Tape') {
                    if (!empty($artworkdtl))
                        $inventoryArtwrk = InventoryArtWork::model()->find("internaljob_id = '{$artworkdtl->internalJob_id}'");
                    else if (!empty($artworkPO)) {
                        $inventoryArtwrk = InventoryArtWork::model()->find("po_id = '{$artworkPO->id}'");
                    }

                    $po = PurchaseOrders::model()->findByPk($inventoryArtwrk->embrTapePo_id);
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $po->id)) . '">' . $po->poNum . '</a>)</li>';
                } else if ($flow->activity == 'Emb Tape Received') {

                    $inventoryArtwrk = InventoryArtWork::model()->find("internaljob_id = '{$artworkdtl->internalJob_id}'");
                    if (empty($inventoryArtwrk)) {
                        $inventoryArtwrk = InventoryArtWork::model()->find("po_id = '{$artworkPO->id}'");
                    }
                    $grn = GoodsReceived::model()->findByPk($inventoryArtwrk->grn_id);
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
                } else if ($flow->activity == 'Artwork PO Created') {
                    $jobdecoration = JobDecorations::model()->find("workorderDtl_id = '$flow->wrkorderDtl_id' and decoJobType = 'Purchase Artwork'");
                    $po = PurchaseOrders::model()->findByPk($jobdecoration->po_id);
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $po->id)) . '">' . $po->poNum . '</a>)</li>';
                } else if ($flow->activity == 'Artwork Received') {

                    $jobdecoration = JobDecorations::model()->find("workorderDtl_id = '$flow->wrkorderDtl_id' and decoJobType = 'Purchase Artwork'");
                    $artworkPO = PurchaseOrders::model()->findByPk($jobdecoration->po_id);
                    $inventoryArtwrk = InventoryArtWork::model()->find("po_id = '{$artworkPO->id}'");


                    $grn = GoodsReceived::model()->find("job_id = '{$flow->job_id}' and wrkorder_id = '{$flow->wrkorder_id}' and po_id = '{$jobdecoration->po_id}'");

                    $flowstr .= '<li >' . $flow->activity . '<br>(<a href="' . Yii::app()->createUrl("inventoryArtWork/view", array("id" => $inventoryArtwrk->id)) . '">' . $inventoryArtwrk->artworkcode . '</a>) - (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
                } else if ($flow->activity == 'Artwork Allocated') {

                    $jobdecoration = JobDecorations::model()->find("workorderDtl_id = '$flow->wrkorderDtl_id' and decoJobType = 'Inventory Artwork'");
                    $artwork = InventoryArtWork::model()->findByPk($jobdecoration->artwork_id);
                    $flowstr .= '<li ><a href="' . Yii::app()->createUrl("inventoryArtWork/view", array("id" => $artwork->id)) . '">' . $flow->activity . '<br>(' . $artwork->artworkcode . ')</a></li>';
                } else {
                    if ($flow->activity != 'Job End')
                        $flowstr .= '<li >' . $flow->activity . '</li>';
                }
            } else if ($type == 'Product-Decoration') {
                if ($flow->activity == 'PO Created') {
                    $jobproddeco = JobProductDecorations::model()->find("job_id = '{$flow->job_id}' and workorderDtl_id = '{$flow->wrkorderDtl_id}'");
                    $po = PurchaseOrders::model()->findByPk($jobproddeco->po_id);
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $po->id)) . '">' . $po->poNum . '</a>)</li>';
                } else if ($flow->activity == 'GIN Created') {
                    $jobproddeco = JobProductDecorations::model()->find("job_id = '{$flow->job_id}' and workorderDtl_id = '{$flow->wrkorderDtl_id}'");
                    $po = PurchaseOrders::model()->findByPk($jobproddeco->po_id);
                    $gin = GoodsIssueNote::model()->find("job_id = '{$flow->job_id}' and po_id = '{$po->id}'");
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsIssueNote/view", array("id" => $gin->id)) . '">' . $gin->ginnum . '</a>)</li>';
                } else if ($flow->activity == 'Goods Received') {
                    $jobproddeco = JobProductDecorations::model()->find("job_id = '{$flow->job_id}' and workorderDtl_id = '{$flow->wrkorderDtl_id}'");
                    $po = PurchaseOrders::model()->findByPk($jobproddeco->po_id);
                    $grn = GoodsReceived::model()->find("grnType = 'Product-Decoration' and po_id = '{$po->id}'");
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
                } else {
                    if ($flow->activity != 'Job End')
                        $flowstr .= '<li >' . $flow->activity . '</li>';
                }
            } else {
                $flowstr .= '<li >' . $flow->activity . '</li>';
            }


            $lastactivity = $flow->activity;
        }



        if ($type == 'Product' && $lastactivity == '') {
            $flowstr .= '<li >Next &#187; Create PO</li>';
        }

        if ($type == 'Decoration' && $lastactivity == '') {
            $flowstr .= '<li >Next &#187; <br>Create Artwork<br>Use Exist Artwork<br>Purchase Artwork</li>';
        }

        if ($type == 'Product-Decoration' && $lastactivity == '') {
            $flowstr .= '<li >Next &#187; Create PO For Product-Decoration</li>';
        }

        if (in_array($lastactivity, array('PO Created', 'Artwork PO Created')) && $type != 'Product-Decoration') {

            if ($lastactivity == 'Artwork PO Created') {
                $jobdecoration = JobDecorations::model()->find("isInternalJob = '0' and workorderDtl_id = '{$this->id}'");
                $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $jobdecoration->po_id)) . '">Goods Receive</a></li>';
            } else {
                $jobproduct = JobProducts::model()->find("workorderDtl_id = '{$this->id}'");
                $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $jobproduct->po_id)) . '">Goods Receive</a></li>';
            }
        }


        if ($lastactivity == 'PO Created' && $type == 'Product-Decoration') {
            $jobproddeco = JobProductDecorations::model()->find("job_id = '{$job->id}' and workorderDtl_id = '{$this->id}'");
            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsIssueNote/create", array("po_id" => $jobproddeco->po_id)) . '">Goods Issue</a></li>';
        }


        if ($lastactivity == 'GIN Created' && $type == 'Product-Decoration') {
            $jobproddeco = JobProductDecorations::model()->find("job_id = '{$job->id}' and workorderDtl_id = '{$this->id}'");
            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $jobproddeco->po_id)) . '">Goods Receive</a></li>';
        }


        if ($lastactivity == 'Artwork Created') {
            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("internalJobs/view", array("id" => $artworkdtl->internalJob_id)) . '">Job Complete</a></li>';
        }

        if (in_array($lastactivity, array('Artwork Done', 'Artwork Received'))) {

            $inventory_id = null;
            if (!empty($artworkdtl)) {
                $artworkinventory = InventoryArtWork::model()->find("internaljob_id = '{$artworkdtl->internalJob_id}'");
                $inventory_id = $artworkinventory->id;
            } else if (!empty($artworkPO)) {
                $artworkinventory = InventoryArtWork::model()->find("po_id = '{$artworkPO->id}'");
                $inventory_id = $artworkinventory->id;
            }

            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("purchaseOrders/createEmbTapePO", array("id" => $inventory_id, "type" => "po_emb_tape")) . '">Purchase Embroidery Tape</a></li>';
            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobs/endDecoration", array("job_id" => $job->id, "wodtls_id" => $this->id)) . '">End Job</a></li>';
        }



        if ($lastactivity == 'PO Emb Tape') {
            $pos = PurchaseOrders::model()->findAll("job_id = '{$job->id}' and poType = 'Purchase  Embroidery Tape' ");
            $po_id = null;
            foreach ($pos as $po) {
                $podtl = PurchaseOrderDetails::model()->find("po_id = '{$po->id}' and workorderDtl_id = '{$this->id}'");
                if (!empty($podtl)) {
                    $po_id = $po->id;
                    break;
                }
            }
            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $po_id)) . '">Receive Embroidery Tape</a></li>';
        }

        if (in_array($lastactivity, array('Emb Tape Received', 'Job End', 'Artwork Allocated'))) {
            $flowstr .= '<li >&#187;End</li>';
        }

        if (in_array($type, array('Product', 'Product-Decoration')) && $lastactivity == 'Goods Received')
            $flowstr .= '<li >&#187;End</li>';

        $flowstr .= '</ul>';

        return $flowstr;
    }

    public function getImg() {
        $return_img = null;
        if ($this->image) {

            if (strpos($this->image, 'http:') !== false || strpos($this->image, 'https:') !== false) {

                return $this->image;
            } else {
                if (is_file('images/product_img/' . $this->image)) {
                    return 'images/product_img/' . $this->image;
                } else {

                    $gloablaResource = GlobalVars::get(GlobalVars::PRODUCT_IMAGE_SOURCE) . $this->product->supplier->supsup_fref . '/' . $this->image;
                    if ($this->is_url_exist($gloablaResource)) {
                        return $gloablaResource;
                    }
                }
            }
        }

        if ($this->image) {
            $quotedtl = QuatationDetails::model()->find(array("condition" => "productsku = '{$this->productsku}'"));

            if ($quotedtl) {
                if ($quotedtl->productimg) {
                    if (strpos($quotedtl->productimg, 'http:') !== false) {
                        if ($this->is_url_exist($quotedtl->productimg)) {
                            $return_img = $quotedtl->productimg;
                        }
                    } else if (strpos($quotedtl->productimg, 'https:') !== false) {
                        if ($this->is_url_exist($quotedtl->productimg)) {
                            $return_img = $quotedtl->productimg;
                        }
                    } else {
                        if (file_exists('images/product_img/' . $quotedtl->productimg)) {
                            $return_img = 'images/product_img/' . $quotedtl->productimg;
                        } else {
                            $return_img = null;
                        }
                    }
                }
            }
        }

        if (!$return_img) {
            $productline = ProductLine::model()->find(array("condition" => "pdlpdl = '{$this->productsku}'"));
            if ($productline) {
                $return_img = $productline->getImg();
            }
        }

        return $return_img;
    }

    function is_url_exist($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_NOBODY, true);
        curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if ($code == 200) {
            $status = true;
        } else {
            $status = false;
        }
        curl_close($ch);
        return $status;
        return true;
    }

    public function qtyDiff() {
        $sizeqtyclrrows = Workorderdetailssizecolor::model()->findAll(array('condition' => "workOrderDetailsId = '{$this->id}'"));

        $rowqty = 0;
        foreach ($sizeqtyclrrows as $row) {
            $rowqty += $row->qty;
        }

        $qtydiff = abs($this->prodQty - $rowqty);
        $rtnqty = intval($qtydiff);
        return $rtnqty;
    }

    public function getBreifDetail() {
        return $this->productsku . ' - ' . $this->prdsrtdesc . ' / ' . $this->decdesc . $this->customdecoration . ' x ' . $this->prodQty . ' Qty';
    }

    public function getMultiDecoNameHtml() {
        $html = "<ol>";
        $workorderDecoDetails = WorkorderDetailsDecoration::model()->findAll(array('condition' => "workorder_detail_id = {$this->id}"));
        if (!$workorderDecoDetails) {
            return '';
        }
        foreach ($workorderDecoDetails as $deco) {

            /*
              if($deco->decprtnam !== 'custom_decoration'){
              $decoRel = Decoration::model()->find(array('condition'=>"decprtnam = '{$deco->decprtnam}'"));
              $link = $decoRel->decnam;
              $link .= "[ " . CHtml::link($decoRel->decprtnam, array("decoration/view", "id" => $decoRel->decsno), array("style"=>"font-size:0.8em;",  "target" => "_blank", 'title' => "click here to see full decoration spec")) . " ]";

              }else{
              $link = $deco->decprtnam;
              }
             */

            $html .= "<li>{$deco->decdesc}</li>";
        }

        $html .= "</ol>";

        return $html;
    }

    public function getMultiDecoHtml() {
        $html = "<ol>";
        $workorderDecoDetails = WorkorderDetailsDecoration::model()->findAll(array('condition' => "workorder_detail_id = {$this->id}"));
        foreach ($workorderDecoDetails as $deco) {
            /*
              if($deco->decprtnam !== 'custom_decoration'){
              $decoRel = Decoration::model()->find(array('condition'=>"decprtnam = '{$deco->decprtnam}'"));
              $link = CHtml::link($deco->decprtnam, array("decoration/view", "id" => $decoRel->decsno), array("target" => "_blank", 'title' => "click here to see full decoration spec"));

              }else{
              $link = $deco->decprtnam;
              }
             * 
             */

            $html .= "<li>{$deco->decdesc}</li>";
        }

        $html .= "</ol>";

        return $html;
    }

    public function getMultiDecoDetailsHtml() {
        $html = "<ol>";
        $workorderDecoDetails = WorkorderDetailsDecoration::model()->findAll(array('condition' => "workorder_detail_id = {$this->id}"));
        foreach ($workorderDecoDetails as $deco) {
            if (!in_array($deco->decprtnam, array(JobProductDecorations::PRODUCT_DECORATION_LINE_CODE))) {
                if ($deco->decprtnam !== 'custom_decoration') {
                    $decoRel = Decoration::model()->find(array('condition' => "decprtnam = '{$deco->decprtnam}'"));
                    $link = CHtml::link($deco->decprtnam, array("decoration/view", "id" => $decoRel->decsno), array("target" => "_blank", 'title' => "click here to see full decoration spec"));
                    $link .= "<br/><p style='text-align:justify;'>" . $decoRel->decnam . "</p>";
                } else {
                    $link = $deco->decprtnam . "<br/><p style='text-align:justify;'>" . $deco->decdesc . "</p>";
                }
            } else {
                continue;
            }

            $html .= "<li>";
            $html .= $link;
            $html .= "</li>";
        }

        $html .= "</ol>";

        return $html;
    }

    public function getMultiDecoDetailsHtmlExLink() {

        $workorderDecoDetails = WorkorderDetailsDecoration::model()->findAll(array('condition' => "workorder_detail_id = {$this->id}"));
        $html .= "";
        foreach ($workorderDecoDetails as $deco) {
            if ($deco->decprtnam !== 'custom_decoration') {
                $decoRel = Decoration::model()->find(array('condition' => "decprtnam = '{$deco->decprtnam}'"));
                $link .= $deco->decprtnam;
                $link .= "\n" . $decoRel->decnam;
            } else {
                $link = $deco->decprtnam . "\n" . $deco->decdesc;
            }


            $html .= $link;
        }

        $html .= "";



        return $html;
    }

    public function recalculateLinePrice() {


        $prodCostPrice = $this->prodCostPrice;
        $prodMarkupRate = $this->prod_supmarg;
        $prodDiscPercntg = $this->prod_discount_pcntg;
        $usdFreight = $this->prod_usd_freight;
        $usdFreightMarkUpRate = $this->productFrieghtMarkUpRate;
        $freightRate = $this->system_freight;
        $otherCostTotal = $this->other_cost;
        $otherCostMarkupRate = $this->other_cost_markup_rate;
        $itmQty = $this->prodQty;


        $totalDecoSupMarginMarkupPrice = 0;
        $totalDecoLogosetupUnitMarkupPrice = 0;


        $decoCostPrice = 0;

        $decorations = $this->rel_multi_deco();
        foreach ($decorations as $deco) {


            $decoCalArr = $deco->getDecorationCalculations(
                    array(
                        'cost_price' => $deco->cost_price,
                        'sup_margin' => $deco->sup_margin,
                        'logo_setup' => $deco->logo_setup,
                        'decorationqty' => $itmQty,
                        'logo_setup_markup_rate' => $deco->logo_setup_markup_rate
            ));

            $decoCostPrice += ($deco->cost_price + $decoCalArr['logo_setup_unit_price']);
            $totalDecoSupMarginMarkupPrice += $decoCalArr['sup_markedup_price'];
            $totalDecoLogosetupUnitMarkupPrice += $decoCalArr['logo_setup_unit_markedup_price'];

            $deco->logo_setup_unit_price = $decoCalArr['logo_setup_unit_price'];
            $deco->logo_setup_unit_markedup_price = $decoCalArr['logo_setup_unit_markedup_price'];

            $deco->save(false); //save without validating the model
        }



        $prodMarkedUpPrice = $prodMarkupRate ? round(($prodCostPrice * $prodMarkupRate), 2) : $prodCostPrice;



        $prodDiscRate = round(($prodDiscPercntg / 100), strlen($prodDiscPercntg));
        $prodDiscountedPrice = $prodDiscRate ? round(($prodMarkedUpPrice - ($prodMarkedUpPrice * $prodDiscRate)), 2) : $prodMarkedUpPrice;

        $usdFreightUnitCost = round(($usdFreight / $itmQty), 2);
        $usdFreightUnitCostWithMarkedUp = $usdFreightUnitCost * $usdFreightMarkUpRate;

        $prodUsdFreightedPrice = $prodDiscountedPrice + round(($usdFreightUnitCostWithMarkedUp), 2);




        $otherCostMarkedUpPrice = floatval($otherCostMarkupRate) ? round(($otherCostTotal * $otherCostMarkupRate), 2) : $otherCostTotal;



        $subTotal = $prodUsdFreightedPrice + $otherCostMarkedUpPrice + ($totalDecoSupMarginMarkupPrice + $totalDecoLogosetupUnitMarkupPrice);
        $subTotalWithSetup = $subTotal;


        $total = $freightRate ? round(($subTotalWithSetup * $freightRate), 2) : $subTotalWithSetup;





        $this->productFrieghtUnitCost = $usdFreightUnitCost;
        $this->productFrieghtUnitCostWithMarkup = $usdFreightUnitCostWithMarkedUp;
        $this->sellPriceExVat = $total;
        $this->sellPriceIncVat = round(($this->sellPriceExVat * $this->prod_supmarg), 2);
        $this->totExVat = $this->sellPriceExVat * $this->prodQty;
        $this->totIncVat = round(($this->totExVat * $this->prod_supmarg), 2);

        $this->save(false);
    }

    public function getHtmlRow() {
        $record = $this;
        $roundingPrecision = (int) GlobalVars::get("RoundingPrecision");
        $html = '';


        $productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
//$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));


//$rowtype = $count % 2;



        $html .= '<tr class="maindetailrow"  id="row_' . $record->id . '"   >            
                <td class="maincell">
                    <table class="maintbl">
                            <tr id="mainrow_' . $record->id . '"  >
                                <td style="width: 3%;text-align: center;"> 
                                <input value="' . intval($record->lineOrder) . '" type="text" name="QuatationDetails[lineOrder]" id="detail-line-order-row-' . $record->id . '" style="width: 15px;" onchange="saveLineOrder(' . $record->id . ', this.value);"/>
                               <input type="checkbox" id="delete_row_' . $record->id . '" class="so-line-select" detail-id="' . $record->id . '" style="color: green;" />    
                                </td>
                                <td style="width: 26%;text-align: center;"><div class="prodecs">';



        if (!empty($record->productsku) && !empty($record->product)) {
            $html .= CHtml::link($record->productsku, array("productLine/view", "id" => $record->product->pdlsno), array("target" => "_blank", 'title' => "click here to see full product spec")) . '<br>';
        }
//if (!empty($record->prdsrtdesc)) {
        $html .= '<textarea id="productsku_' . $record->id . '" onchange="saveproductsku(' . $record->id . ',this.value)" cols="3" rows="3">';
        $html .= trim($record->prdsrtdesc);
        $html .= '</textarea>';
        $html .= '<a href="#" onclick="saveproductsku(' . $record->id . ',this.value);return false;">Save</a>';
//        } else {
//            $html .= '<textarea id="customprod_' . $record->id . '" onchange="savecustomprod(' . $record->id . ',this.value);" >';
//            $html .= trim($record->custmproduct);
//            $html .= '</textarea>';
//        }
        $html .= '</div>';


        $html .= '<div class="viewlongdesc" id="viewlongdesc_' . $record->id . '" onclick="viewlongdecription(' . $record->id . ');">View long description</div>';
        $html .= '<div class="prolngdesc" id="prodlngdesc_' . $record->id . '">';
        $html .= '<textarea onchange="saveprodlngdes(' . $record->id . ',' . $productline->pdlsno . ',this.value);" cols="3" rows="10" >';
        $html .= $record->prdlngdesc;
        $html .= '</textarea>';
        $html .= '<a href="#" onclick="saveprodlngdes(' . $record->id . ',' . $productline->pdlsno . ',this.value);return false;" >Save</a>';
        $html .= '</div>';



        $html .= '</td><td style="width: 26.5%;text-align: center;">';


        $html .= '<div id="multideco_' . $record->id . '">';
        $html .= $record->getMultiDecoHtml();
        $html .= '</div>';
        $html .= '<a href="#" style="width: 95%;"   data-toggle="modal" onclick="showEditMultiDecoModal(' . $record->id . ');return false;">Edit Decorations</a>';






        $html .= '</td>
                                <td style="width: 11%;">
                                    <br>
                                    <input style="width: 95%;text-align: center;"  id="prodqty_' . $record->id . '" name="QuatationDetails[qty]" type="text" value="' . $record->prodQty . '"  onchange="saveprodcutqty(' . $record->id . ',this.value);" />
                                </td>
                                
                                <td style="width: 12.5%;">
                                    <a href="#" style="width: 95%;text-align: center;"   data-toggle="modal" onclick="showEditPriceModal(' . $record->id . ');return false;">Edit Price</a>
                                    <input style="width: 95%;text-align: center;"  id="sellpriceexvat_' . $record->id . '" name="QuatationDetails[sellunitprice_ex_vat]" type="text" value="' . round($record->sellPriceExVat, $roundingPrecision) . '"  disabled="true"/>
                                        
                                </td>
                                
                                <td style="width: 12.5%;">
                                <br>
                                    <input style="width: 95%;text-align: right;"  id="totexvat_' . $record->id . '" disabled="disabled" name="QuatationDetails[selltot_ex_vat]" type="text" value="' . (round($record->sellPriceExVat, $roundingPrecision) * $record->prodQty) . '"  />
                                </td>
                                                               
                                <td class="button-column" >
                                    <table id="moredtl_imgnode_' . $record->id . '" style="width: 100%;cursor: pointer;" onclick="subrowvisible(' . $record->id . ');" >
											<tr>
												<td style="width: 30%;"><span class="sodtlicon fa fa-plus-circle"></span></td>
												<td>Add Size/Dec/Customizations</td>
											</tr>
										</table>							
										
										<hr />
										<table style="width: 100%;cursor: pointer;" onclick="deleteRecord(' . $record->id . ');return false;" >
											<tr>
												<td style="width: 30%;"><span class="sodtlicon fa fa-trash-o"></span></td>
												<td>Delete Item</td>
											</tr>
										</table>	
                                </td> 
                            </tr>
                            <tr class="subrow" id="subrow_' . $record->id . '" >
                                <td colspan="9" >
                                    <div id="subrowdiv_' . $record->id . '" >
                                        <table class="fullwidth">
                                            <tr class="fullwidth">
                                                <td class="fullwidth">
                                                    <table  class="subrowgrid fullwidth">
                                                        <tr >
                                                            <th class="column3" >Customization Details</th>
                                                            <th class="column3" >Notes</th>
                                                            <th class="column2half" >Imagery</th>
                                                            <th class="column1half" >Size/Colors</th>
                                                        </tr>
                                                        <tr >
                                                            <td class="column3" ><textarea onchange="savecutomizeddetails(' . $record->id . ', this.value);"  >' . $record->customizationDetails . '</textarea></td>
                                                            <td class="column3" ><textarea onchange="savenotes(' . $record->id . ', this.value);">' . $record->notes . '</textarea></td>
                                                            <td class="column2half centercls" >';


        if (!empty($record->image)) {


            $html .= '<img src="' . $record->getImg() . '" />';
        } else {

            $html .= '';
        }




        $html .= '</td><td class="column1half"><div  >';


        $html .= '<form id="uploadimgform_' . $record->id . '" action="" method="post" enctype="multipart/form-data">';

        $html .= '<input id="uploadimgfile_' . $record->id . '" type="file" name="file" id="file" required style="display: none;" onchange="imageChoosed(' . $record->id . ',this.files[0].name);" />';

        $html .= '</form><div id="saveimg_' . $record->id . '" class="saveimg" onclick="saveimg(' . $record->id . ');" style="background-color:#32cd32;">Save Image</div>';

        $html .= '<div id="uploadimg_' . $record->id . '" class="uploadimg" onclick=uploadimg(' . $record->id . '); style="background-color:#32cd32;">Upload Image</div>
                                                                    </div>
                                                                    

                                                            <div id="viewsizecolor_' . $record->id . '" class="viewsizecolor" onclick="visiblesizeqtycolorDBTable(' . $record->id . ');" style="background-color:#32cd32;">View Size/Colors</div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td> 
                                            </tr>
                                            <tr class="fullwidth">
                                                <td class="fullwidth">
                                                    <div class="fullwidth sizeqtycolordiv" id="sizeqtycolorDB_tbl_container_' . $record->id . '" >
                                                        <table  id="sizeqtycolorDB_tbl_' . $record->id . '" >
                                                        <tr>
                                                            <th class="column1">#</th>
                                                            <th class="column2half">Size</th>
                                                            <th class="column2half">Quantity</th>
                                                            <th class="column2half">Color</th>
                                                            <th class="column1half"><div  onclick="addsizeqtycolorDBrow(' . $record->id . ');" style="background-color:#32cd32;">+Add Row</div></th>
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr id="sizeqtycolorDBrow_' . $row['id'] . '" >
                                                    <td class="column1">' . $countrow . '</td>
                                                    <td class="column2half">' . $row['size'] . '</td>
                                                    <td class="column2half">' . $row['qty'] . '</td>
                                                    <td class="column2half">' . $row['color'] . '</td>
                                                    <td class="column1half">
                                                    <a href="#" onclick="editsizeqtycolorDBrowAjaxcall(' . $row['id'] . ');return false;">Edit</a>&nbsp;|&nbsp;
                                                    <a href="#"  onclick="deletesizeqtycolorDBrow(' . $row['id'] . ');return false;">Delete</a></td>
                                                </tr>';
        }

        $html .= ' </table>
                    <div id="sizeQtyClrSaveChangesBtn_' . $record->id . '" style="border: 1px solid #fff;background-color:#32cd32;float: right;color: #fff;border-radius: 15px;padding:2px 4px;font-weight: bold;font-size:0.8m;margin-right: 3%;cursor: pointer;display: none;" onclick="savedtlrow(' . $record->id . ');">Save Changes</div>
                                                        
                    </div></td></tr></table></div></td> </tr> </table>
                        <div id="savemessage_' . $record->id . '" class="savemessage">Changes are saved</div>
                         <div class="addproductdtl" onclick="subrowvisible(' . $record->id . ');" title="Add Product Details">Add Product Details</div>   
                        </td>
                    </tr>';

        return $html;
    }

    public static function createDetailByQuoteItem($workorderId, $quotationDetail) {
        $allsaved = true;
        $workorderDetails = new Workorderdetails;
        $workorderDetails->lineOrder = $quotationDetail->lineOrder;
        $workorderDetails->workorderId = $workorderId;
        $workorderDetails->linetypeId = 1;
        $workorderDetails->productsku = $quotationDetail->productsku;

        //$productLine = ProductLine::model()->find(array('condition' => 'pdlpdl=:productKey', 'params' => array(':productKey' => $detail->productsku)));

        $workorderDetails->prdsrtdesc = $quotationDetail->productname;
        $workorderDetails->prdlngdesc = $quotationDetail->productdescription;



        $workorderDetails->prodQty = $quotationDetail->qty;
        //$workorderDetails->decoQty = !empty($detail->decoration) ? $detail->decoration->decorationqty : 0;
        $workorderDetails->prodCostPrice = floatval($quotationDetail->productexunitprice);
        //$workorderDetails->decoCostPrice = !empty($detail->decoration) ? floatval($detail->decoration->decorationunitval) : 0;
        $workorderDetails->prodsupref = $quotationDetail->sup_fref;
        //$workorderDetails->decosupref = !empty($detail->decoration) ? $detail->decoration->supref : '';
        $workorderDetails->sellPriceExVat = $quotationDetail->sellunitprice_ex_vat;
        $workorderDetails->sellPriceIncVat = $quotationDetail->sellunitprice_in_vat;
        $workorderDetails->totExVat = $quotationDetail->selltot_ex_vat;
        $workorderDetails->totIncVat = $quotationDetail->selltot_in_vat;


        $workorderDetails->prod_supmarg = $quotationDetail->supmarg;


        $workorderDetails->prod_usd_freight = $quotationDetail->prodctfrieght;


        //new USD freight mark-up values 2018-10-12
        $workorderDetails->productFrieghtUnitCost = $quotationDetail->productFrieghtUnitCost;
        $workorderDetails->productFrieghtMarkUpRate = $quotationDetail->productFrieghtMarkUpRate;
        $workorderDetails->productFrieghtUnitCostWithMarkup = $quotationDetail->productFrieghtUnitCostWithMarkup;


        //if the image source is URL then trying to get image from the URL and save to local image folder, bytheway rename the productimg with the basename of the URL
        $quotationDetail->saveImageContent();

        $workorderDetails->image = $quotationDetail->productimg;

        $workorderDetails->prod_discount_pcntg = $quotationDetail->customerdicspcn;

        $workorderDetails->system_freight = $quotationDetail->system_freight;


        $workorderDetails->other_cost = $quotationDetail->other_cost;
        $workorderDetails->other_cost_markup_rate = $quotationDetail->other_cost_markup_rate;

        $workorderDetails->createdby = Yii::app()->user->id;
        $workorderDetails->createddate = date("Y-m-d g:i");
        $workorderDetails->customizationDetails = $quotationDetail->customColor; // this field will be used as custom detail
        $workorderDetails->notes = $quotationDetail->customNote;

        $workorderDetails->lockSellPrice = $quotationDetail->lockSellPrice;
        $workorderDetails->systemTaxRateId = $quotationDetail->systemTaxRateId;
        $workorderDetails->customer_accepted = $quotationDetail->customer_accepted;

        if ($allsaved = $workorderDetails->save(false)) {

            $quoteOtherCosts = QuoteOtherCost::model()->findAll(array('condition' => "quote_id = {$quotationDetail->quoteid} and quote_detail_id = {$quotationDetail->id}"));
            foreach ($quoteOtherCosts as $otherCost) {
                $workOrderOtherCost = new WorkorderOtherCost();
                $workOrderOtherCost->workorder_id = $workorderId;
                $workOrderOtherCost->workorder_detail_id = $workorderDetails->id;
                $workOrderOtherCost->other_cost_id = $otherCost->other_cost_id;
                $workOrderOtherCost->cost = floatval($otherCost->cost);
                $workOrderOtherCost->created_by = Yii::app()->user->id;
                $workOrderOtherCost->created_date = date("Y-m-d");
                $allsaved = $workOrderOtherCost->save(false);
            }



            $quotedecorations = QuoteProductDecoration::model()->findAll(array('condition' => 'quataiondetailsid=:qouteDetID', 'params' => array(':qouteDetID' => $quotationDetail->id)));
            $addedDecoDetailsArr = array();
            foreach ($quotedecorations as $deco) {
                $workorderDeco = new WorkorderDetailsDecoration();
                $workorderDeco->work_order_id = $workorderId;
                $workorderDeco->workorder_detail_id = $workorderDetails->id;
                $workorderDeco->decoration_id = $deco->decoRel->decsno;
                $workorderDeco->decprtnam = $deco->decprtnam;
                $workorderDeco->decdesc = $deco->decorationdescription;
                $workorderDeco->quantity = $deco->decorationqty;
                $workorderDeco->cost_price = $deco->decorationunitval;
                $workorderDeco->sup_margin = $deco->supmarg;
                $workorderDeco->sup_markedup_price = $deco->supmargMarkedUpPrice;
                $workorderDeco->logo_setup = $deco->logosetupcharge;
                $workorderDeco->logo_setup_unit_price = $deco->logoSetupUnitCost;
                $workorderDeco->logo_setup_markup_rate = $deco->logoSetupMarkupRate;
                $workorderDeco->logo_setup_unit_markedup_price = $deco->logoSetupUnitCostWithMarkup;
                $workorderDeco->decorationfreightval = $deco->decorationfreightval;
                $workorderDeco->decorationvat = $deco->decorationvat;
                $workorderDeco->supref = $deco->supref;
                $workorderDeco->created_at = date('Y-m-d');
                $workorderDeco->created_by = Yii::app()->user->id;
                $workorderDeco->customization_detail = $deco->customization_detail;

                if ($workorderDeco->save(false)) {
                    $allsaved = true;
                    $addedDecoDetailsArr[] = $workorderDeco->id;
                }
            }
            //here copy details to jobproduct,jobdecoration and jobproductdecoration tables
            $workorderDetails->createJobFlow($workorderDetails, $addedDecoDetailsArr);
        }

        if ($allsaved) {
            return $workorderDetails;
        } else {
            null;
        }
    }

    function createJobFlow($dtl, $addedDecoDetailsArr) {
//$dtl is reffred to Workorderdetails
        $job = Jobs::model()->find("workorder_id = '$dtl->workorderId'");

        if (!empty($job) && !empty($dtl)) {
            if (!empty($dtl->productsku) || !empty($dtl->prdsrtdesc) || !empty($dtl->prdlngdesc)) {
                $job_product = new JobProducts();
                $job_product->job_id = $job->id;
                $job_product->workorderDtl_id = $dtl->id;
                $job_product->qty = $dtl->prodQty;
                $job_product->prodCostPrice = $dtl->prodCostPrice;
                $job_product->status_id = 1; //New
                $job_product->user_id = Yii::app()->user->id;

                $job_product->save();
            }


            if (count($addedDecoDetailsArr) > 0) {
                $criteria = new CDbCriteria;
                $criteria->addInCondition('id', $addedDecoDetailsArr);
                $workOrderDecorations = WorkorderDetailsDecoration::model()->findAll($criteria);
                foreach ($workOrderDecorations as $data) {
                    $job_decoration = new JobDecorations();
                    $job_decoration->job_id = $job->id;
                    $job_decoration->workorderDtl_id = $dtl->id;
                    $job_decoration->decprtnam = $data->decprtnam;
                    $job_decoration->decdesc = $data->decdesc;
                    $job_decoration->customdecoration = $data->customdecoration;
                    $job_decoration->decoQty = $data->quantity;
                    $job_decoration->decoCostPrice = $data->cost_price;
                    $job_decoration->decosupref = $data->supref;
                    $job_decoration->customizationDetails = $dtl->customizationDetails;
                    $job_decoration->status_id = 1; //New
                    $job_decoration->user_id = Yii::app()->user->id;
                    $job_decoration->createdDtm = date('Y-m-d H:i:s');
                    $job_decoration->work_order_detail_decoration_id = $data->id;
                    $job_decoration->save(false);

                    $job_product_decoration = new JobProductDecorations();
                    $job_product_decoration->job_id = $job->id;
                    $job_product_decoration->workorderDtl_id = $dtl->id;
                    $job_product_decoration->decprtnam = $data->decprtnam;
                    $job_product_decoration->decdesc = $data->decdesc;
                    $job_product_decoration->customdecoration = $data->customdecoration;
                    $job_product_decoration->decoQty = $data->quantity;
                    $job_product_decoration->decoCostPrice = $data->cost_price;
                    $job_product_decoration->decosupref = $data->supref;
                    $job_product_decoration->customizationDetails = $dtl->customizationDetails;
                    $job_product_decoration->user_id = Yii::app()->user->id;
                    $job_product_decoration->status_id = 1; //New

                    $job_product_decoration->work_order_detail_decoration_id = $data->id;

                    $job_product_decoration->save(false);
                }
            }
        }
    }

    public function getOnFlagsLabelsHtml() {


        $html = '';

        foreach (array('hide_on_pdf' => 'Hide on PDF') as $flag => $labelText) {
            //check flag on
            if ($this->$flag) {
                $html .= '<span class="label label-success" >' . $labelText . '</span>';
            }
        }

        return $html;
    }

    public function recalculateLineTotal() {
        $GST = GlobalVars::get(GlobalVars::GST);
        if (round($this->sellPriceExVat * $this->prodQty, 2) != round($this->totExVat, 2)) {
            $totalExPriceWas = $this->totExVat;
            if (!$this->gstRate) {
                $this->gstRate = $GST;
            }

            $this->totExVat = round($this->sellPriceExVat * $this->prodQty, 2);
            $this->totIncVat = $this->totExVat * $this->gstRate;


            if ($this->save(false)) {
                $comment = "There was a price mismatch related to the detail [$this->productsku : $this->sellPriceExVat x $this->prodQty = $totalExPriceWas] and has been recalculated as [$this->sellPriceExVat x $this->prodQty = $this->totExVat]";

                SalesLog::createSalesLog($this->workorder->quotationId, $this->workorderId, $this->workorder->quotationNumber, 'SalesOrder', $comment, 1, 0, 1);
            }
        }
    }

}
