<?php

/**
 * This is the model class for table "workorderdetailssizecolor".
 *
 * The followings are the available columns in table 'workorderdetailssizecolor':
 * @property integer $id
 * @property integer $workOrderDetailsId
 * @property string $size
 * @property integer $qty
 * @property string $color
 */
class Workorderdetailssizecolor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Workorderdetailssizecolor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workorderdetailssizecolor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('workOrderDetailsId, qty', 'numerical', 'integerOnly'=>true),
			array('size, color', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('size, qty, color', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'workorderdtl' => array(self::BELONGS_TO, 'Workorderdetails', 'workOrderDetailsId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'workOrderDetailsId' => 'Work Order Details',
			'size' => 'Size',
			'qty' => 'Qty',
			'color' => 'Color',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
		
		$criteria->compare('size',$this->size,true);
		$criteria->compare('qty',$this->qty);
		$criteria->compare('color',$this->color,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}