<?php

/**
 * This is the model class for table "xero_accounts".
 *
 * The followings are the available columns in table 'xero_accounts':
 * @property string $id
 * @property string $account_uuid
 * @property string $code
 * @property string $name
 * @property string $type
 * @property string $tax_type
 * @property string $bank_account_number
 * @property string $bank_account_type
 * @property string $currency_code
 * @property string $description
 * @property string $status
 */
class XeroAccount extends CActiveRecord
{
    //for dropdown list name
    public $displayName;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return XeroAccount the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'xero_accounts';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('account_uuid', 'length', 'max'=>36),
			array('code, type, tax_type', 'length', 'max'=>50),
			array('name, description', 'length', 'max'=>255),
			array('bank_account_number, bank_account_type', 'length', 'max'=>100),
			array('currency_code, status', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, account_uuid, code, name, type, tax_type, bank_account_number, bank_account_type, currency_code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'account_uuid' => 'Account Uuid',
			'code' => 'Code',
			'name' => 'Name',
			'type' => 'Type',
			'tax_type' => 'Tax Type',
			'bank_account_number' => 'Bank Account Number',
			'bank_account_type' => 'Bank Account Type',
			'currency_code' => 'Currency Code',
			'description' => 'Description',
			'status' => 'Status'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('account_uuid',$this->account_uuid,true);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('tax_type',$this->tax_type,true);
		$criteria->compare('bank_account_number',$this->bank_account_number,true);
		$criteria->compare('bank_account_type',$this->bank_account_type,true);
		$criteria->compare('currency_code',$this->currency_code,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('status',$this->status,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}