<?php

/**
 * This is the model class for table "xero_organisation".
 *
 * The followings are the available columns in table 'xero_organisation':
 * @property integer $id
 * @property string $organisation_id
 * @property string $name
 * @property string $legal_name
 * @property string $organisation_type
 * @property string $base_currency
 * @property string $country_code
 * @property string $organisation_status
 * @property string $short_code
 */
class XeroOrganisation extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return XeroOrganisation the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'xero_organisation';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(           
            array('id', 'numerical', 'integerOnly' => true),
            array('organisation_id, organisation_type', 'length', 'max' => 100),
            array('name, legal_name', 'length', 'max' => 255),
            array('base_currency, country_code', 'length', 'max' => 10),
            array('organisation_status', 'length', 'max' => 20),
            array('short_code', 'length', 'max' => 50),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, organisation_id, name, legal_name, organisation_type, base_currency, country_code, organisation_status, short_code', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'organisation_id' => 'Organisation ID',
            'name' => 'Name',
            'legal_name' => 'Legal Name',
            'organisation_type' => 'Organisation Type',
            'base_currency' => 'Base Currency',
            'country_code' => 'Country Code',
            'organisation_status' => 'Organisation Status',
            'short_code' => 'Short Code',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('organisation_id', $this->organisation_id, true);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('legal_name', $this->legal_name, true);
        $criteria->compare('organisation_type', $this->organisation_type, true);
        $criteria->compare('base_currency', $this->base_currency, true);
        $criteria->compare('country_code', $this->country_code, true);
        $criteria->compare('organisation_status', $this->organisation_status, true);
        $criteria->compare('short_code', $this->short_code, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public static function updateOrganisation($organisation = null) {

        if ($organisation) {

            $model = XeroOrganisation::model()->findByPk(1);
            if (!$model) {
                $model = new XeroOrganisation();                
            }

            

            $model->organisation_id = $organisation->getOrganisationId();
            $model->name = $organisation->getName();
            $model->legal_name = $organisation->getLegalName();
            $model->organisation_type = $organisation->getOrganisationType();
            $model->base_currency = $organisation->getBaseCurrency();
            $model->country_code = $organisation->getCountryCode();
            $model->organisation_status = $organisation->getOrganisationStatus();
            $model->short_code = $organisation->getShortCode();
            
            
            $model->save(false);
            
            return $model;
        }

        return null;
    }
    
    public static function getOrganisation() {
        return XeroOrganisation::model()->findByPk(1);
    }

}
